<%
/*******************************************************************************
*	File name			:	EgGraphs.jsp
*	Purpose				:	This program gets the site,host and test names as parameters and
								returns the measurements and states
*	Version				:	eG 3.0
*	Creation Date	:	17-07-2000
*	Last Modified		:	27-08-2003	-	John Williams		-	eG 3.0 Modifications
*								26-09-2003	-	John Williams		-	Footer Page Include
*							20/12/2011  Sri Devi G User - VM Changes
*	Authtor				:	Balamurugan V
*	New UI 				:	New UI changes by Omnicent and Saravanan.A on 12-9-2013
******************************************************************************/
%><%@ page errorPage="EgProbsM.jsp"%>
<%@ page import = "com.egurkha.ini.*" %>
<%@ page import = "com.egurkha.monitor.alarms.AlarmPriorities" %>
<%@ page import = "java.sql.*" %>
<%@ page import = "java.util.*" %>
<%@ page import = "java.io.*"%>
<%@ page import = "java.net.URLEncoder" %>
<%@ page import = "com.eg.EgDbInfo" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgURLEncoder" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgLastMeasureThread" %>
<%@ page import = "com.eg.EgMappingInfo" %>
<%@ page import = "com.egurkha.util.DateUtil" %>
<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page session = "true" %>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "com.eg.EgDateInfo"%>
<%@ page import = "com.egurkha.util.DateTimeTokenizer" %>
<%@ page import = "java.text.SimpleDateFormat"%>
<%@ page import = "com.eg.EgTablesInfo" %>
<%@ page import = "com.egurkha.EgMeasureGraphExt"%>
<%@ page import ="egurkha.reporter.ErUtils"%>

<%@ page import="com.eg.SidCheck" %>
<%@ page import="com.egurkha.*" %>
<%@page import = "egurkha.reporter.*"%>
<%@ page import="net.sf.json.*"%>
<%

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);
	response.setContentType("application/json");

	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	IniUI ui = IniUI.getInstance();
	User u_ser = UserRegistry.getInstance().getUser(session.getId(),true);

	String thisLanguage =ui.getDefaultLanguage();
	if (user!=null)
	{
		String userLang = user.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
	EgTimeZoneConverter timeZoneConverterStart=null;
	EgTimeZoneConverter timeZoneConverterEnd=null;
	String startDateForDisplay = null;
	String startHourForDisplay = null;
	String endDateForDisplay = null;
	String endHourForDisplay = null;
	String startMinForDisplay=null;
	String endMinForDisplay=null;
	String userFormat = user.getUserDateFormat();
	EgDbInfo MeasureDisplay=new EgDbInfo("manager");

		String s_qrstring=request.getQueryString();
		String fromSuper = request.getParameter("fromSuper"); //comes "yes" first time only.
		boolean isfromSuper = session.getAttribute("fromSuper") != null &&
								session.getAttribute("fromSuper").toString().equalsIgnoreCase("yes");
		String Qstring="";
		if(s_qrstring!=null)
		{
				StringTokenizer strtok = new StringTokenizer(s_qrstring,"&");
				while(strtok.hasMoreTokens())
				{
					String param = strtok.nextToken();
					String reqparam =param.substring(0,param.indexOf("="));
					String value = param.substring(param.indexOf("=")+1,param.length());
					if(reqparam.equals("info"))
					{
						value=request.getParameter(reqparam);
						if(value!=null)
						{
							value=com.egurkha.util.StringUtils.replace(value,"|plus|","+");
							value=com.egurkha.util.StringUtils.replace(value,"|amp|","&");
							value=com.egurkha.util.StringUtils.replace(value,"|pct|","%");
							value=com.egurkha.util.StringUtils.replace(value,"|hash|","#");
						}
					}
					if(reqparam.equals("host"))
					{
							value=request.getParameter(reqparam) ;
					}
					if(reqparam.equals("comptype"))
					{
							value=request.getParameter(reqparam) ;
					}
					if(reqparam.equals("test"))
					{
							value=request.getParameter(reqparam);
					}
					if(reqparam.equals("layer"))
					{
							value=request.getParameter(reqparam) ;
					}
					if(reqparam.equals("fromPage"))
					{
							value=request.getParameter(reqparam) ;
					}
					//thendral 18/06/2008
					if(reqparam.equals("msmt_host"))
					{
							value=request.getParameter(reqparam) ;
					}

					if(reqparam.equals("measure"))
					{
						if(fromSuper != null && fromSuper.equalsIgnoreCase("yes"))
						{
							String test = request.getParameter("test");
							value = request.getParameter("measure");
							value = MeasureDisplay.getColumnForMeasure(test,value);
						}
					}
					
					Qstring=Qstring+reqparam+"="+EgURLEncoder.encode(value,"UTF-8")+"&";
					
			}

		}
		if(Qstring.endsWith("&"))
			Qstring=Qstring.substring(0,Qstring.lastIndexOf("&"));
%>

<%!
	EgDbInfo MeasureDisplay=new EgDbInfo("manager");
	EgMeasureGraphExt measureGraphInfo = new EgMeasureGraphExt();
	public String checkForNULL(String str)
	{
		if(str.equals("NULL"))
		{
			return "";
		}
		else
		{
			return str;
		}
	}
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);


	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	String dispDate = null;
	String comFormat = null;

	// Get chart options 
	String chartOption = egUI.getValue("CHART_TYPE","ChartOption");
	String tmpChartOption = chartOption;
	String chartTimeline = egUI.getValue("CHART_TYPE","Timeline");
	chartTimeline = (chartTimeline != null && !chartTimeline.equals(""))?chartTimeline:"1 hour";
	HashSet  optVec = new HashSet ();
	String[] options = {"Any","1 hour","3 hours","6 hours","9 hours","12 hours","15 hours","18 hours","21 hours","24 hours","2 days","3 days","4 days","5 days","6 days","1 week","2 weeks","3 weeks","4 weeks","1 month","2 months"};

	// End
	EgTablesInfo TableData = new EgTablesInfo("manager");

	String  str_site,
			str_host,
			str_port,
			str_layer,
			str_test,
			str_info,
			str_hst_info,
			str_time,
			s_definfo,
			s_glink,
			s_aglink,
			s_mes,
			s_st_time,
			s_st_hr,
			s_en_time,
			s_en_hr,timeLine,
			s_st_min= "",s_end_min ="";
	StringTokenizer st = null;
	String [] str_mes_list = null;
	String s_qstr = null;
	String s_qstr_state = null;
	Vector v_mes = new Vector();

	//MeasureDisplay.checkForUpdate();
	str_site = request.getParameter("site");
	str_port = request.getParameter("port");
	str_test = request.getParameter("test");
	str_layer = request.getParameter("layer");
	str_info = request.getParameter("info");
	if(str_info!=null)
	{
		str_info=com.egurkha.util.StringUtils.replace(str_info,"|plus|","+");
		str_info=com.egurkha.util.StringUtils.replace(str_info,"|amp|","&");
		str_info=com.egurkha.util.StringUtils.replace(str_info,"|pct|","%");
		str_info=com.egurkha.util.StringUtils.replace(str_info,"|hash|","#");
	}
	str_host = request.getParameter("host");
	s_st_time = request.getParameter("starttime");
	s_en_time = request.getParameter("endtime");
	s_st_hr = request.getParameter("starthr");
	s_en_hr = request.getParameter("endhr");
	timeLine = request.getParameter("timeLine");
	String msmtHost = request.getParameter("msmt_host");
	
	String rangech="";
	String  sd_min="";
	String  sd_max="";
	Double r_min=null;
	Double r_max=null;

   String showrange=request.getParameter("showRange");
   if(request.getParameter("maxrange")!=null && request.getParameter("minrange")!=null && showrange!=null && showrange.equalsIgnoreCase("RANGE"))
	{
		sd_min=request.getParameter("minrange");
		sd_max=request.getParameter("maxrange");
	}
	else if(r_min!=null  && r_max!=null)
	{
		sd_min="";
		sd_max="";
	}
	if(timeLine==null)
	{
		timeLine = "1 hour";
	}
	EgDateInfo edi = new EgDateInfo();
	

	// Deciding chart
	chartOption=(chartOption==null || chartOption =="")?"easycharts":chartOption;
	chartOption = chartOption.toLowerCase();
	if(chartOption != null && !chartOption.equals("") && (chartOption.indexOf("easy") == -1 || chartOption.indexOf("graph") == -1))
	{
		
		String tline = request.getParameter("timeLine");
		String ctline = chartTimeline;
		String tmp_start_time = s_st_time+" "+s_st_hr+":00:00";
		String tmp_end_time =  s_en_time+" "+s_en_hr+":00:00";
		chartOption = HighChartTimeline.getChartOption(tline,currentDateFormat,tmp_start_time,tmp_end_time);
	}
	else
		chartOption = "graph";

	java.util.Date local_date = new java.util.Date(edi.egetUTCDate());
	Calendar cal = Calendar.getInstance();
	cal.setTime(local_date);
	cal.setTimeZone(edi.getRealTimeZone());
	boolean isVM = false;
	String s_isVM = request.getParameter("isVM");
	isVM = (new Boolean(s_isVM)).booleanValue();
	boolean isModify = true;
	String s_modify=request.getParameter("modify");
	if(s_modify!=null && s_modify.equalsIgnoreCase("false"))
		isModify=false;
	String lback = request.getParameter("l_back");
	String s_lback = request.getParameter("l_back");
	s_lback = (lback!=null && lback.equalsIgnoreCase("true"))?lback:s_lback;
	int l_times = 1;
	String lTimes = request.getParameter("l_times");
	l_times = (lTimes ==null)?l_times:Integer.parseInt(lTimes);
	String look_back = "60";
	String linterval = request.getParameter("l_interval");
	linterval = (linterval ==null)?look_back:linterval;
	String otherTimeline = request.getParameter("otherTimeline");
	String otherTimeInterval = request.getParameter("otherTimeInterval");
	String [] lookbk_arr = {"Hour","Day","Week","Month","Others"};
	String [] lookbk_valarr = {1*60+"",1*24*60+"",1*24*7*60+"",(1*24*(ErUtils.getMaxDaysInMonth())*60)+"",3*60+""};
	String [] other_tline_valarr = {"3 hrs", "6 hrs", "9 hrs", "12 hrs", "15 hrs", "18 hrs"};
	Hashtable vmHistMap = new Hashtable();
	boolean vmHistExists = false;
	ArrayList hosts = new ArrayList();
	if(isVM)
	{
		String tempInfo = "";
		vmHistMap = EgLastMeasureThread.vmMapDbForHistory;
		if(str_info.startsWith("*") || str_info.startsWith("+"))
		{
			tempInfo = str_info.substring(1);
			if(tempInfo.indexOf(":") >0)
				tempInfo = tempInfo.substring(0,tempInfo.indexOf(":"));
			hosts = (ArrayList)vmHistMap.get(tempInfo);
		}
		else
		{
			if(str_info.indexOf(":")>0)
			{
				tempInfo = str_info.substring(0, str_info.indexOf(":"));
				hosts = (ArrayList)vmHistMap.get(tempInfo);
			}
			else
				hosts = (ArrayList)vmHistMap.get(str_info);
		}
	
		
		
		
		if(hosts!=null && hosts.size() > 0)
		{
			vmHistExists = true;
		}
	}
	String disabled ="";
	if(timeLine!=null && timeLine.equals("Any"))
	{
		String StrDate="";
		try
		{
			java.text.SimpleDateFormat df=new java.text.SimpleDateFormat("MM/dd/yyyy k 'at' hh:mm");
			 StrDate =df.format(edi.egetRealDate());	//----modified on 22/11/07stalin-----------------------
		}
		catch(Exception ee)
		{
			System.out.println("Exception is"+ee);
		}
		String SDate =StrDate.substring(0,StrDate.indexOf(" "));
		String shour =StrDate.substring(StrDate.indexOf(" "),StrDate.lastIndexOf(""));
		shour = shour.substring(0,3);
		String smin =StrDate.substring(StrDate.indexOf(":")+1);

		if (s_st_time== null || s_st_time.equalsIgnoreCase("null"))
		{
			s_st_time= SDate;
		}
		if(s_en_time == null || s_en_time.equalsIgnoreCase("null"))
		{
			s_en_time=SDate;
		}
		if(s_st_hr==null)
		{
			shour =shour.trim();
			int starthr = Integer.parseInt(shour);
			starthr = starthr-1;
			s_st_hr=String.valueOf(starthr);
		}
		if(s_en_hr==null)
		{
			shour =shour.trim();
			s_en_hr =shour;
		}
		if(s_st_min == null)
		{
			s_st_min = smin;
		}
		if(s_end_min == null)
		{
			s_end_min = smin;
		}
		if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
		{
			comFormat = "MM/dd/yyyy";
		}
		else
		{
			comFormat = currentDateFormat;
		}
		s_st_time = DateUtil.changeDateFormat(s_st_time,comFormat,"MM/dd/yyyy");
		if(DateUtil.isDate(s_en_time,"MM/dd/yyyy"))
		{
			comFormat = "MM/dd/yyyy";
		}
		else
		{
			comFormat = currentDateFormat;
		}
		s_en_time = DateUtil.changeDateFormat(s_en_time,comFormat,"MM/dd/yyyy");
	}
	else
	{
		disabled = "disabled";
		String startDateTime="";
		String endDateTime="";
		int blankSpaceIndex = timeLine.indexOf(DateTimeTokenizer.BLANK_SPACE);
		if (blankSpaceIndex > 0)
		{
			SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm");
			java.util.Date tmpday = edi.egetRealDate();
			endDateTime = sdf.format(tmpday);
			int value = Integer.parseInt(timeLine.substring(0, blankSpaceIndex));
			//long value = Integer.parseInt(timeLine.substring(0, blankSpaceIndex));

			String unit = timeLine.substring(blankSpaceIndex+1).toLowerCase();
			if (unit.startsWith("h"))
			{//hours
				value *= 3600;
			}
			else if (unit.startsWith("d"))
			{//days
				value *= (24 * 3600);
			}
			else if (unit.startsWith("w"))
			{//weeks
				value *= (7 * 24 * 3600);
			}
			else if (unit.startsWith("mo"))
			{//months
				//value *= (30 * 24 * 3600);
				value *=(ErUtils.getMaxDaysInMonth()) * 24 * 3600;
			}
			long valueToLong=value;
			java.util.Date start = edi.egetRealDate();
			start.setTime(tmpday.getTime() - (valueToLong * 1000));
			startDateTime = sdf.format(start);
		}
		if ((startDateTime != null) && (endDateTime != null))
		{
			int shr = Integer.parseInt(startDateTime.substring(startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, startDateTime.indexOf(":")));  
			int en_hr = Integer.parseInt(endDateTime.substring(endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, endDateTime.indexOf(":")));
			s_en_time=endDateTime.substring(0, endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
			s_st_time=startDateTime.substring(0, startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
			s_st_hr = String.valueOf(shr);
			if(s_en_hr==null || s_en_hr.trim().length()==0)
				s_en_hr = String.valueOf(en_hr);
			int smin = Integer.parseInt(startDateTime.substring(startDateTime.lastIndexOf(":")+1));
			int emin = Integer.parseInt(endDateTime.substring(endDateTime.lastIndexOf(":")+1));
			s_st_min = String.valueOf(smin);
			s_end_min = String.valueOf(emin);
		}
			
	}	

	if(s_st_time == null || s_en_time == null)
	{
		s_st_time = "";
		s_en_time = "";
	} 
	if(s_st_hr == null || s_en_hr == null)
	{
		s_st_hr = "0";
		s_en_hr = "0";
	} 
	if (s_st_min==null || s_st_min.equals("")) s_st_min = "0";
	if (s_end_min==null || s_end_min.equals("")) s_end_min = "0";

	str_mes_list = MeasureDisplay.getColumnNamesForTest(str_test,str_layer);
	
	s_mes = request.getParameter("measure");
	if(fromSuper != null && fromSuper.equalsIgnoreCase("yes"))
		s_mes = MeasureDisplay.getColumnForMeasure(str_test,s_mes.trim());

	if(s_mes.startsWith(","))
	{
		s_mes = s_mes.substring(1,s_mes.length());
	}

	if(s_mes.indexOf(",") > 0)
	{
		st = new StringTokenizer(s_mes,",");
		while(st.hasMoreTokens())
		{
			v_mes.addElement(st.nextToken().trim());	
		}
	}
	else
	{
		v_mes.addElement(s_mes);
	}

	s_qrstring = request.getQueryString();
	s_qrstring = s_qrstring.substring(0,s_qrstring.indexOf("&gtype="));
	//s_qrstring = StringUtils.replace(s_qrstring,"\\","\\\\");
	//str_info=com.egurkha.util.StringUtils.replace(str_info, "\\", "\\\\");
	String reversedInfo = ui.getReverseLookedupString(str_info);

	if(reversedInfo!=null && reversedInfo.startsWith("*"))
		reversedInfo = reversedInfo.substring(1);
%>

<%
	//String sid = session.getId();
	String wname = "";
	String title = null;
	String titleForTitle="";
	if(str_site!=null&&!str_site.equals("")&&!str_site.equalsIgnoreCase("NULL")&&!str_site.equalsIgnoreCase(null))
	{
		if(str_port!=null && !str_port.equalsIgnoreCase("null"))
		{
			title ="eG Graph for";
			titleForTitle=checkForNULL(str_site)+" > "+str_host+":"+str_port+" > "+ reversedInfo;
		}
		else
		{
			title ="eG Graph for";
			titleForTitle=checkForNULL(str_site)+" > "+str_host+" > "+ reversedInfo;
		}
	}
	else
	{
		if(str_port!=null && !str_port.equalsIgnoreCase("null"))
		{
			title ="eG Graph for";
			titleForTitle=str_host+":"+str_port+" > "+ reversedInfo;
		}
		else
		{
			title ="eG Graph for";
			titleForTitle=str_host+" > "+ reversedInfo;
		}
	}
	if(isVM)
	{
		titleForTitle = reversedInfo;
	}
	JSONObject json = new JSONObject();
	JSONObject hiddenFields = new JSONObject();
	JSONObject formLabels = new JSONObject();
	JSONObject formFields = new JSONObject();
	JSONObject gridData = new JSONObject();
	JSONArray formArray = new JSONArray();
	
%>
<%
String Graphtitle= mappingInfo.getTextDescription("monitor.measure.eG Graph for");
Graphtitle += "&nbsp; - &nbsp;";
String admin = isfromSuper ? mappingInfo.getTextDescription("monitor.common.eG Super Manager") : mappingInfo.getTextDescription("monitor.common.eG Manager");
Graphtitle+=admin;
formLabels.put("title",Graphtitle);
/*
	String test = request.getParameter("halwa");
	System.out.println("The value of halwa is " + test);
	if(test == null)
	{
		out.println("<meta http-equiv='Refresh' content='0;url=EgGraphs.jsp?" +request.getQueryString()+ "&halwa=y'>");
	}
	else if((request.getParameter("gtype")).equals("1"))
	{
		out.println("<meta http-equiv='Refresh' content='100;url=EgGraphs.jsp?" + request.getQueryString() + "'>");
	}
*/
	long refreshFrequency = 60;
	String refFreq = u_ser.getRefreshFrequency();

	if(refFreq!=null && refFreq.length()>0)
	{
		//refreshFrequency =  Long.valueOf(refFreq).longValue() * 1000L;	
		refreshFrequency = Long.valueOf(refFreq).longValue();
	}
/* out.println("<meta http-equiv='Refresh' content='"+refreshFrequency+";url=EgGraphs.jsp?" + request.getQueryString() + "'>"); */
hiddenFields.put("refreshFrequecy",refreshFrequency);
hiddenFields.put("refreshUrl","EgGraphs.jsp?" + request.getQueryString());
%>

<%
	String ua = request.getHeader( "User-Agent" );
	boolean isFirefox = ( ua != null && ua.indexOf( "Firefox/" ) != -1 );
	boolean isMSIE6 = ( ua != null && ua.indexOf( "MSIE 6.0" ) != -1 );
	boolean isMSIE7 = ( ua != null && ua.indexOf( "MSIE 7.0" ) != -1 );
%>
<%
JSONObject measurecombo = new JSONObject();
measurecombo.put("Label",mappingInfo.getTextDescription("monitor.common.Measure"));
measurecombo.put("type","combo");
measurecombo.put("name","measurelist");
hiddenFields.put("rangeval",showrange);
session.setAttribute("title",checkForNULL(str_site)+" > "+str_host+" : "+str_port+" > "+EgURLEncoder.encode(reversedInfo,"UTF-8"));
%>

<%
	JSONArray measureListArray = new JSONArray();
	ArrayList measuresList = new ArrayList();
	String selectVal = "";
	for(int i=0;i < str_mes_list.length ;i = i+2)
	{
		JSONObject measures = new JSONObject();
		String aa=MeasureDisplay. getMeasureForColumn(str_test,str_mes_list[i]);
		String bb = str_test + ":" + aa;
		if(v_mes.contains(str_mes_list[i]))
		{
			measures.put("name",mappingInfo.getMeasureDescription(str_test,aa));
			measures.put("value",str_mes_list[i]);
			selectVal+=str_mes_list[i]+",";
%>
<%
															String unit = TableData.getUnitForMeasure(str_test,aa);
															aa = aa+" ("+unit+")";
															measuresList.add(aa);
															aa="";
		}
		else
		{
			measures.put("name",mappingInfo.getMeasureDescription(str_test,aa));
			measures.put("value",str_mes_list[i]);
%>
															
<%
		}
		measureListArray.add(measures);
	}
	selectVal=selectVal.substring(0,selectVal.length()-1);
	measurecombo.put("selectvalue",selectVal);	
	measurecombo.put("items",measureListArray);	
	formArray.add(measurecombo);
%>
														
<%
	if(msmtHost!=null&&!msmtHost.trim().equals(" ")&&msmtHost.trim().length()>0)
	{
		JSONObject measureLabel = new JSONObject();
		measureLabel.put("Label",mappingInfo.getTextDescription("monitor.common.Measured By"));
		measureLabel.put("type","label");
		measureLabel.put("value",msmtHost);
		formArray.add(measureLabel);
		
%>
													
<%
	}
		formLabels.put("timeline",mappingInfo.getTextDescription("monitor.common.Timeline"));
%>
												
<%
	JSONObject fromDateFilter = new JSONObject();
	fromDateFilter.put("type","date");
	fromDateFilter.put("Label",mappingInfo.getTextDescription("monitor.common.From"));	
	fromDateFilter.put("name","FromDate");
	if(s_st_time!=null && !s_st_time.equals(""))
	{
		if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
		{
			comFormat = "MM/dd/yyyy";
		}
		else
		{
			comFormat = currentDateFormat;
		}
		dispDate = DateUtil.changeDateFormat(s_st_time,comFormat,currentDateFormat);
		timeZoneConverterStart = new EgTimeZoneConverter(dispDate+" "+s_st_hr+":"+s_st_min+":"+"00",user);
		startDateForDisplay = (String) timeZoneConverterStart.getDate(false);
		startHourForDisplay = timeZoneConverterStart.getHour();
		startMinForDisplay = timeZoneConverterStart.getMinute();
	}
	else
	{
		dispDate = "";
	}
	fromDateFilter.put("format",currentDateFormat);
	fromDateFilter.put("time",s_st_time);
	//fromDateFilter.put("selectedValue",dispDate);
	fromDateFilter.put("selectedValue",startDateForDisplay);
	formArray.add(fromDateFilter);
%>
																	
<%
	JSONObject hrcombo = new JSONObject();
	hrcombo.put("Label",mappingInfo.getTextDescription("monitor.common.Hr"));
	hrcombo.put("name","starthr");
	hrcombo.put("type","combo");
	JSONArray starthoursArray = new JSONArray();
	for(int s_ctr=0; s_ctr < 24 ;s_ctr++)
	{
		JSONObject starthours = new JSONObject();
		//if(s_ctr == Integer.parseInt(s_st_hr))
		if(s_ctr == Integer.parseInt(startHourForDisplay))
		{
			starthours.put("name", s_ctr);
			starthours.put("value", s_ctr);
			hrcombo.put("selectvalue",s_ctr);	
		}
		else
		{
			starthours.put("name", s_ctr);
			starthours.put("value", s_ctr);
		}
		starthoursArray.add(starthours);
	}
	hrcombo.put("items",starthoursArray);
	formArray.add(hrcombo);
%>
																	
<%
	JSONObject toDateFilter = new JSONObject();
	toDateFilter.put("type","date");
	toDateFilter.put("Label",mappingInfo.getTextDescription("monitor.common.To"));
	toDateFilter.put("name","todate");		
	if(s_en_time!=null && !s_en_time.equals(""))
	{
		if(DateUtil.isDate(s_en_time,"MM/dd/yyyy"))
		{
			comFormat = "MM/dd/yyyy";
		}
		else
		{
			comFormat = currentDateFormat;
		}
		dispDate = DateUtil.changeDateFormat(s_en_time,comFormat,currentDateFormat);
		timeZoneConverterEnd = new EgTimeZoneConverter(dispDate+" "+s_en_hr+":"+s_end_min+":"+"00",user);
		endDateForDisplay = (String) timeZoneConverterEnd.getDate(false);
		endHourForDisplay = timeZoneConverterEnd.getHour();
		endMinForDisplay = timeZoneConverterEnd.getMinute();
	}
	else
	{
		dispDate = "";
	}
	toDateFilter.put("format",currentDateFormat);
	toDateFilter.put("time",s_en_time);
	//toDateFilter.put("selectedValue",dispDate);
	toDateFilter.put("selectedValue",endDateForDisplay);
	formArray.add(toDateFilter);
%>
																	
<%
	JSONObject tohrcombo = new JSONObject();
	tohrcombo.put("Label",mappingInfo.getTextDescription("monitor.common.Hr"));															
	tohrcombo.put("name","endhr");
	tohrcombo.put("type","combo");
	JSONArray endhoursArray = new JSONArray();
	for(int e_ctr=0; e_ctr < 24 ;e_ctr++)
	{
		JSONObject endhours = new JSONObject();
		//if(e_ctr == Integer.parseInt(s_en_hr))
		if(e_ctr == Integer.parseInt(endHourForDisplay))
		{
			endhours.put("name", e_ctr);
			endhours.put("value", e_ctr);
			tohrcombo.put("selectvalue",e_ctr);
		}
		else
		{
			endhours.put("name", e_ctr);
			endhours.put("value", e_ctr);
		}
		endhoursArray.add(endhours);
	}
	tohrcombo.put("items",endhoursArray);
	formArray.add(tohrcombo);
%>
																	
<%
	JSONObject lookbacklabel = new JSONObject();
	lookbacklabel.put("Label",mappingInfo.getTextDescription("monitor.livegraph.Lookback"));
	lookbacklabel.put("name","er_history");
	lookbacklabel.put("type","checkbox");
	String hist = "";
	boolean checked=false;
	if(s_lback!=null && s_lback.equalsIgnoreCase("true")){
		hist = "checked";
		checked=true;
	}
	lookbacklabel.put("checked",checked);
	formArray.add(lookbacklabel);
	hiddenFields.put("hidPreviousLookback", hist);
%>
																	
<%
	JSONObject intervalcombo = new JSONObject();
	intervalcombo.put("Label",mappingInfo.getTextDescription("monitor.livegraph.Interval"));
	intervalcombo.put("name","er_interval");
	intervalcombo.put("type","combo");
	
	JSONArray intervalsArray = new JSONArray();
				String lb_interval = "";

				if(linterval!=null)
				{
					lb_interval = linterval;
				}
				JSONObject intervals = new JSONObject();
				for(int i=0;i<lookbk_arr.length;i++)
				{
					if(lb_interval.equals(lookbk_valarr[i]))
					{
						String chk1="selected";
						intervals.put("name", mappingInfo.getTextDescription("monitor.livegraph."+lookbk_arr[i]));
						intervals.put("value", lb_interval);
						intervalcombo.put("selectvalue",lb_interval);
%>
<%
						chk1 = "";
					}
					else if(otherTimeline!=null && otherTimeline.equalsIgnoreCase("true") && otherTimeInterval!=null && lookbk_valarr[i].equals("180"))
					{
						String chk1="selected";
						intervals.put("name", mappingInfo.getTextDescription("monitor.livegraph."+lookbk_arr[i]));
						intervals.put("value", "180");
						intervalcombo.put("selectvalue","180");
%>
<%
						chk1 = "";
					}
					else
					{
						intervals.put("name", mappingInfo.getTextDescription("monitor.livegraph."+lookbk_arr[i]));
						intervals.put("value", lookbk_valarr[i]);
%>
<%
					}
					intervalsArray.add(intervals);
				}
				intervalcombo.put("items",intervalsArray);
				formArray.add(intervalcombo);
				hiddenFields.put("hidPreviousOtherTime", otherTimeline);
%>
																	
<%
	JSONObject timescombo = new JSONObject();
	timescombo.put("Label",mappingInfo.getTextDescription("monitor.livegraph.No&#46; of times"));
	timescombo.put("name","er_integrate");
	timescombo.put("type","combo");
	JSONArray noOfTimesArray = new JSONArray();
	for(int i=1;i<=7;i++)
	{
		JSONObject noOfTimes = new JSONObject();
		if(isModify)
		{
			if(l_times==i)
			{
				String chk1="selected";
				noOfTimes.put("name", i);
				noOfTimes.put("value", l_times);
				timescombo.put("selectvalue",l_times);
				chk1 = "";
			}
			else{
				noOfTimes.put("name", i);
				noOfTimes.put("value", String.valueOf( i));
			}
		}
		else
		{
			noOfTimes.put("name", i);
			noOfTimes.put("value", String.valueOf( i));
		}
		noOfTimesArray.add(noOfTimes);
	}
	timescombo.put("items",noOfTimesArray);
	formArray.add(timescombo);
%>
																							
<%
		JSONObject otherintervalcombo = new JSONObject();
		otherintervalcombo.put("Label","");
		otherintervalcombo.put("name","er_otherTime");
		otherintervalcombo.put("type","combo");
		JSONObject newSelection = new JSONObject();
		JSONArray newSelectionArray = new JSONArray();
		
			String dispOtherTimeInterval = "";
			if(otherTimeInterval!=null && otherTimeInterval.equals("180"))
				dispOtherTimeInterval = "3 hrs";
			else if(otherTimeInterval!=null && otherTimeInterval.equals("360"))
				dispOtherTimeInterval = "6 hrs";
			else if(otherTimeInterval!=null && otherTimeInterval.equals("540"))
				dispOtherTimeInterval = "9 hrs";
			else if(otherTimeInterval!=null && otherTimeInterval.equals("720"))
				dispOtherTimeInterval = "12 hrs";
			else if(otherTimeInterval!=null && otherTimeInterval.equals("900"))
				dispOtherTimeInterval = "15 hrs";
			else if(otherTimeInterval!=null && otherTimeInterval.equals("1080"))
				dispOtherTimeInterval = "18 hrs";
			
								for(int ot=0; ot<other_tline_valarr.length; ot++)
								{
									if(dispOtherTimeInterval!=null && dispOtherTimeInterval.equalsIgnoreCase(other_tline_valarr[ot]))
									{
										String oTime="selected";
										newSelection.put("name", mappingInfo.getTextDescription("monitor.livegraph."+other_tline_valarr[ot]));
										newSelection.put("value", dispOtherTimeInterval);
										otherintervalcombo.put("selectvalue",dispOtherTimeInterval);
%>
<%
										oTime = "";
									}
									else
									{
										newSelection.put("name", mappingInfo.getTextDescription("monitor.livegraph."+other_tline_valarr[ot]));
										newSelection.put("value", other_tline_valarr[ot]);
%>
<%
									}
									newSelectionArray.add(newSelection);
								}
								otherintervalcombo.put("items",newSelectionArray);
								formArray.add(otherintervalcombo);
%>
															
<%
	JSONObject viewcombo = new JSONObject();
	viewcombo.put("Label",mappingInfo.getTextDescription("monitor.common.View"));
	viewcombo.put("name","mode");
	viewcombo.put("type","combo");
	JSONObject views = new JSONObject();
	JSONArray viewsArray = new JSONArray();
	
	String mode = request.getParameter("mode");
	String select2d="";
	String select3d="";
	boolean use3DGraphs = ui.use3DGraphs(IniUI.MONITOR);
	if(mode!=null&&!mode.equals(""))
	{
		if(mode.equals("2D")){
		select2d="selected";
		viewcombo.put("selectvalue","2D");
		}
		if(mode.equals("3D")){
		select3d="selected";
		viewcombo.put("selectvalue","3D");
		}
	}
	else 
	{
		if(use3DGraphs){
		select3d="selected";
		viewcombo.put("selectvalue","3D");
		}
		else{
		select2d="selected";
		viewcombo.put("selectvalue","2D");
		}
	}
	views.put("name", mappingInfo.getTextDescription("monitor.common.2D"));
	views.put("value", "2D");
	viewsArray.add(views);
	views.put("name", mappingInfo.getTextDescription("monitor.common.3D"));
	views.put("value", "3D");	
	viewsArray.add(views);
	viewcombo.put("items",viewsArray);
	formArray.add(viewcombo);
%>
																	
<%
	if(showrange!=null && showrange.equalsIgnoreCase("RANGE") && !(s_lback!=null && s_lback.equalsIgnoreCase("true")))
	{
		JSONObject datarange = new JSONObject();
		datarange.put("type","slider");
		datarange.put("Label",mappingInfo.getTextDescription("monitor.measureGraph.Data Range"));
		datarange.put("minvalue",sd_min);
		datarange.put("maxvalue",sd_max);
		formArray.add(datarange);	
%>
																	
<%
	}
		JSONObject graphbuttoninfo = new JSONObject();	
		graphbuttoninfo.put("type","button");
		graphbuttoninfo.put("name","graph");
		graphbuttoninfo.put("text",mappingInfo.getTextDescription("monitor.common.Graph"));
		formArray.add(graphbuttoninfo);
		
		JSONObject databuttoninfo = new JSONObject();	
		databuttoninfo.put("type","button");
		databuttoninfo.put("name","data");
		databuttoninfo.put("text",mappingInfo.getTextDescription("monitor.common.Data"));
		formArray.add(databuttoninfo);
		
		JSONObject printbuttoninfo = new JSONObject();	
		printbuttoninfo.put("type","tool");
		printbuttoninfo.put("name","print");
		printbuttoninfo.put("text",mappingInfo.getTextDescription("monitor.common.PRINT"));
		formArray.add(printbuttoninfo);
		
		JSONObject savebuttoninfo = new JSONObject();	
		savebuttoninfo.put("type","tool");
		savebuttoninfo.put("name","save");
		savebuttoninfo.put("text",mappingInfo.getTextDescription("monitor.common.SAVE"));
		formArray.add(savebuttoninfo);
%>
												
<%
	EgMeasureGraphExt measureGraphInfo = new EgMeasureGraphExt();
	if(!EgInstallInfo.isConfigTest((String)request.getParameter("test")))
	{
		if(s_lback!=null && s_lback.equalsIgnoreCase("true"))
		{
			if(s_mes!=null && s_mes.indexOf(",")>-1)	// if 2
			{
				StringTokenizer tok = new StringTokenizer(s_mes, ",");	// while
				{
					JSONArray MultipleGridArray = new JSONArray();
					JSONArray GraphsArray = new JSONArray();
					while(tok.hasMoreTokens())
					{
						String tempMeasure = tok.nextToken();
						String measValue = "";
						JSONObject graphUrl = new JSONObject();
						JSONObject multiplegrid = new JSONObject(); 
						JSONObject multipleGridColumns = new JSONObject();	
						measValue = tempMeasure;
						
						hiddenFields.put("measure", request.getParameter("measure"));
						hiddenFields.put("gtype", request.getParameter("gtype"));
						hiddenFields.put("msmt_host", request.getParameter("msmt_host"));
						graphUrl.put("Graphs","/final/servlet/com.egurkha.LookBackTimelineMeasures?"+Qstring+"&gformat=graph&measureValue="+measValue+"&otherTimeline="+otherTimeline+"&otherTimeInterval="+otherTimeInterval);						
%>
							

<%
						Enumeration testMeasures = null;
						boolean showdata = false;
						ArrayList availMeasures = new ArrayList();
						ArrayList legendsList = new ArrayList();
						if(str_site.equals("null") || str_site.equals("NULL"))
						{
							str_site = "-1";
						}
						ArrayList measureData1 = new ArrayList();
						Hashtable avgMinMaxData = new Hashtable();
						if(isVM)
						{
							if(vmHistExists)
							{
								
								for(int h=0; h < hosts.size();h++)
								{
									String host = (String)hosts.get(h);
									String st_host = host.substring(0,host.lastIndexOf(":"));
									String ss_host = st_host.substring(0, st_host.indexOf(":"));
									String ss_port = st_host.substring(st_host.indexOf(":")+1);
									avgMinMaxData = measureGraphInfo.getAvgMaxMinData(measValue, str_test, ss_host, ss_port, str_site, str_test, str_info, s_st_time, s_en_time, msmtHost, request.getParameter("comptype"), timeLine, s_st_hr, s_en_hr, sd_min, sd_max, u_ser, l_times, linterval, otherTimeline, otherTimeInterval, currentDateFormat,isVM);
									
								}
								
							}
						}
						else
							avgMinMaxData = measureGraphInfo.getAvgMaxMinData(measValue, str_test, str_host, str_port, str_site, str_test, str_info, s_st_time, s_en_time, msmtHost, request.getParameter("comptype"), timeLine, s_st_hr, s_en_hr, sd_min, sd_max, u_ser, l_times, linterval, otherTimeline, otherTimeInterval, currentDateFormat);
						testMeasures = avgMinMaxData.keys();

						while(testMeasures.hasMoreElements())
						{
							String meas = (String)testMeasures.nextElement();
							availMeasures.add(meas);
						}
						Comparator comparator = Collections.reverseOrder();
						Collections.sort(availMeasures,comparator);
						Collections.sort(measuresList,String.CASE_INSENSITIVE_ORDER);
						if(availMeasures!=null && avgMinMaxData.size()>0)
						{
							String temp_mes = MeasureDisplay.getMeasureForColumn(str_test,measValue);
							String measureDisp = mappingInfo.getMeasureDescription(str_test,temp_mes);

							String unitForMeasure = TableData.getUnitForMeasure(str_test, temp_mes.trim());

							if(unitForMeasure!=null)
								measureDisp = measureDisp + " (" + unitForMeasure + ")";

							
							multipleGridColumns.put("MeasureLabel", measureDisp);
							multipleGridColumns.put("MeasureAvgLabel", mappingInfo.getTextDescription("monitor.measure.Avg"));
							multipleGridColumns.put("MeasureMaxLabel", mappingInfo.getTextDescription("monitor.measure.Max"));
							multipleGridColumns.put("MeasureMinLabel", mappingInfo.getTextDescription("monitor.common.Min"));
							multiplegrid.put("MeasureGridColumns",multipleGridColumns);

							if(avgMinMaxData!=null && avgMinMaxData.size()>0)
							{
								if(availMeasures!=null && availMeasures.size()>0)
								{
									JSONArray dataArray = new JSONArray();
									for(int a=0; a<availMeasures.size();a++)
									{
										String legendName   = (String)availMeasures.get(a);
										ArrayList measureData = (ArrayList) avgMinMaxData.get(legendName);
										String avgValue =(String) measureData.get(0);
										String maxValue =(String) measureData.get(1);
										String minValue =(String) measureData.get(2);
										if(avgValue.equals("-")&&minValue.equals("-"))
										{
											maxValue="-";
										}
										JSONObject multipleGridData = new JSONObject();
										multipleGridData.put("MeasuresDisplay", legendName);
										multipleGridData.put("MeasureAvgDisplay", MeasureDisplay.formatValue(avgValue));
										multipleGridData.put("MeasureMaxDisplay", MeasureDisplay.formatValue(maxValue));
										multipleGridData.put("MeasureMinDisplay", MeasureDisplay.formatValue(minValue));
										dataArray.add(multipleGridData);
				
%>
										
<%
									}
									multiplegrid.put("MeasureGridData",dataArray);
								}
							}
		
%>
										
<%
						}
						GraphsArray.add(graphUrl);
						MultipleGridArray.add(multiplegrid);
%>

<%
					}
					json.put("MultipleGraphsUrl",GraphsArray);
					gridData.put("MultipleMeasureGridData",MultipleGridArray);
				}
			}
			else
			{
				hiddenFields.put("measure", request.getParameter("measure"));
				hiddenFields.put("gtype", request.getParameter("gtype"));
				hiddenFields.put("msmt_host", request.getParameter("msmt_host"));
				
				json.put("GraphUrl", "/final/servlet/com.egurkha.LookBackTimelineMeasures?"+Qstring+"&l_back="+hist+"&l_times="+l_times+"&l_interval="+linterval+"&otherTimeline="+otherTimeline+"&otherTimeInterval="+otherTimeInterval);

%>
							

<%
				Enumeration testMeasures = null;
				boolean showdata = false;
				ArrayList availMeasures = new ArrayList();
				ArrayList legendsList = new ArrayList();
				if(str_site.equals("null") || str_site.equals("NULL"))
				{
					str_site = "-1";
				}
				ArrayList measureData1 = new ArrayList();
				Hashtable avgMinMaxData = new Hashtable();
				if(isVM)
				{
					if(vmHistExists)
					{
						
						for(int h=0; h < hosts.size();h++)
						{
							String host = (String)hosts.get(h);
							String st_host = host.substring(0,host.lastIndexOf(":"));
							String ss_host = st_host.substring(0, st_host.indexOf(":"));
							String ss_port = st_host.substring(st_host.indexOf(":")+1);
							avgMinMaxData = measureGraphInfo.getAvgMaxMinData(s_mes, str_test, ss_host, ss_port, str_site, str_test, str_info, s_st_time, s_en_time, msmtHost, request.getParameter("comptype"), timeLine, s_st_hr, s_en_hr, sd_min, sd_max, u_ser, l_times, linterval, otherTimeline, otherTimeInterval, currentDateFormat,isVM);
							
						}
						
					}
				}
				else
					avgMinMaxData = measureGraphInfo.getAvgMaxMinData(s_mes, str_test, str_host, str_port, str_site, str_test, str_info, s_st_time, s_en_time, msmtHost, request.getParameter("comptype"), timeLine, s_st_hr, s_en_hr, sd_min, sd_max, u_ser, l_times, linterval, otherTimeline, otherTimeInterval, currentDateFormat);
				
				testMeasures = avgMinMaxData.keys();

				while(testMeasures.hasMoreElements())
				{
					String meas = (String)testMeasures.nextElement();
					availMeasures.add(meas);
				}
				Comparator comparator = Collections.reverseOrder();
				Collections.sort(availMeasures,comparator);
				Collections.sort(measuresList,String.CASE_INSENSITIVE_ORDER);
				if(availMeasures!=null && avgMinMaxData.size()>0)
				{
					String temp_mes = MeasureDisplay.getMeasureForColumn(str_test,s_mes);
					String measureDisp = mappingInfo.getMeasureDescription(str_test,temp_mes);

					String unitForMeasure = TableData.getUnitForMeasure(str_test, temp_mes.trim());

					if(unitForMeasure!=null)
						measureDisp = measureDisp + " (" + unitForMeasure + ")";
					JSONObject MeasureGridColumns = new JSONObject();
					MeasureGridColumns.put("MeasureLabel", measureDisp);
					MeasureGridColumns.put("MeasureAvgLabel", mappingInfo.getTextDescription("monitor.measure.Avg"));
					MeasureGridColumns.put("MeasureMaxLabel", mappingInfo.getTextDescription("monitor.measure.Max"));
					MeasureGridColumns.put("MeasureMinLabel", mappingInfo.getTextDescription("monitor.common.Min"));
					gridData.put("MeasureGridColumns",MeasureGridColumns);
%>
							
<%
					if(avgMinMaxData!=null && avgMinMaxData.size()>0)
					{
						if(availMeasures!=null && availMeasures.size()>0)
						{
							JSONArray dataArray= new JSONArray();
							for(int a=0; a<availMeasures.size();a++)
							{
								String legendName   = (String)availMeasures.get(a);
								ArrayList measureData = (ArrayList) avgMinMaxData.get(legendName);
								String avgValue =(String) measureData.get(0);
								String maxValue =(String) measureData.get(1);
								String minValue =(String) measureData.get(2);
								if(avgValue.equals("-")&&minValue.equals("-"))
								{
									maxValue="-";
								}
								JSONObject MeasureGridData = new JSONObject();
								MeasureGridData.put("MeasuresDisplay", legendName);
								MeasureGridData.put("MeasureAvgDisplay", MeasureDisplay.formatValue(avgValue));
								MeasureGridData.put("MeasureMaxDisplay", MeasureDisplay.formatValue(maxValue));
								MeasureGridData.put("MeasureMinDisplay", MeasureDisplay.formatValue(minValue));
								dataArray.add(MeasureGridData);			
				
%>
										
<%
							}
							gridData.put("MeasureGridData",dataArray);
						}
					}
%>
										
<%
				}
%>
<%
			}
		}
		else
		{
			hiddenFields.put("measure", request.getParameter("measure"));
			hiddenFields.put("gtype", request.getParameter("gtype"));
			hiddenFields.put("msmt_host", request.getParameter("msmt_host"));
			
			json.put("GraphUrl", response.encodeURL("/final/servlet/com.egurkha.TimelineMeasures?gformat=graph&")+Qstring);
%>
							
<%
			Enumeration testMeasures = null;
			boolean showdata = false;
			ArrayList availMeasures = new ArrayList();
			ArrayList legendsList = new ArrayList();
			if(str_site.equals("null") || str_site.equals("NULL"))
			{
				str_site = "-1";
			}
			ArrayList measureData1 = new ArrayList();
			Hashtable avgMinMaxData = new Hashtable();
			if(isVM)
			{
				if(vmHistExists)
				{
					
					for(int h=0; h < hosts.size();h++)
					{
						String host = (String)hosts.get(h);
						String st_host = host.substring(0,host.lastIndexOf(":"));
						String ss_host = st_host.substring(0, st_host.indexOf(":"));
						String ss_port = st_host.substring(st_host.indexOf(":")+1);
						avgMinMaxData = measureGraphInfo.getAvgMaxMinData(s_mes, str_test, ss_host, ss_port, str_site, str_test, str_info, s_st_time, s_en_time, msmtHost, request.getParameter("comptype"), timeLine, s_st_hr, s_en_hr, sd_min, sd_max, u_ser,isVM);
						
					}
					
				}
			}
			else
				avgMinMaxData = measureGraphInfo.getAvgMaxMinData(s_mes, str_test, str_host, str_port, str_site, str_test, str_info, s_st_time, s_en_time, msmtHost, request.getParameter("comptype"), timeLine, s_st_hr, s_en_hr, sd_min, sd_max, u_ser);

			testMeasures = avgMinMaxData.keys();

			while(testMeasures.hasMoreElements())
			{
				String meas = (String)testMeasures.nextElement();
				if(measuresList!=null&&measuresList.contains(meas))
				{
					showdata= true;
				}
				availMeasures.add(meas);
			}
			Comparator comparator = Collections.reverseOrder();
			Collections.sort(availMeasures,comparator);
			Collections.sort(measuresList,String.CASE_INSENSITIVE_ORDER);
			if(availMeasures!=null&&avgMinMaxData.size()>0&&showdata)
			{
				JSONObject MeasureGridColumns = new JSONObject();
				MeasureGridColumns.put("MeasureLabel", mappingInfo.getTextDescription("monitor.measure.Measurement Name"));
				MeasureGridColumns.put("MeasureAvgLabel", mappingInfo.getTextDescription("monitor.measure.Avg"));
				MeasureGridColumns.put("MeasureMaxLabel", mappingInfo.getTextDescription("monitor.measure.Max"));
				MeasureGridColumns.put("MeasureMinLabel", mappingInfo.getTextDescription("monitor.common.Min"));
				gridData.put("MeasureGridColumns",MeasureGridColumns);
				JSONArray dataArray= new JSONArray();
%>
							
<%
				for(int k=0;k<measuresList.size();k++)
				{
					String measureName = (String)measuresList.get(k);
					ArrayList measureData = (ArrayList) avgMinMaxData.get(measureName);
					String temp = str_test +  ":" + measureName.substring(0,measureName.indexOf("(")-1);
					String measure_name =  measureName.substring(0,measureName.indexOf("(")-1);
					String unitTemp = measureName.substring(measureName.indexOf("("),measureName.length());
					String avgValue =(String) measureData.get(0);
					String maxValue =(String) measureData.get(1);
					String minValue =(String) measureData.get(2);
					if(avgValue.equals("-")&&minValue.equals("-"))
					{
						maxValue="-";
					}
					if(!legendsList.contains(measureName))
					{
						JSONObject MeasureGridData = new JSONObject();
						//MeasureGridData.put("MeasuresDisplay",mappingInfo.getMeasureDescription("",temp));
						MeasureGridData.put("MeasuresDisplay",mappingInfo.getMeasureDescription(str_test,measure_name));
						MeasureGridData.put("MeasuresDisplayUnit", unitTemp);
						MeasureGridData.put("MeasureAvgDisplay", MeasureDisplay.formatValue(avgValue));
						MeasureGridData.put("MeasureMaxDisplay", MeasureDisplay.formatValue(maxValue));
						MeasureGridData.put("MeasureMinDisplay", MeasureDisplay.formatValue(minValue));
						dataArray.add(MeasureGridData);		
%>
										
<%
					}
				}
				gridData.put("MeasureGridData",dataArray);
%>
										
<%
			}
%>
<%
		}
	}
	else
	{
		hiddenFields.put("measure", request.getParameter("measure"));
		hiddenFields.put("gtype", request.getParameter("gtype"));
		hiddenFields.put("msmt_host", request.getParameter("msmt_host"));
		
		json.put("error",mappingInfo.getTextDescription("monitor.measureGraph.There is no Graph for this test&#46 Please select DATA to view the previous Data"));
		
	}
	json.put("CurrentDateError",mappingInfo.getTextDescription("monitor.common.From and To Date should be lesser than Current date"));
	json.put("MeasureErrormsg",mappingInfo.getTextDescription("monitor.measureGraph.Please select atleast one measure"));
	json.put("DateErrormsg",mappingInfo.getTextDescription("monitor.common.From date should be lesser than To date"));
	json.put("DataRangeError", mappingInfo.getTextDescription("monitor.measureGraph.From value should be less than To value"));
	json.put("HiddenFields",hiddenFields);
	json.put("FormFields",formArray);
	json.put("GridData",gridData);
	json.put("formLabels",formLabels);
	json.put("chartOption",chartOption);
	json.put("chartTimeline",chartTimeline);
	json.put("iniChartOption",tmpChartOption);
	v_mes.clear();
	response.getWriter().write(json.toString());
						
%>