<%
/*
	Author			:	James Thomas
	Creation Date	:	13th October 2006
	Purpose			:	Displays the current status of the servers being monitored 
	Design Changes	:	Jaiwin

	Design Changes	:	Vijaykumar 29.1.2007
*/
%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %> 
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="EgLoginTracker.jsp" %>
<%@ page errorPage="EgErrorSmall.jsp" %>
<%@ page import="com.egurkha.*"%>
<%@ page import="com.egurkha.ini.*" %>
<%@ page import="com.egurkha.util.*" %>
<%@ page import="com.eg.EgDateInfo" %>
<%@ page import="com.eg.EgDiscInfo"%>
<%@ page import="com.eg.EgServicesInfo" %>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import="com.eg.AgentConfig" %>
<%@ page import="com.eg.EgAgentInfo" %>
<%@ page import="com.eg.EgExternalInfo" %>
<%@ page import="com.egurkha.EgMostProbComp"%>
<%@ page import="com.egurkha.monitor.HealthDAO"%>
<%@ page import="com.egurkha.monitor.DashboardData"%>
<%@ page import="com.egurkha.monitor.DashboardResult"%>
<%@ page import = "com.eg.EgAggregateInfo" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgAggregateInfo" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);
	
	EgAggregateInfo aggregateInfo =new EgAggregateInfo("manager");
	DashboardData d = (DashboardData) session.getAttribute("dashboardData");
	DashboardResult r = (DashboardResult) session.getAttribute("dashboardResult");
	EgAggregateInfo aggInfo=new EgAggregateInfo("manager");
	IniUI ui = (IniUI)IniUI.getInstance();
	String aggregateComp = ui.getValue("COMPONENT_METRIC_VIEW","AggregateComp");
	aggregateComp = (aggregateComp == null || aggregateComp.equals("null") || aggregateComp.trim().length()==0 ) ? "layerModel":aggregateComp;

	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	String showHostSystem=egUI.getValue("HOST_SYSTEM","Show_HostSystem");
	showHostSystem=(showHostSystem==null || showHostSystem.trim().length()==0)?"CompType":showHostSystem;

	boolean isShowHostSystemHost = false;
	boolean isShowHostSystemOS = false;
	boolean isShowHostSystemCompType = false;

	if(showHostSystem.equalsIgnoreCase("HostSystem"))
	{
		isShowHostSystemHost=true;
	}
	else if(showHostSystem.equalsIgnoreCase("OS"))
	{
		isShowHostSystemOS=true;
	}
	else
	{
		isShowHostSystemCompType = true;
	}

	long maxDuration;
	long totalDuration;
	long alarmCount = r.alarmCount;
	int measureCount = r.measureCount;
	if(r.alarms==null)
	{
%>
		<jsp:forward page="empty.jsp">
			<jsp:param name="reason" value="No components have been enabled for monitoring"/>
		</jsp:forward>
<%
	}
%>

<html>
<head>
<title>Problem Analysis</title>
 <egui:skin ui="monitor"/>

<!-- Screen width script started here -->
<SCRIPT LANGUAGE="JavaScript">
documentView ={
		getObject: function()
{
			if(typeof( window.innerWidth) == 'number')
			{//Firefox
				this.height = window.innerHeight;
				this.width = window.innerWidth-10;
				this.fireFox = true;
			}
			else if( document.documentElement && ( document.documentElement.clientWidth
				|| document.documentElement.clientHeight ))
			{//IE 6 + in 'standards compliant mode'
				this.height = document.documentElement.clientHeight;
				this.width = document.documentElement.clientWidth;
				this.ie = true;
			}
			else if(document.body && document.body.clientHeight)
			{ //IE 4 compatible
				this.height = document.body.clientHeight;
				this.width = document.body.clientWidth;
				this.ie = true;
			}

			this.screenHeight=window.screen.availHeight;
			this.screenWidth=window.screen.availWidth;
			return this;
		},
		getScreenHeight: function()
		{
			return this.getObject().screenHeight;
		},
		getScreenWidth: function()
		{
			return this.getObject().screenWidth;
		},
		getHeight: function()
		{
			return this.getObject().height;
		},
		getWidth: function()
		{
			return this.getObject().width;
		},
		isIE: function()
		{
				return this.getObject().ie;
		},
		isFireFox: function()
		{
				return this.getObject().fireFox;
}
	};
var old_width=0;
function bigScreenPage()
{
	if(old_width==0)
	{
		old_width=1000;
	}
	var divObj = document.getElementsByTagName('div');

	if(divObj!=null && divObj!=undefined)
	{
		var countSelect=divObj.length;

		for(var i=0;i<countSelect;i++)
		{
			var divId = divObj[i].id;
			var divWidth =divObj[i].offsetWidth;
			if(divWidth!=null && divWidth!=undefined && divId=='mainTable')
			{
				var newDivWidth=parseInt((parseInt(divWidth)/old_width) * documentView.getWidth());
				divObj[i].style.width=(newDivWidth)+"px";
			}
		}
	}
	old_width=documentView.getWidth();
}
window.onresize=bigScreenPage;
</script>
</head>
<body topmargin="0" marginheight="0" leftmargin="0" marginwidth="0" onload="bigScreenPage()">
<%
	List list = d.user.getServers(true);	
	EgUserRole userRole = d.user.getUserRole();
	boolean hasAllComponentAccess=userRole.hasAllComponentAccess();
	Object obj[] = list.toArray();
	Vector usersValidNicks = new Vector();
	for(int i=0;i<obj.length;i++)
	{
		String temp = obj[i].toString();
		String temp1 = temp.toString();
		temp = temp.substring(0,temp.indexOf(":"));
		usersValidNicks.add(temp);
		if(temp1.indexOf(":") != temp1.lastIndexOf(":"))
		{
			usersValidNicks.add(temp1);
		}
	}
	TreeMap problemMap = new TreeMap();
	TreeMap timeMap = new TreeMap();
	TreeMap maxTimeMap = new TreeMap();
	TreeSet sortedSet = new TreeSet();
	DateTimeTokenizer dtt = new DateTimeTokenizer();
	java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	EgDateInfo egDate = new EgDateInfo();
	java.util.Date now = new java.util.Date(egDate.egetDateUS());	
	dtt.setDateFormat(DateTimeTokenizer._YMD);
	dtt.setDateSeparator(DateTimeTokenizer.HYPHEN_SEPARATOR);
	dtt.setTimeFormat(DateTimeTokenizer.HMS);
	//sdf.setTimeZone(egDate.getRealTimeZone());
	dtt.setEndDateTime(sdf.format(now));
	totalDuration = 0l;
	maxDuration = dtt.getDateDifference();
	problemMap.clear();
	for (Iterator i=r.alarms.iterator(); i.hasNext(); )
	{
		String[] row = (String[])i.next();
		dtt.setStartDateTime(row[5]);
		long difference = dtt.getDateDifference();
		maxDuration = Math.max(maxDuration, difference);
		totalDuration += difference;
		String thisLayer = row[2];
		Integer count = (Integer)problemMap.get(thisLayer);
		if (count == null)
		{
			problemMap.put(thisLayer, new Integer(1));
			sortedSet.add("01#"+thisLayer);
		}
		else
		{
			int myVal = count.intValue();
			sortedSet.remove(myVal+"#"+thisLayer);
			sortedSet.remove("0"+myVal+"#"+thisLayer);
			myVal++;
			problemMap.put(thisLayer, new Integer(myVal));
			sortedSet.add(((myVal<10)?"0":"")+myVal+"#"+thisLayer);
		}
		Long layerTimeCount = (Long)timeMap.get(thisLayer);
		if (layerTimeCount == null)
		{
			timeMap.put(thisLayer, new Long(difference));
		}
		else
		{
			long myVal = layerTimeCount.longValue();
			myVal+=difference;
			timeMap.put(thisLayer, new Long(myVal));
		}
		//maxTimeMap
		Long maxDiff = (Long)maxTimeMap.get(thisLayer);
		if (maxDiff == null)
		{
			maxTimeMap.put(thisLayer, new Long(difference));
		}
		else
		{
			long myVal = maxDiff.longValue();
			myVal = Math.max(myVal, difference);
			maxTimeMap.put(thisLayer, new Long(myVal));
		}
	}
	Iterator keyiter = sortedSet.iterator();
	int maxVal = 5;
	int c=0;
	if (sortedSet.size()>0)
	{
	%>
<table width="100%"  height="100%" border="0"  cellpadding="0" cellspacing="0">
	
<!-- 	<tr>
		<td height="21" width="100%" colspan="4" >			
			<table align="left" cellspacing="0" cellpadding="0" border="0" width="100%" height="21">
				<tr>
					<td nowrap width="13%" height="21" id="table_header1"   align="left" >&nbsp;&nbsp;<egui:intnl text="Event Analysis"/></td>
<%
	EgServicesInfo s = new EgServicesInfo("manager");
	if(s.computeTopMetrics() && r.maxDisplayCompMap.size()>0)
	{
%>
					<td nowrap width="18%"  height="21"   class="heading_border_zone2"  align="left" id="mouse"> &nbsp;&nbsp;<a href="#" class="header_text_link_zone2"  onclick="javascript:parent.swapPage('minMax')"><egui:intnl text="Measures At-A-Glance"/></td>
<%
	}
%>
					<td width="69%" height="21" align="left" class="heading_border_zone2"> &nbsp;</td>
				</tr>
			</table>	
	
		</td>
	</tr> -->
	<tr>
		<td  width ="54%" height="100%"   valign="top"  align="left" id="lineright" class="eg_cellbglits">
			<table align="left" valign="top" cellspacing="0" cellpadding="0" border="0" width="100%">
				<tr>
					<td  width ="100%" height="100%"   valign="top"  align="left">
						<table align="left" valign="top" cellspacing="0" cellpadding="0" border="0" width="100%">
							<tr>
								<td width="40%" id="table_header" height="15" style="padding-left:4px" > <egui:intnl text="monitor.home.Layer"/>
								</td>
								<td width="20%" align="center" id="table_header" style="padding-left:4px" height="15"> <egui:intnl text="monitor.home.Unresolved Problems"/>
								</td>
								<td width="20%" height="15" align="center" style="padding-left:4px" id="table_header"> <egui:intnl text="monitor.home.Average Duration"/>
								</td>
								<td width="20%" align="center" height="15" style="padding-left:4px;border-right-width:0px" id="table_header" > <egui:intnl text="monitor.home.Maximum Duration"/>
								</td>
							</tr>
<%
		boolean overflow = sortedSet.size()>maxVal;	
		//if (overflow)
		{
%>
							<tr>
								<td align="right" valign="middle" height="25" colspan="4" id="body_headbg" style="border-right-width:0px;border-top-width:0px">
									<a href ="/final/monitor/EgSiteInfraView.jsp?disphist=yes" target="_parent" style="text-decoration=none;" class="eg_monlink"><egui:intnl text="monitor.home.Click here for more events"/>&nbsp;<img src="/final/monitor/eg_images/forward-arrow.gif" border="0"> </a>&nbsp; 
								</td>
							</tr>
<%
		}
%>
							<tr>
								<td colspan="4">
									<table align="left" valign="top" cellspacing="0" cellpadding="0" border="0" width="100%">
										<tr>
											<td width="40%" height="21" id="cell_border1"   style="padding:2px"><span  >&nbsp;<b><egui:intnl text="monitor.home.SUMMARY"/></b></span>
											</td>
											<td width="20%" height="21" align="left" id="cell_border2"  style="padding:2px" ><span> <b>&nbsp;&nbsp;<%=alarmCount%>&nbsp;</b></span>
											</td>
											<td width="20%" align="left" height="21" id="cell_border1"style="padding:2px" ><span> <b>&nbsp;&nbsp;&nbsp;<%=r.averageDuration%></b> </span>
											</td>
											<td width="20%" height="21" align="left"id="cell_border2" style="padding:2px;border-right-width:0px" ><span> <b>&nbsp;&nbsp;&nbsp;<%=r.maximumDuration%></b></span>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
/*		if(sortedSet.size()>9)
		{
			maxVal = 8;
			overflow = true;
		}
*/
		for (int i=0; i<maxVal; i++)
		{
			if (sortedSet.size()==0)
			{
				//add empty space to keep summary at the bottom
%>
							<tr><td align="right" height="25" >&nbsp;</td></tr>
					<%//=(i==(maxVal-1))?"<td>&nbsp;sdfsdf</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>":""%>
<%
			}
			else
			{
				String thisKey = (String)sortedSet.last();
				sortedSet.remove(thisKey);
				thisKey = thisKey.substring(thisKey.indexOf("#")+1);
				Integer thisVal = (Integer)problemMap.get(thisKey);
				if (thisVal==null)
					continue;
				int myCount = thisVal.intValue();
				Long timeVal = (Long)timeMap.get(thisKey);
				Long maxTimeVal = (Long)maxTimeMap.get(thisKey);
%>
							<tr>
								<td height="21" valign="top" id="cell_border1" style= "padding:2px"> &nbsp;<egui:intnl layer="<%=thisKey.trim()%>"/> </td>
								<td  height="21" valign="top" align="left" id="cell_border2" style="padding:2px" > &nbsp;&nbsp;<%=myCount%>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp; </td>
								<td  height="21" id="cell_border1"  valign="top"  align="left" style="padding:2px"> &nbsp;&nbsp;&nbsp; <%=DateTimeTokenizer.getTimeDifference(timeVal.longValue()/myCount)%> </td>
								<td height="21"  id="cell_border2" valign="top" align="left" style="border-right-width:0px;padding:2px" > &nbsp;&nbsp;&nbsp;<%=DateTimeTokenizer.getTimeDifference(maxTimeVal.longValue())%> </td>
							</tr>
<%
			}
		}
%>
						</table>
					</td>
				</tr>
			</table>
		</td>
		<td  width ="1%" height="100%"   valign="top"  align="left" style="padding:0px"><img src="/final/monitor/eg_images/spacer.gif" width="8" border="0"></td>
		<td width="45%" height="100%" valign="top" align="left" style="padding:0px" id="lineleft" class="eg_cellbglits">
		<div id="mainTable" class="div_scroll" style="border:0px solid #ff0000;width:484px;height:100%">
			<table align="left" valign="middle" cellspacing="0" cellpadding="0" border="0" width="100%" style="padding:0px;border-top-width:0px;border-right-width:0px">
			<form name="frm" style="margin:0px; padding:0px">
<%
		String selection = request.getParameter("duration");
		String array[]={"1 hour","6 hours","12 hours","18 hours","24 hours"};
%>
				<tr>
					<td width="25%" id="table_header"  valign="middle"  align="left" wrap>&nbsp;<egui:intnl text="monitor.home.Component"/><br><egui:intnl text="monitor.home.Type"/></td>
					<td width="45%" height="21" id="table_header" valign="middle"  align="left" >&nbsp;<egui:intnl text="monitor.home.Component"/><br><egui:intnl text="monitor.home.Name"/></td>
					<td width="10%" height="21" id="table_header" valign="middle"  align="left" style="border-right-width:0px">&nbsp;<egui:intnl text="monitor.home.Events"/></td>
				</tr>
<%
		long duration = 0l;
		if (selection!=null)
		{
			if(selection.equals("1 hour"))
			{
				duration = 1 * 60 * 60 * 1000;				
				session.setAttribute("duration","1 hour");
			}
			else if(selection.equals("6 hours"))
			{
				duration = 6 * 60 * 60 * 1000;
				session.setAttribute("duration","6 hours");
			}
			else if(selection.equals("12 hours"))
			{
				duration = 12 * 60 * 60 * 1000;
				session.setAttribute("duration","12 hours");
			}
			else if(selection.equals("18 hours"))
			{
				duration = 18 * 60 * 60 * 1000;
				session.setAttribute("duration","18 hours");
			}
			else
			{
				duration = 24 * 60 * 60 * 1000;
				session.setAttribute("duration","24 hours");
			}
		}
		else
		{
			duration = 1 * 60 * 60 * 1000;
			session.setAttribute("duration","1 hour");
		}
%>
				<tr>
					<td colspan="3" height="25"  valign="middle"  align="center" id="body_headbg" style="border-left-width:0px;border-top-width:0px">&nbsp; <egui:intnl text="monitor.home.Components with most events in the last"/> &nbsp;&nbsp;<select name="durationcbo" onchange="javascript:parent.refreshPage(frm.durationcbo.options[frm.durationcbo.selectedIndex].value);"> 

	<%
				if(selection == null && session.getAttribute("duration")==null)
				{
					selection = "1 hour";
					session.setAttribute("duration","1 hour");
				}
				if(selection == null && session.getAttribute("duration")!=null)
				{
					selection = session.getAttribute("duration").toString();
				}
				for(int i=0;i<array.length;i++)
				{
					if(selection!=null && selection.trim().equalsIgnoreCase(array[i]))
					{
						String tempOptions="";
						String tempOptions2="";
						if(array[i].indexOf(" ")>-1)
						{
							
				tempOptions2=array[i].substring(0,array[i].indexOf(" "))+" "; tempOptions=array[i].substring(array[i].indexOf(" ")+1);	
						}
						else
						{
							tempOptions=array[i];
						}
	%>
					<OPTION value="<%=array[i]%>" selected>
					<%=tempOptions2%><egui:intnl text='<%="monitor.common."+tempOptions%>'/>
					<%//=array[i]%>
					</OPTION>
	<%
					}
					else
					{
						String tempOptions="";
						String tempOptions2="";
						if(array[i].indexOf(" ")>-1)
						{
							tempOptions2=array[i].substring(0,array[i].indexOf(" "))+" "; tempOptions=array[i].substring(array[i].indexOf(" ")+1);	
						}
						else
						{
							tempOptions=array[i];
						}
	%>
					<OPTION value="<%=array[i]%>"><%=tempOptions2%>
					<egui:intnl text='<%="monitor.common."+tempOptions%>'/>
					<%//=array[i]%>
					</OPTION>
	<%				}
				}
	%>		
					</select>
					</td>
				</tr>
<%
			//r.userComponentsList;
			String temp = "";
			int rowCount = 0;
			if(hasAllComponentAccess || (d.user.getLoginID()).equalsIgnoreCase("Admin")  || (d.user.getLoginID()).equalsIgnoreCase("supermonitor"))
			 rowCount = 8;
			HealthDAO healthDAO = new HealthDAO();
			Hashtable compListTable = new Hashtable();
			ArrayList validServers = new ArrayList();
			Hashtable keyCompListTable = new Hashtable();
			for(int i=0;i<r.userComponentsList.size();i++)
			{
				String name = r.userComponentsList.get(i).toString();
				if(name ==null || name.trim().length()==0)
					continue;
				String key = name.substring(0,name.indexOf(":"));
				String value = name.substring(name.indexOf(":")+1);
				compListTable.put(key,value);
				validServers.add(key);
				String newKey = key+":"+value.substring(0,value.indexOf(":"));
				keyCompListTable.put(newKey,name);
			}
			SmSessionData smsData = new SmSessionData(session.getId());
			EgThreadLocal egtl = new EgThreadLocal();
			egtl.set(smsData);
			EgComponentList mostEventsList =  healthDAO.getCompsMostEvents(duration,rowCount);//found using event_hist table
			EgDiscInfo discinfo = new EgDiscInfo("manager");

			if(mostEventsList!=null&&mostEventsList.size()>0)
			{
				EgComponentList result = new EgComponentList();
				if(isShowHostSystemCompType)
				{
					for(int index=0;index<mostEventsList.size() && (rowCount==0 || index < rowCount);index++)
					{
						EgMostProbComp component = (EgMostProbComp) mostEventsList.get(index);
						int count = component.getEventCount();
						String type = component.getType();
						String name = component.getDisplayName();
						List srvTypes;
						if(type.equals("Host_system"))
						{
							if(name.indexOf(":")!=-1)
								srvTypes = discinfo.getServerTypesForNick(name.substring(0,name.indexOf(":")));
							else
								srvTypes = discinfo.getServerTypesForNick(name.trim());

							if(srvTypes !=null && srvTypes.size() >0)
							{
								type=srvTypes.get(0).toString();
							}
							
							if(type!=null && type.trim().length()>0)
							{
								boolean toAdd=true;
								for(int j=0;j<result.size();j++)
								{
									EgMostProbComp componentObj = (EgMostProbComp) result.get(j);
									String temp_type = componentObj.getType();
									String temp_name = componentObj.getName();
									String temp_name1 = name;
									if(temp_name!=null && temp_name.indexOf(":")>-1)
									{
										temp_name=temp_name.substring(0,temp_name.indexOf(":"));
									}
									if(temp_name1!=null && temp_name1.indexOf(":")>-1)
									{
										temp_name1=temp_name1.substring(0,temp_name1.indexOf(":"));
									}
									if(temp_type!=null && temp_type.equalsIgnoreCase(type) && temp_name.equalsIgnoreCase(temp_name1))
									{
										int count_temp = componentObj.getEventCount();
										int total_count = count+count_temp;
										componentObj.setEventCount(total_count);
										toAdd=false;
										break;
									}
								}

								if(toAdd)
								{
									result.add(new EgMostProbComp(type, name, State.GOOD,count));
								}
							}
						}
						else
						{
							if(result!=null && result.size()>0)
							{
								boolean toAdd=true;
								for(int j=0;j<result.size();j++)
								{
									EgMostProbComp componentObj = (EgMostProbComp) result.get(j);
									String temp_type = componentObj.getType();
									String temp_name = componentObj.getName();
									String temp_name1 = name;
									if(temp_name!=null && temp_name.indexOf(":")>-1)
									{
										temp_name=temp_name.substring(0,temp_name.indexOf(":"));
									}
									if(temp_name1!=null && temp_name1.indexOf(":")>-1)
									{
										temp_name1=temp_name1.substring(0,temp_name1.indexOf(":"));
									}
									if(temp_type!=null && temp_type.equalsIgnoreCase(type) && temp_name.equalsIgnoreCase(temp_name1))
									{
										int count_temp = componentObj.getEventCount();
										int total_count = count+count_temp;
										componentObj.setEventCount(total_count);
										toAdd=false;
										break;
									}
								}

								if(toAdd)
								{
									result.add(new EgMostProbComp(type, name, State.GOOD,count));
								}
							}
							else
							{
								result.add((EgMostProbComp)component);
							}
						}
					}
				}
				else
				{
					result = mostEventsList;
				}

				EgExternalInfo externalInfo=new EgExternalInfo("manager");
				AgentConfig agentConfig=AgentConfig.getAgentConfig();
				EgAgentInfo agentInfo=new EgAgentInfo("manager");

				for(int index=0;index<result.size() && (rowCount==0 || index < rowCount);index++)
				{
					EgMostProbComp component = (EgMostProbComp) result.get(index);		
					String address="";
					int count = component.getEventCount();
					String type = component.getType();
					String name = component.getDisplayName();
					String name1 = name;
					temp = type;
					String type2=type;
					List srvTypes;
					
					if(type.equals("Host_system"))
					{
						if(name.indexOf(":")!=-1)
							srvTypes = discinfo.getServerTypesForNick(name.substring(0,name.indexOf(":")));
						else
							srvTypes = discinfo.getServerTypesForNick(name.trim());

						if(srvTypes !=null && srvTypes.size() >0)
						{
							type=srvTypes.get(0).toString();
							type2=type;
						}
					}
					
					if(validServers==null || !validServers.contains(type))
						continue;
					String display = "";
					if(type.startsWith("Agg_"))
						display = aggregateComp;
					name = (String) compListTable.get(type);
					String displayValue = "";
					if(name1.indexOf(":")!=-1)
					{
						String kkey = type+":"+name1.substring(0,name1.indexOf(":"));

						if(!keyCompListTable.containsKey(kkey))
							continue;
						displayValue = (String ) keyCompListTable.get(kkey.trim());
					}
					else
					{
						displayValue = (String ) keyCompListTable.get(type+":"+name1.trim());
					}
					if (displayValue == null)
						continue;
					name=displayValue.substring(displayValue.indexOf(":")+1);
					//address="/final/monitor/componentTabSet.jsp?monCmd=componentDashboard&componentName="+displayValue;
					//address="/final/monitor/EgDispLayers.jsp?site=NULL&qctr=0&comptype"+component.getType()+"&host="+component.getName();
					//address="/final/monitor/EgDispLayers.jsp?site=NULL&qctr=0&comptype="+EgURLEncoder.encode(type,"UTF-8")+"&host="+EgURLEncoder.encode(component.getName(),"UTF-8");
				
					/*if(type.startsWith("Agg_") && aggregateInfo.getView().equalsIgnoreCase("dashboard") && EgInstallInfo.isAggregationSupported())
					{					
						address = "/final/monitor/aggDashboard.jsp?comptype="+EgURLEncoder.encode(type,"UTF-8")+"&host="+EgURLEncoder.encode(name,"UTF-8");
					}
					else
					{*/
						address="../servlet/com.eg.EgDashboardController?from=list&site=NULL&qctr=0&comptype="+EgURLEncoder.encode(type,"UTF-8")+"&host="+EgURLEncoder.encode(name,"UTF-8")+"&tab=LayerModel&toDashBoardLayer=true";
						if(type!=null && !type.startsWith("Agg"))
						{
							address=address+"&showDashBoardLink=true";
						}
					//}
					//address="/final/monitor/EgSiteInfraView.jsp?site=NULL&fromalarm=NULL&qctr=2&comptype="+component.getType()+"&host="+component.getName()+"&layer="+layer1+"&test="+test1+"&tstate="+state1+"&msmt_host=";
					/*if(type.startsWith("Agg_")&& aggInfo.getView().equalsIgnoreCase("dashboard") 				&&EgInstallInfo.isAggregationSupported())	//Muniraj added on 30/04/2008
					{
						address="/final/monitor/aggDashboard.jsp?comptype="+EgURLEncoder.encode(type,"UTF-8")+"&host="+EgURLEncoder.encode(name,"UTF-8");
					}*/
					if(name1.toUpperCase().endsWith(":NULL"))
					name1 = name1.substring(0,name1.lastIndexOf(":"));
					/*
						address="../servlet/com.eg.EgMonitorController?monCmd=componentList&from=MainDashboard&action=search&selTypeString="+type+"&searchNameString="+name;		
					*/
					//type = (type.endsWith("_server"))?type.substring(0,type.indexOf("_server")):type;
					type = (temp.equals("Host_system"))?temp:type;
					/* 
						User might have had this component earlier and deleted. But that component's measures are still present in event_hist table. So we do not show that component.
					*/
					String userCompNick = null;
					if(name1.indexOf(":")>-1)
						userCompNick = name1.substring(0,name1.indexOf(":"));
					else
						userCompNick=name1;

					if(!usersValidNicks.contains(userCompNick))
						continue; 
%>
				<tr>
					<td width="40%" height="21" id="cell_border1" valign="top"  align="left" style="border-left-width:1px;padding:2px; border-top:0px"><a href="<%=address%>" class="eg_monlink" target="_parent">
<%
					if(isShowHostSystemOS && type!=null && type.equals("Host_system"))
					{
						boolean isAgentlessServer=agentInfo.isAgentlessServer(userCompNick,type2);
						String osName="";
						try
						{
							if(isAgentlessServer)
							{
								osName = externalInfo.getOSNameForAgentlessComp(userCompNick);
							}
							else
							{
								osName = agentConfig.getAgentOS(userCompNick);
							}
						}
						catch(Throwable th)
						{
							th.printStackTrace();
						}

						if(osName!=null && osName.trim().length()>0)
						{
							out.println(osName);
						}
						else
						{
%>
					<egui:intnl type="<%=type%>"/>
<%
						}
					}
					else
					{
%>
					<egui:intnl type="<%=type%>"/>
<%
					}
%>
					</a></td>
					<td width="30%" height="21" id="cell_border2"  valign="top"  align="left" style="padding:2px"><a href="<%=address%>" class="eg_monlink" target="_parent"><%=name1%></a></td>
					<td width="30%" height="21" id="cell_border1"  valign="top"  align="center" style="padding:2px;border-right:0px"><%=count%></td>
				</tr>
<%
				}
			}
			else
			{
%>
				<tr>
					<td align="center" height="150px" width="100%" valign="middle" colspan="3"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif"><br><b><egui:intnl text="monitor.home.No events found"/></b> </td>
				</tr>
<%
			}
%>

			</form>
			</table>
		</div>
		</td>
	</tr>
</table>
<%
	}
	else
	{
%>
		<table width="100%" height="100%" cellpadding="0" cellspacing="0" border="0">
			<tr>
				<td nowrap align="center" id="eg_errorsmall" valign="middle"> 
				<img src="/final/monitor/eg_images/egtick.gif">
				<br>
				<egui:intnl text="monitor.info.No events available"/>
				</td>
			</tr>
		</table>
<%
	}
%>
</body>
</html>