<%
/************************************************************************************************
*	File				:	ErDesktopResourcePrint.jsp
*	Version				:	7.2
*	Author				:	Suganya.S
*	Creation Date			:	08.07.2022
*
*************************************************************************************************/
%>


<%@ include file="ErTracker.jsp"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="com.eg.EgReportInfo"%>
<%@ page import="java.net.*"%>
<%@ page import="java.util.*"%>
<%@ page import="net.sf.json.*" %>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>
<%@ page import="com.egurkha.util.StringUtils"%>

<%
	String COLON = ":";
	String pdfPrint = request.getParameter("pdfPrint");
	String titleToDisplay=request.getParameter("er_RmDispName");
	String s_st_date = request.getParameter("startdate");
	String s_en_date = request.getParameter("enddate");
	String s_st_hr = request.getParameter("starthr");
	String s_en_hr = request.getParameter("endhr");
	String strmin = request.getParameter("startmin");
	String enmin = request.getParameter("endmin");
	
	if(s_st_date==null)
	{
		s_st_date = request.getParameter("er_stdate");
	}
	if(s_en_date==null)
	{
		s_en_date = request.getParameter("er_enddate");
	}
	if(s_st_hr==null)
	{
		s_st_hr = request.getParameter("er_sthr");
	}
	if(s_en_hr==null)
	{
		s_en_hr = request.getParameter("er_endhr");
	}
	if(strmin==null)
	{
		strmin = request.getParameter("er_stmin");
	}
	if(enmin==null)
	{
		enmin = request.getParameter("er_endmin");
	}
	String timefrom2=request.getParameter("timefrom");
	String minfrom2=request.getParameter("minfrom");
	String timeto2=request.getParameter("timeto");
	String minto2=request.getParameter("minto");
	String er_componentStr = request.getParameter("er_component");
	String er_componentType=request.getParameter("er_compType");
	String er_site = request.getParameter("er_site");
	String er_option =request.getParameter("er_option");
	String templateFor = request.getParameter("templateFor");
	String installDir = EgInstallInfo.getInstallDir();
	String s_iniFile_dir = installDir+ "/manager/config/";
	EgReportInfo reportInfo=new EgReportInfo("manager");
	ErUtils erUtils = new ErUtils();
	EgMappingInfo intlmap = null;
	if (thisuser != null) 
	{
		intlmap = new EgMappingInfo(thisuser.getLanguage());
	}
	
	String componentTypeDisp = "";
	if(er_componentType!=null)
	{
		componentTypeDisp = intlmap.getComponentTypeDescription(er_componentType);
		if(componentTypeDisp.equalsIgnoreCase("All"))
		{
			componentTypeDisp = intlmap.getTextDescription("reporter.common.All Component Types");
		}
	}
	String headerKeyName="";
	if(er_option!=null && er_option.equalsIgnoreCase("Segment"))
	{
		headerKeyName=er_option+" : "+er_site;
	}
	else if(er_option!=null && er_option.equalsIgnoreCase("Service"))
	{
		headerKeyName=er_option+" : "+er_site;
	}
	else if(er_option!=null && er_option.equalsIgnoreCase("Component"))
	{
		headerKeyName=er_option;
	}
	else
	{
		headerKeyName="Zone"+" : "+er_site;
	}
	try 
	{
		EgTimeZoneConverter timeZoneConverterStart = null;
		EgTimeZoneConverter timeZoneConverterEnd = null;
		String startDateForDisplay = null;
		String startHourForDisplay = null;
		String endDateForDisplay = null;
		String endHourForDisplay = null;
		String startMinForDisplay = null;
		String endMinForDisplay = null;
		String strManagerURL = request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort();
		String controllerURL = strManagerURL+"/final/servlet/com.eg.ErTemplateC;jsessionid=" + session.getId() + "?";
%>

<!Doctype html>
<head>
<%
	if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
	{
%>
	<title>&nbsp; <egui:intnl text="reporter.common.Reporter" />
	&nbsp; &nbsp; <egui:intnl text="reporter.common.Print" /> &nbsp;</title>
<%
	}
	else
	{
%>
	<title>&nbsp; <egui:intnl text="reporter.common.Reporter" />
	&nbsp; &nbsp;</title>
<%
	}
%>

<meta name="Author" content="">
<meta  charset="UTF-8">
<link rel="stylesheet" type="text/css" href="/final/reporter/styles/printpagestyle.css" />
<link rel="stylesheet" type="text/css" href="/final/styles/eGLightThemeIcons.css" />
</head>
<body  style="padding:10px;background-color:#ffffff">
<%
	String strLogCls = "printHeaderBoxLogo";
	String pdfIconStyle = "";
	if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
	{
		strLogCls = "printHeaderBoxLogo";
	}
	else
	{
		strLogCls = "printPdfHeaderBoxLogo";
		pdfIconStyle = "position:relative; left:370px;";
	}
	if (pdfPrint != null && pdfPrint.equalsIgnoreCase("yes")) 
	{
%>
	<div class="<%=strLogCls%>" style="padding-top:10px"><img src="<%=imageName%>" border="0" /></div>
<%
	}
	else
	{
%>
	<div class="<%=strLogCls%>"><img src="<%=imageName%>" border="0" /></div>
<%
	}
%>
	<div class="printHeaderBox">
<%
	if (!StringUtils.isNull(titleToDisplay))
	{
%>
		<div class="printHeaderBoxTitle"><%=titleToDisplay%> for &nbsp;<%=headerKeyName%>&nbsp;</div>
<%
	}
	else
	{
%>
		<div class="printHeaderBoxTitle"><egui:intnl text="reporter.common.eG Report " />&nbsp;<%=headerKeyName%>&nbsp;</div>
<%
	}
	if (pdfPrint != null && pdfPrint.equalsIgnoreCase("yes")) 
	{
%>
		<div class="printHeaderBoxPrintIcon" style="float:left"><img class="iconPrinter mouse"  src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" border="0" onClick="javascript:print()" alt='<egui:intnl text="reporter.common.PRINT"/>' title='<egui:intnl text="reporter.common.PRINT"/>'/></div>
<%
	}
%>
	</div>
	<div class="printOuterBoxNoBorder"> 
<%
	String dispStart = "";
	String dispEnd = "";
	dispStart = s_st_date + " " + s_st_hr + COLON + strmin ;
	dispEnd = s_en_date + " " + s_en_hr + COLON + enmin ;
	//Time zone Conversion
	timeZoneConverterStart = new EgTimeZoneConverter(dispStart ,thisuser);
	startDateForDisplay = (String) timeZoneConverterStart.getDate(false);
	startHourForDisplay = timeZoneConverterStart.getHour();
	startMinForDisplay = timeZoneConverterStart.getMinute();

	timeZoneConverterEnd = new EgTimeZoneConverter(dispEnd ,thisuser);
	endDateForDisplay = (String) timeZoneConverterEnd.getDate(false);
	endHourForDisplay = timeZoneConverterEnd.getHour();
	endMinForDisplay = timeZoneConverterEnd.getMinute();

	String pdfStartDate = startDateForDisplay+" "+startHourForDisplay+":"+startMinForDisplay;
	String pdfEndDate = endDateForDisplay+" "+endHourForDisplay+":"+endMinForDisplay;

	String Days = reportInfo.getExcludeWeekend(templateFor);
	String excludeweekend=request.getParameter("er_excwe");
	if (excludeweekend==null ||	excludeweekend.equals(""))
	{
		excludeweekend="No";
	}
	Vector dvec = new Vector();
	String stimefmt =	pdfStartDate+ " hrs";
	String etimefmt =	pdfEndDate+ " hrs";
	String ssd="Start Date : "+stimefmt+"  "+"End Date : "+etimefmt;
	if(er_componentStr.indexOf(":")>-1)
	{
		er_componentStr = er_componentStr.substring(0, er_componentStr.lastIndexOf(":"));
		if(er_componentStr.indexOf(":")>-1)
		{
			er_componentStr = er_componentStr.substring(0, er_componentStr.lastIndexOf(":"));
		}
	}
%>
	<div class="printSelectionFields"><egui:intnl text="reporter.common.Analyze by" /> - <span class="bold"><%=intlmap.getTextDescription("reporter.common."+er_option)%></span></div>
	<div class="printSelectionFields"><egui:intnl text="reporter.common.Component Type" /> - <span class="bold"><%=componentTypeDisp%></span></div>
	<div class="printSelectionFields"><egui:intnl text="reporter.common.Component" /> - <span class="bold"><%=er_componentStr%></span></div>
	<div class="printSelectionFields"><egui:intnl text="reporter.common.Timeline" /> - <span class="bold"><%=stimefmt%>&nbsp;to <%=etimefmt%></span></div>
<%
	String sessionName = templateFor.toUpperCase()+"_RESULT";
	HashMap resultMap = (HashMap)session.getAttribute(sessionName);
	boolean noDataFound = resultMap.get("NO_DATA") != null ? (Boolean)resultMap.get("NO_DATA"):false;
%>
	</div>
	<div class="printOuterBox">
<%
	if(!noDataFound)
	{
		List measureList = resultMap.get("measureList") != null ? (ArrayList)resultMap.get("measureList"):null;
		if(measureList != null && measureList.size() > 0)
		{
%>
			<table cellpadding="0px" cellspacing="0px" style="width:100%">
				<tbody>
<%			for(int m=0;m<measureList.size();m++)
			{
				String eachMeasure = (String)measureList.get(m);
				String key = "barChartObj_"+eachMeasure;
				String titleKey = "barChartTitle_"+eachMeasure;
				JSONObject barChartObj = resultMap.get(key) != null ? (JSONObject)resultMap.get(key):null;
				String barchartTitle = resultMap.get(titleKey) != null ? (String)resultMap.get(titleKey):null;
				int tdWidth = 49;
				int chartWidth=440;
				if(measureList.size() == 1)
				{
					tdWidth = 100;
					chartWidth=800;
				}
				String padding="padding:0 0 0 0";
				if(measureList.size() > 1 && m%2 == 0)
				{
					padding="padding-right:10px";
				}
				if(barChartObj != null)
				{
					session.setAttribute(key,barChartObj);
					String chartUrl=controllerURL+"command=IMAGE&option=print&er_width="+chartWidth+"&er_height=270&sessionKey="+key+"&templateFor="+templateFor;
%>
					<%if(m%2 == 0)
					{%>
						<tr style="width:100%">
					<%}%>
						<td height="100%" style="width:<%=tdWidth%>%;<%=padding%>">
							<div class="printOuterBox" style="width:100%">
								<div class="printOuterBoxHeader"><%=barchartTitle%></div>
								<div style="width:100%;padding:0px;height:270px;">
									<img src="<%=chartUrl%>"/>
								</div>
							</div>
						</td>
					<%if(m%2!=0)
					{%>
						</tr>
					<%}%>
<%				}
			}
%>
			</tbody>
		</table>
<%		String gridTitle = resultMap.get("gridTitle") != null ? (String)resultMap.get("gridTitle"):null;
		JSONArray gridData = resultMap.get("gridData") != null ? (JSONArray)resultMap.get("gridData"):null;
		JSONObject gridColumns = resultMap.get("gridColumns") != null ? (JSONObject)resultMap.get("gridColumns"):null;
		ArrayList subCol = new ArrayList();
		if(gridData != null && gridData.size() > 0)
		{
%>
		<div class="printOuterBoxHeader" style="margin-top:10px;">
			<%=intlmap.getTextDescription("reporter.common."+gridTitle)%>
		</div>
		<div class="newTable" style="width:100%;">
			<table valign="middle" width="100%" cellpadding="0px" cellspacing="0px" >
				<thead>
					<tr>
<%
					Iterator itrs = gridColumns.keySet().iterator();
					while(itrs.hasNext())
					{
						String rowSpan = "2";
						String colSpan = "1";
						String colKey = (String)itrs.next();
						Object colObj = gridColumns.get(colKey);
						String dispStr = colKey;
						String width="10";
						if(colObj instanceof JSONArray)
						{
							JSONArray JAry = (JSONArray)colObj;
							subCol.add(JAry);
							if(JAry.size() > 0)
							{
								colSpan = JAry.size()+"";
								rowSpan = "1";
							}
						}
%>
						<th rowspan ="<%=rowSpan%>" colspan="<%=colSpan%>" class="printTableHeader"><%=dispStr%></th>
<%
					}
%>
					</tr>
<%
					if(subCol.size()>0)
					{
%>
					<tr>
<%
						for(int u=0;u<subCol.size();u++)
						{
							JSONArray sub = (JSONArray)subCol.get(u);
							String colSpan = sub.size()+"";
							if(sub.size() > 0)
							 {
								for(int v=0;v<sub.size();v++)
								{
									String dispStr = (String)sub.get(v);
%>
									<th class="subHeader"><%=dispStr%></th>
<%
								 }
							 }
						 }
%>
					</tr>
<%
					}
%>
				</thead>
				<tbody>
<%
				for(int i=0;i<gridData.size();i++)
				{
%>
					<tr>
<%
						JSONArray tabledata =  (JSONArray)gridData.get(i);
						for(int t=0;t<tabledata.size();t++)
						{
%>
							<td style="text-align:center;"><%=tabledata.get(t)%></td>
<%						}
%>					</tr>
<%				}
%>				</tbody>
			</table>
		</div>
<%		}
	}
	else
	{
%>
		<table width='100%' height='100%'><tr><td align='center' valign='middle'><img src='../images/Light/nomeasures_custom.png' /></td></tr></table>
<%	}
%>
	</div>
<%
		if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
		{
%>
			<div class="printFooterText"><%=strPrintFooterText%></div>
<%
		}
	}
%>
	</body>
</html>
<%
}
catch(Exception e)
{
	e.printStackTrace();
}
%>