<!DOCTYPE html>

<%
/*****************************************************************************
*	File name		: ErExternalMonitorPrint.jsp
*	Purpose			: This page Handles Print External Monitor Report
*	Version			: Reporter 7.0
*   Author          : Ezhilarasi 
*   Creation Date   : 14/Aug/2018
********************************************************************************/
%>
<%@ include file="ErTracker.jsp"%>
<%@ page import="egurkha.reporter.*"%>
<%@ page import="java.util.*"%>
<%@ page import = "net.sf.json.*" %>
<%@ page import="com.eg.*"%>
<%@ page import="com.eg.EgDbInfo"%>
<%@ page import="com.eg.IniFile"%>
<%@ page import="com.eg.EgDateInfo"%>
<%@ page import="java.text.Format.*"%>
<%@ page import="java.text.DateFormat.*"%>
<%@ page import="java.text.*"%>
<%@ page import="com.eg.EgReportInfo"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="com.eg.EgTablesInfo"%>
<%@ page import="com.egurkha.util.DateUtil"%>
<%@ page import="com.egurkha.util.*"%>
<%@ page import="com.egurkha.util.DateTimeTokenizer"%>
<%@ page import="com.eg.EgURLDecoder"%>
<%@ page import="com.eg.EgDbInfo"%>
<%@ page import="com.eg.EgConfigInfo"%>
<%@ page import="java.io.*"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%
try
{
	Map allData = (Map)session.getAttribute("allData");
	String pdfPrint = request.getParameter("pdfPrint");
	String reportFor = request.getParameter("reportFor");
	EgReportInfo reportInfo = new EgReportInfo("manager");
	String strManagerURL = request.getScheme()+"://"+request.getServerName()+":"+ request.getServerPort();
	String controllerURL = strManagerURL+"/final/servlet/com.eg.ErExternalMonitorReportC;jsessionid=" + session.getId() + "?";
	EgMappingInfo intlmp = new EgMappingInfo(thisuser.getLanguage());
	Map selectParams =  (Map)session.getAttribute("selectionDetail");
	String analysisBy = (String)selectParams.get("analysisBy");
	String siteName = (String)selectParams.get(analysisBy);
	String startDate = (String)selectParams.get("startdate");
	String endDate = (String)selectParams.get("enddate");
	String starthr = (String)selectParams.get("starthr");
	String endhr = (String)selectParams.get("endhr");
	String startmin = (String)selectParams.get("startmin");
	String endmin = (String)selectParams.get("endmin");
	String weekends = (String)selectParams.get("weekends");
	String timeFrom = (String)selectParams.get("timeFrom");
	String timeTo   = (String)selectParams.get("toTime");
	String uid = request.getParameter("uid");
	String Days="Saturday,Sunday";
	if("00:00:00".equals(timeFrom))
	{
		timeFrom  = timeFrom.substring(0,timeFrom.lastIndexOf(":"));
		timeTo    = timeTo.substring(0,timeTo.lastIndexOf(":"));
	}
	String dispStart = startDate + " " + starthr  + ":" + startmin  ;
	String dispEnd   = endDate + " " + endhr + ":" + endmin ;
	
	String reportForTest=reportInfo.getValue("ExternalMonitor_Report","reportForTest");
	List reporForList=new ArrayList(Arrays.asList((String[])reportForTest.split(",")));
	Map testDispNameMap=new HashMap();
	for(int r=0;r<reporForList.size();r++)
	{
		String eachTest=(String)reporForList.get(r);
		if(eachTest != null && eachTest.indexOf("$") != -1)
		{
			String testDisp=eachTest.substring(eachTest.indexOf("$")+1);
			eachTest=eachTest.substring(0,eachTest.indexOf("$"));
			testDispNameMap.put(eachTest,testDisp);
		}
	}
	String fileName="";
	String titleToDisplay=reportInfo.getValue("ExternalMonitor_Report",reportFor+"_title");
	if(titleToDisplay==null || titleToDisplay.length()==0)
		titleToDisplay="External Monitoring";
	if(testDispNameMap.get(reportFor) == null || (testDispNameMap.get(reportFor) !=null && testDispNameMap.get(reportFor).toString().length()==0))
		fileName="External Monitoring";
	else
		fileName=(String)testDispNameMap.get(reportFor);
	HashMap paramVal =new HashMap();
	paramVal.put("fileName",fileName);
	session.setAttribute("parameters", paramVal);

	%>
	<!Doctype html>
		<head>
			<meta http-equiv="refresh">
			<link rel="stylesheet" type="text/css" href="/final/styles/eGLightThemeIcons.css" />
			<link rel="stylesheet" type="text/css" href="/final/reporter/styles/printpagestyle.css" />
			<style>
				@media print {body {-webkit-print-color-adjust: exact;}}
				.ptoc1-style-left { margin-left: 0 }
				.ptoc2-style-left { margin-left: 16 }
				.ptoc3-style-left { margin-left: 32 }
				.ptoc4-style-left { margin-left: 48 }
				.ptoc5-style-left { margin-left: 64 }
				.ptoc6-style-left { margin-left: 80 }
				.ptoc-table { border: 0; width: 100%;align:center;valign:middle;font-size:30px;line-height:80px}
				.ptoc-left-col { width: 99%; padding-right: 0 }
				.ptoc-right-col { text-align: right; padding-left: 0;vertical-align: middle; }
				.ptoc-link { text-decoration: none; color: black }
			</style>
			<%
				if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
				{
					%>

					<title>&nbsp; <egui:intnl text="reporter.common.Reporter" />
					&nbsp; &nbsp;-PDR- &nbsp;</title>
					
					<%
				}
				else
				{
					%>
						<title>External Monitoring Report</title>			
					<%
				}
			%>
		</head>
		<body marginwidth="20" marginheight="20" bgcolor="#FFFFFF">
		<%
			String strLogCls = "printHeaderBoxLogo";
			boolean isPDF=false;
			if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
			{
				strLogCls = "printHeaderBoxLogo";
			}else
			{
				strLogCls = "printPdfHeaderBoxLogo";
				isPDF=true;
			}
			if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
			{
%>
				<div class="<%=strLogCls%>" style="padding:10px"><img src="<%=imageName%>" border="0" /></div>
<%
			}
			else
			{
%>
				<div class="<%=strLogCls%>"><img src="<%=imageName%>" border="0" /></div>
<%
			}
%>
			<div class="printHeaderBox">
				<%
				if (!StringUtils.isNull(titleToDisplay))
				{
					%>
					<div class="printHeaderBoxTitle"><%= titleToDisplay %></div>
					<%
				}
				else
				{
					%>
					<div class="printHeaderBoxTitle"><egui:intnl text="reporter.common.External Monitoring Report " /></div>
					<%
				}
				if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
				{
			%>
					<div class="printHeaderBoxPrintIcon"><img class="iconPrinter mouse"  id="pri ntbt" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" border="0" onClick="javascript:window.print()" alt='<egui:intnl text="reporter.common.PRINT"/>' title='<egui:intnl text="reporter.common.PRINT"/>'/></div>
			<%
				}
			%>
		</div>
		<div class="printOuterBoxNoBorder"> 
			<%
			if(analysisBy != null)
			{
				%>
				<div class="printSelectionFields"><egui:intnl text="reporter.common.Analyzed by"/> : <span class="bold"><%=analysisBy%></span></div>
				<%
			}
			if(weekends != null)
			{
				%>
				<div class="printSelectionFields"><egui:intnl text="reporter.common.Exclude Weekends"/> : <span class="bold"><%=weekends%></span></div>
				<%
			}
			if(dispStart != null)
			{
				%>
				<div class="printSelectionFields"><egui:intnl text="reporter.common.Start Date" /> : <span class="bold"><%=dispStart%></span></div>
				<%
			}
			if(dispEnd != null)
			{
				%>
				<div class="printSelectionFields"><egui:intnl text="reporter.common.End Date" /> : <span class="bold"><%=dispEnd%></span></div>
				<%
			}
			if(timeFrom != null)
			{
				%>
				<div class="printSelectionFields"><egui:intnl text="reporter.common.Time Period"/> : <span class="bold"><%=timeFrom%>&nbsp;   <egui:intnl text="reporter.common.to "/>&nbsp; <%=timeTo%></span></div>
				<%
			}
			%>	
		</div>
		<%
		if(allData.get("gridPanel") != null)
		{
			Map gridPanel=(Map)allData.get("gridPanel");
			boolean isChartView=false;
			if(gridPanel.get("chartView") != null)
			{
				Boolean chartView=(Boolean)gridPanel.get("chartView");
				if(chartView.booleanValue())
				{
					isChartView=true;
				}
			}			
			if(gridPanel != null)
			{
				%>
				<div class="clearDiv"></div>
				<%
				if(isChartView)
				{
					JSONArray testPanelArry=(JSONArray)gridPanel.get("testPanelList");
					for(int t=0;t<testPanelArry.size();t++)
					{
						JSONObject eachPanelObj=(JSONObject)testPanelArry.get(t);
						String panelTitleStr=(String)eachPanelObj.get("title");
						String panelHeight=(String)eachPanelObj.get("panelHeight");
						String typeStr=(String)eachPanelObj.get("type");
						JSONArray subPanelArry=(JSONArray)eachPanelObj.get("subPanels");
						int panelHeightInt=300;
						if(panelHeight != null && panelHeight.length()>0)
						{
							panelHeightInt=Integer.parseInt(panelHeight);
						}
						%>
							<div class="printOuterBox">								
								<div class="printOuterBoxHeader"><%=panelTitleStr%></div>
								<div style="width:100%;overflow:hidden;position: relative;">
								<%
								if(typeStr != null)
								{
									if(typeStr.equalsIgnoreCase("overviewPanel"))
									{
										for(int s=0;s<subPanelArry.size();s++)
										{
											JSONObject subPanelObj=(JSONObject)subPanelArry.get(s);
											String internalSubPanelName=(String)subPanelObj.get("internalSubPanelName");
											String subPanelTitle=(String)subPanelObj.get("title");
											Map subPanelDetail=(Map)allData.get(internalSubPanelName);
											
											if(!subPanelDetail.isEmpty())
											{
											JSONObject chartCollection=(JSONObject)subPanelDetail.get("chartCollection");
											JSONObject fistChartData=(JSONObject)chartCollection.get("fistChartData");
											JSONArray firstSummaryList=(JSONArray)fistChartData.get("firstSummaryList");
											String successPercent=(String)fistChartData.get("successPercent");
											String failurePercent=(String)fistChartData.get("failurePercent");
											String successColor=(String)fistChartData.get("successColor");
											String failureColor=(String)fistChartData.get("failureColor");
											%>												
											<table valign="middle" width="100%" cellpadding="0px" cellspacing="0px">
											<tbody>
											<tr>
											<%
											for(int f=0;f<firstSummaryList.size();f++)
											{
												JSONObject eachSummary=(JSONObject)firstSummaryList.get(f);
												if(eachSummary.get("value") != null)
												{
													String imageCls=(String)eachSummary.get("imageCls");
													String value=(String)eachSummary.get("value");
													String name=(String)eachSummary.get("name");
													%>
													<td align="center" width="22%">
														<table cellpadding="0px" cellspacing="0px">
															<tbody>
																<tr> 
																	<td align="right"><div class="<%=imageCls%>"></div></td>
																	<td style="padding:5px 5px 5px 10px"><span class="newFont_bold28"><%=value%></span></td>
																</tr>
																<tr>
																	<td align="center" style="padding:7px" colspan="2"><span class="newFont_normal13"><%=name%></span></td>
																</tr>
															</tbody>
														</table>
													</td>
													<%
												}
											}
											%>
												<td>
												<div>
												<table align="center">
													<tbody>
													<tr>
														<td>
															<div align="center" style="position:relative; width:160px; height:160px">
																<img width="100%" height="100%" src="<%=controllerURL+"&er_view=print&width=150&height=150&internalSubPanelName="+internalSubPanelName%>"/>
															</div>
														</td>
														<td>
															<table align="center" cellpadding="0" cellspacing="0" border="0">
																<tbody>
																<tr>
																	<td>
																	<svg xmlns="http://www.w3.org/2000/svg" height="10" width="10">
																	  <circle cx="5" cy="5" r="4" fill="<%=successColor%>" />
																	</svg>
																	</td>
																	<td nowrap="" align="left" style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11">Success</td>
																	<td nowrap="" align="left" style="" class="newFont_normal11"><%=successPercent%></td>
																</tr>
																<tr>
																	<td>
																	<svg xmlns="http://www.w3.org/2000/svg" height="10" width="10">
																	  <circle cx="5" cy="5" r="4" fill="<%=failureColor%>" />
																	</svg>
																	</td>
																	<td nowrap="" align="left" style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11">Failure</td>
																	<td nowrap="" align="left" style="" class="newFont_normal11"><%=failurePercent%></td>
																</tr>
																</tbody>
															</table>
														</td>
													</tr>
													</tbody>
												</table>
												</div>
												</td>
											</tr>
											</tbody>
											</table>
											<%
											}
											else
											{
											%>
												<table width="100%" ><tr><td align="center" valign="middle" style="vertical-align:middle">
													<img src="/final/images/Light/nomeasures_custom.png">
												</table>
											<%
											}
										}
									}
									else if(typeStr.equalsIgnoreCase("digitalWithChart"))
									{
										%>
										<table valign="middle" width="100%"  cellpadding="0px" cellspacing="0px">
										<tbody>											
										<tr>
										<%
										double eachPanelWidth=100.0;
										for(int s=0;s<subPanelArry.size();s++)
										{
											JSONObject subPanelObj=(JSONObject)subPanelArry.get(s);
											String internalSubPanelName=(String)subPanelObj.get("internalSubPanelName");
											String lineCls=(String)subPanelObj.get("lineCls");
											String subPanelTitle=(String)subPanelObj.get("title");
											String subPanelWidth=(String)eachPanelObj.get("width");
											if(eachPanelObj.get("panelColWidth") != null)
											{
												double panelColWidth=(Double)eachPanelObj.get("panelColWidth");
												eachPanelWidth=panelColWidth*100.0;
											}
											Map subPanelDetail=(Map)allData.get(internalSubPanelName);
											JSONObject chartCollection=(JSONObject)subPanelDetail.get("chartCollection");
											JSONObject digitalObj=(JSONObject)chartCollection.get("digitalObj");
											Boolean isData=(Boolean)subPanelDetail.get("isData");	
											String alignStyle="";
											if(lineCls != null) 
											{
												if(lineCls.equalsIgnoreCase("graphSeperatorLineRight"))
												{
													alignStyle="border-right:1px solid #dedede;";
												}
												else if(lineCls.equalsIgnoreCase("graphSeperatorLineBottom"))
												{
													alignStyle="border-bottom:1px solid #dedede;";
												}
												else if(lineCls.equalsIgnoreCase("graphSeperatorLineBottomRight"))
												{
													alignStyle="border-right:1px solid #dedede;border-bottom:1px solid #dedede;";
												}
												
											}
											%>
											<td style="vertical-align:top;<%=alignStyle%>">
											<%
											if(isData!=null && isData.booleanValue())
											{
												%>
												<div class="" >
												<div  class="printOuterBoxHeader"><%=subPanelTitle%></div>
												<div style="width:100%;overflow:hidden;position: relative;">
												<table width="100%"><tbody>
												<tr>
													<td align="center" width="22%">
														<table cellpadding="0px" cellspacing="0px">
															<tbody>
																<tr> 
																	<td align="right"><div class="<%=digitalObj.get("imageCls")%>"></div></td>
																	<td style="padding:5px 5px 5px 10px"><span class="newFont_bold28"><%=digitalObj.get("value")%></span></td>
																</tr>
																<tr>
																	<td align="center" style="padding:7px" colspan="2"><span class="newFont_normal13"><%=digitalObj.get("title")%></span></td>
																</tr>
															</tbody>
														</table>
													</td>
												</tr>
												<tr><td width="100%">
												<img  src="<%=controllerURL+"&er_view=print&width="+subPanelWidth+"&height="+(panelHeightInt-90)+"&internalSubPanelName="+internalSubPanelName%>"/>	
												</td></tr>
												</tbody></table>
												</div>
												<%
											}
											else
											{
												%>
												<table width="100%" ><tr><td align="center" valign="middle" style="vertical-align:middle">
													<img src="/final/images/Light/nomeasures_custom.png">
												</table>
												<%
											}
											%>
											</td>
											<%
											if(eachPanelWidth>90)	
											{
												%>
												</tr>
												<tr>
												<%
											}
										}
										%>
										</tr>
										</tbody>
										</table>
										<%
									}
									else if(typeStr.equalsIgnoreCase("anyChart"))
									{
										%>
										<table style="page-break-inside: auto !important" valign="middle" width="100%"  cellpadding="0px" cellspacing="0px">
										<tr>
										<%
										for(int s=0;s<subPanelArry.size();s++)
										{
											JSONObject subPanelObj=(JSONObject)subPanelArry.get(s);
											String internalSubPanelName=(String)subPanelObj.get("internalSubPanelName");	
											String lineCls=null;
											if(subPanelObj.get("lineCls") != null)
												lineCls=(String)subPanelObj.get("lineCls");
											String subPanelTitle=(String)subPanelObj.get("title");
											String subPanelWidth=(String)eachPanelObj.get("width");
											Map subPanelDetail=(Map)allData.get(internalSubPanelName);
											boolean isGrid=false;
											if(subPanelDetail.get("gridCollection") != null)
												isGrid=true;
											Boolean isData=(Boolean)subPanelDetail.get("isData");
											String alignStyle="";
											if(s%2==0)
											{
												alignStyle="padding:10px 10px 10px 0px;";
											}
											else
											{
												alignStyle="padding:10px 10px 10px 10px;";
											}
											if(lineCls != null)
											{
												if(lineCls.equalsIgnoreCase("graphSeperatorLineRight"))
												{
													alignStyle+="border-right:1px solid #dedede;";
												}
												else if(lineCls.equalsIgnoreCase("graphSeperatorLineBottom"))
												{
													alignStyle+="border-bottom:1px solid #dedede;";
												}
												else if(lineCls.equalsIgnoreCase("graphSeperatorLineBottomRight"))
												{
													alignStyle+="border-right:1px solid #dedede;border-bottom:1px solid #dedede;";
												}
											}
											%>
											<td style="vertical-align:top;<%=alignStyle%>" align="left" height="auto" width="50%"  valign="top">
											<div class="">
												<div class="printOuterBoxHeader"><%=subPanelTitle%></div>
												<div style="width:100%;overflow:hidden;position: relative;">
											<%
											if(isData!=null && isData.booleanValue())
											{
												if(isGrid)
												{
													%>
														<div class="newTable"><%=getGridData(subPanelDetail)%></div>
														<tr>
															<td style="vertical-align:top;padding:10px 0px 10px 10px" align="left" height="auto" width="50%"  valign="top">
															<div class="printOuterBoxHeader">Top 10 Transactions Based on Success (%)</div>
															<div style="border-right:1px solid #dedede;"><img width="100%" height="100%" src="<%=controllerURL+"&er_view=print&width="+subPanelWidth+"&height="+(panelHeightInt+30)+"&internalSubPanelName="+internalSubPanelName%>"/>
															</div>
															</td>
															<td style="vertical-align:top;padding:10px 10px 10px 0px" align="left" height="auto" width="50%"  valign="top">
															<div class="printOuterBoxHeader">Top 10 Transactions Based on Average (Secs)</div>
															<div><img width="100%" height="100%" src="<%=controllerURL+"&isAvgbarChart=yes&er_view=print&width="+subPanelWidth+"&height="+(panelHeightInt+30)+"&internalSubPanelName="+internalSubPanelName%>"/>
															</div>
															</td>
														</tr>
													<%
												}
												else
												{
													%>
													<img width="100%"  src="<%=controllerURL+"&er_view=print&width="+subPanelWidth+"&height="+(panelHeightInt-30)+"&internalSubPanelName="+internalSubPanelName%>"/>	
													<%
												}
											}
											else
											{
												%>
												<table width="100%" ><tr><td align="center" valign="middle" style="vertical-align:middle">
													<img src="/final/images/Light/nomeasures_custom.png">
												</table>
												<%
											}
											%>
											</div>
											</td>
											<%
											if((s+1)%2==0)
											{
												%>
												</tr>
												<tr>
												<%
											}
										}
										%>
										</tr>
										</table>
										<%
									}
									else if(typeStr.equalsIgnoreCase("flowChart"))
									{
									}
								}
								%>
								</div>
							</div>
							<div class="clearDiv" style="height:20px"></div>							
						<%
					}
					
				}
				else
				{
					Boolean isData=(Boolean)gridPanel.get("isData");
					%>
					<div class="printOuterBox">
						<div class="printOuterBoxHeader">Details</div>
						<div style="width:100%;overflow:auto;padding:10px">

					
					<%
					if(isData!=null && isData.booleanValue())
					{
						%>
							<div class="newTable"><%=this.getGridData(gridPanel)%></div>
						<%						
					}
					else
					{
						%>
							<table width="100%" height="100%"><tr><td align="center" valign="middle" style="vertical-align:middle">
							<img src="/final/images/Light/nomeasures_custom.png"></table>
						<%
							
					}
					%>
						</div>
					</div>
					<%
				}
			}
		}
		if(pdfPrint!=null && pdfPrint.equalsIgnoreCase("yes"))
		{
			%>
				<div class="printFooterText"><%=strPrintFooterText%></div>
			<%
		}
		%>
		</body>
	</html>
	<%
}
catch(Exception e)
{
	e.printStackTrace();
}
%>
<%!
public String getGridData(Map gridPanel)
{
	StringBuffer sb=new StringBuffer();
	JSONObject gridCollection=(JSONObject)gridPanel.get("gridCollection");
	JSONArray gridColumn=(JSONArray)gridCollection.get("gridColumn");
	JSONArray gridData=(JSONArray)gridCollection.get("gridData");
	boolean needColInfo=true;
	if(gridCollection.get("needSubColumn") != null && gridCollection.get("needSubColumn").toString().equalsIgnoreCase("no"))
	{
		needColInfo=false;
	}
	sb.append("<table align=\"center\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\">");
	sb.append("<thead><tr>");
	String headerAlign="center";
	String colInfo=" rowspan=\"2\" ";
	boolean isSubColumn=false;
	JSONArray subColumnArry=new JSONArray();
	JSONArray tempGridColumn=new JSONArray();
	for(int c=0;c<gridColumn.size();c++)
	{
		JSONObject eachColumnObj=(JSONObject)gridColumn.get(c);
		if(eachColumnObj.get("subColumnArry") != null)
		{
			isSubColumn=true;
			JSONArray subColArry=(JSONArray)eachColumnObj.get("subColumnArry");
			JSONObject subObj=null;
			for(int s=0;s<subColArry.size();s++)
			{
				subObj=new JSONObject();
				String eachData=(String)subColArry.get(s);
				subColumnArry.add(eachData);
				subObj.put("name",eachData);
				subObj.put("width",eachColumnObj.get("width"));
				subObj.put("align",eachColumnObj.get("align"));				
				tempGridColumn.add(subObj);
			}
		}
		else
		{
			tempGridColumn.add(eachColumnObj);		
		}
	}
	for(int c=0;c<gridColumn.size();c++)
	{
		JSONObject eachColumnObj=(JSONObject)gridColumn.get(c);
		String eachHeader=(String)eachColumnObj.get("name");
		if(eachHeader != null && eachHeader.indexOf("(") != -1)
		{
			String unitStr=eachHeader.substring(eachHeader.indexOf("(")+1,eachHeader.lastIndexOf(")"));
			eachHeader=eachHeader.substring(0,eachHeader.indexOf("("))+"<br />("+unitStr+")";
		}
		headerAlign="center";
		if(eachColumnObj.get("align") != null)
		{
			headerAlign=(String)eachColumnObj.get("align");
		}
		if(eachColumnObj.get("subColumnArry") != null)
		{
			JSONArray subColArry=(JSONArray)eachColumnObj.get("subColumnArry");
			colInfo=" colspan=\""+subColArry.size()+"\" ";
		}	
		if(needColInfo)
			sb.append("<th align=\""+headerAlign+"\" "+colInfo+">"+eachHeader+"</th>");
		else
			sb.append("<th align=\""+headerAlign+"\">"+eachHeader+"</th>");
		
	}
	sb.append("</tr>");
	if(isSubColumn)
	{
		sb.append("<tr>");
		for(int s=0;s<subColumnArry.size();s++)
		{
			String eachSubCol=(String)subColumnArry.get(s);
			sb.append("<th align=\""+headerAlign+"\">"+eachSubCol+"</th>");
		}
		sb.append("</tr>");
	}
	sb.append("</thead>");
	sb.append("<tbody>");
	Map tempDataMap=new LinkedHashMap();
	for(int d=0;d<gridData.size();d++)
	{
		JSONArray eachDataArry=(JSONArray)gridData.get(d);
		if(eachDataArry.size() > 0)
		{
			String compName=(String)eachDataArry.get(0);
			if(tempDataMap.get(compName)==null)
			{
				List tempDataList=new ArrayList();
				tempDataList.add(eachDataArry);
				tempDataMap.put(compName,tempDataList);
			}
			else
			{
				List tempDataList=(List)tempDataMap.get(compName);
				tempDataList.add(eachDataArry);
			}											
		}
	}
	gridColumn=tempGridColumn;
	Iterator itr=tempDataMap.keySet().iterator();
	int v=0;
	while(itr.hasNext())
	{
		String eachKey=(String)itr.next();
		List eachKeyList=(List)tempDataMap.get(eachKey);
		int rowSpanCount=eachKeyList.size();
		for(int d=0;d<rowSpanCount;d++)
		{
			JSONArray eachDataArry=(JSONArray)eachKeyList.get(d);
			sb.append("<tr>");
			String dataAlign="center";
			for(int e=0;e<eachDataArry.size();e++)
			{
				String eachData=(String)eachDataArry.get(e);
				dataAlign="center";
				if(eachData != null)
				{
					if(eachData.indexOf("~DDLink") != -1)
						eachData=eachData.substring(0,eachData.indexOf("~DDLink"));
					if(eachData.indexOf("$") != -1)
					{
						String bgColor=eachData.substring(eachData.indexOf("$")+1);
						eachData=eachData.substring(0,eachData.indexOf("$"));
						eachData="<div style='position:relative;margin:auto!important;width:50px;border-radius:2px;padding:3px 0px 0px 0px;background:"+bgColor+";color:#ffffff'>"+eachData+"<div/>";
					}
					if(eachData.indexOf("stageColor") != -1)
					{
						String bgColor="#EE2C24";
						bgColor=eachData.substring(eachData.indexOf("stageColor")+10);
						eachData="<div><svg xmlns=\"http://www.w3.org/2000/svg\" width=\"10\" height=\"10\"><g><circle cx=\"5\" cy=\"5\" r=\"4\" fill=\""+bgColor+"\" stoke-width=\"0\" ></circle></g></svg></div>";
					}
				}
				
				JSONObject colObj=(JSONObject)gridColumn.get(e);											
				if(colObj.get("align") != null)
				{
					dataAlign=(String)colObj.get("align");
				}
				if(rowSpanCount>1 && d==0 && e==0)
				{
					sb.append("<td rowspan=\""+rowSpanCount+"\" align=\""+dataAlign+"\">"+eachData+"</td>");		
				}
				else
				{
					if(rowSpanCount>1 && d!=0 && e==0)
						continue;
					sb.append("<td align=\""+dataAlign+"\">"+eachData+"</td>");
				}
			}
			sb.append("</tr>");
		}
	}
	sb.append("</tbody></table>");
	return sb.toString();	
}
%>
