<%@ page import = "com.eg.RumConstants" %>
<%@ page import = "com.eg.RumPropsManager" %>


<%
	response.setHeader("Cache-Control","no-store,no-store,must-revalidate");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires",0);
	
	long unlockTime = 0;
	String attemptStatus = "unknown";


	String logoutMsg = request.getParameter("timeoutMsg");
	String forceLogout = request.getParameter("forceLogout");
	if (forceLogout == null || forceLogout.trim().length() == 0)
	{
		forceLogout = "false";
	}
	
	if (forceLogout.equalsIgnoreCase("true") ||
		logoutMsg != null && logoutMsg.equalsIgnoreCase("You have been timed out. Please sign in to continue."))
	{
		session.removeAttribute("userId");
		response.sendRedirect("/rumcollector/admin.jsp");
	}
	
	attemptStatus = RumPropsManager.getLoginAttemptStatus();
	if(attemptStatus.equalsIgnoreCase("locked"))
	{
		unlockTime = RumPropsManager.getLastAttemptTime() + RumPropsManager.getUnlockTime();
	}
	else
	{
		if(attemptStatus.equalsIgnoreCase("unlocked"))
		{
			RumPropsManager.setLoginAttempt(true);
		}
		String status = RumPropsManager.getSessionStatus(session);

		if(status.equalsIgnoreCase("active"))
		{
			response.sendRedirect(request.getContextPath()+"/admin.jsp");
		}
	}
%>
<html>
<head>
	<title>Rum Collector Administrator Console</title>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="shortcut icon" href="images/eg.ico">
	<link rel="stylesheet" type="text/css" href="css/admin.css">
	<script>
		var LOGBACK_DELAY = "<%=RumConstants.LOGBACK_DELAY%>";
		var XML_DELAY = "<%=RumConstants.XML_DELAY%>";
		var MMDB_DELAY = "<%=RumConstants.MMDB_DELAY%>";
		var RUM_DELAY = "<%=RumConstants.RUM_DELAY%>";
	</script>
	<script>
		<%@include file="/WEB-INF/js/jquery.js" %>
		<%@include file="/WEB-INF/js/admin.js" %>
		<%@include file="/WEB-INF/js/timeout.js" %>
	</script>
	<script>
		document.onscroll = function()
		{
			clearTimeout(time);
			time = setTimeout(logout,timeoutTime);
		}
		
		var attempt_status = '<%=attemptStatus%>';
		var unlockTime = <%=unlockTime%>;

		var xmlhttp;
		var val;
		function auth()
		{
			var thisForm = document.indexForm;
			if (window.XMLHttpRequest) {
				xmlhttp=new XMLHttpRequest();
			} else {
				xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");
			}

			if (xmlhttp != null)
			{
				document.getElementById("loginError").innerHTML = "";
				var pwd = document.getElementById("password").value;

				var eglpwd = md5(pwd);
				var parameters = "eglpwd="+eglpwd;
				var url = "/rumcollector/Properties?action=authUser";

				xmlhttp.open("POST",url,false);
				xmlhttp.onreadystatechange = function()
				{
					if (xmlhttp.readyState==4 && xmlhttp.status==200)
					{
						var response=JSON.parse(xmlhttp.responseText);

						try
						{
							if (response.result== "success")
							{
								val = "true";
								loadMenuItem(1);
							}
							else if (response.result == "failure")
							{
								val = "false";
							}
							else
							{
								val = response.result;
								if(val.indexOf(":")>0)
								{
									var v_args = val.split(":");
									val = attempt_status = v_args[0];
									unlockTime = Number(v_args[1]);
								}
							}
						}
						catch (error){
							alert(error);
						}
					}
				}
				xmlhttp.setRequestHeader('Content-type','application/x-www-form-urlencoded');
				xmlhttp.send(parameters);
			}
			else
			{
				alert("does not support XMLHttp");
				//alert('<egui:intnl text="admin.login.Your browser does not support XMLHTTP"/>');
			}
		}

		function checkPassword()
		{
			if (attempt_status!=null && attempt_status == 'locked')
			{
				return;
			}
			auth();
			var thisForm = document.indexForm;
			if(val == "false")
			{
				$('#login  Error').html('Please provide a valid password.');
				$('#password').val('');
				$('#password').focus();
				return false;
			}
			else if(val == "locked")
			{
				setTimePeriod();
			}
			else
			{
				//thisForm.action = "/final/toolkit";
				thisForm.submit();
			}
		}

		window.onload = function() {
			if(attempt_status == 'locked')
			{
				controlEls('','clear',true,'auto','0.3');
			}
			else
			{
				$('#password').focus();
			}
			history.forward();
		}
	</script>
</head>
<body>
<form name="indexForm" method='POST' style="padding:0px;margin:0px">
<input type="hidden" name="userId" id="userId" value="<%=(String)session.getAttribute("userId")%>">
<div id="login-box" style="display:none;">
<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center" height="100%" id="login_bg_img">
		<tbody><tr>
			<td id="login_bg_img" height="20" valign="top" width="20">&nbsp;</td>
		</tr>
		<tr>
			<td valign="top" align="center" height="100%">
				<table width="97%" border="0" cellspacing="0" cellpadding="0" id="eg_whitebg" height="100%">
					<tbody><tr>
						<td width="370" align="center" valign="middle"></td>
					</tr>
					<tr>
						<td valign="middle" colspan="2" width="100%">
							<table border="0" cellspacing="0" cellpadding="0" width="100%" height="415">
								<tbody><tr>
									<td height="415" valign="middle" width="365" align="left">
										<table border="0" cellspacing="0" cellpadding="0" width="100%">
											<tbody><tr>
												<td width="365" height="145"><img src="./images/log_globe1.gif" height="145" width="365"></td>
											</tr>
											<tr>
												<td width="365" height="140"><img src="./images/log_globe2.gif" height="140" width="365"></td>
											</tr>
											<tr>
												<td width="365" height="130"><img src="./images/log_globe3.gif" height="130" width="365"></td>
											</tr>
										</tbody></table>
									</td>
									<td height="415" valign="middle">
										<table border="0" cellspacing="0" cellpadding="0" width="100%" height="100%">
											<tbody><tr>
												<td id="screenHeight" width="365" height="100">&nbsp;</td>
											</tr>
											<tr>
												<td align="center" valign="top">
													<table border="0" cellspacing="0" cellpadding="0">
														<tbody><tr>
															<td width="100%" align="center"><span class="loginTitle">Rum Collector Administrator Console</span><br><br>
																<div id="LoginPage">
																	<div id="layout2">
																		<div id="authWrapper">
																			<div id="mainPanel">
																				<table border="0" cellpadding="0" cellspacing="0">
																					<tbody>
																					<tr>
																						<td height="20"></td>
																					</tr>
																					<tr>
																						<td style="padding-bottom:4px;">
																							<label for="password"><b>Password</b></label>
																						</td>
																					</tr>
																					<tr>
																						<td>
																							<div class="input-wrap">
																								<input name="pwd" id="password" type="password" onpaste="return false" oncopy="return false" tabindex="1" onkeypress="pwdKeyPress(event);">
																							</div>
																						</td>
																					</tr>
																					<tr>
																						<td width="100%" height="10" id="eg_blankspace">&nbsp;</td>
																					</tr>
																					<tr>
																						<td>
																							<table width="100%" border="0">
																								<tbody><tr>
																									<td width="68%">&nbsp;</td>
																									<td align="left">
																										<a href="javascript:void(0);" class="submitBtn mouse" id="SubmitButton" tabindex="4" name="loginBtn" onclick="checkPassword()">
																											Sign In</a>
																									</td>
																								</tr>
																							</tbody></table>
																						</td>
																					</tr>
																					<tr>
																						<td width="100%" height="5" id="eg_blankspace">&nbsp;</td>
																					</tr>
																				</tbody></table>
																			</div>
																		</div>
																		<div style="clear:both"></div>
																	</div>
																</div>
															</td>
														</tr>
														<tr>
															<td>
																<div>
																<table border="0" cellpadding="0" cellspacing="0" width="100%">
																	<tbody><tr>
																		<td id="switchPage1" style="padding-left:74px;">
																		</td>
																		<td id="switchPage2" style="display:none;padding-left:74px;">|<a href="#" id="switchToLoginPage" class="body_link">&nbsp;Login Page&nbsp;</a>|</td>
																	</tr>
																</tbody></table>
																</div>
															</td>
														</tr>
														<tr>
															<td style="padding-top:10px;">
																<div id="loginError" align="center" style="width:450px;color:red;font-size:11px;"></div>
															</td>
														</tr>
													</tbody></table>
												</td>
											</tr>
										</tbody></table>
									</td>
								</tr>
							</tbody></table>
						</td>
					</tr>
					<tr>
						<td valign="bottom" width="100%" style="padding-bottom:6px" colspan="2">
							<table border="0" cellpadding="0" cellspacing="0" width="100%" valign="bottom">
								<tbody><tr>
									<td width="450">&nbsp;
									<b>&copy;&nbsp;eG Innovations, Inc. All Rights Reserved</b></td>
									<td align="right"><b>Powered by eG Enterprise</b>&nbsp;&nbsp;&nbsp;</td>
								</tr>
							</tbody></table>
						</td>
					</tr>
				</tbody></table>
			</td>
		</tr>
		<tr>
			<td id="login_bg_img" height="20" valign="top" width="20">&nbsp;</td>
		</tr>
	</tbody></table>
</div>
<div class="appFrame appBackgroundColor x-body" id="properties-box" style="display:none;">
	<div class="appBackgroundColor appContainer">
		<div class="appContainer">
			<div class="appFrame appBackgroundColor">
				<!-- ---------------- top menu bar on top of everything: main nav, eval toolbar, etc. ---------------- -->
				<div class="ads-top-menu-bar-container-row">
					<div class="titleBarDiv">
					<!-- -------- TOP MENU BAR ROW -------- -->
						<div class="ads-top-menu-bar-ContainerRow ads-display-table">
							<div class="ads-display-table-row">
								<!-- -------- EG INNOVATIONS LOGO -------- -->
								<div class="ads-display-table-cell ads-top-menu-bar-full-logo-container" style="vertical-align: middle; ">
									<img src="images/eGLogo.png" style="cursor: pointer" class="hoverable">
								</div>
								<!-- -------- spacer -------- -->
								<div class="ads-display-table-cell" style="width: 100%; "></div>
								<!-- -------- SIGNOUT -------- -->
								<div class="ads-display-table-cell" style="vertical-align: middle; padding-right: 12px;">
									<div class="adsCursorPointer hoverable dropdown-toggleAD">
										<!-- <img src="images/signout.png" style="width: 20px; height: 20px; " class="hoverable"> -->
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="ads-main-container-under-top-menu-bar">
					<!-- ---------------- LEFT NAV ---------------- -->
					<!-- adding  position: absolute; z-index: 2; to make drop shadow "on top of" right side content in 4.1 -->
					<div class="leftListDiv leftNavPanel" style="height: 100%; width: 256px; min-width: 0px; position: absolute; z-index: 2;margin-top: 40px;">
						<!-- keep in sync with NAV_PANEL_WIDTH -->
						<div class="absoluteExpanded ads-left-nav2-container">
							<div class="ads-left-nav2-directive-root-container">
								<!-- ============================== Security Settings ============================= -->
								<div class="ads-display-table" style="width: 100%;">
									<div id="menu0" onclick="loadMenuItem(0);" class="ads-display-table-row ads-left-nav-main-item hoverable">
										<div id="menuText0" class="ads-display-table-cell ads-left-nav-main-item-label">
											Security Settings
										</div>
									</div>
								</div>
								<!-- ============================== Rum.Properties ============================= -->
								<div class="ads-display-table" style="width: 100%;">
									<div id="menu1" onclick="loadMenuItem(1);" class="ads-display-table-row ads-left-nav-main-item hoverable">
										<div id="menuText1" class="ads-display-table-cell ads-left-nav-main-item-label">
											RUM Properties
										</div>
									</div>
								</div>
								<!-- ============================== Logback.Properties ============================= -->
								<div class="ads-display-table" style="width: 100%;">
									<div id="menu2" onclick="loadMenuItem(2);" class="ads-display-table-row ads-left-nav-main-item hoverable">
										<div id="menuText2" class="ads-display-table-cell ads-left-nav-main-item-label">
											Logback.Properties
										</div>
									</div>
								</div>
								<!-- ============================== egrum.js ============================= -->
								<div class="ads-display-table" style="width: 100%;">
									<div id="menu3" onclick="loadMenuItem(3);" class="ads-display-table-row ads-left-nav-main-item hoverable">
										<div id="menuText3" class="ads-display-table-cell ads-left-nav-main-item-label">
											egrum.js
										</div>
									</div>
								</div>
								<!-- ============================== Log View ============================= -->
								<div class="ads-display-table" style="width: 100%;">
									<div id="menu4" onclick="loadMenuItem(4);" class="ads-display-table-row ads-left-nav-main-item hoverable">
										<div id="menuText4" class="ads-display-table-cell ads-left-nav-main-item-label">
											Log View / Download
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<!-- ---------------- RIGHT SIDE ---------------- -->
					<div class="ads-right-side-content-container">
						<!-- ---------------- Page Title / Location Bar / Refresh / Time Range  ---------------- -->
						<div class="titleBarDiv">
							<div class="adsMainTitleBarContainerRow" style="position: relative;">
								<div class="ads-display-table ads-main-title-bar-height">
									<div class="ads-display-table-row">
										<div class="ads-display-table-cell" style="padding-left: 6px;">
										</div>
										<!-- padding left of screen title -- NO hamburger -->
										<div class="ads-display-table-cell" style="padding-left: 18px">
										</div>
										<div class="ads-display-table-cell ads-main-title-bar-height ads-width-100percent ads-vertical-align">
											<!-- ----------- Inner TABLE for location name, App selector, Beta Indicator -------- -->
											<div class="ads-display-table ads-main-title-bar-height">
												<div class="ads-display-table-row">
													<!-- ---------------- Screen Title / Location ---------------- -->
													<div class="ads-display-table-cell ads-main-title-bar-height ads-vertical-align ads-location-bar-container">
														<div class="ads-display-table ads-main-title-bar-location-text ads-main-title-bar-action-item-hover-styles adsCursorPointer hoverable" style="white-space: normal; word-break: break-all;" ad-top-offset="-32">
															<div class="ads-display-table-row" style="border:solid 1px red;">
																<div id="titleText" class="ads-display-table-cell ads-vertical-align ads-location-bar-string"></div>
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="ads-right-side-under-location-bar-container" style="overflow: auto">
						<div id="resultDiv" class="adsPageContainerDiv ads-border-top ads-section-home-background-image"></div>
							<div id="egrumjsDiv" align="center" style="display:none;">
								<table  class="radiobt"  style="table-layout:auto">
									<tr><td height="50" colspan="6"></td></tr>
									<tr>
										<td>Capture raw timestamp metrics for Navigation Timing API: </td>
										<td width="5"></td>
										<td>
											<input type="radio" name="egrum-debug-nav" value="true" id="yes-egrum-debug-nav"/>
											<label for="yes-egrum-debug-nav">Yes</label>
										</td>
										<td width="5"></td>
										<td>
											<input type="radio" name="egrum-debug-nav" value="false" id="no-egrum-debug-nav"/>
											<label for="no-egrum-debug-nav">No</label>
										</td>
									</tr>
									<tr><td height="10" colspan="5"></td></tr>
									<tr>
										<td>Capture raw timestamp metrics for Resource Timing API: </td>
										<td width="5"></td>
										<td>
											<input type="radio" name="egrum-debug-rsrc" value="true" id="yes-egrum-debug-rsrc"/>
											<label for="yes-egrum-debug-rsrc">Yes</label>
										</td>
										<td width="5"></td>
										<td>
											<input type="radio" name="egrum-debug-rsrc" value="false" id="no-egrum-debug-rsrc"/>
											<label for="no-egrum-debug-rsrc">No</label>
										</td>
									</tr>
									<tr><td height="25" colspan="5"></td></tr>
									<tr>
										<td>Enable advanced configuration options: </td>
										<td width="5"></td>
										<td>
											<input type="radio" name="enable-config-options" value="true" id="yes-enable-config-options" onclick="enableEgRumConfigOpts();"/>
											<label for="yes-enable-config-options">Yes</label>											
										</td>
										<td width="5"></td>
										<td>
											<input type="radio" name="enable-config-options" value="false" id="no-enable-config-options" onclick="enableEgRumConfigOpts();"/>
											<label for="no-enable-config-options">No</label>
										</td>
									</tr>
									<tr><td height="10" colspan="5"></td></tr>
									<tr id = "js-error-row">
										<td>Capture JavaScript Errors: </td>
										<td width="5"></td>
										<td>
											<input type="radio" name="egrum-config-js" value="true" id="yes-egrum-config-js"/>
											<label for="yes-egrum-config-js">Yes</label>
										</td>
										<td width="5"></td>
										<td>
											<input type="radio" name="egrum-config-js" value="false" id="no-egrum-config-js"/>
											<label for="no-egrum-config-js">No</label>
										</td>
									</tr>
									<tr><td height="10" colspan="5"></td></tr>								
									<tr id= "egrum-config-rsrc-row">
										<td>Capture Resource Details: </td>
										<td width="5"></td>
										<td>
											<input type="radio" name="egrum-config-rsrc" value="true" id="yes-egrum-config-rsrc"/>
											<label for="yes-egrum-config-rsrc">Yes</label>
										</td>
										<td width="5"></td>
										<td>
											<input type="radio" name="egrum-config-rsrc" value="false" id="no-egrum-config-rsrc"/>
											<label for="no-egrum-config-rsrc">No</label>
										</td>
									</tr>
									<tr><td height="10" colspan="5"></td></tr>
									<tr id="egrum-config-ajax-row">
										<td>Capture Ajax Requests: </td>
										<td width="5"></td>
										<td>
											<input type="radio" name="egrum-config-ajax" value="true" id="yes-egrum-config-ajax" />
											<label for="yes-egrum-config-ajax">Yes</label>
										</td>
										<td width="5"></td>
										<td>
											<input type="radio" name="egrum-config-ajax" value="false" id="no-egrum-config-ajax"/>
											<label for="no-egrum-config-ajax">No</label>
										</td>
									</tr>
									<tr><td height="10" colspan="5"></td></tr>
									<tr id="egrum-config-exclude-url-row">
										<td>URL Patterns to be excluded: </td>
										<td width="5"></td>
										<td>
											<input type="text" name="egrum-config-exclude-url" id="exclude-url" value="none" oninput="textBoxValidation('excludedURL');"/>
											<span style="color:#FF0000;" id="exclude-url-error-msg" ></span>
										</td>
									</tr>
									<tr><td height="10" colspan="5"></td></tr>
									<tr id="egrum-config-include-url-row">
										<td>URL Patterns to be included: </td>
										<td width="5"></td>
										<td>
											<input type="text" name="egrum-config-include-url" id="include-url" value="*" oninput="textBoxValidation('includedURL')"/>
											<span style="color:#FF0000;" id="include-url-error-msg" ></span>
										</td>
									</tr>
									<tr><td height="10" colspan="5"></td></tr>
									<tr>
										<td colspan="6" style="text-align:center">
											<input type="button" value="Update" class="save-btn" onclick="saveEgRumJSOption();">
										</td>
									</tr>
								</table>
							</div>
							<div id="logviewDiv" class="logviewDiv" align="center" style="display:none;">
								<table cellpadding="0" cellspacing="0" border="0" style="width:100%;">
									<tr>
										<td>
											<div align="center" style="border:1px solid #d2d2d2; background-color:#F7F7F7;padding: 10px 0px;">
												<table cellpadding="0" cellspacing="0" border="0">
													<tr>
														<td>Log / Data file directory</td>
														<td width="20"></td>
														<td>Log / Data file name</td>
														<td width="20"></td>
														<td>Filter by date</td>
													</tr>
													<tr><td height="5"></td></tr>
													<tr>
														<td><select class="filterDwn" id="logsDir" name="logsDir" onchange="loadlogView(1);"></select></td>
														<td></td>
														<td><select  class="filterDwn" id="logFile" name="logFile" onchange="loadlogView(2);"></select></td>
														<td></td>
														<td><select  class="filterDwn" id="filterByDate" name="filterByDate" onchange="loadlogView(3);"></select></td>
													</tr>	
												</table>
											</div>
										</td>
									</tr>
									<tr><td height="20"></td></tr>
									<tr>
										<td>
											<table cellpadding="0" cellspacing="0" border="0" style="width:100%;">
												<tr>
													<td>
														<div class="last-modified-div">
															<span class="last-modified">Last modified time: </span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span id="lastModifiedText"></span>
														</div>
														<div class="dowload-div">
															<table cellpadding="0" cellspacing="0" border="0" height="10">
																<tr>
																	<td><div class="iconReset" title="Reset" onClick="loadlogView(2);"></div></td>
																	<td width="5"></td>
																	<td><div class="iconDownload" title="Download" onClick="downloadLog();"></div></td>
																</tr>
															</table>
														</div>
													</td>
												</tr>
												<tr>
													<td><textarea  id="actualLogs" class="actualLogs" readonly style="border:#abb2bd 1px solid;width:100%; outline: none; resize: none;padding: 5px;"></textarea >
												</td>
											</tr>
											</table>
										</td>
									</tr>
								</table>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
				
<!--Save Alert Notification Start -->
<div id="platformNotificationsContainer" class="ui-notify" style="z-index: 100000; position: absolute; overflow-wrap: break-word;">
		<div class="ui-notify-message ui-notify-message-style" style="background-color:#F2F2F2; ">
			<div style="position: relative;">
				 <div class="ads-display-table">
					  <div class="ads-display-table-row">
						  <!-- icon 
						  <div class="ads-display-table-cell" style="vertical-align: top;">
							   <img src="./images/info.svg" style="height: 28px; width: 28px; ">
						  </div>--> 
						  <!-- message --> 
						  <div class="ads-display-table-cell ads-vertical-align" style="width: 320px; padding-left: 8px;">
								<div class="ads-bold-text" style="width: 256px; color: #404040; font-size: 14px; line-height: 20px; "></div>
								<div class="ads-readable-text-line-height" id="notificationMessage"  style="width: 320px; padding-top: 0px; color: #404040; font-size: 14px; "></div>
						  </div>
					  </div>
				  </div>
				  <!-- close button --> 
				  <div style="position: absolute; top: 0px; right: 0px;">
					 <div class="pull-right adsCursorPointer ui-notify-close ads-close-button" onclick="hideNotification();"></div>
				  </div>
			 </div>
		</div>
</div>
<!--Save Alert Notification Ends -->
<!--Loading div start -->
<div id="outer-div">
	<div id="preloader-popup" class="x-mask-msg" style="z-index: 19001;left:45%;top:35%;">
		<div id="status-popup">Loading...</div>
	</div>
</div>
<!--Loading div ends -->
</div>

<script language="Javascript">
	$().ready(function() {
		if(document.referrer != '/rumcollector/admin.jsp'){ 
			history.pushState(null, null, '/rumcollector/admin.jsp');
			window.addEventListener('popstate', function () {
				history.pushState(null, null, '/rumcollector/admin.jsp');
			});
		}

		if('<%=logoutMsg%>' != null && '<%=logoutMsg%>' != 'null'){
			$('#loginError').html('<%=logoutMsg%>');
		}
		else if(attempt_status == 'locked')
		{
			setTimePeriod();
		}
	});

	document.getElementById('password').addEventListener("keydown", function(e){
		if (e.which == 13)
		{
			e.preventDefault();
			checkPassword();
		}
		else if (e.getModifierState("CapsLock")) 
		{
			$('#loginError').html('Caps Lock is on');
		}
		else
		{
			var curPos = document.getElementById('password').selectionStart;
			if(curPos <=1 && e.which == 8)
			{
				$('#loginError').html('Please provide a password.');
			}
			else if(attempt_status != 'locked')
			{
				$('#loginError').html('');
			}
		}
	});
	

	function setTimePeriod()
	{	
		var timePeriodMsg;
		var now = new Date().getTime();
		var distance = unlockTime - now;
		

		var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
		var seconds = Math.floor((distance % (1000 * 60)) / 1000);
		
		if(minutes >0)
		{
			timePeriodMsg = minutes+(minutes == 1 ? ' minute ' : ' minutes ');
			timePeriodMsg += seconds+(seconds <= 1 ? ' second.' : ' seconds.');
		}
		else
		{
			timePeriodMsg = seconds+(seconds <= 1 ? ' second.' : ' seconds.');
		}
	  callLoginTimer(timePeriodMsg);
	}
	
	function callLoginTimer(timePeriodMsg)
	{
		var x = setInterval(function(){
			var now = new Date().getTime();
			var distance = unlockTime - now;

			if (distance < 0)
			{
				clearInterval(x);
				attempt_status = 'unlocked';
				controlEls('','focus',false,'pointer','');
			}
			else
			{
				var timerMsg = 'The account is locked. Try logging in after '+timePeriodMsg;
				controlEls(timerMsg,'clear',true,'auto','0.3');
			}
		}, 1000);
	}
	
	function controlEls(tMsg,pVal,pRead,sBtnCur,sBtnOpc)
	{
		$('#loginError').html(tMsg);
		pVal == 'focus' ? $('#password').focus() : $('#password').val('');
		$('#password').prop("readonly", pRead);
		$('#SubmitButton').css('cursor',sBtnCur);
		$('#SubmitButton').css('opacity',sBtnOpc);
	}
</script>
</form>
</body>
</html>