/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigInfo;
import com.eg.IniFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;

public class DiscoverDns {
    private String cmdLine1 = "cmd.exe /c ipconfig /all";
    private String cmdLine2 = "cmd.exe /c set";
    private BufferedReader errorReader;
    private BufferedReader inputReader;
    private StringTokenizer st;
    private Process process;
    private String line;
    private Runtime runtime;
    private Vector domainVector;
    private String setValue;
    private FileWriter writer;
    private static String[] array1 = new String[2];
    private static String[] array2 = new String[1];
    private boolean index = true;
    private EgConfigInfo configInfo = new EgConfigInfo("manager");
    static IniFile iniFile;
    private String result;

    public DiscoverDns() {
        int n;
        for (n = 0; n < array1.length; ++n) {
            DiscoverDns.array1[n] = new String();
        }
        for (n = 0; n < array2.length; ++n) {
            DiscoverDns.array2[n] = new String();
        }
        DiscoverDns.array1[0] = "Primary DNS Suffix ";
        DiscoverDns.array1[1] = "DNS Servers ";
        DiscoverDns.array2[0] = "SystemRoot";
        this.inputReader = this.execute(this.cmdLine1);
        if (this.inputReader != null) {
            this.domainVector = (Vector)this.parseReader(this.inputReader, array1, true);
        }
        this.inputReader = this.execute(this.cmdLine2);
        if (this.inputReader != null) {
            this.setValue = (String)this.parseReader(this.inputReader, array2, false);
        }
        if (this.setValue != null && this.domainVector != null) {
            this.setValue = this.setValue.replace('\\', '/');
            if (this.createConfFile(this.setValue + "/system32/drivers/etc/resolv.conf")) {
                this.result = "TRUE";
                this.createSetupFile();
                System.out.println("File created");
            } else {
                this.result = "FALSE";
                System.out.println("File is not Created");
            }
        } else {
            try {
                File file = new File(this.setValue + "/system32/drivers/etc/resolv.conf");
                if (file.exists()) {
                    this.result = "FALSE";
                    file.delete();
                }
            }
            catch (Exception exception) {
                this.result = "FALSE";
                exception.printStackTrace();
            }
        }
        try {
            iniFile.setValue("FIND DNS SERVER", "FOUND", this.result);
            iniFile.saveFile();
        }
        catch (Exception exception) {
            System.out.println("DiscoverDns Error:- error is created while putting an entry in eg_setup.ini file");
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
    }

    private BufferedReader execute(String string) {
        BufferedReader bufferedReader;
        this.runtime = Runtime.getRuntime();
        if (this.runtime != null) {
            try {
                this.process = this.runtime.exec(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.process.destroy();
                this.runtime = null;
                this.process = null;
                return null;
            }
        } else {
            System.out.println("DiscoverDns Error: runtime environment is null");
            return null;
        }
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
        }
        catch (Exception exception) {
            System.out.println("DiscoverDns Error: cann't get the input stream");
            exception.printStackTrace();
            this.process.destroy();
            this.runtime = null;
            this.process = null;
            return null;
        }
        try {
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
        }
        catch (Exception exception) {
            System.out.println("DiscoverDns Error: cann't get the error stream");
            exception.printStackTrace();
            this.closeReader(bufferedReader);
            this.process.destroy();
            this.runtime = null;
            this.process = null;
            return null;
        }
        return bufferedReader;
    }

    private void closeReader(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            return;
        }
        try {
            while (bufferedReader.readLine() != null) {
            }
        }
        catch (Exception exception) {
            System.out.println("Error from DiscoverDns class");
            exception.printStackTrace();
        }
        try {
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.out.println("Error from DiscoverDns class");
            exception.printStackTrace();
        }
    }

    private boolean createConfFile(String string) {
        try {
            this.writer = new FileWriter(string);
            this.writer.write("domain " + (String)this.domainVector.elementAt(0));
            this.writer.write("\n");
            this.writer.write("nameserver " + (String)this.domainVector.elementAt(1));
            this.writer.flush();
            this.writer.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.writer = null;
            return false;
        }
        this.writer = null;
        return true;
    }

    private Object parseReader(BufferedReader bufferedReader, String[] stringArray, boolean bl) {
        Vector<String> vector = null;
        String string = null;
        if (bl) {
            vector = new Vector<String>();
        } else {
            string = new String();
        }
        if (bufferedReader != null) {
            try {
                while ((this.line = bufferedReader.readLine()) != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (bl) {
                            if (this.line.indexOf(stringArray[i]) != 1) continue;
                            this.st = new StringTokenizer(this.line, ":");
                            this.st.nextToken();
                            vector.addElement(this.st.nextToken().trim());
                            continue;
                        }
                        if (!this.line.startsWith(stringArray[i])) continue;
                        this.st = new StringTokenizer(this.line, "=");
                        this.st.nextToken();
                        string = this.st.nextToken().trim();
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("Error from DiscoverDns class");
                exception.printStackTrace();
                this.closeReader(bufferedReader);
                vector = null;
                return null;
            }
        } else {
            System.out.println("Error from DiscoverDns class:- input stream is null");
            this.closeReader(bufferedReader);
            vector = null;
            return null;
        }
        this.closeReader(bufferedReader);
        if (bl) {
            return vector;
        }
        return string;
    }

    public void createSetupFile() {
        iniFile = new IniFile(this.configInfo.getSetupFile(), true);
    }
}

