/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.api.rest.schema.ContainerType;
import com.vmware.vcloud.api.rest.schema.QueryResultCatalogRecordType;
import com.vmware.vcloud.api.rest.schema.QueryResultDiskRecordType;
import com.vmware.vcloud.api.rest.schema.QueryResultMediaRecordType;
import com.vmware.vcloud.api.rest.schema.QueryResultRecordsType;
import com.vmware.vcloud.api.rest.schema.QueryResultVAppRecordType;
import com.vmware.vcloud.api.rest.schema.QueryResultVAppTemplateRecordType;
import com.vmware.vcloud.api.rest.schema.QueryResultVMRecordType;
import com.vmware.vcloud.api.rest.schema.ReferencesType;
import com.vmware.vcloud.sdk.QueryParams;
import com.vmware.vcloud.sdk.RecordResult;
import com.vmware.vcloud.sdk.ReferenceResult;
import com.vmware.vcloud.sdk.Result;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import com.vmware.vcloud.sdk.constants.query.FormatType;
import com.vmware.vcloud.sdk.constants.query.QueryCatalogField;
import com.vmware.vcloud.sdk.constants.query.QueryDiskField;
import com.vmware.vcloud.sdk.constants.query.QueryField;
import com.vmware.vcloud.sdk.constants.query.QueryMediaField;
import com.vmware.vcloud.sdk.constants.query.QueryRecordType;
import com.vmware.vcloud.sdk.constants.query.QueryReferenceType;
import com.vmware.vcloud.sdk.constants.query.QueryVAppField;
import com.vmware.vcloud.sdk.constants.query.QueryVAppTemplateField;
import com.vmware.vcloud.sdk.constants.query.QueryVMField;
import com.vmware.vcloud.sdk.constants.query.SortType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryService {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");
    protected VcloudClient client;

    protected QueryService(VcloudClient client) {
        this.client = client;
    }

    public String buildQuery(FormatType formatType) {
        StringBuilder query = new StringBuilder();
        if (formatType != null) {
            query.append("&format=");
            query.append(formatType.value());
        }
        return query.toString();
    }

    public String buildQuery(String queryTypeValue) throws VCloudException {
        StringBuilder query = new StringBuilder();
        if (queryTypeValue == null) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.QUERY_TYPE_NOT_FOUND));
        }
        query.append("/query?type=");
        query.append(queryTypeValue);
        return query.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String buildQuery(QueryParams<? extends QueryField> queryParams) throws VCloudException {
        StringBuilder query = new StringBuilder();
        if (queryParams != null) {
            for (QueryField queryField : queryParams.getSortFields().keySet()) {
                if (queryParams.getSortFields().get(queryField).equals((Object)SortType.SORT_ASC)) {
                    query.append("&sortAsc=");
                    query.append(queryField.value());
                    continue;
                }
                query.append("&sortDesc=");
                query.append(queryField.value());
            }
            if (queryParams.getFields().size() > 0 || queryParams.getMetadataFields().size() > 0) {
                query.append("&fields=");
                int fieldSize = 0;
                for (QueryField queryField : queryParams.getFields()) {
                    query.append(queryField.value());
                    if (++fieldSize == queryParams.getFields().size()) continue;
                    query.append(",");
                }
                if (fieldSize > 0 && queryParams.getMetadataFields().size() > 0) {
                    query.append(",");
                }
                boolean bl = false;
                for (String metadataField : queryParams.getMetadataFields()) {
                    void var4_8;
                    query.append(metadataField);
                    if (++var4_8 == queryParams.getMetadataFields().size()) continue;
                    query.append(",");
                }
            }
            if (queryParams.getPage() != null) {
                query.append("&page=");
                query.append(queryParams.getPage());
            }
            if (queryParams.getOffset() != null) {
                query.append("&offset=");
                query.append(queryParams.getOffset());
            }
            if (queryParams.getPageSize() != null) {
                query.append("&pageSize=");
                query.append(queryParams.getPageSize());
            }
            if (queryParams.getFilter() != null && queryParams.getFilter().getFilterText() != null && !queryParams.getFilter().getFilterText().isEmpty()) {
                query.append("&filter=");
                query.append(queryParams.getFilter().getFilterText());
            }
        }
        return query.toString();
    }

    public <T extends Result> T executeQuery(String query) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + query);
        ContainerType resultType = (ContainerType)SdkUtil.get(this.client, query, 200);
        if (resultType instanceof ReferencesType) {
            return (T)new ReferenceResult(this.client, (ReferencesType)resultType);
        }
        return (T)new RecordResult(this.client, (QueryResultRecordsType)resultType);
    }

    public ReferenceResult queryReferences(QueryReferenceType queryReferenceType, QueryParams<? extends QueryField> queryParams) throws VCloudException {
        String query = this.client.getVcloudApiURL() + this.buildQuery(queryReferenceType.value()) + this.buildQuery(queryParams) + this.buildQuery(FormatType.REFERENCE_VIEW);
        return (ReferenceResult)this.executeQuery(query);
    }

    public RecordResult queryRecords(QueryRecordType queryRecordType, QueryParams<? extends QueryField> queryParams) throws VCloudException {
        String query = this.client.getVcloudApiURL() + this.buildQuery(queryRecordType.value()) + this.buildQuery(queryParams) + this.buildQuery(FormatType.RECORD_VIEW);
        return (RecordResult)this.executeQuery(query);
    }

    public RecordResult queryIdRecords(QueryRecordType queryRecordType, QueryParams<? extends QueryField> queryParams) throws VCloudException {
        String query = this.client.getVcloudApiURL() + this.buildQuery(queryRecordType.value()) + this.buildQuery(queryParams) + this.buildQuery(FormatType.ID_RECORD_VIEW);
        return (RecordResult)this.executeQuery(query);
    }

    public ReferenceResult queryReferences(QueryReferenceType queryReferenceType) throws VCloudException {
        String query = this.client.getVcloudApiURL() + this.buildQuery(queryReferenceType.value()) + this.buildQuery(FormatType.REFERENCE_VIEW);
        return (ReferenceResult)this.executeQuery(query);
    }

    public RecordResult queryRecords(QueryRecordType queryRecordType) throws VCloudException {
        String query = this.client.getVcloudApiURL() + this.buildQuery(queryRecordType.value()) + this.buildQuery(FormatType.RECORD_VIEW);
        return (RecordResult)this.executeQuery(query);
    }

    public RecordResult queryIdRecords(QueryRecordType queryRecordType) throws VCloudException {
        String query = this.client.getVcloudApiURL() + this.buildQuery(queryRecordType.value()) + this.buildQuery(FormatType.ID_RECORD_VIEW);
        return (RecordResult)this.executeQuery(query);
    }

    public ReferenceResult queryCatalogReferences() throws VCloudException {
        String query = this.client.getVcloudApiURL() + "/catalogs/query" + "?" + this.buildQuery(FormatType.REFERENCE_VIEW);
        return (ReferenceResult)this.executeQuery(query);
    }

    public RecordResult<QueryResultCatalogRecordType> queryCatalogRecords() throws VCloudException {
        String query = this.client.getVcloudApiURL() + "/catalogs/query" + "?" + this.buildQuery(FormatType.RECORD_VIEW);
        return (RecordResult)this.executeQuery(query);
    }

    public RecordResult<QueryResultCatalogRecordType> queryCatalogIdRecords() throws VCloudException {
        String query = this.client.getVcloudApiURL() + "/catalogs/query" + "?" + this.buildQuery(FormatType.ID_RECORD_VIEW);
        return (RecordResult)this.executeQuery(query);
    }

    public RecordResult<QueryResultCatalogRecordType> queryCatalogRecords(QueryParams<QueryCatalogField> queryParams) throws VCloudException {
        String query = this.client.getVcloudApiURL() + "/catalogs/query" + "?" + this.buildQuery(queryParams) + this.buildQuery(FormatType.RECORD_VIEW);
        return (RecordResult)this.executeQuery(query);
    }

    public RecordResult<QueryResultCatalogRecordType> queryCatalogIdRecords(QueryParams<QueryCatalogField> queryParams) throws VCloudException {
        String query = this.client.getVcloudApiURL() + "/catalogs/query" + "?" + this.buildQuery(queryParams) + this.buildQuery(FormatType.ID_RECORD_VIEW);
        return (RecordResult)this.executeQuery(query);
    }

    public ReferenceResult queryCatalogReferences(QueryParams<QueryCatalogField> queryParams) throws VCloudException {
        String query = this.client.getVcloudApiURL() + "/catalogs/query" + "?" + this.buildQuery(queryParams) + this.buildQuery(FormatType.REFERENCE_VIEW);
        return (ReferenceResult)this.executeQuery(query);
    }

    public ReferenceResult queryvAppReferences() throws VCloudException {
        String query = this.client.getVcloudApiURL() + "/vApps/query" + "?" + this.buildQuery(FormatType.REFERENCE_VIEW);
        return (ReferenceResult)this.executeQuery(query);
    }

    public RecordResult<QueryResultVAppRecordType> queryvAppRecords() throws VCloudException {
        String query = this.client.getVcloudApiURL() + "/vApps/query" + "?" + this.buildQuery(FormatType.RECORD_VIEW);
        return (RecordResult)this.executeQuery(query);
    }

    public RecordResult<QueryResultVAppRecordType> queryvAppIdRecords() throws VCloudException {
        String query = this.client.getVcloudApiURL() + "/vApps/query" + "?" + this.buildQuery(FormatType.ID_RECORD_VIEW);
        return (RecordResult)this.executeQuery(query);
    }

    public RecordResult<QueryResultVAppRecordType> queryvAppRecords(QueryParams<QueryVAppField> queryParams) throws VCloudException {
        String query = this.client.getVcloudApiURL() + "/vApps/query" + "?" + this.buildQuery(queryParams) + this.buildQuery(FormatType.RECORD_VIEW);
        return (RecordResult)this.executeQuery(query);
    }

    public RecordResult<QueryResultVAppRecordType> queryvAppIdRecords(QueryParams<QueryVAppField> queryParams) throws VCloudException {
        String query = this.client.getVcloudApiURL() + "/vApps/query" + "?" + this.buildQuery(queryParams) + this.buildQuery(FormatType.ID_RECORD_VIEW);
        return (RecordResult)this.executeQuery(query);
    }

    public ReferenceResult queryvAppReferences(QueryParams<QueryVAppField> queryParams) throws VCloudException {
        String query = this.client.getVcloudApiURL() + "/vApps/query" + "?" + this.buildQuery(queryParams) + this.buildQuery(FormatType.REFERENCE_VIEW);
        return (ReferenceResult)this.executeQuery(query);
    }

    public ReferenceResult queryVmReferences() throws VCloudException {
        String query = this.client.getVcloudApiURL() + "/vms/query" + "?" + this.buildQuery(FormatType.REFERENCE_VIEW);
        return (ReferenceResult)this.executeQuery(query);
    }

    public RecordResult<QueryResultVMRecordType> queryVmRecords(QueryParams<QueryVMField> queryParams) throws VCloudException {
        String query = this.client.getVcloudApiURL() + "/vms/query" + "?" + this.buildQuery(queryParams) + this.buildQuery(FormatType.RECORD_VIEW);
        return (RecordResult)this.executeQuery(query);
    }

    public RecordResult<QueryResultVMRecordType> queryVmIdRecords(QueryParams<QueryVMField> queryParams) throws VCloudException {
        String query = this.client.getVcloudApiURL() + "/vms/query" + "?" + this.buildQuery(queryParams) + this.buildQuery(FormatType.ID_RECORD_VIEW);
        return (RecordResult)this.executeQuery(query);
    }

    public RecordResult<QueryResultVMRecordType> queryVmRecords() throws VCloudException {
        String query = this.client.getVcloudApiURL() + "/vms/query" + "?" + this.buildQuery(FormatType.RECORD_VIEW);
        return (RecordResult)this.executeQuery(query);
    }

    public RecordResult<QueryResultVMRecordType> queryVmIdRecords() throws VCloudException {
        String query = this.client.getVcloudApiURL() + "/vms/query" + "?" + this.buildQuery(FormatType.ID_RECORD_VIEW);
        return (RecordResult)this.executeQuery(query);
    }

    public ReferenceResult queryVmReferences(QueryParams<QueryVMField> queryParams) throws VCloudException {
        String query = this.client.getVcloudApiURL() + "/vms/query" + "?" + this.buildQuery(queryParams) + this.buildQuery(FormatType.REFERENCE_VIEW);
        return (ReferenceResult)this.executeQuery(query);
    }

    public ReferenceResult queryvAppTemplateReferences() throws VCloudException {
        String query = this.client.getVcloudApiURL() + "/vAppTemplates/query" + "?" + this.buildQuery(FormatType.REFERENCE_VIEW);
        return (ReferenceResult)this.executeQuery(query);
    }

    public RecordResult<QueryResultVAppTemplateRecordType> queryvAppTemplateRecords() throws VCloudException {
        String query = this.client.getVcloudApiURL() + "/vAppTemplates/query" + "?" + this.buildQuery(FormatType.RECORD_VIEW);
        return (RecordResult)this.executeQuery(query);
    }

    public RecordResult<QueryResultVAppTemplateRecordType> queryvAppTemplateIdRecords() throws VCloudException {
        String query = this.client.getVcloudApiURL() + "/vAppTemplates/query" + "?" + this.buildQuery(FormatType.ID_RECORD_VIEW);
        return (RecordResult)this.executeQuery(query);
    }

    public RecordResult<QueryResultVAppTemplateRecordType> queryvAppTemplateRecords(QueryParams<QueryVAppTemplateField> queryParams) throws VCloudException {
        String query = this.client.getVcloudApiURL() + "/vAppTemplates/query" + "?" + this.buildQuery(queryParams) + this.buildQuery(FormatType.RECORD_VIEW);
        return (RecordResult)this.executeQuery(query);
    }

    public RecordResult<QueryResultVAppTemplateRecordType> queryvAppTemplateIdRecords(QueryParams<QueryVAppTemplateField> queryParams) throws VCloudException {
        String query = this.client.getVcloudApiURL() + "/vAppTemplates/query" + "?" + this.buildQuery(queryParams) + this.buildQuery(FormatType.ID_RECORD_VIEW);
        return (RecordResult)this.executeQuery(query);
    }

    public ReferenceResult queryvAppTemplateReferences(QueryParams<QueryVAppTemplateField> queryParams) throws VCloudException {
        String query = this.client.getVcloudApiURL() + "/vAppTemplates/query" + "?" + this.buildQuery(queryParams) + this.buildQuery(FormatType.REFERENCE_VIEW);
        return (ReferenceResult)this.executeQuery(query);
    }

    public ReferenceResult queryMediaReferences() throws VCloudException {
        String query = this.client.getVcloudApiURL() + "/mediaList/query" + "?" + this.buildQuery(FormatType.REFERENCE_VIEW);
        return (ReferenceResult)this.executeQuery(query);
    }

    public RecordResult<QueryResultMediaRecordType> queryMediaRecords() throws VCloudException {
        String query = this.client.getVcloudApiURL() + "/mediaList/query" + "?" + this.buildQuery(FormatType.RECORD_VIEW);
        return (RecordResult)this.executeQuery(query);
    }

    public RecordResult<QueryResultMediaRecordType> queryMediaIdRecords() throws VCloudException {
        String query = this.client.getVcloudApiURL() + "/mediaList/query" + "?" + this.buildQuery(FormatType.ID_RECORD_VIEW);
        return (RecordResult)this.executeQuery(query);
    }

    public RecordResult<QueryResultMediaRecordType> queryMediaRecords(QueryParams<QueryMediaField> queryParams) throws VCloudException {
        String query = this.client.getVcloudApiURL() + "/mediaList/query" + "?" + this.buildQuery(queryParams) + this.buildQuery(FormatType.RECORD_VIEW);
        return (RecordResult)this.executeQuery(query);
    }

    public RecordResult<QueryResultMediaRecordType> queryMediaIdRecords(QueryParams<QueryMediaField> queryParams) throws VCloudException {
        String query = this.client.getVcloudApiURL() + "/mediaList/query" + "?" + this.buildQuery(queryParams) + this.buildQuery(FormatType.ID_RECORD_VIEW);
        return (RecordResult)this.executeQuery(query);
    }

    public ReferenceResult queryMediaReferences(QueryParams<QueryMediaField> queryParams) throws VCloudException {
        String query = this.client.getVcloudApiURL() + "/mediaList/query" + "?" + this.buildQuery(queryParams) + this.buildQuery(FormatType.REFERENCE_VIEW);
        return (ReferenceResult)this.executeQuery(query);
    }

    public ReferenceResult queryDiskReferences() throws VCloudException {
        String query = this.client.getVcloudApiURL() + "/disks/query" + "?" + this.buildQuery(FormatType.REFERENCE_VIEW);
        return (ReferenceResult)this.executeQuery(query);
    }

    public RecordResult<QueryResultDiskRecordType> queryDiskRecords(QueryParams<QueryDiskField> queryParams) throws VCloudException {
        String query = this.client.getVcloudApiURL() + "/disks/query" + "?" + this.buildQuery(queryParams) + this.buildQuery(FormatType.RECORD_VIEW);
        return (RecordResult)this.executeQuery(query);
    }

    public RecordResult<QueryResultDiskRecordType> queryDiskIdRecords(QueryParams<QueryDiskField> queryParams) throws VCloudException {
        String query = this.client.getVcloudApiURL() + "/disks/query" + "?" + this.buildQuery(queryParams) + this.buildQuery(FormatType.ID_RECORD_VIEW);
        return (RecordResult)this.executeQuery(query);
    }

    public RecordResult<QueryResultDiskRecordType> queryDiskRecords() throws VCloudException {
        String query = this.client.getVcloudApiURL() + "/disks/query" + "?" + this.buildQuery(FormatType.RECORD_VIEW);
        return (RecordResult)this.executeQuery(query);
    }

    public RecordResult<QueryResultDiskRecordType> queryDiskIdRecords() throws VCloudException {
        String query = this.client.getVcloudApiURL() + "/disks/query" + "?" + this.buildQuery(FormatType.ID_RECORD_VIEW);
        return (RecordResult)this.executeQuery(query);
    }

    public ReferenceResult queryDiskReferences(QueryParams<QueryDiskField> queryParams) throws VCloudException {
        String query = this.client.getVcloudApiURL() + "/disks/query" + "?" + this.buildQuery(queryParams) + this.buildQuery(FormatType.REFERENCE_VIEW);
        return (ReferenceResult)this.executeQuery(query);
    }
}

