/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.api.rest.schema.ContainerType;
import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudResource;

public abstract class Result<T extends ContainerType>
extends VcloudResource<ContainerType> {
    private String name;
    private Integer page;
    private Integer pageSize;
    private Long total;
    private ReferenceType nextPage;
    private ReferenceType lastPage;
    private ReferenceType previousPage;
    private ReferenceType firstPage;
    private ReferenceType alternateReferencesRef;
    private ReferenceType alternateIdRecordsRef;
    private ReferenceType alternateRecordsRef;

    Result(VcloudClient client, ContainerType containerType) {
        super(client, containerType);
        if (containerType instanceof ContainerType) {
            this.name = containerType.getName();
            this.page = containerType.getPage();
            this.pageSize = containerType.getPageSize();
            this.total = containerType.getTotal();
            for (LinkType link : containerType.getLink()) {
                if (link.getRel().equals("nextPage")) {
                    this.nextPage = link;
                    continue;
                }
                if (link.getRel().equals("firstPage")) {
                    this.firstPage = link;
                    continue;
                }
                if (link.getRel().equals("previousPage")) {
                    this.previousPage = link;
                    continue;
                }
                if (link.getRel().equals("lastPage")) {
                    this.lastPage = link;
                    continue;
                }
                if (link.getRel().equals("alternate") && link.getType().equals("application/vnd.vmware.vcloud.query.references+xml")) {
                    this.alternateReferencesRef = link;
                    continue;
                }
                if (link.getRel().equals("alternate") && link.getType().equals("application/vnd.vmware.vcloud.query.idrecords+xml")) {
                    this.alternateIdRecordsRef = link;
                    continue;
                }
                if (!link.getRel().equals("alternate") || !link.getType().equals("application/vnd.vmware.vcloud.query.records+xml")) continue;
                this.alternateRecordsRef = link;
            }
        }
    }

    ReferenceType getNextPageReference() {
        return this.nextPage;
    }

    ReferenceType getFirstPageReference() {
        return this.firstPage;
    }

    ReferenceType getPreviousPageReference() {
        return this.previousPage;
    }

    ReferenceType getLastPageReference() {
        return this.lastPage;
    }

    ReferenceType getAlternateRecordRef() {
        return this.alternateRecordsRef;
    }

    ReferenceType getAlternateIdRecordRef() {
        return this.alternateIdRecordsRef;
    }

    ReferenceType getAlternateReferencesRef() {
        return this.alternateReferencesRef;
    }

    public String getName() {
        return this.name;
    }

    public Integer getPage() {
        return this.page;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Long getTotal() {
        return this.total;
    }

    public Boolean hasNextPage() {
        return this.getNextPageReference() != null;
    }

    public Boolean hasFirstPage() {
        return this.getFirstPageReference() != null;
    }

    public Boolean hasPreviousPage() {
        return this.getPreviousPageReference() != null;
    }

    public Boolean hasLastPage() {
        return this.getLastPageReference() != null;
    }

    Boolean hasAlternateReferencesRefResult() {
        return this.getAlternateReferencesRef() != null;
    }

    Boolean hasAlternateRecordsRefResult() {
        return this.getAlternateRecordRef() != null;
    }

    Boolean hasAlternateIdRecordsRefResult() {
        return this.getAlternateIdRecordRef() != null;
    }
}

