/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.api.rest.schema.IdentifiableResourceType;
import com.vmware.vcloud.api.rest.schema.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.TaskType;
import com.vmware.vcloud.api.rest.schema.VmAffinityRuleType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmAffinityRule
extends VcloudEntity<VmAffinityRuleType> {
    private static Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");

    VmAffinityRule(VcloudClient client, VmAffinityRuleType vmAffinityRule) {
        super(client, vmAffinityRule);
        this.setEntityLinks(client, vmAffinityRule);
    }

    @Override
    protected void setEntityLinks(VcloudClient client, VmAffinityRuleType entityType) {
        this.setReference((IdentifiableResourceType)entityType);
    }

    public static VmAffinityRule getVmAffinityRuleByObject(VcloudClient client, VmAffinityRuleType vmAffinityRuleType) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + vmAffinityRuleType.getHref());
        return new VmAffinityRule(client, vmAffinityRuleType);
    }

    public static VmAffinityRule getVmAffinityRuleByUrl(VcloudClient client, String url) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        return new VmAffinityRule(client, (VmAffinityRuleType)VmAffinityRule.getResourceByUrl(client, url));
    }

    public VmAffinityRuleType getVmAffinityRule() throws VCloudException {
        String url = this.getReference().getHref();
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        return (VmAffinityRuleType)SdkUtil.get(this.getVcloudClient(), url, 200);
    }

    public TaskType delete() throws VCloudException {
        String url = this.getReference().getHref();
        return (TaskType)SdkUtil.delete(this.getVcloudClient(), url, 202);
    }

    public TaskType updateVmAffinityRule(VmAffinityRuleType vmAffinityRuleType) throws VCloudException {
        String url = this.getReference().getHref();
        ObjectFactory objectFactory = new ObjectFactory();
        String updateAffinityRule = JAXBUtil.marshal(objectFactory.createVmAffinityRule(vmAffinityRuleType));
        logger.info(SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + url);
        return (TaskType)SdkUtil.put(this.getVcloudClient(), url, updateAffinityRule, "application/vnd.vmware.vcloud.vmaffinityrule+xml", 202);
    }
}

