/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin;

import com.vmware.vcloud.api.rest.schema.AuditEventType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditEvent
extends VcloudEntity<AuditEventType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");

    public AuditEvent(VcloudClient client, AuditEventType auditEventType) {
        super(client, auditEventType);
    }

    public static AuditEvent getAuditEventByReference(VcloudClient client, ReferenceType auditEventRef) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + auditEventRef.getHref());
        AuditEventType auditEventType = (AuditEventType)AuditEvent.getResourceByReference(client, auditEventRef);
        return new AuditEvent(client, auditEventType);
    }

    public static AuditEvent getAuditEventById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        AuditEventType auditEventType = (AuditEventType)AuditEvent.getEntityById(client, vCloudId, "application/vnd.vmware.admin.event+xml");
        return new AuditEvent(client, auditEventType);
    }
}

