/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin;

import com.vmware.vcloud.api.rest.schema.ExternalNetworkType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.TaskType;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.Task;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalNetwork
extends VcloudEntity<ExternalNetworkType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");

    ExternalNetwork(VcloudClient client, ExternalNetworkType externalNetworkType_1_5) {
        super(client, externalNetworkType_1_5);
    }

    public static ExternalNetwork getExternalNetworkByReference(VcloudClient client, ReferenceType externalNetworkRef) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + externalNetworkRef.getHref());
        return new ExternalNetwork(client, (ExternalNetworkType)ExternalNetwork.getResourceByReference(client, externalNetworkRef));
    }

    public static ExternalNetwork getExternalNetworkById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new ExternalNetwork(client, (ExternalNetworkType)ExternalNetwork.getEntityById(client, vCloudId, "application/vnd.vmware.admin.network+xml"));
    }

    public Task reset() throws VCloudException {
        String taskCanelActionUrl = this.getReference().getHref() + "/action/reset";
        return ExternalNetwork.executeAction(this.getVcloudClient(), taskCanelActionUrl, null, null, 202);
    }

    public static Task reset(VcloudClient client, ReferenceType externalNetworkReference) throws VCloudException {
        return ExternalNetwork.executeAction(client, externalNetworkReference.getHref() + "/action/reset", null, null, 202);
    }

    private static Task executeAction(VcloudClient client, String externalNetworkActionUrl, String content, String contentType, int statusCode) throws VCloudException {
        return new Task(client, (TaskType)SdkUtil.post(client, externalNetworkActionUrl, content, contentType, statusCode));
    }
}

