/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin.extensions.service;

import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.RightType;
import com.vmware.vcloud.api.rest.schema.extension.AdminApiDefinitionType;
import com.vmware.vcloud.api.rest.schema.extension.AdminServiceLinkType;
import com.vmware.vcloud.api.rest.schema.extension.AdminServiceType;
import com.vmware.vcloud.api.rest.schema.extension.ApiFilterType;
import com.vmware.vcloud.api.rest.schema.extension.AuthorizationCheckParamsType;
import com.vmware.vcloud.api.rest.schema.extension.AuthorizationCheckResponseType;
import com.vmware.vcloud.api.rest.schema.extension.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.extension.ResourceClassType;
import com.vmware.vcloud.api.rest.schema.extension.RightRefsType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.ReferenceResult;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.admin.Right;
import com.vmware.vcloud.sdk.admin.extensions.service.AdminApiDefinition;
import com.vmware.vcloud.sdk.admin.extensions.service.AdminApiFilter;
import com.vmware.vcloud.sdk.admin.extensions.service.AdminResourceClass;
import com.vmware.vcloud.sdk.admin.extensions.service.AdminServiceLink;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import com.vmware.vcloud.sdk.constants.query.FormatType;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminService
extends VcloudEntity<AdminServiceType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");

    public AdminService(VcloudClient client, AdminServiceType serviceResource) {
        super(client, serviceResource);
    }

    public static AdminService getAdminServiceByReference(VcloudClient client, ReferenceType reference) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + reference.getHref());
        return new AdminService(client, (AdminServiceType)AdminService.getResourceByReference(client, reference));
    }

    public static AdminService getAdminServiceById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new AdminService(client, (AdminServiceType)AdminService.getEntityById(client, vCloudId, "application/vnd.vmware.admin.service+xml"));
    }

    public AdminService updateAdminService(AdminServiceType serviceParams) throws VCloudException {
        String requestXML = JAXBUtil.marshal(new ObjectFactory().createService(serviceParams));
        return new AdminService(this.getVcloudClient(), (AdminServiceType)SdkUtil.put(this.getVcloudClient(), ((AdminServiceType)this.getResource()).getHref(), requestXML, "application/vnd.vmware.admin.service+xml", 200));
    }

    public AdminService disable() throws VCloudException {
        AdminServiceType adminServiceParams = (AdminServiceType)this.getResource();
        adminServiceParams.setEnabled(Boolean.valueOf(false));
        return this.updateAdminService(adminServiceParams);
    }

    public void delete() throws VCloudException {
        SdkUtil.delete(this.getVcloudClient(), this.getReference().getHref(), 204);
    }

    public Right createRight(RightType rightType) throws VCloudException {
        String requestXML = JAXBUtil.marshal(new com.vmware.vcloud.api.rest.schema.ObjectFactory().createRight(rightType));
        return new Right(this.getVcloudClient(), (RightType)SdkUtil.post(this.getVcloudClient(), ((AdminServiceType)this.getResource()).getHref() + "/rights", requestXML, "application/vnd.vmware.admin.right+xml", 201));
    }

    public Right createRight(String rightName, String rightDescription, String rightCategory, String bundleKey, String operationKey, String serviceNamespace) throws VCloudException {
        RightType rightParams = new RightType();
        rightParams.setName(rightName);
        rightParams.setDescription(rightDescription);
        rightParams.setCategory(rightCategory);
        rightParams.setBundleKey(bundleKey);
        rightParams.setOperationKey(operationKey);
        rightParams.setServiceNamespace(serviceNamespace);
        return this.createRight(rightParams);
    }

    public AdminServiceLink createAdminLink(AdminServiceLinkType serviceLinkParams) throws VCloudException {
        String requestXML = JAXBUtil.marshal(new ObjectFactory().createServiceLink(serviceLinkParams));
        return new AdminServiceLink(this.getVcloudClient(), (AdminServiceLinkType)SdkUtil.post(this.getVcloudClient(), ((AdminServiceType)this.getResource()).getHref() + "/links", requestXML, "application/vnd.vmware.admin.serviceLink+xml", 201));
    }

    public AdminServiceLink createServiceLink(String linkHref, String relation, String resourceType, String mimeType, String resourceId) throws VCloudException {
        AdminServiceLinkType serviceLink = new AdminServiceLinkType();
        serviceLink.setLinkHref(linkHref);
        serviceLink.setRel(relation);
        serviceLink.setResourceType(resourceType);
        serviceLink.setMimeType(mimeType);
        serviceLink.setResourceId(resourceId);
        return this.createAdminLink(serviceLink);
    }

    public AdminApiDefinition createAdminApiDefinition(AdminApiDefinitionType apiDefinitionParams) throws VCloudException {
        String requestXML = JAXBUtil.marshal(new ObjectFactory().createApiDefinition(apiDefinitionParams));
        return new AdminApiDefinition(this.getVcloudClient(), (AdminApiDefinitionType)SdkUtil.post(this.getVcloudClient(), ((AdminServiceType)this.getResource()).getHref() + "/apidefinitions", requestXML, "application/vnd.vmware.admin.apiDefinition+xml", 201));
    }

    public AdminResourceClass registerAdminResourceClass(ResourceClassType resourceClassParams) throws VCloudException {
        String requestXML = JAXBUtil.marshal(new ObjectFactory().createResourceClass(resourceClassParams));
        return new AdminResourceClass(this.getVcloudClient(), (ResourceClassType)SdkUtil.post(this.getVcloudClient(), ((AdminServiceType)this.getResource()).getHref() + "/resourceclasses", requestXML, "application/vnd.vmware.admin.resourceClass+xml", 201));
    }

    public AdminResourceClass registerResourceClass(String name, String type, String nid, String urlTemplate, String urnPattern, String mimeType) throws VCloudException {
        ResourceClassType resourceClass = new ResourceClassType();
        resourceClass.setMimeType(mimeType);
        resourceClass.setUrlTemplate(urlTemplate);
        resourceClass.setUrnPattern(urnPattern);
        resourceClass.setType(type);
        resourceClass.setNid(nid);
        resourceClass.setName(name);
        return this.registerAdminResourceClass(resourceClass);
    }

    public AdminApiFilter createAdminApiFilter(ApiFilterType apiFilterParams) throws VCloudException {
        String requestXML = JAXBUtil.marshal(new ObjectFactory().createApiFilter(apiFilterParams));
        return new AdminApiFilter(this.getVcloudClient(), (ApiFilterType)SdkUtil.post(this.getVcloudClient(), ((AdminServiceType)this.getResource()).getHref() + "/apifilters", requestXML, "application/vnd.vmware.admin.apiFilter+xml", 201));
    }

    public AdminApiFilter createURLFilter(List<String> urlPatterns) throws VCloudException {
        ApiFilterType apiFilter = new ApiFilterType();
        StringBuilder urls = new StringBuilder();
        for (String urlPattern : urlPatterns) {
            urls.append("(").append(urlPattern).append(")|");
        }
        apiFilter.setUrlPattern(urls.toString());
        return this.createAdminApiFilter(apiFilter);
    }

    public AdminApiFilter createResponseContentFilter(String responseContentType) throws VCloudException {
        ApiFilterType apiFilter = new ApiFilterType();
        apiFilter.setResponseContentType(responseContentType);
        return this.createAdminApiFilter(apiFilter);
    }

    public List<ReferenceType> getRightRefs() throws VCloudException {
        return ((RightRefsType)SdkUtil.get(this.getVcloudClient(), ((AdminServiceType)this.getResource()).getHref() + "/rights", 200)).getRight();
    }

    public ReferenceResult getAdminLinkRefs() throws VCloudException {
        String query = this.getReference().getHref() + "/links" + "?" + this.getVcloudClient().getQueryService().buildQuery(FormatType.REFERENCE_VIEW);
        return (ReferenceResult)this.getVcloudClient().getQueryService().executeQuery(query);
    }

    public ReferenceResult getAdminApiDefinitionRefs() throws VCloudException {
        String query = this.getReference().getHref() + "/apidefinitions" + "?" + this.getVcloudClient().getQueryService().buildQuery(FormatType.REFERENCE_VIEW);
        return (ReferenceResult)this.getVcloudClient().getQueryService().executeQuery(query);
    }

    public ReferenceResult getAdminResourceClassRefs() throws VCloudException {
        String query = this.getReference().getHref() + "/resourceclasses" + "?" + this.getVcloudClient().getQueryService().buildQuery(FormatType.REFERENCE_VIEW);
        return (ReferenceResult)this.getVcloudClient().getQueryService().executeQuery(query);
    }

    public ReferenceResult getAdminApiFilterRefs() throws VCloudException {
        String query = this.getReference().getHref() + "/apifilters" + "?" + this.getVcloudClient().getQueryService().buildQuery(FormatType.REFERENCE_VIEW);
        return (ReferenceResult)this.getVcloudClient().getQueryService().executeQuery(query);
    }

    public boolean isAuthorized(AuthorizationCheckParamsType authorizationCheckParamsType) throws VCloudException {
        String checkAuthorizationUri = ((AdminServiceType)this.getResource()).getHref() + "/authorizationcheck";
        ObjectFactory objectFactory_v5_1 = new ObjectFactory();
        String requestBodyXml = JAXBUtil.marshal(objectFactory_v5_1.createAuthorizationCheckParams(authorizationCheckParamsType));
        return ((AuthorizationCheckResponseType)SdkUtil.post(this.getVcloudClient(), checkAuthorizationUri, requestBodyXml, "application/vnd.vmware.admin.authorizationCheckParams+xml", 200)).isIsAuthorized();
    }
}

