/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast.input;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import net.sourceforge.openforecast.DataPoint;
import net.sourceforge.openforecast.DataSet;
import net.sourceforge.openforecast.Observation;
import net.sourceforge.openforecast.input.AbstractBuilder;

public class CSVBuilder
extends AbstractBuilder {
    private static final char SEPARATOR = ',';
    private boolean hasHeaderRow = false;
    private FileReader fileReader;

    public CSVBuilder(String filename) throws FileNotFoundException {
        this(new FileReader(filename));
    }

    public CSVBuilder(String filename, boolean hasHeaderRow) throws FileNotFoundException {
        this(new FileReader(filename), hasHeaderRow);
    }

    public CSVBuilder(File file) throws FileNotFoundException {
        this(new FileReader(file));
    }

    public CSVBuilder(File file, boolean hasHeaderRow) throws FileNotFoundException {
        this(new FileReader(file), hasHeaderRow);
    }

    public CSVBuilder(FileReader reader) {
        this(reader, false);
    }

    public CSVBuilder(FileReader reader, boolean hasHeaderRow) {
        this.fileReader = reader;
        this.hasHeaderRow = hasHeaderRow;
    }

    public DataSet build() throws IOException {
        String line;
        DataSet dataSet = new DataSet();
        boolean firstLineRead = false;
        BufferedReader reader = new BufferedReader(this.fileReader);
        do {
            if ((line = reader.readLine()) == null || (line = line.trim()).length() == 0 || line.startsWith("#")) continue;
            if (!firstLineRead) {
                firstLineRead = true;
                if (this.hasHeaderRow) {
                    this.readHeaderRow(line);
                    continue;
                }
                int n = 0;
                int pos = 0;
                while ((pos = line.indexOf(44, pos)) > 0) {
                    ++n;
                    ++pos;
                }
                this.setNumberOfVariables(n);
            }
            DataPoint dp = this.build(line);
            dataSet.add(dp);
        } while (line != null);
        return dataSet;
    }

    private void readHeaderRow(String line) throws IOException {
        ArrayList<String> vars = new ArrayList<String>();
        int pos = 0;
        while (pos < line.length()) {
            int nextQuote = line.indexOf("\"", pos);
            int nextSeparator = line.indexOf(44, pos);
            if (nextSeparator < 0) break;
            if (nextQuote < 0 || nextQuote > nextSeparator) {
                String name = line.substring(pos, nextSeparator);
                vars.add(name);
                pos = nextSeparator + 1;
                continue;
            }
            int secondQuote = line.indexOf("\"", nextQuote + 1);
            String name = line.substring(nextQuote + 1, secondQuote);
            vars.add(name);
            pos = line.indexOf(44, secondQuote) + 1;
        }
        int n = vars.size();
        int i = 0;
        while (i < n) {
            this.addVariable(((String)vars.get(i)).trim());
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private DataPoint build(String line) throws IOException {
        Observation dataPoint = new Observation(0.0);
        StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(line));
        tokenizer.commentChar(35);
        tokenizer.eolIsSignificant(true);
        tokenizer.parseNumbers();
        int i = 0;
        int n = this.getNumberOfVariables();
        int lastToken = 44;
        block7: do {
            int token = tokenizer.nextToken();
            switch (tokenizer.ttype) {
                case 9: 
                case 32: {
                    continue block7;
                }
                case 44: {
                    if (lastToken != 44) break;
                    tokenizer.nval = 0.0;
                }
                case -2: {
                    if (i == n) {
                        dataPoint.setDependentValue(tokenizer.nval);
                    } else {
                        dataPoint.setIndependentValue(this.getVariableName(i), tokenizer.nval);
                    }
                    ++i;
                    break;
                }
                case -3: {
                    throw new IOException("Invalid input in CSV file. Number expected, found '" + tokenizer.sval + "'");
                }
                case -1: 
                case 10: 
            }
            lastToken = tokenizer.ttype;
        } while (tokenizer.ttype != -1);
        return dataPoint;
    }

    static {
        SEPARATOR = (char)44;
    }
}

