/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast.models;

import java.util.Iterator;
import net.sourceforge.openforecast.DataPoint;
import net.sourceforge.openforecast.DataSet;
import net.sourceforge.openforecast.ForecastingModel;
import net.sourceforge.openforecast.models.AccuracyIndicators;
import net.sourceforge.openforecast.models.ModelNotInitializedException;

public abstract class AbstractForecastingModel
implements ForecastingModel {
    static double TOLERANCE = 1.0E-8;
    protected AccuracyIndicators accuracyIndicators = new AccuracyIndicators();
    protected boolean initialized = false;

    protected AbstractForecastingModel() {
    }

    public double getBias() {
        if (!this.initialized) {
            throw new ModelNotInitializedException();
        }
        return this.accuracyIndicators.getBias();
    }

    public double getMAD() {
        if (!this.initialized) {
            throw new ModelNotInitializedException();
        }
        return this.accuracyIndicators.getMAD();
    }

    public double getMAPE() {
        if (!this.initialized) {
            throw new ModelNotInitializedException();
        }
        return this.accuracyIndicators.getMAPE();
    }

    public double getMSE() {
        if (!this.initialized) {
            throw new ModelNotInitializedException();
        }
        return this.accuracyIndicators.getMSE();
    }

    public double getSAE() {
        if (!this.initialized) {
            throw new ModelNotInitializedException();
        }
        return this.accuracyIndicators.getSAE();
    }

    public DataSet forecast(DataSet dataSet) {
        if (!this.initialized) {
            throw new ModelNotInitializedException();
        }
        Iterator it = dataSet.iterator();
        while (it.hasNext()) {
            DataPoint dp = (DataPoint)it.next();
            dp.setDependentValue(this.forecast(dp));
        }
        return dataSet;
    }

    protected void calculateAccuracyIndicators(DataSet dataSet) {
        this.initialized = true;
        double sumErr = 0.0;
        double sumAbsErr = 0.0;
        double sumAbsPercentErr = 0.0;
        double sumErrSquared = 0.0;
        DataSet forecastValues = new DataSet(dataSet);
        this.forecast(forecastValues);
        Iterator it = dataSet.iterator();
        Iterator itForecast = forecastValues.iterator();
        while (it.hasNext()) {
            DataPoint dp = (DataPoint)it.next();
            double x = dp.getDependentValue();
            DataPoint dpForecast = (DataPoint)itForecast.next();
            double forecastValue = dpForecast.getDependentValue();
            double error = forecastValue - x;
            sumErr += error;
            sumAbsErr += Math.abs(error);
            sumAbsPercentErr += Math.abs(error / x);
            sumErrSquared += error * error;
        }
        int n = dataSet.size();
        this.accuracyIndicators.setBias(sumErr / (double)n);
        this.accuracyIndicators.setMAD(sumAbsErr / (double)n);
        this.accuracyIndicators.setMAPE(sumAbsPercentErr / (double)n);
        this.accuracyIndicators.setMSE(sumErrSquared / (double)n);
        this.accuracyIndicators.setSAE(sumAbsErr);
    }
}

