/*
 * Decompiled with CFR 0.152.
 */
package Acme.Nnrpd;

import Acme.Nnrpd.MultiplexNewsDbGroups;
import Acme.Nnrpd.MultiplexNewsDbMessageIds;
import Acme.Nnrpd.NewsDb;
import Acme.Nnrpd.NewsDbArticle;
import Acme.Nnrpd.NewsDbException;
import Acme.Nnrpd.NewsDbGroup;
import Acme.Utils;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class MultiplexNewsDb
extends NewsDb {
    private Vector groupsPats = new Vector();
    private Vector newsDbs = new Vector();
    private static String[] overviewFmt = new String[]{"Subject", "From", "Date", "Message-ID", "References", "Bytes", "Lines"};

    public void add(String groupsPat, NewsDb newsDb) {
        this.groupsPats.addElement(groupsPat);
        this.newsDbs.addElement(newsDb);
    }

    public boolean authorize(String user, String password) throws NewsDbException {
        int i = 0;
        while (i < this.newsDbs.size()) {
            NewsDb newsDb = (NewsDb)this.newsDbs.elementAt(i);
            if (!newsDb.authorize(user, password)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean getPostingOk() throws NewsDbException {
        int i = 0;
        while (i < this.newsDbs.size()) {
            NewsDb newsDb = (NewsDb)this.newsDbs.elementAt(i);
            if (newsDb.getPostingOk()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public NewsDbGroup getGroup(String groupName) throws NewsDbException {
        NewsDb newsDb = this.findNewsDb(groupName);
        return newsDb.getGroup(groupName);
    }

    public NewsDbArticle getArticle(NewsDbGroup group, int artNum) throws NewsDbException {
        int i = 0;
        while (i < this.newsDbs.size()) {
            NewsDb newsDb = (NewsDb)this.newsDbs.elementAt(i);
            if (newsDb.getDbStamp() == group.getDbStamp()) {
                return newsDb.getArticle(group, artNum);
            }
            ++i;
        }
        return null;
    }

    public NewsDbArticle getArticle(String messageId) throws NewsDbException {
        int i = 0;
        while (i < this.newsDbs.size()) {
            NewsDb newsDb = (NewsDb)this.newsDbs.elementAt(i);
            NewsDbArticle article = newsDb.getArticle(messageId);
            if (article != null) {
                return article;
            }
            ++i;
        }
        return null;
    }

    public String[][] getHeaders(String[] names, NewsDbGroup group, int firstArtNum, int lastArtNum) throws NewsDbException {
        NewsDb newsDb = this.findNewsDb(group.getName());
        return newsDb.getHeaders(names, group, firstArtNum, lastArtNum);
    }

    public Enumeration getGroups() throws NewsDbException {
        return new MultiplexNewsDbGroups(this.newsDbs.elements());
    }

    public Enumeration getGroups(long since) throws NewsDbException {
        return new MultiplexNewsDbGroups(this.newsDbs.elements(), since);
    }

    public Enumeration getGroups(long since, String distsPat) throws NewsDbException {
        return new MultiplexNewsDbGroups(this.newsDbs.elements(), since, distsPat);
    }

    public Enumeration getMessageIds(String groupsPat, long since) throws NewsDbException {
        return new MultiplexNewsDbMessageIds(this.newsDbs.elements(), groupsPat, since);
    }

    public Enumeration getMessageIds(String groupsPat, long since, String distsPat) throws NewsDbException {
        return new MultiplexNewsDbMessageIds(this.newsDbs.elements(), groupsPat, since, distsPat);
    }

    public void post(String text) throws NewsDbException {
        String newsgroups = NewsDbArticle.getHeader(text, "Newsgroups");
        if (newsgroups == null || newsgroups.length() == 0) {
            throw new NewsDbException("article has no newsgroups");
        }
        StringTokenizer st = new StringTokenizer(newsgroups, ",");
        while (st.hasMoreTokens()) {
            NewsDb newsDb;
            String groupName = st.nextToken();
            try {
                newsDb = this.findNewsDb(groupName);
            }
            catch (NewsDbException newsDbException) {
                continue;
            }
            newsDb.post(text);
            return;
        }
        throw new NewsDbException("can't find a news database supporting any group in " + newsgroups);
    }

    public void close() {
        int i = 0;
        while (i < this.newsDbs.size()) {
            NewsDb newsDb = (NewsDb)this.newsDbs.elementAt(i);
            newsDb.close();
            ++i;
        }
        this.newsDbs = null;
    }

    private NewsDb findNewsDb(String groupName) throws NewsDbException {
        int i = 0;
        while (i < this.groupsPats.size()) {
            String groupsPat = (String)this.groupsPats.elementAt(i);
            if (Utils.match(groupsPat, groupName)) {
                return (NewsDb)this.newsDbs.elementAt(i);
            }
            ++i;
        }
        throw new NewsDbException("no database found for group " + groupName);
    }
}

