/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.Chart;
import com.objectplanet.chart.ChartSample;
import com.objectplanet.chart.PieChartRenderer;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Hashtable;

public class PieChart
extends Chart {
    public static final int SELECTION_STYLE_TRIANGLE = 0;
    public static final int SELECTION_STYLE_CIRCLE = 1;
    public static final int SELECTION_STYLE_DETACHED = 2;
    private int aD;
    private double aG;
    private boolean az;
    private boolean au;
    private int aH;
    private int ar;
    private boolean aq;
    private Color aB;
    private double ao;
    private Hashtable as;
    private int at;
    private Color aw;
    private Color[] ay;
    private Color aA;
    private Color[] ap;
    private Color aC;
    private Color[] av;
    private boolean aF;
    int[] aE;
    private boolean ax;

    public PieChart() {
        this(1);
    }

    public PieChart(int n) {
        this(1, n);
    }

    public PieChart(int n, int n2) {
        super(n, n2);
        this.renderer = new PieChartRenderer(this);
        this.chartType = "pie";
        this.ay = new Color[n2];
        this.ap = new Color[n2];
        this.av = new Color[n2];
        this.aE = new int[n2];
        this.as = new Hashtable();
        this.aD = 20;
        this.aG = 0.4f;
        this.U = false;
        this.az = false;
        this.au = false;
        this.aH = 0;
        this.ar = 0;
        this.aq = true;
        this.aB = null;
        this.ao = 0.1;
        this.at = 3;
        this.S = 3;
        this.Z = 3;
        this.R = 3;
    }

    public void reset() {
        super.reset();
        this.aD = 20;
        this.aG = 0.4f;
        this.az = false;
        this.au = false;
        this.aH = 0;
        this.ar = 0;
        this.aq = true;
        this.aB = null;
        this.ao = 0.1;
        this.aF = true;
        if (this.as != null) {
            this.as.clear();
        }
        this.ax = false;
        this.at = 3;
        this.S = 3;
        this.Z = 3;
        this.R = 3;
    }

    public double getPercentValue(int n, int n2) {
        if (n < 0 || n >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Invalid series index: " + n);
        }
        if (n2 < 0 || n2 >= this.getSampleCount()) {
            throw new IllegalArgumentException("Invalid sample index: " + n2);
        }
        int n3 = this.getSeriesCount();
        if (n3 == 1) {
            int n4 = this.getSampleCount();
            double d = 0.0;
            for (int i = 0; i < n4; ++i) {
                double d2 = this.getSampleValue(0, i);
                if (!(d2 > 0.0)) continue;
                d += d2;
            }
            double d3 = this.getSampleValue(0, n2);
            if (d3 >= 0.0) {
                return d3 / d * 100.0;
            }
        } else {
            double d = 0.0;
            for (int i = 0; i < n3; ++i) {
                double d4 = this.getSampleValue(i, n2);
                if (!(d4 > 0.0)) continue;
                d += d4;
            }
            double d5 = this.getSampleValue(n, n2);
            if (d5 > 0.0) {
                return d5 / d * 100.0;
            }
        }
        return 0.0;
    }

    public void setAngle(int n) {
        if (this.aD != n) {
            this.aD = n;
            this.needRender = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public int getAngle() {
        return this.aD;
    }

    public void setStartAngle(int n) {
        this.setStartAngle(0, n);
    }

    public void setStartAngle(int n, int n2) {
        if (n >= this.getSampleCount()) {
            throw new IllegalArgumentException("Invalid pie index: " + n);
        }
        n2 = (n2 %= 360) < 0 ? -360 - n2 : -n2;
        if (n < 0) {
            for (int i = 0; i < this.getSampleCount(); ++i) {
                this.aE[i] = n2;
            }
        } else {
            this.aE[n] = n2;
        }
        this.needRender = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public int getStartAngle(int n) {
        return -this.aE[n];
    }

    public void setDepth(double d) {
        if (this.aG != d) {
            this.aG = d;
            this.needRender = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public float getDepth() {
        return (float)this.aG;
    }

    public void setPercentDecimalCount(int n) {
        if (this.aH != n) {
            this.aH = n;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public int getPercentDecimalCount() {
        return this.aH;
    }

    public void setPercentLabelsOn(boolean bl) {
        if (this.az != bl) {
            this.az = bl;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public boolean isPercentLabelsOn() {
        return this.az;
    }

    public void setPercentLabelStyle(int n) {
        if (this.at != n) {
            this.at = 3;
            if (n == 0 || n == 1 || n == 5) {
                this.at = n;
            }
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public int getPercentLabelStyle() {
        return this.at;
    }

    public void setPieLabelsOn(boolean bl) {
        if (this.au != bl) {
            this.au = bl;
            this.needRender = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public boolean isPieLabelsOn() {
        return this.au;
    }

    public void setInsideLabelColor(int n, Color color) {
        if (n >= 0) {
            if (n >= this.ay.length) {
                Color[] colorArray = new Color[n + 1];
                System.arraycopy(this.ay, 0, colorArray, 0, this.ay.length);
                this.ay = colorArray;
            }
            this.ay[n] = color;
            this.autoRepaint();
        } else {
            this.aw = color;
        }
    }

    public Color getInsideLabelColor(int n) {
        if (n == -1) {
            return this.aw;
        }
        try {
            return this.ay[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid pie index: " + n);
        }
    }

    public void setOutsideLabelColor(int n, Color color) {
        if (n >= 0) {
            if (n >= this.ap.length) {
                Color[] colorArray = new Color[n + 1];
                System.arraycopy(this.ap, 0, colorArray, 0, this.ap.length);
                this.ap = colorArray;
            }
            this.ap[n] = color;
            this.autoRepaint();
        } else {
            this.aA = color;
        }
    }

    public Color getOutsideLabelColor(int n) {
        if (n == -1) {
            return this.aA;
        }
        try {
            return this.ap[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid pie index: " + n);
        }
    }

    public void setPointingLabelColor(int n, Color color) {
        if (n >= 0) {
            if (n >= this.av.length) {
                Color[] colorArray = new Color[n + 1];
                System.arraycopy(this.av, 0, colorArray, 0, this.av.length);
                this.av = colorArray;
            }
            this.av[n] = color;
            this.autoRepaint();
        } else {
            this.aC = color;
        }
    }

    public Color getPointingLabelColor(int n) {
        if (n == -1) {
            return this.aC;
        }
        try {
            return this.av[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid pie index: " + n);
        }
    }

    public void setFont(String string, Font font) {
        super.setFont(string, font);
    }

    public void setSelectionStyle(int n) {
        if (this.ar != n) {
            this.ar = n;
            this.needRender = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public int getSelectionStyle() {
        return this.ar;
    }

    public void setDetachedDistance(double d) {
        if (this.ao != d) {
            this.ao = d;
            this.needRender = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public double getDetachedDistance() {
        return this.ao;
    }

    public void setDetachedSlice(int n, int n2, double d) {
        Double d2 = new Double(n * 1000000 + n2);
        if (d != 0.0) {
            this.as.put(d2, new Double(d));
        } else {
            this.as.remove(d2);
        }
        this.needRender = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public double getDetachedSlice(int n, int n2) {
        Double d = new Double(n * 1000000 + n2);
        Double d2 = (Double)this.as.get(d);
        if (d2 != null) {
            return d2;
        }
        return 0.0;
    }

    public void setSliceSeperatorOn(boolean bl) {
        if (this.aq != bl) {
            this.aq = bl;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public boolean isSliceSeperatorOn() {
        return this.aq;
    }

    public void setSliceSeperatorColor(Color color) {
        if (this.aB != color) {
            this.aB = color;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public Color getSliceSeperatorColor() {
        return this.aB;
    }

    public void setGradientSamplesOn(boolean bl) {
        this.aF = bl;
    }

    public boolean isGradientSamplesOn() {
        return this.aF;
    }

    public void setPieRotationOn(boolean bl) {
        this.ax = bl;
    }

    public boolean isPieRotationOn() {
        return this.ax;
    }

    public Polygon getSlicePolygon(int n, int n2) {
        return ((PieChartRenderer)this.renderer).getSlicePolygon(n, n2);
    }

    protected Rectangle getTotalGraphBounds() {
        return this.getGraphBounds();
    }

    protected void checkDataIntegrity() {
        int n;
        Object[] objectArray;
        super.checkDataIntegrity();
        this.renderer.checkDataIntegrity();
        int n2 = this.getSampleCount();
        if (this.ay != null && n2 != this.ay.length) {
            objectArray = new Color[n2];
            n = Math.min(n2, this.ay.length);
            System.arraycopy(this.ay, 0, objectArray, 0, n);
            this.ay = objectArray;
        }
        if (this.ap != null && n2 != this.ap.length) {
            objectArray = new Color[n2];
            n = Math.min(n2, this.ap.length);
            System.arraycopy(this.ap, 0, objectArray, 0, n);
            this.ap = objectArray;
        }
        if (this.av != null && n2 != this.av.length) {
            objectArray = new Color[n2];
            n = Math.min(n2, this.av.length);
            System.arraycopy(this.av, 0, objectArray, 0, n);
            this.av = objectArray;
        }
        if (this.aE != null && n2 != this.aE.length) {
            objectArray = new int[n2];
            n = Math.min(n2, this.aE.length);
            System.arraycopy(this.aE, 0, objectArray, 0, n);
            this.aE = (int[])objectArray;
        }
    }

    protected String constructLabel(int n, int n2, int n3, boolean bl, String string) {
        boolean bl2;
        boolean bl3 = bl2 = this.az && this.at == n3;
        if (bl2 && n >= 0) {
            string = this.formatNumber(this.getPercentValue(n, n2), this.getPercentDecimalCount()) + "%";
        }
        return super.constructLabel(n, n2, n3, bl, string);
    }

    public boolean isAnyFloatingLabelsOn(int n) {
        boolean bl = this.U && this.Z == 3;
        bl |= this.T && this.R == 3;
        bl |= this.isValueLabelsOn(n) && this.S == 3;
        return bl |= this.az && this.at == 3;
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (this.ax) {
            ((PieChartRenderer)this.renderer).handlePieRotation(aWTEvent);
        }
        super.processEvent(aWTEvent);
    }

    public ChartSample checkSelection(Point point) {
        return this.renderer.checkSelection(point);
    }
}

