/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.image;

import com.objectplanet.image.IndexedEncoder;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class IndexedAlphaEncoder
extends IndexedEncoder {
    protected ByteArrayOutputStream trnsChunk = new ByteArrayOutputStream();
    private boolean transparency_set;

    IndexedAlphaEncoder(int compression) {
        super(compression);
        this.colorType = 5;
    }

    synchronized void encode(Image image, DataOutputStream out) throws IOException {
        this.trnsChunk.reset();
        this.trnsChunk.write("tRNS".getBytes());
        this.transparency_set = false;
        super.encode(image, out);
    }

    protected void writeChunks(DataOutputStream out) throws IOException {
        this.writeChunk(this.headerChunk, out);
        this.writeChunk(this.paletteChunk, out);
        this.writeChunk(this.trnsChunk, out);
        this.writeChunk(this.idatChunk, out);
    }

    public void setDimensions(int width, int height) {
        this.headerChunk.reset();
        try {
            DataOutputStream header = new DataOutputStream(this.headerChunk);
            header.write("IHDR".getBytes());
            header.writeInt(width);
            header.writeInt(height);
            header.write(8);
            header.write(3);
            header.write(0);
            header.write(0);
            header.write(0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        if (model == null || pixels == null) {
            return;
        }
        if (!this.palette_set) {
            this.initPalette();
            this.palette_set = true;
        }
        if (!this.transparency_set) {
            this.trnsChunk.write(0);
            this.transparency_set = true;
        }
        int rows = pixels.length / scansize;
        int index = 0;
        for (int row = 0; row < rows; ++row) {
            if (this.pngPixels == null || this.pngPixels.length < scansize + 1) {
                this.pngPixels = new byte[scansize + 1];
            }
            this.pngPixels[0] = 0;
            for (int i = 0; i < scansize; ++i) {
                if (model.getAlpha(pixels[index]) == 0) {
                    this.pngPixels[i + 1] = 0;
                } else {
                    this.setPixel(model, pixels[index], i);
                }
                ++index;
            }
            try {
                this.deflaterOut.write(this.pngPixels, 0, scansize + 1);
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        if (model == null || pixels == null) {
            return;
        }
        if (!this.palette_set) {
            byte[] a = new byte[256];
            byte[] r = new byte[256];
            byte[] g = new byte[256];
            byte[] b = new byte[256];
            ((IndexColorModel)model).getAlphas(a);
            ((IndexColorModel)model).getReds(r);
            ((IndexColorModel)model).getGreens(g);
            ((IndexColorModel)model).getBlues(b);
            for (int i = 0; i < 256; ++i) {
                this.paletteChunk.write(r[i]);
                this.paletteChunk.write(g[i]);
                this.paletteChunk.write(b[i]);
                this.trnsChunk.write(a[i]);
            }
            this.palette_set = true;
        }
        try {
            this.deflaterOut.write(0);
            this.deflaterOut.write(pixels, 0, pixels.length);
        }
        catch (IOException e) {
            // empty catch block
        }
    }
}

