/*
 * Decompiled with CFR 0.152.
 */
package com.fusioncharts.exporter.beans;

import com.fusioncharts.exporter.beans.ChartMetadata;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportBean {
    private ChartMetadata metadata;
    private String stream;
    private HashMap<String, Object> exportParameters = new HashMap();

    public ExportBean() {
        this.exportParameters.put("exportfilename", "FusionCharts");
        this.exportParameters.put("exportaction", "download");
        this.exportParameters.put("exportargetwindow", "_self");
        this.exportParameters.put("exportformat", "PDF");
    }

    public ChartMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(ChartMetadata metadata) {
        this.metadata = metadata;
    }

    public String getStream() {
        return this.stream;
    }

    public void setStream(String stream) {
        this.stream = stream;
    }

    public HashMap<String, Object> getExportParameters() {
        return new HashMap<String, Object>(this.exportParameters);
    }

    public Object getExportParameterValue(String key) {
        return this.exportParameters.get(key);
    }

    public void setExportParameters(HashMap<String, Object> exportParameters) {
        this.exportParameters = exportParameters;
    }

    public void addExportParameter(String parameterName, Object value) {
        this.exportParameters.put(parameterName.toLowerCase(), value);
    }

    public void addExportParametersFromMap(HashMap<String, String> moreParameters) {
        this.exportParameters.putAll(moreParameters);
    }

    public String getParametersAndMetadataAsQueryString() {
        String queryParams = "";
        queryParams = String.valueOf(queryParams) + "?width=" + this.metadata.getWidth();
        queryParams = String.valueOf(queryParams) + "&height=" + this.metadata.getHeight();
        queryParams = String.valueOf(queryParams) + "&bgcolor=" + this.metadata.getBgColor();
        for (String key : this.exportParameters.keySet()) {
            String value = (String)this.exportParameters.get(key);
            queryParams = String.valueOf(queryParams) + "&" + key + "=" + value;
        }
        return queryParams;
    }

    public String getMetadataAsQueryString(String filePath, boolean isError, boolean isHTML) {
        String queryParams = "";
        if (isError) {
            queryParams = String.valueOf(queryParams) + (isHTML ? "<BR>" : "&") + "width=0";
            queryParams = String.valueOf(queryParams) + (isHTML ? "<BR>" : "&") + "height=0";
        } else {
            queryParams = String.valueOf(queryParams) + (isHTML ? "<BR>" : "&") + "width=" + this.metadata.getWidth();
            queryParams = String.valueOf(queryParams) + (isHTML ? "<BR>" : "&") + "height=" + this.metadata.getHeight();
        }
        queryParams = String.valueOf(queryParams) + (isHTML ? "<BR>" : "&") + "DOMId=" + this.metadata.getDOMId();
        if (filePath != null) {
            queryParams = String.valueOf(queryParams) + (isHTML ? "<BR>" : "&") + "fileName=" + filePath;
        }
        return queryParams;
    }
}

