/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.ChartRenderer;
import com.objectplanet.chart.ChartSample;
import com.objectplanet.chart.PieChart;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.Serializable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PieChartRenderer
extends ChartRenderer {
    public static final int SELECTION_STYLE_TRIANGLE = 0;
    public static final int SELECTION_STYLE_CIRCLE = 1;
    public static final int SELECTION_STYLE_DETACHED = 2;
    private double[][] f;
    private double[][] l;
    private Rectangle[] q;
    private Rectangle[] s;
    private Point[] h;
    private int[] n;
    private double t;
    private int o;
    private long m;
    private int k;
    private double g;
    private int i;
    private int p;
    private static final int u = 0;
    private static final int j = 1;
    private static final int r = 2;
    private static final int v = 3;
    PieChart chart;

    public PieChartRenderer(PieChart pieChart) {
        super(pieChart);
        this.chart = pieChart;
        this.legend = pieChart.legend;
        this.gridRenderer = pieChart.gridRenderer;
        this.legendRenderer = pieChart.legendRenderer;
        int n = pieChart.getSeriesCount();
        int n2 = pieChart.getSampleCount();
        this.f = new double[n][n2];
        this.l = new double[n][n2];
        this.q = new Rectangle[n == 1 ? 1 : n2];
        this.s = new Rectangle[n == 1 ? 1 : n2];
        this.h = new Point[this.q.length];
        this.n = new int[this.q.length];
        for (int i = 0; i < this.q.length; ++i) {
            this.q[i] = new Rectangle();
            this.s[i] = new Rectangle();
            this.h[i] = new Point();
        }
    }

    protected Point getSampleCenter(int n, int n2) {
        Point point = new Point();
        int n3 = this.getSeriesCount();
        Point point2 = this.h[n3 > 1 ? n : 0];
        if (point2 == null) {
            return null;
        }
        double d = this.f[n2][n];
        double d2 = this.l[n2][n];
        double d3 = -((d + d2) / 2.0);
        double d4 = 1.0;
        int n4 = this.n[n3 == 1 ? 0 : n];
        double d5 = 0.0;
        if (this.chart.isSelected(n2, n) && d - d2 < 360.0 && this.chart.getSelectionStyle() == 2) {
            d5 = (double)n4 * this.chart.getDetachedDistance() / 2.0;
        }
        if (this.display3dOn) {
            int n5 = (int)Math.round((double)n4 * ((double)this.chart.getAngle() / 90.0));
            d4 = (double)(n4 - n5) / (double)n4;
        }
        double d6 = d3 * (Math.PI / 180);
        point.x = point2.x + (int)Math.round(Math.cos(d6) * (double)n4 * 0.3 + Math.cos(d6) * d5);
        point.y = point2.y + (int)Math.round((Math.sin(d6) * (double)n4 * 0.3 + Math.sin(d6) * d5) * d4);
        if (this.chart.getGraphBounds().contains(point)) {
            return point;
        }
        return null;
    }

    public Polygon getSlicePolygon(int n, int n2) {
        double d;
        Polygon polygon = new Polygon();
        int n3 = 0;
        double d2 = this.f[0][n2];
        double d3 = this.l[0][n2];
        if (this.getSeriesCount() == 1) {
            d = this.chart.getDetachedSlice(0, n2);
        } else {
            d = this.chart.getDetachedSlice(n2, n);
            n3 = n2;
            d2 = this.f[n][n3];
            d3 = this.l[n][n3];
        }
        d2 = -d2;
        d3 = -d3;
        int n4 = this.n[n3];
        Point point = new Point();
        point.x = this.h[n3].x;
        point.y = this.h[n3].y;
        double d4 = 1.0;
        if (this.display3dOn) {
            int n5 = (int)Math.round((double)n4 * ((double)this.chart.getAngle() / 90.0));
            d4 = (double)(n4 - n5) / (double)n4;
        }
        double d5 = (d2 + d3) * (Math.PI / 180) / 2.0;
        int n6 = point.x + (int)Math.round(Math.cos(d5) * (double)n4 * 0.5 * d);
        int n7 = point.y + (int)Math.round(Math.sin(d5) * (double)n4 * 0.5 * d * d4);
        polygon.addPoint(n6, n7);
        d5 = d2 * (Math.PI / 180);
        n6 = point.x + (int)Math.round(Math.cos(d5) * (double)n4 * 0.5 * (1.0 + d));
        n7 = point.y + (int)Math.round(Math.sin(d5) * (double)n4 * 0.5 * (1.0 + d) * d4);
        polygon.addPoint(n6, n7);
        for (double d6 = d2 + 5.0; d6 < d3; d6 += 5.0) {
            d5 = d6 * (Math.PI / 180);
            n6 = point.x + (int)Math.round(Math.cos(d5) * (double)n4 * 0.5 * (1.0 + d));
            n7 = point.y + (int)Math.round(Math.sin(d5) * (double)n4 * 0.5 * (1.0 + d) * d4);
            polygon.addPoint(n6, n7);
        }
        d5 = d3 * (Math.PI / 180);
        n6 = point.x + (int)Math.round(Math.cos(d5) * (double)n4 * 0.5 * (1.0 + d));
        n7 = point.y + (int)Math.round(Math.sin(d5) * (double)n4 * 0.5 * (1.0 + d) * d4);
        polygon.addPoint(n6, n7);
        return polygon;
    }

    protected void calculateGraphBounds(Rectangle rectangle) {
        Cloneable cloneable;
        Dimension dimension = this.chart.getSize();
        this.legendRenderer.calculateGraphBounds(this.legend, rectangle);
        this.display3dOn = this.chart.is3DModeOn();
        if (this.chart.isTitleOn()) {
            cloneable = this.getLabelSize(this.chart.getTitle(), this.getFontMetrics(this.getFont("titleFont")));
            rectangle.y += ((Dimension)cloneable).height;
            rectangle.height -= ((Dimension)cloneable).height;
        }
        if ((cloneable = this.chart.getGraphInsets()) != null) {
            int n;
            if (cloneable.top != -1) {
                n = rectangle.y + rectangle.height;
                rectangle.y = cloneable.top;
                rectangle.height = n - rectangle.y;
            }
            if (cloneable.left != -1) {
                n = rectangle.x + rectangle.width;
                rectangle.x = cloneable.left;
                rectangle.width = n - rectangle.x;
            }
            if (cloneable.bottom != -1) {
                rectangle.height = dimension.height - cloneable.bottom - rectangle.y;
            }
            if (cloneable.right != -1) {
                rectangle.width = dimension.width - cloneable.right - rectangle.x;
            }
        }
    }

    public void render(Graphics graphics) {
        this.render(graphics, !this.chart.isServletModeOn());
    }

    protected void checkDataIntegrity() {
        int n = this.chart.getSeriesCount();
        int n2 = this.chart.getSampleCount();
        this.f = new double[n][n2];
        this.l = new double[n][n2];
        this.q = new Rectangle[n == 1 ? 1 : n2];
        this.s = new Rectangle[n == 1 ? 1 : n2];
        this.h = new Point[this.q.length];
        this.n = new int[this.q.length];
        for (int i = 0; i < this.q.length; ++i) {
            this.q[i] = new Rectangle();
            this.s[i] = new Rectangle();
            this.h[i] = new Point();
        }
    }

    protected void renderData(Graphics graphics, Rectangle rectangle, Rectangle rectangle2) {
        this.do(graphics, rectangle);
        this.for(graphics);
    }

    protected void calculateChartData(Rectangle rectangle, Rectangle rectangle2) {
    }

    private void do(Graphics graphics, Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(10, 10, this.chart.getSize().width - 20, this.chart.getSize().height - 20);
        this.calculateGraphBounds(rectangle2);
        int n = this.getSeriesCount();
        if (n == 1) {
            double[] dArray = this.chart.getSampleValues(0);
            this.a(rectangle, 1);
            this.a(graphics, this.q[0], dArray, 0);
        } else {
            int n2 = this.getSampleCount();
            this.a(rectangle, n2);
            for (int i = 0; i < n2; ++i) {
                double[] dArray = new double[n];
                for (int j = 0; j < n; ++j) {
                    dArray[j] = this.chart.getSampleValue(j, i);
                }
                this.a(graphics, this.q[i], dArray, i);
            }
        }
    }

    private void a(Rectangle rectangle, int n) {
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        int n6 = n;
        int n7 = 1;
        for (n4 = 1; n4 <= n; ++n4) {
            for (n3 = 1; n3 <= n; ++n3) {
                if (n4 * n3 < n || (n2 = Math.min(rectangle.width / n4, rectangle.height / n3)) <= n5) continue;
                n5 = n2;
                n6 = n4;
                n7 = n3;
            }
        }
        n4 = 0;
        for (n3 = 0; n3 < n7; ++n3) {
            for (n2 = 0; n2 < n6; ++n2) {
                if (n4 >= n) continue;
                Rectangle rectangle2 = this.s[n4];
                rectangle2.width = rectangle.width / n6;
                rectangle2.height = rectangle.height / n7;
                rectangle2.x = rectangle.x + rectangle2.width * n2;
                rectangle2.y = rectangle.y + rectangle2.height * n3;
                if (n > 1) {
                    rectangle2.width -= 10;
                    rectangle2.height -= 10;
                    rectangle2.x += 5;
                    rectangle2.y += 5;
                }
                this.q[n4].setBounds(this.s[n4]);
                ++n4;
            }
        }
    }

    private void a(Graphics graphics, Rectangle rectangle, double[] dArray, int n) {
        int n2;
        int n3;
        double d;
        double d2;
        double d3;
        double d4;
        int n4;
        double d5;
        double d6;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        Serializable serializable;
        Object object;
        int n10;
        int n11;
        int n12;
        if (rectangle == null || rectangle.width <= 0 || rectangle.height <= 0) {
            return;
        }
        for (n12 = 0; n12 < dArray.length; ++n12) {
            if (!Double.isNaN(dArray[n12])) continue;
            dArray[n12] = 0.0;
        }
        n12 = this.chart.getValueLabelStyle();
        int n13 = this.chart.getSampleLabelStyle();
        int n14 = this.chart.getSeriesLabelStyle();
        int n15 = this.chart.getPercentLabelStyle();
        boolean bl = this.chart.isValueLabelsOn();
        boolean bl2 = this.chart.isSampleLabelsOn();
        boolean bl3 = this.chart.isSeriesLabelsOn();
        boolean bl4 = this.chart.isPercentLabelsOn();
        boolean bl5 = bl4 && n15 == 1 || bl2 && n13 == 1 || bl3 && n14 == 1 || bl && n12 == 1;
        boolean bl6 = bl4 && n15 == 5 || bl2 && n13 == 5 || bl3 && n14 == 5 || bl && n12 == 5;
        int n16 = this.getSeriesCount();
        int n17 = this.getSampleCount();
        int n18 = 0;
        int n19 = 0;
        double d7 = this.chart.getDetachedDistance();
        int n20 = this.chart.getSelectionStyle();
        if (bl5 || bl6) {
            Font font = this.getFont("outsideLabelFont");
            if (bl6) {
                font = this.getFont("pointingLabelFont");
            }
            FontMetrics fontMetrics = this.getFontMetrics(font);
            for (n11 = 0; n11 < n16; ++n11) {
                for (n10 = 0; n10 < n17; ++n10) {
                    ChartSample chartSample = n16 == 1 ? this.chart.getSample(0, n10) : this.chart.getSample(n11, n10);
                    if (chartSample == null || chartSample.value == null || chartSample.value.isNaN()) continue;
                    object = this.chart.constructLabel(n11, n10, 1, true, null);
                    if (bl6) {
                        object = this.chart.constructLabel(n11, n10, 5, true, null);
                    }
                    serializable = this.getLabelSize((String)object, fontMetrics);
                    n18 = Math.max(n18, ((Dimension)serializable).width);
                    n19 = Math.max(n19, ((Dimension)serializable).height);
                }
            }
            rectangle.x += n18;
            rectangle.width -= n18 * 2;
            if (bl5 && !bl6) {
                rectangle.y += n19;
                rectangle.height -= n19 * 2;
            }
        }
        int n21 = n9 = Math.min(rectangle.width, rectangle.height);
        n10 = rectangle.x + rectangle.width / 2;
        int n22 = rectangle.y + rectangle.height / 2;
        object = this.getFont("pieLabelFont");
        if (object == null) {
            object = this.chart.getFont();
        }
        serializable = this.getFontMetrics((Font)object);
        graphics.setFont((Font)object);
        double d8 = this.chart.getAngle();
        double d9 = this.chart.getDepth();
        if (this.display3dOn) {
            n8 = (int)Math.round((double)n9 * d9 * (d8 / 90.0));
            n22 -= n8 / 2;
            double d10 = (double)rectangle.width / (double)n9;
            n7 = (int)Math.round((double)n9 * d10);
            n6 = (int)Math.round((double)(n21 -= (int)Math.round((double)n9 * (d8 / 90.0))) * d10);
            n8 = (int)Math.round((double)n7 * d9 * (d8 / 90.0));
            n11 = n6 + n8;
            n22 = rectangle.y + rectangle.height / 2 - n8 / 2;
            if (n22 - n6 / 2 < rectangle.y) {
                double d11 = (double)n6 / (double)n11;
                n11 = rectangle.height;
                n6 = (int)Math.round((double)n11 * d11);
                n8 = rectangle.height - n6;
                d10 = (double)n9 / (double)n21;
                n7 = (int)Math.round((double)n6 * d10);
                n22 = rectangle.y + rectangle.height / 2 - n8 / 2;
            }
            n9 = n7;
            n21 = n6;
        }
        this.g = (double)n21 / (double)n9;
        if (bl5 || bl6) {
            if (this.display3dOn) {
                if (!bl6) {
                    if ((n21 = (int)((double)(n9 -= (int)((double)n9 / 11.0)) * this.g)) + (n8 = (int)Math.round((double)n9 * d9 * (d8 / 90.0))) + n9 / 10 > rectangle.height) {
                        n21 = rectangle.height - n8 - n9 / 11;
                        n9 = (int)((double)n21 / this.g);
                        n8 = (int)Math.round((double)n9 * d9 * (d8 / 90.0));
                    }
                    n22 = this.q[n].y + this.q[n].height / 2 - n8 / 2;
                } else {
                    n8 = (int)((double)n9 * 1.1) + n18 * 2;
                    if (this.s[n].width < n8) {
                        n9 -= Math.min(n9 / 11, n8 - this.s[n].width);
                        n21 = (int)((double)n9 * this.g);
                    }
                }
            } else {
                if (!bl6) {
                    n9 -= n9 / 11;
                } else {
                    n8 = Math.min(n9, n21) + n18 * 2 + 70;
                    if (this.s[n].width < n8) {
                        n9 -= Math.min(70, n8 - this.s[n].width);
                    }
                }
                n21 = n9;
            }
            this.k = (this.s[n].width - n9) / 2 - n18;
        }
        if (this.chart.isPieLabelsOn()) {
            Font font = this.getFont("pieLabelFont");
            String string = this.chart.getSampleLabel(n);
            Dimension dimension = this.getLabelSize(string, this.getFontMetrics(font));
            if (this.display3dOn) {
                n7 = (int)Math.round((double)n9 * d9 * (d8 / 90.0));
                n6 = n22 + n21 / 2 + dimension.height - ((FontMetrics)serializable).getDescent() + 2;
                if ((n6 += n7) > rectangle.y + rectangle.height) {
                    int n23 = n6 - (rectangle.y + rectangle.height);
                    n21 -= n23;
                    n22 -= n23 / 2;
                }
            } else {
                n9 = n21 -= dimension.height;
                n22 -= dimension.height / 2;
            }
        }
        this.h[n].x = n10;
        this.h[n].y = n22;
        this.n[n] = n9;
        double d12 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d12 += Math.abs(dArray[i]);
        }
        if (d12 == 0.0) {
            return;
        }
        double d13 = 0.0;
        double d14 = 90.0;
        n16 = this.getSeriesCount();
        for (n5 = 0; n5 < dArray.length; ++n5) {
            if (n16 == 1) {
                this.f[0][n5] = d14 + (double)this.chart.aE[0];
            } else {
                this.f[n5][n] = d14 + (double)this.chart.aE[n];
            }
            if (!Double.isNaN(dArray[n5])) {
                d14 = 90.0 - (d13 += Math.abs(dArray[n5])) * 360.0 / d12;
            }
            if (n16 == 1) {
                this.l[0][n5] = d14 + (double)this.chart.aE[0];
                continue;
            }
            this.l[n5][n] = d14 + (double)this.chart.aE[n];
        }
        for (n5 = 0; n5 < dArray.length; ++n5) {
            if (n16 == 1) {
                if (this.f[0][n5] > -270.0 && this.l[0][n5] <= -270.0 || this.f[0][n5] >= 90.0 && this.l[0][n5] <= 90.0) {
                    this.i = n5;
                }
                if (!(this.f[0][n5] >= -90.0 && this.l[0][n5] < -90.0) && (!(this.f[0][n5] > -450.0) || !(this.l[0][n5] <= -450.0))) continue;
                this.p = n5;
                continue;
            }
            if (this.f[n5][n] > -270.0 && this.l[n5][n] <= -270.0 || this.f[n5][n] >= 90.0 && this.l[n5][n] <= 90.0) {
                this.i = n5;
            }
            if (!(this.f[n5][n] > -90.0 && this.l[n5][n] <= -90.0) && (!(this.f[n5][n] > -450.0) || !(this.l[n5][n] <= -450.0))) continue;
            this.p = n5;
        }
        if (this.i < 0 || this.p < 0) {
            return;
        }
        if (n16 == 1) {
            d6 = this.f[0][this.i];
            d5 = this.l[0][this.i];
        } else {
            d6 = this.f[this.i][n];
            d5 = this.l[this.i][n];
        }
        ChartSample chartSample = n16 == 1 ? this.chart.getSample(0, this.i) : this.chart.getSample(this.i, n);
        boolean bl7 = n16 == 1 ? this.chart.isSelected(0, this.i) : this.chart.isSelected(this.i, n);
        double d15 = bl7 && n20 == 2 ? d7 : (n16 == 1 ? this.chart.getDetachedSlice(0, this.i) : this.chart.getDetachedSlice(this.i, n));
        if (chartSample != null) {
            this.a((Graphics2D)graphics, this.i, this.chart.getSampleColor(this.i), d6, d6 - d5, n9, n21, n10, n22, bl7, d15, 2);
        }
        if ((n4 = this.i - 1) == -1) {
            n4 = dArray.length - 1;
        }
        while (dArray[n4] == 0.0) {
            if (--n4 != -1) continue;
            n4 = dArray.length - 1;
        }
        if (n16 == 1) {
            d4 = this.f[0][n4];
            d3 = this.l[0][n4];
        } else {
            d4 = this.f[n4][n];
            d3 = this.l[n4][n];
        }
        while (d4 <= -90.0 && d4 > -270.0 && d3 <= -90.0 && d3 > -270.0 || d4 <= -450.0 && d4 > -630.0 && d3 <= -450.0 && d3 > -630.0) {
            if (n4 != this.p && n4 != this.i) {
                chartSample = n16 == 1 ? this.chart.getSample(0, n4) : this.chart.getSample(n4, n);
                bl7 = n16 == 1 ? this.chart.isSelected(0, n4) : this.chart.isSelected(n4, n);
                d15 = bl7 && n20 == 2 ? d7 : (n16 == 1 ? this.chart.getDetachedSlice(0, n4) : this.chart.getDetachedSlice(n4, n));
                if (chartSample != null) {
                    this.a((Graphics2D)graphics, n4, this.chart.getSampleColor(n4), d4, d4 - d3, n9, n21, n10, n22, bl7, d15, 0);
                }
            }
            if (--n4 == -1) {
                n4 = dArray.length - 1;
            }
            if (n16 == 1) {
                d4 = this.f[0][n4];
                d3 = this.l[0][n4];
                continue;
            }
            d4 = this.f[n4][n];
            d3 = this.l[n4][n];
        }
        n4 = this.i + 1;
        if (n4 == dArray.length) {
            n4 = 0;
        }
        while (dArray[n4] == 0.0) {
            if (++n4 != dArray.length) continue;
            n4 = 0;
        }
        if (n16 == 1) {
            d4 = this.f[0][n4];
            d3 = this.l[0][n4];
        } else {
            d4 = this.f[n4][n];
            d3 = this.l[n4][n];
        }
        for (int i = 0; (-90.0 <= d4 && d4 <= 90.0 && -90.0 <= d3 && d3 <= 90.0 || -450.0 <= d4 && d4 <= -270.0 && -450.0 <= d3 && d3 <= -270.0) && i < dArray.length; ++i) {
            if (n4 != this.p && n4 != this.i) {
                chartSample = n16 == 1 ? this.chart.getSample(0, n4) : this.chart.getSample(n4, n);
                bl7 = n16 == 1 ? this.chart.isSelected(0, n4) : this.chart.isSelected(n4, n);
                d15 = bl7 && n20 == 2 ? d7 : (n16 == 1 ? this.chart.getDetachedSlice(0, n4) : this.chart.getDetachedSlice(n4, n));
                if (chartSample != null) {
                    this.a((Graphics2D)graphics, n4, this.chart.getSampleColor(n4), d4, d4 - d3, n9, n21, n10, n22, bl7, d15, 1);
                }
            }
            if (++n4 == dArray.length) {
                n4 = 0;
            }
            if (n16 == 1) {
                d4 = this.f[0][n4];
                d3 = this.l[0][n4];
                continue;
            }
            d4 = this.f[n4][n];
            d3 = this.l[n4][n];
        }
        if (n16 == 1) {
            d2 = this.f[0][this.p];
            d = this.l[0][this.p];
        } else {
            d2 = this.f[this.p][n];
            d = this.l[this.p][n];
        }
        if (this.p != -1) {
            chartSample = n16 == 1 ? this.chart.getSample(0, this.p) : this.chart.getSample(this.p, n);
            bl7 = n16 == 1 ? this.chart.isSelected(0, this.p) : this.chart.isSelected(this.p, n);
            d15 = bl7 && n20 == 2 ? d7 : (n16 == 1 ? this.chart.getDetachedSlice(0, this.p) : this.chart.getDetachedSlice(this.p, n));
            if (chartSample != null) {
                this.a((Graphics2D)graphics, this.p, this.chart.getSampleColor(this.p), d2, d2 - d, n9, n21, n10, n22, bl7, d15, 3);
            }
        }
        if (this.chart.isSliceSeperatorOn()) {
            boolean bl8 = false;
            for (n4 = 0; n4 < dArray.length; ++n4) {
                if (n16 == 1) {
                    d4 = this.f[0][n4];
                    d3 = this.l[0][n4];
                    bl7 = this.chart.isSelected(0, n4);
                    chartSample = this.chart.getSample(0, n4);
                } else {
                    d4 = this.f[n4][n];
                    d3 = this.l[n4][n];
                    bl7 = this.chart.isSelected(n4, n);
                    chartSample = this.chart.getSample(n4, n);
                }
                d15 = bl7 && n20 == 2 ? d7 : (n16 == 1 ? this.chart.getDetachedSlice(0, n4) : this.chart.getDetachedSlice(n4, n));
                if (d15 != 0.0) continue;
                if (chartSample != null && chartSample.value != null && !chartSample.value.isNaN()) {
                    if (this.chart.getSliceSeperatorColor() != null) {
                        graphics.setColor(this.chart.getSliceSeperatorColor());
                    } else {
                        graphics.setColor(PieChartRenderer.getDarker(this.chart.getSampleColor(n4)));
                    }
                    double d16 = (double)(-Math.round(d4)) * (Math.PI / 180);
                    n3 = n10 + (int)Math.round(Math.cos(d16) * ((double)n9 * 0.5));
                    n2 = n22 + (int)Math.round(Math.sin(d16) * ((double)n21 * 0.5));
                    double d17 = (double)(-Math.round(d3)) * (Math.PI / 180);
                    int n24 = n10 + (int)Math.round(Math.cos(d17) * ((double)n9 * 0.5));
                    int n25 = n22 + (int)Math.round(Math.sin(d17) * ((double)n21 * 0.5));
                    if (bl8) {
                        graphics.drawLine(n10, n22, n3, n2);
                    }
                    graphics.drawLine(n10, n22, n24, n25);
                }
                bl8 = bl7;
            }
        }
        if (this.chart.isPieLabelsOn()) {
            String string = n16 == 1 ? this.chart.getSeriesLabel(n) : this.chart.getSampleLabel(n);
            Font font = this.getFont("pieLabelFont");
            if (string != null && string.trim().length() > 0) {
                Color color;
                Dimension dimension = this.getLabelSize(string, this.getFontMetrics(font));
                n3 = n10 - dimension.width / 2;
                n2 = n22 + n21 / 2 + ((FontMetrics)serializable).getHeight() - ((FontMetrics)serializable).getDescent() + 3;
                if (this.display3dOn) {
                    n2 += (int)Math.round((double)n9 * d9 * (d8 / 90.0));
                }
                graphics.setColor((color = this.chart.getSampleLabelColor(n)) != null ? color : this.chart.getForeground());
                this.paintLabel(graphics, string, n3, n2, dimension, 0, 0, false);
            }
        }
    }

    private void a(Graphics2D graphics2D, int n, Color color, double d, double d2, int n2, int n3, int n4, int n5, boolean bl, double d3, int n6) {
        Arc2D.Double double_;
        Arc2D.Double double_2;
        GradientPaint gradientPaint;
        GradientPaint gradientPaint2;
        boolean bl2;
        if (d3 > 0.0 && d2 < 360.0) {
            double d4 = -d + d2 / 2.0;
            double d5 = d4 * (Math.PI / 180);
            n4 += (int)Math.round(Math.cos(d5) * ((double)n2 * (d3 / 2.0)));
            n5 += (int)Math.round(Math.sin(d5) * ((double)n3 * (d3 / 2.0)));
        }
        Point point = new Point(n4, n5);
        int n7 = n4 - n2 / 2;
        int n8 = n5 - n3 / 2;
        double d6 = d;
        double d7 = -d2;
        double d8 = d6 + d7;
        int n9 = (int)Math.round((double)((float)n2 * this.chart.getDepth()) * ((double)this.chart.getAngle() / 90.0));
        boolean bl3 = bl2 = n == this.i && n == this.p;
        if (this.chart.isGradientSamplesOn()) {
            gradientPaint2 = new GradientPaint(n7, 0.0f, PieChartRenderer.getDarker(PieChartRenderer.getDarker(color)), (float)((double)n7 + (double)n2 * 0.66), 0.0f, PieChartRenderer.getBrighter(color), true);
            gradientPaint = new GradientPaint(n7, n8, PieChartRenderer.getDarker(PieChartRenderer.getDarker(color)), (float)n7 + (float)((double)n2 * 1.5), (float)n8 + (float)((double)n3 * 1.5), color);
        } else {
            gradientPaint2 = new GradientPaint(n7, 0.0f, PieChartRenderer.getDarker(color), (float)((double)n7 + (double)n2 * 0.66), 0.0f, PieChartRenderer.getDarker(color), true);
            gradientPaint = new GradientPaint(n7, n8, PieChartRenderer.getDarker(color), (float)n7 + (float)((double)n2 * 1.5), (float)n8 + (float)((double)n3 * 1.5), PieChartRenderer.getDarker(color));
        }
        if (this.display3dOn) {
            if (!bl2 || n6 != 3) {
                double_2 = new Arc2D.Double(n7, n8 + n9, n2, n3, d6, d7, 2);
                double_ = new Arc2D.Double(n7, n8 + n9, n2, n3, d6, d7, 0);
                graphics2D.setPaint(gradientPaint2);
                graphics2D.fill(double_2);
                if (this.chart.isSliceSeperatorOn()) {
                    if (this.chart.getSliceSeperatorColor() != null) {
                        graphics2D.setColor(this.chart.getSliceSeperatorColor());
                        graphics2D.setPaint(gradientPaint);
                        graphics2D.draw(double_);
                    } else {
                        graphics2D.setPaint(gradientPaint);
                        graphics2D.draw(double_2);
                    }
                } else {
                    graphics2D.setPaint(gradientPaint);
                    graphics2D.draw(double_);
                }
            }
            if (d6 < -360.0) {
                d6 += 720.0;
            } else if (d6 < 0.0) {
                d6 += 360.0;
            }
            d8 = d6 + d7;
            if (bl2) {
                if (n6 == 2) {
                    if (d6 >= 270.0) {
                        this.a(graphics2D, n7, n8, n2, n3, point, n9, 180.0, d8 - 180.0, gradientPaint2, gradientPaint, false, true);
                    } else if (d6 <= 90.0) {
                        this.a(graphics2D, n7, n8, n2, n3, point, n9, -180.0, d8 + 180.0, gradientPaint2, gradientPaint, false, true);
                    } else if (d6 + d7 <= -90.0) {
                        this.a(graphics2D, n7, n8, n2, n3, point, n9, d6, -d6, gradientPaint2, gradientPaint, true, false);
                    }
                } else if (n6 == 3) {
                    if (d6 >= 270.0) {
                        this.a(graphics2D, n7, n8, n2, n3, point, n9, d6, 180.0 - d6, gradientPaint2, gradientPaint, true, false);
                    } else if (d6 < 90.0) {
                        this.a(graphics2D, n7, n8, n2, n3, point, n9, d6, -180.0 - d6, gradientPaint2, gradientPaint, true, false);
                    } else if (d6 + d7 <= -90.0) {
                        this.a(graphics2D, n7, n8, n2, n3, point, n9, 0.0, d8, gradientPaint2, gradientPaint, false, true);
                    }
                } else if (n6 == 1 && d6 == 90.0 && d7 == -180.0) {
                    this.a(graphics2D, n7, n8, n2, n3, point, n9, 90.0, -90.0, gradientPaint2, gradientPaint, true, false);
                    this.a(graphics2D, n7, n8, n2, n3, point, n9, -90.0, 90.0, gradientPaint2, gradientPaint, true, false);
                }
            } else {
                this.a(graphics2D, n7, n8, n2, n3, point, n9, d6, d7, gradientPaint2, gradientPaint, true, true);
            }
        }
        if (!bl2 || n6 != 2) {
            gradientPaint2 = this.chart.isGradientSamplesOn() ? new GradientPaint(n7, n8, PieChartRenderer.getDarker(color), (float)n7 + (float)n2, (float)n8 + (float)n3, PieChartRenderer.getBrighter(color)) : new GradientPaint(n7, n8, color, (float)n7 + (float)n2, (float)n8 + (float)n3, color);
            double_2 = new Arc2D.Double(n7, n8, n2, n3, d6, d7, 2);
            double_ = new Arc2D.Double(n7, n8, n2, n3, d6, d7, 0);
            graphics2D.setPaint(gradientPaint2);
            graphics2D.fill(double_2);
            graphics2D.setPaint(gradientPaint);
            if (this.chart.isSliceSeperatorOn()) {
                if (this.chart.getSliceSeperatorColor() != null) {
                    graphics2D.setColor(this.chart.getSliceSeperatorColor());
                    graphics2D.setPaint(gradientPaint);
                    graphics2D.draw(double_);
                } else {
                    graphics2D.setPaint(gradientPaint);
                    graphics2D.draw(double_2);
                }
            } else {
                graphics2D.setPaint(gradientPaint);
                graphics2D.draw(double_);
            }
        }
        if (bl) {
            this.a(graphics2D, color, (int)Math.round(-d), (int)Math.round(-d2), n2, n3, n4, n5, this.chart.getSelectionStyle());
        }
    }

    private void a(Graphics2D graphics2D, int n, int n2, int n3, int n4, Point point, int n5, double d, double d2, GradientPaint gradientPaint, GradientPaint gradientPaint2, boolean bl, boolean bl2) {
        boolean bl3;
        double d3 = Math.toRadians(-d);
        double d4 = (double)n + (Math.cos(d3) * 0.5 + 0.5) * (double)n3;
        double d5 = (double)n2 + (Math.sin(d3) * 0.5 + 0.5) * (double)n4;
        d3 = Math.toRadians(-d - d2);
        double d6 = (double)n + (Math.cos(d3) * 0.5 + 0.5) * (double)n3;
        double d7 = (double)n2 + (Math.sin(d3) * 0.5 + 0.5) * (double)n4;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(point.x, point.y + n5 + 1);
        generalPath.lineTo(point.x, point.y);
        generalPath.lineTo((float)d4, (float)d5);
        generalPath.lineTo((float)d4, (float)d5 + (float)n5 + 1.0f);
        generalPath.closePath();
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.moveTo(point.x, point.y + n5 + 1);
        generalPath2.lineTo(point.x, point.y);
        generalPath2.lineTo((float)d6, (float)d7);
        generalPath2.lineTo((float)d6, (float)d7 + (float)n5 + 1.0f);
        generalPath2.closePath();
        graphics2D.setPaint(gradientPaint2);
        graphics2D.drawLine(point.x, point.y, point.x, point.y + n5);
        graphics2D.setPaint(PieChartRenderer.getDarker(gradientPaint2.getColor2()));
        if (bl && (d > 270.0 || d < 90.0)) {
            graphics2D.fill(generalPath);
        }
        if (bl2 && (d + d2 > -270.0 && d + d2 < -90.0 || d + d2 > 90.0 && d + d2 < 270.0)) {
            graphics2D.fill(generalPath2);
        }
        graphics2D.setPaint(gradientPaint);
        boolean bl4 = d >= 0.0 && d + d2 <= 0.0 || d >= -360.0 && d + d2 <= -360.0;
        boolean bl5 = bl3 = d >= -180.0 && d + d2 <= -180.0 || d >= 180.0 && d + d2 <= 180.0;
        if (bl4 && bl3) {
            if (d <= 90.0) {
                this.a(graphics2D, n, n2, n3, n4, n5, d, -d, gradientPaint, gradientPaint2);
                this.a(graphics2D, n, n2, n3, n4, n5, -180.0, d + d2 + 180.0, gradientPaint, gradientPaint2);
                this.a(graphics2D, n, n2, n3, n4, n5, 0.0, -180.0, gradientPaint, gradientPaint2);
            } else {
                this.a(graphics2D, n, n2, n3, n4, n5, 0.0, 180.0, gradientPaint, gradientPaint2);
                this.a(graphics2D, n, n2, n3, n4, n5, d, 180.0 - d, gradientPaint, gradientPaint2);
                this.a(graphics2D, n, n2, n3, n4, n5, 0.0, d + d2, gradientPaint, gradientPaint2);
            }
            graphics2D.drawLine(n, point.y, n - 1, point.y + n5);
            graphics2D.drawLine(n + n3, point.y, n + n3, point.y + n5);
        } else if (bl4) {
            this.a(graphics2D, n, n2, n3, n4, n5, d, -d, gradientPaint, gradientPaint2);
            this.a(graphics2D, n, n2, n3, n4, n5, 0.0, d + d2, gradientPaint, gradientPaint2);
            graphics2D.drawLine(n + n3, point.y, n + n3, point.y + n5);
        } else if (bl3) {
            if (d <= 90.0) {
                this.a(graphics2D, n, n2, n3, n4, n5, d, 180.0 + d, gradientPaint, gradientPaint2);
                this.a(graphics2D, n, n2, n3, n4, n5, -180.0, d + d2 + 180.0, gradientPaint, gradientPaint2);
            } else {
                this.a(graphics2D, n, n2, n3, n4, n5, 180.0, d + d2 - 180.0, gradientPaint, gradientPaint2);
                this.a(graphics2D, n, n2, n3, n4, n5, d, 180.0 - d, gradientPaint, gradientPaint2);
            }
            graphics2D.drawLine(n, point.y, n - 1, point.y + n5);
        } else {
            this.a(graphics2D, n, n2, n3, n4, n5, d, d2, gradientPaint, gradientPaint2);
        }
        graphics2D.setPaint(PieChartRenderer.getDarker(gradientPaint2.getColor2()));
        if (bl && d > 90.0 && d < 270.0) {
            graphics2D.fill(generalPath);
        }
        if (bl2 && (d + d2 > 270.0 || d + d2 > -90.0 && d + d2 < 90.0 || d + d2 < -270.0 && d + d2 > -360.0)) {
            graphics2D.fill(generalPath2);
        }
        graphics2D.setPaint(gradientPaint2);
        if (bl) {
            graphics2D.drawLine((int)d4, (int)d5, (int)d4, (int)d5 + n5);
        }
        if (bl2) {
            graphics2D.drawLine((int)d6, (int)d7, (int)d6, (int)d7 + n5);
        }
    }

    private void a(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5, double d, double d2, Paint paint, Paint paint2) {
        GeneralPath generalPath = new GeneralPath();
        Arc2D.Double double_ = new Arc2D.Double(n, n2, n3, n4, d, d2, 0);
        Point2D point2D = double_.getStartPoint();
        generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
        generalPath.append(double_, false);
        Arc2D.Double double_2 = new Arc2D.Double(n, n2 + n5, n3, n4, d + d2, -d2, 0);
        generalPath.append(double_2, true);
        generalPath.closePath();
        graphics2D.setPaint(paint);
        graphics2D.fill(generalPath);
        graphics2D.setPaint(paint2);
        graphics2D.draw(double_2);
    }

    private void a(Graphics graphics, Color color, double d, double d2, int n, int n2, int n3, int n4, int n5) {
        if (n5 == 1) {
            double d3 = d - d2 / 2.0;
            double d4 = d3 * (Math.PI / 180);
            int n6 = n3 + (int)Math.round(Math.cos(d4) * ((double)n * 0.4));
            int n7 = n4 + (int)Math.round(Math.sin(d4) * ((double)n2 * 0.4));
            int n8 = Math.max(n / 16, 3);
            int n9 = Math.max(n2 / 16, 3);
            int n10 = n8 / 2;
            int n11 = n9 / 2;
            graphics.setColor(PieChartRenderer.getDarker(color));
            graphics.fillOval(n6 - n10, n7 - n11, n8, n9);
            graphics.setColor(PieChartRenderer.getDarker(color));
            graphics.drawArc(n6 - n10, n7 - n11, n8, n9, 45, 180);
            graphics.setColor(PieChartRenderer.getDarker(PieChartRenderer.getDarker(color)));
            graphics.drawArc(n6 - n10 + 1, n7 - n11 + 1, n8 - 2, n9 - 2, 45, 180);
            graphics.setColor(color);
            graphics.drawArc(n6 - n10 + 1, n7 - n11 + 1, n8 - 2, n9 - 2, 45, -180);
            graphics.setColor(color.brighter());
            graphics.drawArc(n6 - n10, n7 - n11, n8, n9, 45, -180);
        } else if (n5 == 0) {
            double d5 = d - d2 / 2.0;
            double d6 = d5 * (Math.PI / 180);
            int n12 = (int)Math.round((double)n * 0.7);
            int n13 = (int)Math.round((double)n2 * 0.7);
            int n14 = n3 + (int)Math.round(Math.cos(d6) * ((double)n * 0.1));
            int n15 = n4 + (int)Math.round(Math.sin(d6) * ((double)n2 * 0.1));
            graphics.setColor(PieChartRenderer.getDarker(color));
            graphics.fillArc(n14 -= (int)Math.round((double)n12 / 2.0), n15 -= (int)Math.round((double)n13 / 2.0), n12 + 1, n13 + 1, (int)(-Math.round(d)), (int)Math.round(d2));
        }
    }

    protected void paintFloatingLabel(Graphics graphics, String string, Rectangle rectangle, int n, int n2, Font font, FontMetrics fontMetrics) {
        int n3 = this.getSeriesCount();
        Point point = this.h[n3 > 1 ? n : 0];
        if (string == null || n2 < 0 || n2 >= this.getSeriesCount() || n < 0 || n >= this.getSampleCount() || fontMetrics == null || point == null) {
            return;
        }
        double d = this.f[n2][n];
        double d2 = this.l[n2][n];
        double d3 = -((d + d2) / 2.0);
        double d4 = 1.0;
        int n4 = this.n[n3 == 1 ? 0 : n];
        if (this.display3dOn) {
            int n5 = (int)Math.round((double)n4 * ((double)this.chart.getAngle() / 90.0));
            d4 = (double)(n4 - n5) / (double)n4;
        }
        double d5 = d3 * (Math.PI / 180);
        int n6 = point.x + (int)Math.round(Math.cos(d5) * (double)n4 * 0.3);
        int n7 = point.y + (int)Math.round(Math.sin(d5) * (double)n4 * 0.3 * d4);
        Dimension dimension = this.getLabelSize(string, fontMetrics);
        Color color = PieChartRenderer.getDarker(this.chart.getSampleColor(this.getSeriesCount() == 1 ? n : n2));
        this.a(graphics, string, n6 -= dimension.width / 2, n7 -= dimension.height / 2 - fontMetrics.getAscent(), dimension, color, fontMetrics);
    }

    private void for(Graphics graphics) {
        int n;
        int n2;
        if (graphics == null) {
            return;
        }
        int n3 = this.getSeriesCount();
        int n4 = this.chart.getValueLabelStyle();
        int n5 = this.chart.getSampleLabelStyle();
        int n6 = this.chart.getSeriesLabelStyle();
        int n7 = this.chart.getPercentLabelStyle();
        boolean bl = this.chart.isValueLabelsOn();
        boolean bl2 = this.chart.isSampleLabelsOn();
        boolean bl3 = this.chart.isSeriesLabelsOn();
        boolean bl4 = this.chart.isPercentLabelsOn();
        boolean bl5 = bl4 && n7 != 3;
        bl5 |= bl && n4 != 3;
        bl5 |= bl2 && n5 != 3;
        if (!(bl5 |= bl3 && n3 > 1 && n6 != 3)) {
            return;
        }
        Font font = this.getFont("insideLabelFont");
        FontMetrics fontMetrics = this.getFontMetrics(font);
        graphics.setFont(font);
        int n8 = this.getSampleCount();
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n8; ++n) {
                ChartSample chartSample = this.chart.getSample(n2, n);
                if (chartSample == null || chartSample.value == null || chartSample.value.isNaN()) continue;
                String string = this.chart.constructLabel(n2, n, 0, true, null);
                this.a(graphics, string, n2, n, font, fontMetrics);
            }
        }
        n2 = bl4 && n7 == 1 || bl2 && n5 == 1 || bl3 && n6 == 1 || bl && n4 == 1 ? 1 : 0;
        int n9 = n = bl4 && n7 == 5 || bl2 && n5 == 5 || bl3 && n6 == 5 || bl && n4 == 5 ? 1 : 0;
        if (n2 != 0 && n == 0) {
            this.do(graphics);
        }
        if (n != 0) {
            this.if(graphics);
        }
    }

    private void a(Graphics graphics, String string, int n, int n2, Font font, FontMetrics fontMetrics) {
        Color color;
        int n3 = this.getSeriesCount();
        Point point = this.h[n3 > 1 ? n2 : 0];
        if (point == null) {
            return;
        }
        double d = this.f[n][n2];
        double d2 = this.l[n][n2];
        double d3 = -((d + d2) / 2.0);
        double d4 = 1.0;
        int n4 = this.n[n3 == 1 ? 0 : n2];
        double d5 = 0.0;
        if (this.chart.isSelected(n, n2) && d - d2 < 360.0 && this.chart.getSelectionStyle() == 2) {
            d5 = (double)n4 * this.chart.getDetachedDistance() / 2.0;
        }
        if (this.display3dOn) {
            int n5 = (int)Math.round((double)n4 * ((double)this.chart.getAngle() / 90.0));
            d4 = (double)(n4 - n5) / (double)n4;
        }
        double d6 = d3 * (Math.PI / 180);
        int n6 = point.x + (int)Math.round(Math.cos(d6) * (double)n4 * 0.35 + Math.cos(d6) * d5);
        int n7 = point.y + (int)Math.round((Math.sin(d6) * (double)n4 * 0.35 + Math.sin(d6) * d5) * d4);
        Dimension dimension = this.getLabelSize(string, fontMetrics);
        n6 -= dimension.width / 2;
        n7 -= dimension.height / 2 - fontMetrics.getAscent();
        int n8 = 0;
        if (n3 > 1) {
            n8 = n2;
        }
        if ((color = this.chart.getInsideLabelColor(n8)) == null) {
            color = this.chart.getInsideLabelColor(-1);
        }
        if (color == null) {
            Color color2 = this.chart.getSampleColor(n3 == 1 ? n2 : n);
            color = (color2.getRed() + color2.getGreen() + color2.getBlue()) / 3 > 110 ? Color.black : Color.white;
        }
        graphics.setColor(color);
        this.paintLabel(graphics, string, n6, n7, dimension, this.chart.getMultilineLabelAlignment(), 0, false);
    }

    private void do(Graphics graphics) {
        int n;
        Font font = this.getFont("outsideLabelFont");
        FontMetrics fontMetrics = this.getFontMetrics(font);
        graphics.setFont(font);
        int n2 = this.getSampleCount();
        int n3 = this.getSeriesCount();
        Rectangle[] rectangleArray = new Rectangle[n2];
        Rectangle[] rectangleArray2 = new Rectangle[n2];
        for (n = 0; n < n2; ++n) {
            rectangleArray2[n] = new Rectangle(-10, -10, -10, -10);
        }
        for (n = 0; n < n3; ++n) {
            for (int i = 0; i < n2; ++i) {
                boolean bl;
                Color color;
                ChartSample chartSample = this.chart.getSample(n, i);
                if (chartSample == null || chartSample.value == null || chartSample.value.isNaN()) continue;
                Point point = this.h[n3 > 1 ? i : 0];
                if (point == null) {
                    return;
                }
                String string = this.chart.constructLabel(n, i, 1, true, null);
                double d = this.f[n][i];
                double d2 = this.l[n][i];
                double d3 = -((d + d2) / 2.0);
                double d4 = 1.0;
                int n4 = this.n[n3 == 1 ? 0 : i];
                if (this.display3dOn) {
                    int n5 = (int)Math.round((double)n4 * ((double)this.chart.getAngle() / 90.0));
                    d4 = (double)(n4 - n5) / (double)n4;
                }
                double d5 = 0.0;
                if (this.chart.isSelected(n, i) && d - d2 < 360.0 && this.chart.getSelectionStyle() == 2) {
                    d5 = (double)n4 * this.chart.getDetachedDistance() / 2.0;
                }
                d3 = (d3 + 360.0) % 360.0;
                double d6 = d3 * (Math.PI / 180);
                Dimension dimension = this.getLabelSize(string, fontMetrics);
                int n6 = point.x + (int)Math.round(Math.cos(d6) * (double)n4 * 0.5 + Math.cos(d6) * d5);
                int n7 = point.y + (int)Math.round((Math.sin(d6) * (double)n4 * 0.5 + Math.sin(d6) * d5) * d4);
                n7 -= dimension.height / 2;
                double d7 = Math.max((double)n4 * 0.05, 10.0);
                if (d3 > 292.5 && d3 <= 337.5) {
                    n6 = (int)((double)n6 + d7 * Math.cos(d6));
                    n7 = (int)((double)n7 + (d7 * Math.sin(d6) - (double)(dimension.height / 2)));
                } else if (d3 > 247.5 && d3 <= 292.5) {
                    n6 = (int)((double)n6 + (d7 * Math.cos(d6) - (double)(dimension.width / 2)));
                    n7 = (int)((double)n7 + (d7 * Math.sin(d6) - (double)(dimension.height / 2)));
                } else if (d3 > 202.5 && d3 <= 247.5) {
                    n6 = (int)((double)n6 + (d7 * Math.cos(d6) - (double)dimension.width));
                    n7 = (int)((double)n7 + (d7 * Math.sin(d6) - (double)(dimension.height / 2)));
                } else if (d3 > 157.5 && d3 <= 202.5) {
                    n6 = (int)((double)n6 + (d7 * Math.cos(d6) - (double)dimension.width));
                    n7 = (int)((double)n7 + d7 * Math.sin(d6));
                } else if (d3 > 112.5 && d3 <= 157.5) {
                    n6 = (int)((double)n6 + (d7 * Math.cos(d6) - (double)dimension.width));
                    n7 = (int)((double)n7 + (d7 * Math.sin(d6) + (double)(dimension.height / 2)));
                } else if (d3 > 67.5 && d3 <= 112.5) {
                    n6 = (int)((double)n6 + (d7 * Math.cos(d6) - (double)(dimension.width / 2)));
                    n7 = (int)((double)n7 + (d7 * Math.sin(d6) + (double)(dimension.height / 2)));
                } else if (d3 > 22.5 && d3 <= 67.5) {
                    n6 = (int)((double)n6 + d7 * Math.cos(d6));
                    n7 = (int)((double)n7 + (d7 * Math.sin(d6) + (double)(dimension.height / 2)));
                } else {
                    n6 = (int)((double)n6 + d7 * Math.cos(d6));
                    n7 = (int)((double)n7 + d7 * Math.sin(d6));
                }
                if (this.display3dOn && d3 > 7.0 && d3 < 173.0) {
                    n7 = (int)((long)n7 + Math.round((double)((float)n4 * this.chart.getDepth()) * ((double)this.chart.getAngle() / 90.0)));
                }
                int n8 = 0;
                if (n3 > 1) {
                    n8 = i;
                }
                if ((color = this.chart.getOutsideLabelColor(n8)) == null) {
                    color = this.chart.getOutsideLabelColor(-1);
                }
                if (color == null) {
                    color = this.chart.getForeground();
                }
                graphics.setColor(color);
                Rectangle rectangle = new Rectangle(n6, n7, dimension.width, dimension.height);
                Rectangle rectangle2 = n3 == 1 ? rectangle.intersection(rectangleArray2[0]) : rectangle.intersection(rectangleArray2[i]);
                boolean bl2 = bl = rectangle2.width <= 0 || rectangle2.height <= 0;
                if (!(n3 == 0 && i == 0 || n3 > 0 && n == 0)) {
                    rectangle2 = n3 == 1 ? rectangle.intersection(rectangleArray[0]) : rectangle.intersection(rectangleArray[i]);
                    bl &= rectangle2.width <= 0 || rectangle2.height <= 0;
                }
                if (bl) {
                    this.paintLabel(graphics, string, n6, n7 + fontMetrics.getAscent(), dimension, this.chart.getMultilineLabelAlignment(), 0, false);
                    if (n3 == 1) {
                        rectangleArray2[0] = rectangle;
                    } else {
                        rectangleArray2[i] = rectangle;
                    }
                }
                if (n3 == 1 && i == 0) {
                    rectangleArray[0] = rectangle;
                    continue;
                }
                if (n3 <= 1 || n != 0) continue;
                rectangleArray[i] = rectangle;
            }
        }
    }

    private void if(Graphics graphics) {
        boolean bl;
        boolean bl2 = bl = this.chart.isPercentLabelsOn() && this.chart.getPercentLabelStyle() == 5 || this.chart.isSampleLabelsOn() && this.chart.getSampleLabelStyle() == 5 || this.chart.isSeriesLabelsOn() && this.chart.getSeriesLabelStyle() == 5 || this.chart.isValueLabelsOn() && this.chart.getValueLabelStyle() == 5;
        if (!bl) {
            return;
        }
        Font font = this.getFont("pointingLabelFont");
        FontMetrics fontMetrics = this.getFontMetrics(font);
        graphics.setFont(font);
        int n = this.getSeriesCount();
        int n2 = this.getSampleCount();
        int n3 = n > 1 ? n2 : 1;
        int n4 = n > 1 ? n : n2;
        for (int i = 0; i < n3; ++i) {
            int n5;
            double d;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            int n14;
            Object object;
            int n15;
            Point point = this.h[i];
            if (point == null) continue;
            int n16 = n4;
            String[] stringArray = new String[n16];
            Dimension[] dimensionArray = new Dimension[n16];
            Point[] pointArray = new Point[n16];
            Point[] pointArray2 = new Point[n16];
            double[] dArray = new double[n16];
            for (n15 = 0; n15 < n4; ++n15) {
                int n17;
                double d2;
                double d3;
                double d4;
                if (this.getSeriesCount() == 1) {
                    d4 = this.f[0][n15];
                    d3 = this.l[0][n15];
                } else {
                    d4 = this.f[n15][i];
                    d3 = this.l[n15][i];
                }
                dArray[n15] = d2 = -((d4 + d3) / 2.0);
                object = n3 == 1 ? this.chart.getSample(0, n15) : this.chart.getSample(n15, i);
                if (object == null || object.value == null || object.value.isNaN()) continue;
                stringArray[n15] = n3 == 1 ? this.chart.constructLabel(0, n15, 5, true, null) : this.chart.constructLabel(n15, i, 5, true, null);
                double d5 = 1.0;
                int n18 = this.n[n3 == 1 ? 0 : i];
                if (this.display3dOn) {
                    n17 = (int)Math.round((double)n18 * ((double)this.chart.getAngle() / 90.0));
                    d5 = (double)(n18 - n17) / (double)n18;
                }
                n17 = n == 1 ? this.chart.isSelected(0, n15) : this.chart.isSelected(n15, i);
                double d6 = 0.0;
                if (n17 != 0 && d4 - d3 < 360.0 && this.chart.getSelectionStyle() == 2) {
                    d6 = (double)n18 * this.chart.getDetachedDistance() / 2.0;
                }
                double d7 = (d2 += d2 < 0.0 ? 360.0 : 0.0) * (Math.PI / 180);
                dimensionArray[n15] = this.getLabelSize(stringArray[n15], fontMetrics);
                double d8 = (double)point.x + ((double)n18 / 2.0 + d6) * Math.cos(d7);
                double d9 = (double)point.y + ((double)(n18 + 2) / 2.0 + d6) * Math.sin(d7) * d5;
                n14 = dArray[n15] >= 90.0 && dArray[n15] < 270.0 || dArray[n15] >= 450.0 && dArray[n15] < 630.0 ? point.x - n18 / 2 - this.k - dimensionArray[n15].width : point.x + n18 / 2 + this.k;
                n13 = (int)(d9 - (double)dimensionArray[n15].height / 2.0 + (double)fontMetrics.getAscent());
                pointArray2[n15] = new Point((int)d8, (int)d9);
                pointArray[n15] = new Point(n14, n13);
            }
            n15 = 0;
            for (n12 = n16 - 1; n12 >= 0; --n12) {
                if (stringArray[n12] == null || !((dArray[n12] + 90.0) % 360.0 < (dArray[n15] + 90.0) % 360.0)) continue;
                n15 = n12;
            }
            n12 = 0;
            for (int j = 0; j < n16; ++j) {
                if (stringArray[j] == null || !((dArray[j] + 90.0) % 360.0 > (dArray[n12] + 90.0) % 360.0)) continue;
                n12 = j;
            }
            String[] stringArray2 = new String[n16];
            String[] stringArray3 = new String[n16];
            Dimension[] dimensionArray2 = new Dimension[n16];
            Dimension[] dimensionArray3 = new Dimension[n16];
            Point[] pointArray3 = new Point[n16];
            object = new Point[n16];
            Point[] pointArray4 = new Point[n16];
            Point[] pointArray5 = new Point[n16];
            double[] dArray2 = new double[n16];
            double[] dArray3 = new double[n16];
            int n19 = 0;
            int n20 = 0;
            for (n11 = 0; n11 < n16; ++n11) {
                if (!(dArray[n15] >= -90.0 && dArray[n15] < 90.0) && (!(dArray[n15] >= 270.0) || !(dArray[n15] < 450.0))) continue;
                if (stringArray[n15] != null && !stringArray[n15].equals("")) {
                    stringArray2[n19] = stringArray[n15];
                    pointArray3[n19] = pointArray[n15];
                    dimensionArray2[n19] = dimensionArray[n15];
                    pointArray4[n19] = pointArray2[n15];
                    dArray2[n19] = dArray[n15];
                    ++n19;
                }
                n15 = n15 == n16 - 1 ? 0 : n15 + 1;
            }
            for (n11 = 0; n11 < n16; ++n11) {
                if (!(dArray[n12] >= 90.0 && dArray[n12] < 270.0) && (!(dArray[n12] >= 450.0) || !(dArray[n12] < 630.0))) continue;
                if (stringArray[n12] != null && !stringArray[n12].equals("")) {
                    stringArray3[n20] = stringArray[n12];
                    object[n20] = pointArray[n12];
                    dimensionArray3[n20] = dimensionArray[n12];
                    pointArray5[n20] = pointArray2[n12];
                    dArray3[n20] = dArray[n12];
                    ++n20;
                }
                n12 = n12 == 0 ? n16 - 1 : n12 - 1;
            }
            this.a(i, pointArray3, dimensionArray2, pointArray4, point, n19, fontMetrics);
            this.a(i, (Point[])object, dimensionArray3, pointArray5, point, n20, fontMetrics);
            Color color = this.chart.getPointingLabelColor(i);
            if (color == null) {
                color = this.chart.getPointingLabelColor(-1);
            }
            if (color == null) {
                color = this.chart.getForeground();
            }
            graphics.setColor(color);
            for (n10 = 0; n10 < n19; ++n10) {
                if (pointArray3[n10] == null) continue;
                int n21 = n9 = pointArray4[n10].x + 2;
                n8 = n9;
                n6 = n7 = pointArray4[n10].y + 1;
                int n22 = pointArray3[n10].x - 2;
                n14 = n13 = pointArray3[n10].y - fontMetrics.getAscent() + dimensionArray2[n10].height / 2 + 1;
                d = dArray2[n10] * (Math.PI / 180);
                if (n7 > point.y && n14 > n7 || n7 <= point.y && n14 < n7) {
                    n5 = (int)((double)(n14 - n7) / Math.tan(d));
                    n5 = Math.min(n5, n22 - n9 - this.k / 2);
                    n21 = n9 + Math.max(n5, 0);
                    n6 = n14;
                    if (n22 > n9) {
                        graphics.drawLine(n22, n14, n21, n6);
                        graphics.drawLine(n21, n6, n9, n7);
                    }
                } else {
                    n5 = (this.n[i] / 2 - (n9 - point.x)) / 3;
                    n8 = Math.max(n9, n22 - this.k / 2);
                    n21 = n9 + Math.max(0, n5);
                    if (n22 > n9) {
                        graphics.drawLine(n22, n14, n8, n13);
                        graphics.drawLine(n8, n13, n21, n6);
                        graphics.drawLine(n21, n6, n9, n7);
                    }
                }
                this.paintLabel(graphics, stringArray2[n10], pointArray3[n10].x, pointArray3[n10].y, dimensionArray2[n10], 0, 0, false);
            }
            for (n10 = 0; n10 < n20; ++n10) {
                if (object[n10] == null) continue;
                int n23 = object[n10].x + dimensionArray3[n10].width;
                int n24 = n9 = pointArray5[n10].x;
                n8 = n9;
                n14 = n13 = object[n10].y - fontMetrics.getAscent() + dimensionArray3[n10].height / 2 + 1;
                n6 = n7 = pointArray5[n10].y + 1;
                d = dArray3[n10] * (Math.PI / 180);
                if (n7 > point.y && n14 > n7 || n7 <= point.y && n14 < n7) {
                    n5 = (int)((double)(n14 - n7) / Math.tan(d));
                    n5 = Math.max(n5, n23 - n9 + this.k / 2);
                    n24 = n9 + Math.min(n5, 0);
                    n6 = n14;
                    if (n9 > n23) {
                        graphics.drawLine(n23, n14, n24, n6);
                        graphics.drawLine(n24, n6, n9, n7);
                    }
                } else {
                    n5 = (this.n[i] / 2 - (point.x - n9)) / 3;
                    n8 = Math.min(n9, n23 + this.k / 2);
                    n24 = n9 - Math.max(0, n5);
                    if (n9 > n23) {
                        graphics.drawLine(n23, n14, n8, n13);
                        graphics.drawLine(n8, n13, n24, n6);
                        graphics.drawLine(n24, n6, n9, n7);
                    }
                }
                this.paintLabel(graphics, stringArray3[n10], object[n10].x, object[n10].y, dimensionArray3[n10], 0, 0, false);
            }
        }
    }

    private void a(int n, Point[] pointArray, Dimension[] dimensionArray, Point[] pointArray2, Point point, int n2, FontMetrics fontMetrics) {
        int n3;
        int n4;
        if (pointArray == null || dimensionArray == null || pointArray2 == null || n2 < 1) {
            return;
        }
        pointArray[0].y = Math.max(pointArray[0].y, this.s[n].y + fontMetrics.getAscent());
        pointArray[n2 - 1].y = Math.min(pointArray[n2 - 1].y, this.s[n].y + this.s[n].height - dimensionArray[n2 - 1].height + fontMetrics.getAscent());
        int n5 = dimensionArray[0].height;
        for (n4 = 1; n4 < n2; ++n4) {
            n5 += dimensionArray[n4].height + 10;
        }
        n4 = this.n[n];
        if (this.display3dOn) {
            n3 = (int)Math.round((double)((float)this.n[n] * this.chart.getDepth()) * ((double)this.chart.getAngle() / 90.0));
            n4 = (int)Math.round((double)this.n[n] * this.g + (double)(n3 / 2));
        }
        n3 = point.y - n4 / 2;
        if (n5 <= n4) {
            int n6 = pointArray[0].y - (n3 + fontMetrics.getAscent());
            block1: for (int i = 1; i < n2; ++i) {
                int n7;
                int n8 = pointArray[i].y - (pointArray[i - 1].y + dimensionArray[i - 1].height) - 10;
                if (n8 > 0) {
                    n6 += n8;
                    continue;
                }
                if (n8 >= 0) continue;
                if (-n8 < n6) {
                    n6 += n8;
                    for (n7 = i; n7 > 0; --n7) {
                        n8 = n7 == 1 ? (n8 += pointArray[n7 - 1].y - (n3 + fontMetrics.getAscent())) : (n8 += pointArray[n7 - 1].y - (pointArray[n7 - 2].y + dimensionArray[n7 - 2].height) - 10);
                        pointArray[n7 - 1].y = pointArray[n7].y - dimensionArray[n7 - 1].height - 10;
                        if (n8 >= 0) continue block1;
                    }
                    continue;
                }
                for (n7 = 1; n7 <= i; ++n7) {
                    pointArray[n7].y = pointArray[n7 - 1].y + dimensionArray[n7 - 1].height + 10;
                }
                n6 = 0;
            }
        } else {
            int n9;
            int n10 = n2;
            while (n5 > this.s[n].height) {
                n9 = n10 / 2;
                if (n10 % 2 == 1) {
                    n9 = n2 - n9;
                }
                pointArray[n2 - n9] = null;
                n5 -= dimensionArray[n2 - n9].height + 10;
                --n10;
            }
            n9 = (this.s[n].height - n5) / 2;
            int n11 = this.s[n].y + fontMetrics.getAscent() + n9;
            for (int i = 0; i < n2; ++i) {
                if (pointArray[i] == null) continue;
                pointArray[i].y = n11;
                n11 += dimensionArray[i].height + 10;
            }
        }
    }

    public ChartSample checkSelection(Point point) {
        int n;
        if (point == null) {
            return null;
        }
        this.case = -1;
        this.e = -1;
        ChartSample chartSample = super.checkSelection(point);
        int n2 = this.getSeriesCount();
        int n3 = this.getSampleCount();
        if (chartSample == null && (n = this.legendRenderer.getSelectedElement(point, this.legend)) > -1) {
            if (n2 > 1 || this.chart.chartType.equals("line") || this.chart.u) {
                chartSample = new ChartSample(-1);
                chartSample.setSeries(n);
            } else if (n < n3) {
                chartSample = this.chart.getSample(0, n);
                if (chartSample != null) {
                    chartSample.setSeries(-1);
                }
            } else if (n >= n3) {
                n = -1;
            } else {
                chartSample = this.chart.getSample(0, n);
            }
        }
        if (chartSample == null) {
            int n4;
            n = -1;
            for (n4 = 0; this.q != null && n4 < this.q.length; ++n4) {
                Rectangle rectangle = this.q[n4];
                if (rectangle == null || !rectangle.contains(point)) continue;
                n = n4;
                break;
            }
            if (n >= 0) {
                double d;
                int n5;
                double d2;
                double d3;
                point.x -= this.h[n].x;
                point.y -= this.h[n].y;
                if (this.display3dOn) {
                    n4 = this.n[n];
                    int n6 = (int)Math.round((double)n4 * ((double)this.chart.getAngle() / 90.0));
                    d3 = (double)n4 / (double)(n4 - n6);
                    point.y = (int)Math.round((double)point.y * d3);
                }
                if ((d3 = -((d2 = Math.atan2(point.y, point.x)) * 57.29577951308232)) > 90.0 && d3 <= 180.0) {
                    d3 = -360.0 + d3;
                }
                double d4 = 0.0;
                double d5 = 0.0;
                double d6 = 0.0;
                if (n2 == 1) {
                    for (n5 = 0; n5 < n3; ++n5) {
                        d6 = this.f[0][n5];
                        d5 = this.l[0][n5];
                        if (!(d3 <= d6 && d3 > d5 || d3 - 360.0 <= d6 && d3 - 360.0 > d5) && (!(d3 + 360.0 <= d6) || !(d3 + 360.0 > d5))) continue;
                        chartSample = this.chart.getSample(0, n5);
                        d4 = (d6 + d5) / 2.0;
                        break;
                    }
                } else {
                    for (n5 = 0; n5 < n2; ++n5) {
                        d6 = this.f[n5][n];
                        d5 = this.l[n5][n];
                        if (!(d3 <= d6 && d3 > d5 || d3 - 360.0 <= d6 && d3 - 360.0 > d5) && (!(d3 + 360.0 <= d6) || !(d3 + 360.0 > d5))) continue;
                        chartSample = this.chart.getSample(n5, n);
                        d4 = (d6 + d5) / 2.0;
                        break;
                    }
                }
                if (chartSample != null && chartSample.isSelected() && this.chart.getSelectionStyle() == 2) {
                    double d7 = d4 * (Math.PI / 180);
                    double d8 = this.chart.getDetachedDistance();
                    point.x = (int)((double)point.x - Math.cos(d7) * (double)this.n[n] * 0.5 * d8);
                    point.y = (int)((double)point.y + Math.sin(d7) * (double)this.n[n] * 0.5 * d8);
                    d2 = Math.atan2(point.y, point.x);
                    d3 = -(d2 * 57.29577951308232);
                    if (d3 > 90.0 && d3 <= 180.0) {
                        d3 = -360.0 + d3;
                    }
                    if (!(d3 <= d6 && d3 > d5 || d5 > d6 && (d3 <= d6 || d3 >= d5))) {
                        return null;
                    }
                }
                if ((d = Math.sqrt(point.x * point.x + point.y * point.y)) > (double)(this.n[n] / 2)) {
                    return null;
                }
            }
        }
        if (chartSample != null) {
            this.e = chartSample.getIndex();
            this.case = chartSample.getSeries();
            this.d = point;
        } else {
            this.e = -1;
            this.case = -1;
        }
        return chartSample;
    }

    protected void handlePieRotation(AWTEvent aWTEvent) {
        int n = this.getSeriesCount();
        switch (aWTEvent.getID()) {
            case 501: {
                ChartSample chartSample = this.checkSelection(((MouseEvent)aWTEvent).getPoint());
                this.o = 0;
                if (n != 1 && chartSample != null) {
                    this.o = chartSample.getIndex();
                }
                if (this.o != -1) {
                    int n2 = ((MouseEvent)aWTEvent).getX();
                    int n3 = ((MouseEvent)aWTEvent).getY();
                    double d = Math.atan2(n3 -= this.h[this.o].y, n2 -= this.h[this.o].x);
                    this.t = -(d * 57.29577951308232);
                    if (chartSample == null) {
                        this.t = Double.NaN;
                    }
                }
                this.m = System.currentTimeMillis();
                break;
            }
            case 506: {
                double d;
                double d2;
                double d3;
                int n4 = ((MouseEvent)aWTEvent).getX();
                int n5 = ((MouseEvent)aWTEvent).getY();
                if (new Double(this.t).isNaN()) break;
                if (this.o != -1 && Math.abs(d3 = (d2 = -((d = Math.atan2(n5 -= this.h[this.o].y, n4 -= this.h[this.o].x)) * 57.29577951308232)) - this.t) >= 2.0) {
                    int n6 = this.o;
                    this.chart.aE[n6] = (int)((double)this.chart.aE[n6] + (d3 - d3 % 2.0));
                    int n7 = this.o;
                    this.chart.aE[n7] = this.chart.aE[n7] - 360;
                    int n8 = this.o;
                    this.chart.aE[n8] = this.chart.aE[n8] % 360;
                    this.t = d2;
                }
                if (System.currentTimeMillis() - this.m > 150L) {
                    this.chart.o = false;
                }
                this.chart.needRender = true;
                this.chart.repaint();
            }
        }
    }

    protected boolean isAnyFloatingLabelsOn(int n) {
        int n2 = this.chart.getValueLabelStyle();
        int n3 = this.chart.getSampleLabelStyle();
        int n4 = this.chart.getSeriesLabelStyle();
        int n5 = this.chart.getPercentLabelStyle();
        boolean bl = this.chart.isValueLabelsOn(n);
        boolean bl2 = this.chart.isSampleLabelsOn();
        boolean bl3 = this.chart.isSeriesLabelsOn();
        boolean bl4 = this.chart.isPercentLabelsOn();
        boolean bl5 = bl && n2 == 3;
        bl5 |= bl2 && (n3 == 3 || n3 == 4);
        bl5 |= bl3 && n4 == 3;
        return bl5 |= bl4 && n5 == 3;
    }
}

