/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.ws;

import com.vmware.vim25.ws.Argument;
import com.vmware.vim25.ws.XmlGen;
import com.vmware.vim25.ws.XmlGenDom;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public final class WSClient {
    private static final String SOAP_ACTION_HEADER = "SOAPAction";
    private static final String SOAP_ACTION_V40 = "urn:vim25/4.0";
    private static final String SOAP_ACTION_V41 = "urn:vim25/4.1";
    private static final String SOAP_ACTION_V50 = "urn:vim25/5.0";
    private static final String SOAP_ACTION_V51 = "urn:vim25/5.1";
    private static final String SOAP_ACTION_V55 = "urn:vim25/5.5";
    private URL baseUrl = null;
    private String cookie = null;
    private String vimNameSpace = null;
    private String soapAction = null;
    private int connectTimeout = 0;
    private int readTimeout = 0;
    XmlGen xmlGen = new XmlGenDom();

    public WSClient(String serverUrl) throws MalformedURLException {
        this(serverUrl, true);
    }

    public WSClient(String serverUrl, boolean ignoreCert) throws MalformedURLException {
        if (serverUrl.endsWith("/")) {
            serverUrl = serverUrl.substring(0, serverUrl.length() - 1);
        }
        this.baseUrl = new URL(serverUrl);
        if (ignoreCert) {
            try {
                WSClient.trustAllHttpsCertificates();
                HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String urlHostName, SSLSession session) {
                        return true;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Object invoke(String methodName, Argument[] paras, String returnType) throws RemoteException {
        String soapMsg = XmlGen.toXML(methodName, paras, this.vimNameSpace);
        InputStream is = null;
        try {
            is = this.post(soapMsg);
            Object object = this.xmlGen.fromXML(returnType, is);
            return object;
        }
        catch (Exception e1) {
            throw new RemoteException("VI SDK invoke exception:" + e1);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public StringBuffer invokeAsString(String methodName, Argument[] paras) throws RemoteException {
        String soapMsg = XmlGen.toXML(methodName, paras, this.vimNameSpace);
        try {
            InputStream is = this.post(soapMsg);
            return this.readStream(is);
        }
        catch (Exception e) {
            throw new RemoteException("VI SDK invoke exception:" + e);
        }
    }

    public InputStream post(String soapMsg) throws IOException {
        InputStream is;
        HttpURLConnection postCon = (HttpURLConnection)this.baseUrl.openConnection();
        if (this.connectTimeout > 0) {
            postCon.setConnectTimeout(this.connectTimeout);
        }
        if (this.readTimeout > 0) {
            postCon.setReadTimeout(this.readTimeout);
        }
        try {
            postCon.setRequestMethod("POST");
        }
        catch (ProtocolException e) {
            e.printStackTrace();
        }
        postCon.setDoOutput(true);
        postCon.setDoInput(true);
        postCon.setRequestProperty(SOAP_ACTION_HEADER, this.soapAction);
        postCon.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
        if (this.cookie != null) {
            postCon.setRequestProperty("Cookie", this.cookie);
        }
        OutputStream os = postCon.getOutputStream();
        OutputStreamWriter out = new OutputStreamWriter(os, "UTF8");
        out.write(soapMsg);
        out.close();
        try {
            is = postCon.getInputStream();
        }
        catch (IOException ioe) {
            is = postCon.getErrorStream();
        }
        if (this.cookie == null) {
            this.cookie = postCon.getHeaderField("Set-Cookie");
        }
        return is;
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(URL baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getCookie() {
        return this.cookie;
    }

    public void setCookie(String cookie) {
        this.cookie = cookie;
    }

    public String getVimNameSpace() {
        return this.vimNameSpace;
    }

    public void setVimNameSpace(String vimNameSpace) {
        this.vimNameSpace = vimNameSpace;
    }

    public void setConnectTimeout(int timeoutMilliSec) {
        this.connectTimeout = timeoutMilliSec;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setReadTimeout(int timeoutMilliSec) {
        this.readTimeout = timeoutMilliSec;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setSoapActionOnApiVersion(String apiVersion) {
        this.soapAction = "4.0".equals(apiVersion) ? SOAP_ACTION_V40 : ("4.1".equals(apiVersion) ? SOAP_ACTION_V41 : ("5.0".equals(apiVersion) ? SOAP_ACTION_V50 : ("5.1".equals(apiVersion) ? SOAP_ACTION_V51 : ("5.5".equals(apiVersion) ? SOAP_ACTION_V55 : SOAP_ACTION_V55))));
    }

    private StringBuffer readStream(InputStream is) throws IOException {
        String lineStr;
        StringBuffer sb = new StringBuffer();
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        while ((lineStr = in.readLine()) != null) {
            sb.append(lineStr);
        }
        in.close();
        return sb;
    }

    private static void trustAllHttpsCertificates() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[]{new TrustAllManager()};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, null);
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
    }

    private static class TrustAllManager
    implements X509TrustManager {
        private TrustAllManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }
    }
}

