/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.utils.Debug;
import java.io.IOException;
import java.io.InputStream;

public class LimiterInputStream
extends InputStream {
    public static final int NO_LIMIT = -1;
    private int _lengthLimit;
    private InputStream _in;

    public LimiterInputStream(InputStream stream, int length) throws IOException {
        Debug.println(this, "CTOR " + stream + " length = " + length);
        this._lengthLimit = length;
        this._in = stream;
    }

    public int available() throws IOException {
        int avail = this._in.available();
        if (this._lengthLimit != -1 && avail > this._lengthLimit) {
            return this._lengthLimit;
        }
        return avail;
    }

    public void close() throws IOException {
        this._lengthLimit = 0;
        this._in.close();
    }

    public int read() throws IOException {
        Debug.println(this, "read() remaining = " + this._lengthLimit);
        if (this._lengthLimit == 0) {
            return -1;
        }
        if (this._lengthLimit != -1) {
            --this._lengthLimit;
        }
        return this._in.read();
    }

    public int read(byte[] buf) throws IOException {
        Debug.println(this, "read(buf[]) remaining = " + this._lengthLimit);
        return this.read(buf, 0, buf.length);
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        Debug.println(this, "read(buf[],int,int) remaining = " + this._lengthLimit);
        int toRead = length;
        if (this._lengthLimit != -1 && toRead > this._lengthLimit) {
            toRead = this._lengthLimit;
        }
        Debug.println(this, "read into buffer " + toRead);
        int len = this._in.read(buf, offset, toRead);
        if (this._lengthLimit != -1) {
            this._lengthLimit -= len;
        }
        return len;
    }

    public long skip(long n) throws IOException {
        long toSkip = n;
        if (this._lengthLimit != -1 && toSkip > (long)this._lengthLimit) {
            toSkip = this._lengthLimit;
        }
        long skipped = this._in.skip(toSkip);
        if (this._lengthLimit != -1) {
            this._lengthLimit = (int)((long)this._lengthLimit - skipped);
        }
        return skipped;
    }
}

