/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.SybDatabaseMetaData;
import com.sybase.jdbc2.jdbc.SybDriver;
import com.sybase.jdbc2.utils.Debug;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class LoaderConnection {
    protected static final int MAX_BUFFER_SIZE = 1000;
    private Driver _driver;
    private Connection _connection;
    private String _url;
    private Properties _properties;
    private boolean _keepAlive;

    public LoaderConnection(String url, Properties props) {
        this(new SybDriver(), url, props);
    }

    public LoaderConnection(Driver driver, String url, Properties props) {
        this._url = url;
        this.setProps(props);
        this._connection = null;
        this._keepAlive = true;
        this._driver = driver;
    }

    protected Enumeration allClassesInJar(String jarName) throws SQLException {
        Enumeration answer;
        this.open();
        SybDatabaseMetaData md = (SybDatabaseMetaData)this._connection.getMetaData();
        if (md.canReturnJars()) {
            Debug.println(this, "ASE");
            answer = new JarDataEnumeration(jarName);
        } else {
            Debug.println(this, "ASA");
            answer = new ClassDataEnumeration(jarName);
        }
        this.close();
        return answer;
    }

    protected void close() throws SQLException {
        if (!this._keepAlive) {
            this.kill();
        }
    }

    protected byte[] fetchClass(String className) throws SQLException {
        this.open();
        byte[] answer = null;
        SybDatabaseMetaData md = (SybDatabaseMetaData)this._connection.getMetaData();
        ResultSet rs = md.getClassForName(className);
        if (!rs.next()) {
            throw new SQLException("No results returned!");
        }
        answer = rs.getBytes(1);
        rs.close();
        this.close();
        return answer;
    }

    protected byte[] fetchClassFromJar(String className, String jarName) throws SQLException {
        this.open();
        byte[] answer = null;
        SybDatabaseMetaData md = (SybDatabaseMetaData)this._connection.getMetaData();
        ResultSet rs = md.getJarForClass(className);
        if (rs.next()) {
            InputStream stream = rs.getBinaryStream(1);
            try {
                JarInputStream jarStream = new JarInputStream(stream);
                ClassData jarBytes = this.readJarBytes(jarStream, className);
                if (jarBytes != null) {
                    answer = jarBytes._data;
                }
                jarStream.close();
            }
            catch (IOException iOException) {}
            if (rs.next()) {
                throw new SQLException("More than one row was returned for class " + className + ", jar " + jarName);
            }
        }
        rs.close();
        this.close();
        return answer;
    }

    protected Connection getConnection() {
        return this._connection;
    }

    protected boolean getKeepAlive() {
        return this._keepAlive;
    }

    protected void kill() throws SQLException {
        this._connection.close();
        this._connection = null;
    }

    protected void open() throws SQLException {
        if (this._connection == null) {
            this._connection = this._driver.connect(this._url, this._properties);
        }
    }

    protected byte[] readBytes(InputStream stream, int bufferSize) throws IOException {
        int i;
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[bufferSize];
        while ((i = stream.read(buffer, 0, bufferSize)) != -1) {
            outStream.write(buffer, 0, i);
        }
        byte[] answer = outStream.toByteArray();
        outStream.close();
        return answer;
    }

    protected ClassData readJarBytes(JarInputStream stream, String className) throws IOException {
        ClassData answer;
        block2: {
            String entryName;
            JarEntry entry;
            answer = null;
            Debug.println(this, "Reading jar bytes for " + className);
            while (true) {
                entry = stream.getNextJarEntry();
                Debug.println(this, "entry = " + entry);
                if (entry == null) break block2;
                if (entry.isDirectory()) continue;
                Debug.println(this, "Checking entry " + entry.getName());
                entryName = entry.getName();
                if (className == null || entryName.equals(className.concat(".class"))) break;
            }
            Debug.println(this, "Found it!");
            Debug.println(this, "Name = " + entry.getName());
            Debug.println(this, "Compressed size = " + entry.getCompressedSize());
            Debug.println(this, "Method = " + entry.getMethod());
            Debug.println(this, "Size = " + entry.getSize());
            int bufferSize = 1000;
            if (entry.getSize() > 0L && entry.getSize() < 1000L) {
                bufferSize = (int)entry.getSize();
            }
            answer = new ClassData();
            answer._data = this.readBytes(stream, bufferSize);
            answer._name = entryName.substring(0, entryName.lastIndexOf(".class"));
            stream.closeEntry();
        }
        return answer;
    }

    public void setKeepAlive(boolean flag) {
        this._keepAlive = flag;
    }

    private void setProps(Properties props) {
        this._properties = (Properties)((Hashtable)props).clone();
        Enumeration e = ((Hashtable)this._properties).keys();
        while (e.hasMoreElements()) {
            String propKey = (String)e.nextElement();
            if (!propKey.equalsIgnoreCase("class_loader") && !propKey.equalsIgnoreCase("preload_jars")) continue;
            ((Hashtable)this._properties).remove(propKey);
        }
    }

    protected class JarDataEnumeration
    implements Enumeration {
        ResultSet _rs;
        private JarInputStream _jarStream;
        private ClassData _nextElement = null;

        protected JarDataEnumeration(String jarName) throws SQLException {
            SybDatabaseMetaData md = (SybDatabaseMetaData)LoaderConnection.this._connection.getMetaData();
            this._rs = md.getJarByName(jarName);
            if (this._rs.next()) {
                InputStream stream = this._rs.getBinaryStream(1);
                try {
                    this._jarStream = new JarInputStream(stream);
                    this._nextElement = this.fetchNextElement();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                Debug.println(this, "No rows returned for getJarByName");
            }
        }

        private ClassData fetchNextElement() {
            ClassData answer;
            try {
                answer = LoaderConnection.this.readJarBytes(this._jarStream, null);
            }
            catch (IOException iOException) {
                answer = null;
            }
            Debug.println(this, "Fetched next element: " + answer);
            return answer;
        }

        public boolean hasMoreElements() {
            boolean answer;
            block2: {
                boolean bl = answer = this._nextElement != null;
                if (answer) break block2;
                try {
                    this._rs.close();
                }
                catch (SQLException sQLException) {}
            }
            return answer;
        }

        public Object nextElement() {
            ClassData answer = this._nextElement;
            this._nextElement = this.fetchNextElement();
            return answer;
        }
    }

    protected class ClassDataEnumeration
    implements Enumeration {
        private Enumeration _enum;

        protected ClassDataEnumeration(String jarName) throws SQLException {
            SybDatabaseMetaData md = (SybDatabaseMetaData)LoaderConnection.this._connection.getMetaData();
            ResultSet rs = md.getClassesInJar(jarName);
            Vector<String> names = new Vector<String>();
            while (rs.next()) {
                String className = rs.getString(1);
                names.addElement(className);
            }
            rs.close();
            this._enum = names.elements();
        }

        public boolean hasMoreElements() {
            return this._enum.hasMoreElements();
        }

        public Object nextElement() {
            ClassData answer = new ClassData();
            answer._name = (String)this._enum.nextElement();
            try {
                answer._data = LoaderConnection.this.fetchClass(answer._name);
            }
            catch (SQLException sQLException) {
                answer = null;
            }
            return answer;
        }
    }

    protected class ClassData {
        protected String _name;
        protected byte[] _data;

        protected ClassData() {
        }

        public byte[] getData() {
            return this._data;
        }
    }
}

