/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.DynamicClassLoader;
import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.LoaderConnection;
import com.sybase.jdbc2.jdbc.Protocol;
import com.sybase.jdbc2.jdbc.SybConnection;
import com.sybase.jdbc2.jdbc.SybDebug;
import com.sybase.jdbc2.jdbc.SybKey;
import com.sybase.jdbc2.jdbc.SybProperty;
import com.sybase.jdbc2.jdbc.SybUrlManager;
import com.sybase.jdbc2.jdbc.SybUrlProvider;
import com.sybase.jdbcx.Debug;
import com.sybase.jdbcx.SybMessageHandler;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class SybDriver
implements com.sybase.jdbcx.SybDriver {
    private static final Object GLOBAL_SYBDRIVER_LOCK = new Object();
    protected static final int HIGHEST_JCONNECT_VERSION = 6;
    public static final int DEFAULT_DRIVER_VERSION = 5;
    protected int _version = 5;
    private transient SybMessageHandler _msgHandler;

    static {
        SybDriver d = new SybDriver();
    }

    public SybDriver() {
        com.sybase.jdbc2.utils.Debug.println(this, "Driver() " + this);
        this.registerWithDriverManager();
    }

    public boolean acceptsURL(String url) throws SQLException {
        SybUrlManager uMgr;
        SybUrlProvider up;
        int index = url.indexOf(47);
        if (index != -1) {
            url = url.substring(0, index);
            com.sybase.jdbc2.utils.Debug.println(this, "resetting URL to " + url);
        }
        if ((up = (uMgr = new SybUrlManager(url, null, null)).getUrlProvider()) == null) {
            return false;
        }
        Protocol p = up.getProtocol();
        return p != null;
    }

    protected final Connection connect(SybUrlProvider up) throws SQLException {
        return this.connect(null, up);
    }

    protected final SybConnection connect(String url, SybUrlProvider up) throws SQLException {
        SQLWarning w;
        com.sybase.jdbc2.utils.Debug.println(this, "connect(" + url + ", " + up + ") ");
        SybConnection conn = this.createConnection(url, up);
        if (this._msgHandler != null) {
            conn.setSybMessageHandler(this._msgHandler);
        }
        if ((w = up.getSybProperty().getWarnings()) != null) {
            conn.handleSQLE(w);
        }
        return conn;
    }

    public final Connection connect(String url, Properties info) throws SQLException {
        SQLWarning w;
        com.sybase.jdbc2.utils.Debug.println(this, "Connect(" + url + ")");
        SybProperty props = new SybProperty(info, this._version);
        SybUrlManager uMgr = new SybUrlManager(url, info, props);
        SybUrlProvider up = uMgr.getUrlProvider();
        if (up == null) {
            return null;
        }
        SybConnection conn = new SybConnection(up, url);
        if (this._msgHandler != null) {
            conn.setSybMessageHandler(this._msgHandler);
        }
        if ((w = props.getWarnings()) != null) {
            conn.handleSQLE(w);
        }
        return conn;
    }

    protected SybConnection createConnection(String url, SybUrlProvider up) throws SQLException {
        Protocol p;
        com.sybase.jdbc2.utils.Debug.println(this, "createConnection(" + url + ", " + up + ")");
        SybConnection conn = null;
        if (up != null && (p = up.getProtocol()) != null) {
            conn = new SybConnection(up, url);
        }
        return conn;
    }

    private static StringBuffer escapeSpecialCharacters(String src) {
        StringBuffer retBuf = new StringBuffer();
        int srcLen = src.length();
        char c = '\u0000';
        int i = 0;
        while (i < srcLen) {
            c = src.charAt(i);
            if (c == '\\' || c == ',') {
                retBuf.append('\\');
            }
            retBuf.append(c);
            ++i;
        }
        return retBuf;
    }

    public com.sybase.jdbcx.DynamicClassLoader getClassLoader(String url, Properties props) {
        LoaderConnection conn = new LoaderConnection(this, url, props);
        DynamicClassLoader loader = new DynamicClassLoader(conn);
        return loader;
    }

    public final Debug getDebug() {
        return new SybDebug();
    }

    public int getMajorVersion() {
        return 5;
    }

    public SybMessageHandler getMessageHandler() {
        return this.getSybMessageHandler();
    }

    public int getMinorVersion() {
        return 5;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        int propStart;
        DriverPropertyInfo[] dpi = new DriverPropertyInfo[42];
        SybProperty props = new SybProperty(info, this._version);
        if (url != null && (propStart = url.indexOf(63)) > 0 && propStart++ < url.length()) {
            props.parsePropertyString(url.substring(propStart));
        }
        int idx = 0;
        while (idx < 42) {
            dpi[idx] = new DriverPropertyInfo(SybProperty.PROPNAME[idx], props._propValue[idx] == null ? null : props._propValue[idx].toString());
            dpi[idx].required = false;
            dpi[idx].description = SybProperty.DESCRIPTION[idx];
            ++idx;
        }
        dpi[3].required = true;
        dpi[4].required = true;
        dpi[11].value = "";
        dpi[10].value = String.valueOf(dpi[10].value) + "\n\nConfidential property of Sybase, Inc.\nCopyright 1997-2001\nSybase, Inc.  All rights reserved.\nUnpublished rights reserved under U.S. copyright laws.\nThis software contains confidential and trade secret information of Sybase,\nInc.  Use, duplication or disclosure of the software and documentation by\nthe U.S. Government is subject to restrictions set forth in a license\nagreement between the Government and Sybase, Inc. or other written\nagreement specifying the Government's rights to use the software and any\napplicable FAR provisions, for example, FAR 52.227-19.\n\nSybase, Inc. 6475 Christie Avenue, Emeryville, CA 94608, USA\n";
        return dpi;
    }

    public SybMessageHandler getSybMessageHandler() {
        return this._msgHandler;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    protected void registerWithDriverManager() {
        com.sybase.jdbc2.utils.Debug.println(this, "registerWithDriverManager()");
        try {
            Object object = GLOBAL_SYBDRIVER_LOCK;
            synchronized (object) {
                DriverManager.registerDriver(this);
                Enumeration<Driver> e = DriverManager.getDrivers();
                while (e.hasMoreElements()) {
                    Driver d = e.nextElement();
                    if (!(d instanceof SybDriver) || d == this) continue;
                    DriverManager.deregisterDriver(d);
                }
            }
        }
        catch (SQLException sQLException) {
            com.sybase.jdbc2.utils.Debug.assert(null, false, "DriverManager.registerDriver failed");
        }
    }

    public final void setKey(SybKey key) throws SQLException {
    }

    public void setMessageHandler(SybMessageHandler msgHandler) {
        this.setSybMessageHandler(msgHandler);
    }

    public final void setRemotePassword(String serverName, String password, Properties props) {
        StringBuffer remPwdBuf = new StringBuffer();
        String remPwdKey = SybProperty.PROPNAME[9];
        String oldRemPwd = props.getProperty(remPwdKey);
        if (oldRemPwd != null) {
            remPwdBuf.append(oldRemPwd);
        }
        remPwdBuf.append(',');
        if (serverName != null) {
            remPwdBuf.append((Object)SybDriver.escapeSpecialCharacters(serverName));
        }
        remPwdBuf.append(',');
        if (password != null) {
            remPwdBuf.append((Object)SybDriver.escapeSpecialCharacters(password));
        }
        ((Hashtable)props).put(remPwdKey, remPwdBuf.toString());
    }

    public void setSybMessageHandler(SybMessageHandler msgHandler) {
        this._msgHandler = msgHandler;
    }

    public void setVersion(int version) throws SQLException {
        switch (version) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this._version = version;
                return;
            }
            case 0: {
                this._version = 6;
                return;
            }
        }
        ErrorMessage.raiseError("JZ0D6", String.valueOf(version));
    }
}

