/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.Cursor;
import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.Escape;
import com.sybase.jdbc2.jdbc.EscapeTokenizer;
import com.sybase.jdbc2.jdbc.ParamManager;
import com.sybase.jdbc2.jdbc.Protocol;
import com.sybase.jdbc2.jdbc.ProtocolContext;
import com.sybase.jdbc2.jdbc.ProtocolResultSet;
import com.sybase.jdbc2.jdbc.ResultGetter;
import com.sybase.jdbc2.jdbc.SybConnection;
import com.sybase.jdbc2.jdbc.SybCursorResultSet;
import com.sybase.jdbc2.jdbc.SybDatabaseMetaData;
import com.sybase.jdbc2.jdbc.SybPreparedStatement;
import com.sybase.jdbc2.jdbc.SybResultSet;
import com.sybase.jdbc2.tds.TdsProtocolContext;
import com.sybase.jdbc2.utils.CacheManager;
import com.sybase.jdbc2.utils.Debug;
import com.sybase.jdbcx.SybMessageHandler;
import java.io.IOException;
import java.io.StringWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class SybStatement
implements com.sybase.jdbcx.SybStatement {
    private SQLWarning _warning = null;
    protected int _rsType = 1003;
    protected int _rsConcur = -9;
    protected int _rsFetchDir = 1000;
    protected ProtocolContext _context;
    protected Protocol _protocol;
    protected CacheManager _statementManager;
    private int _fieldsize = 0;
    protected boolean _doEscapes = true;
    protected String _rpcName = null;
    protected boolean _hasReturn = false;
    protected boolean _allowsOutputParms = false;
    protected boolean _returnHasBeenRegistered = false;
    protected boolean _closing = false;
    protected SybResultSet _currentRS = null;
    protected ResultGetter _resultGetter;
    protected Cursor _cursor = null;
    protected int _state = 1;
    private int _rowcount = -1;
    private boolean _validRowcount = false;
    protected static final int NORESULTS = 1;
    protected static final int ONERESULT = 2;
    protected static final int MANYRESULTS = 3;
    protected int _currentQT = -1;
    protected static final String CALL_DELIMS = "(), \t\n\r";
    protected static final int OTHER = 0;
    protected static final int CALL = 1;
    protected static final int SELECT = 2;
    protected static final int DELETE = 4;
    protected static final int UPDATE = 8;
    protected static final int VALID = 4096;
    protected int _type;
    protected int _setStart;
    protected int _setEnd;
    protected String _table;
    protected Vector _batchCmds = null;
    protected int _batchCmdsCount = 0;
    protected boolean _doneinproc = false;
    protected SybDatabaseMetaData _dbmda = null;

    protected SybStatement(ProtocolContext pc) {
        this._context = pc;
        this._context._batch = false;
        this._protocol = pc._protocol;
        this._statementManager = new CacheManager(pc._is);
        this._statementManager.setSetable(false);
        this._resultGetter = new ResultGetter(this);
        this._resultGetter.setManager(this._statementManager);
        this._statementManager.register(this._resultGetter);
    }

    public void addBatch(String sql) throws SQLException {
        Debug.println(this, "addBatch(" + sql + ")");
        this.checkBatch();
        if (this._batchCmds == null) {
            this._batchCmds = new Vector();
            this._batchCmdsCount = 0;
        }
        this._batchCmds.add(sql);
        ++this._batchCmdsCount;
        Debug.println(this, "batchCmdsCount = " + this._batchCmdsCount);
    }

    /*
     * Unable to fully structure code
     */
    protected int[] batchLoop(ParamManager params) throws SQLException {
        block16: {
            Debug.println(this, "batchLoop");
            lastRowCount = 0;
            this._currentQT = 3;
            rowsAffected = new int[this._batchCmdsCount];
            i = 0;
            while (i < rowsAffected.length) {
                rowsAffected[i] = 0;
                ++i;
            }
            rowNdx = 0;
            retStatVDoneProc = 5;
            try {
                while (true) {
                    if (retStatVDoneProc != 3) {
                        retStatVDoneProc = 5;
                        lastRowCount = 0;
                    }
                    block9: while (true) {
                        result = this.nextResult(params);
                        switch (result) {
                            case 5: {
                                Debug.println(this, "_doneinproc = " + (this._doneinproc != false ? "true" : "false"));
                                if (this._doneinproc) {
                                    tpc = (TdsProtocolContext)this._context;
                                    if (tpc.isProcDone()) {
                                        retStatVDoneProc = 5;
                                        break block9;
                                    }
                                    Debug.println(this, "Protocol.RESULT_COUNT, lastRowCount = " + (lastRowCount += this._rowcount));
                                    continue block9;
                                }
                                lastRowCount += this._rowcount;
                                break block9;
                            }
                            case 0: {
                                Debug.println(this, "Protocol.RESULT_NONE");
                                retStatVDoneProc = 0;
                                break block9;
                            }
                            case 3: {
                                if (this._doneinproc) {
                                    retStatVDoneProc = 3;
                                    Debug.println(this, "Protocol.RESULT_PARAM, XStatement handle, since it is a proc call with doneproc following");
                                    break block9;
                                }
                                Debug.println(this, "Protocol.RESULT_PARAM, ignoring retstat");
                                continue block9;
                            }
                            default: {
                                ErrorMessage.raiseError("JZ0P1");
                                continue block9;
                            }
                        }
                        break;
                    }
                    if (retStatVDoneProc == 3) continue;
                    if (rowNdx < rowsAffected.length) {
                        rowsAffected[rowNdx++] = lastRowCount;
                        Debug.println(this, " Total Rows Affected for current batch cmd = " + lastRowCount);
                    }
                    if (retStatVDoneProc == 0) break;
                }
                break block16;
            }
            catch (SQLException sqe) {
                this.doCancel(false);
                successfulRows = new int[rowNdx];
                i = 0;
                ** while (i < rowNdx)
            }
lbl-1000:
            // 1 sources

            {
                successfulRows[i] = rowsAffected[i];
                ++i;
                continue;
            }
lbl60:
            // 1 sources

            ErrorMessage.raiseBatchUpdateException(sqe, successfulRows);
        }
        return rowsAffected;
    }

    protected String batchToString() {
        Debug.assert(this, this._batchCmds.size() > 0);
        int batchSize = this._batchCmds.size() * (((String)this._batchCmds.elementAt(this._batchCmds.size() / 2)).length() + 1);
        Debug.println(this, "Guessing batch size at " + batchSize);
        StringWriter sw = new StringWriter(batchSize);
        sw.write((String)this._batchCmds.elementAt(0));
        int i = 1;
        while (i < this._batchCmds.size()) {
            sw.write(" ");
            sw.write((String)this._batchCmds.elementAt(i));
            ++i;
        }
        String sql = sw.toString();
        Debug.println(this, "Batch turned out to be: " + sql.length() + " characters:\n" + sql);
        return sql;
    }

    public void cancel() throws SQLException {
        Debug.println(this, "cancel");
        this.checkDead();
        this.doCancel(true);
    }

    protected boolean checkBatch() throws SQLException {
        try {
            if (this._dbmda == null) {
                this._dbmda = (SybDatabaseMetaData)this._context._conn.getMetaData();
            }
        }
        catch (SQLException sQLException) {
            return false;
        }
        if (this._dbmda._batchSupport != 1) {
            if (!this._dbmda.supportsBatchUpdates()) {
                this._dbmda._batchSupport = 0;
                ErrorMessage.raiseError("JZ0BS");
            }
            this._dbmda._batchSupport = 1;
        } else if (this._dbmda._execBatchInLoop == -1) {
            this._dbmda._execBatchInLoop = this._dbmda.execBatchUpdatesInLoop() ? 1 : 0;
        }
        Debug.println(this, "checkBatch() = " + (this._dbmda._execBatchInLoop == 1 ? "yes" : "no"));
        return this._dbmda._execBatchInLoop == 1;
    }

    protected void checkCursor(boolean langCur) throws SQLException {
        try {
            if (this._cursor == null) {
                this._cursor = this._protocol.getCursor(this._context, langCur);
                this._cursor.setFetchSize(this._context._conn._props.getInteger(16));
                if (this instanceof SybPreparedStatement && ((SybPreparedStatement)this)._dynStmtName != null) {
                    this._cursor.setType(8);
                }
                if (this._rsConcur == -9) {
                    this._rsConcur = 1008;
                }
                this._cursor.setType(this._rsConcur);
            }
        }
        catch (SQLException sqe) {
            this.handleSQLE(sqe);
        }
    }

    protected void checkDead() throws SQLException {
        if (this._state == 4) {
            ErrorMessage.raiseError("JZ0S2");
        }
        this._context._conn.checkConnection();
    }

    protected void checkStatement(boolean write) throws SQLException {
        this.checkDead();
        if (this._cursor != null && this._currentRS != null && this._currentRS._state == 2 && this._cursor.isLanguageCursor()) {
            ErrorMessage.raiseError("JZ00E");
        }
        if (this._closing) {
            return;
        }
        if (write) {
            this.doCancel(false);
            this._state = 2;
        } else if (this._state != 2) {
            ErrorMessage.raiseError("JZ0S1");
        }
    }

    public void clearBatch() throws SQLException {
        Debug.println(this, "clearBatch()");
        this.checkBatch();
        this._batchCmds = null;
        this._batchCmdsCount = 0;
    }

    public void clearWarnings() throws SQLException {
        this.checkDead();
        this._warning = null;
    }

    public void close() throws SQLException {
        this.checkDead();
        this._closing = true;
        Debug.println(this, "close");
        this.doCancel(true);
        try {
            this.deallocateDynamic();
            this._statementManager.clear();
            if (this._cursor != null) {
                this._cursor.close(true);
                this._cursor = null;
            }
        }
        catch (IOException ioe) {
            ErrorMessage.raiseError("JZ006", ioe.getMessage());
        }
        this._statementManager = null;
        this._context.drop();
        this._state = 4;
    }

    protected void deallocateDynamic() throws SQLException {
    }

    private void doCancel(boolean fromCancel) throws SQLException {
        Debug.println(this, "doCancel");
        this._protocol.cancel(this._context, false);
        if (this._cursor != null) {
            this._cursor.close(fromCancel);
            if (fromCancel) {
                this._cursor = null;
            }
        }
        if (this._currentRS != null) {
            this._currentRS.close(true);
            this._currentRS = null;
        }
        try {
            this._statementManager.clear();
        }
        catch (IOException iOException) {}
        this.resetRowCount();
        this._state = 1;
        this._currentQT = -1;
    }

    protected String doEscapeProcessing(String escape) throws SQLException {
        if (escape == null || escape.length() == 0) {
            ErrorMessage.raiseError("JZ0S4");
        }
        if (this._doEscapes) {
            return this.processEscapes(escape);
        }
        return escape;
    }

    public boolean execute(String sql) throws SQLException {
        Debug.println(this, "execute: " + sql);
        sql = this.doEscapeProcessing(sql);
        return this.execute(sql, (ParamManager)null);
    }

    protected boolean execute(String sql, ParamManager params) throws SQLException {
        this.checkStatement(true);
        this.sendQuery(sql, params);
        return this.executeLoop();
    }

    public int[] executeBatch() throws SQLException {
        return this.executeBatch(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int[] executeBatch(ParamManager params) throws SQLException {
        int[] nArray;
        block11: {
            Debug.println(this, "executeBatch()");
            if (this._batchCmds == null) {
                Debug.println(this, "executeBatch() -- returning empty array because clearBatch() was called and nothing more was added to the batch");
                return new int[0];
            }
            int[] rowsAffected = new int[this._batchCmds.size()];
            String sql = "";
            try {
                block12: {
                    if (this.checkBatch()) {
                        Debug.println(this, "Executing Batch Update in loop");
                        if (params != null) {
                            nArray = this.sendBatch((String)this._batchCmds.elementAt(0), params);
                            Object var6_5 = null;
                            break block11;
                        }
                        int i = 0;
                        while (i < this._batchCmds.size()) {
                            int[] rows = this.sendBatch((String)this._batchCmds.elementAt(i), params);
                            rowsAffected[i] = rows[0];
                            ++i;
                        }
                        break block12;
                    }
                    rowsAffected = this.sendBatch(this.batchToString(), params);
                }
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (!this.checkBatch()) {
                    this.clearBatch();
                }
                this._context._batch = false;
                throw throwable;
            }
            if (!this.checkBatch()) {
                this.clearBatch();
            }
            this._context._batch = false;
            return rowsAffected;
        }
        if (!this.checkBatch()) {
            this.clearBatch();
        }
        this._context._batch = false;
        return nArray;
    }

    protected boolean executeLoop() throws SQLException {
        this._currentQT = 3;
        int result = this.nextResult();
        switch (result) {
            default: {
                ErrorMessage.raiseError("JZ0P1");
            }
            case 0: 
            case 1: 
            case 3: 
            case 5: 
        }
        return this._currentRS != null;
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        Debug.println(this, "executeQuery: " + sql);
        sql = this.doEscapeProcessing(sql);
        return this.executeQuery(sql, null);
    }

    protected ResultSet executeQuery(String sql, ParamManager params) throws SQLException {
        Debug.println(this, "executeQuery(String, ParamManager)");
        this.checkStatement(true);
        if (this._rsConcur == -9) {
            this._rsConcur = 1007;
        }
        if (this._cursor == null && this._rsConcur == 1008) {
            Debug.println(this, "creating a cursor because user requested updatable concurrency.");
            this.checkCursor(false);
        }
        if (this._cursor != null) {
            this._cursor.setTable(this._table);
            ProtocolResultSet prs = null;
            prs = this instanceof SybPreparedStatement && ((SybPreparedStatement)this)._dynStmtName != null ? this._cursor.open(((SybPreparedStatement)this)._dynStmtName, params, false) : this._cursor.open(sql, params, false);
            if (prs == null) {
                ErrorMessage.raiseError("JZ0R2");
            }
            prs.setType(this._rsType);
            this._currentRS = new SybCursorResultSet(this, prs);
            this._context._conn.addCursorResultSet(this._cursor.getName(), this._currentRS);
            this._state = 2;
        } else {
            this.sendQuery(sql, params);
            this.queryLoop();
        }
        return this._currentRS;
    }

    public int executeUpdate(String sql) throws SQLException {
        Debug.println(this, "executeUpdate: " + sql);
        sql = this.doEscapeProcessing(sql);
        return this.executeUpdate(sql, (ParamManager)null);
    }

    protected int executeUpdate(String sql, ParamManager params) throws SQLException {
        this.checkStatement(true);
        if (this.sendQuery(sql, params)) {
            return 1;
        }
        return this.updateLoop();
    }

    public Connection getConnection() throws SQLException {
        return this._context._conn;
    }

    public int getFetchDirection() throws SQLException {
        return this._rsFetchDir;
    }

    public int getFetchSize() throws SQLException {
        if (this._cursor != null) {
            return this._cursor.getFetchSize();
        }
        return 0;
    }

    public int getMaxFieldSize() throws SQLException {
        this.checkDead();
        return this._context._maxFieldSize;
    }

    public int getMaxRows() throws SQLException {
        this.checkDead();
        return this._protocol.getIntOption(this._context, 4);
    }

    public SybMessageHandler getMessageHandler() {
        return this.getSybMessageHandler();
    }

    public boolean getMoreResults() throws SQLException {
        this.checkDead();
        Debug.println(this, "getMoreResults");
        if (this._state == 1) {
            this._validRowcount = true;
            return false;
        }
        int nextRes = this.nextResult();
        switch (nextRes) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    public int getQueryTimeout() throws SQLException {
        this.checkDead();
        return this._context._timeout / 1000;
    }

    public ResultSet getResultSet() throws SQLException {
        this.checkDead();
        this.setRowCount(-1);
        if (this._context.getState() == 5) {
            ErrorMessage.raiseError("JZ0PA");
        }
        return this._currentRS;
    }

    public int getResultSetConcurrency() throws SQLException {
        if (this._currentRS != null) {
            return this._currentRS.getConcurrency();
        }
        if (this._rsConcur == -9) {
            return 1007;
        }
        return this._rsConcur;
    }

    public int getResultSetType() throws SQLException {
        if (this._currentRS != null) {
            return this._currentRS.getType();
        }
        return this._rsType;
    }

    public SybMessageHandler getSybMessageHandler() {
        return this._context.getMessageHandler();
    }

    public int getUpdateCount() throws SQLException {
        this.checkDead();
        Debug.println(this, "getUpdateCount");
        if (this._context.getState() == 5) {
            ErrorMessage.raiseError("JZ0PA");
        }
        if (!this._validRowcount) {
            ErrorMessage.raiseError("JZ0CU");
        }
        int updateCount = this._rowcount;
        this.resetRowCount();
        return updateCount;
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkDead();
        return this._warning;
    }

    protected String handleCallBody(String body) throws SQLException {
        Debug.println(this, "handleCallBody");
        StringTokenizer st = new StringTokenizer(body);
        String newBody = body;
        boolean startsWithExec = false;
        String originalExec = null;
        this._allowsOutputParms = true;
        try {
            String nextThing;
            this._rpcName = st.nextToken(CALL_DELIMS);
            int start = this._rpcName.length();
            if (this._rpcName.toLowerCase().equals("exec")) {
                startsWithExec = true;
                Debug.println(this, "ignoring keyword " + this._rpcName);
                this._rpcName = st.nextToken(CALL_DELIMS);
                int rpcNameStart = body.indexOf(this._rpcName);
                originalExec = body.substring(0, rpcNameStart);
                newBody = body.substring(rpcNameStart);
                start += this._rpcName.length();
            }
            Debug.println(this, "rpcName = " + this._rpcName);
            StringTokenizer paren_st = new StringTokenizer(body.substring(body.indexOf(this._rpcName) + this._rpcName.length()));
            String n = paren_st.nextToken(" ");
            int lastCloseParen = body.lastIndexOf(41);
            Debug.println(this, "first token is " + n + " and lastCloseParen = " + lastCloseParen);
            if (n.startsWith("(") && lastCloseParen > 0) {
                newBody = String.valueOf(this._rpcName) + " " + body.substring(body.indexOf(40) + 1, lastCloseParen);
            }
            while ((nextThing = st.nextToken(CALL_DELIMS)).charAt(0) == '?') {
            }
            Debug.println(this, "Not a pure RPC because " + nextThing);
            this._rpcName = null;
        }
        catch (NoSuchElementException noSuchElementException) {}
        if (startsWithExec) {
            Debug.println(this, "check to see if 'exec' is stripped");
            if (!this._protocol.getBoolOption(this._context, 12)) {
                Debug.println(this, "Nope, put it back on");
                newBody = String.valueOf(originalExec) + newBody;
            }
        }
        Debug.println(this, "Converted call to " + newBody);
        return newBody;
    }

    protected void handleParam(ParamManager pm) throws SQLException {
    }

    protected void handleSQLE(SQLException sqe) throws SQLException {
        boolean foundAnException = SybConnection.thisChainHasAnException(sqe);
        SQLWarning w = null;
        w = !foundAnException ? (SQLWarning)sqe : SybConnection.getAllTheWarnings(sqe);
        if (w != null) {
            if (this._warning == null) {
                this._warning = w;
            } else {
                this._warning.setNextWarning(w);
            }
        }
        if (foundAnException) {
            throw sqe;
        }
        Debug.println(this, ">>> Only Warnings");
    }

    protected int nextResult() throws SQLException {
        return this.nextResult(null);
    }

    protected int nextResult(ParamManager pm) throws SQLException {
        int result;
        Debug.println(this, "nextResult");
        this.resetRowCount();
        while (true) {
            try {
                result = this._resultGetter.nextResult();
            }
            catch (SQLException sqe) {
                this.handleSQLE(sqe);
                continue;
            }
            break;
        }
        switch (result) {
            case 1: {
                Debug.println(this, "got a resultSet");
                ProtocolResultSet prs = this._protocol.resultSet(this._context);
                if (prs != null) {
                    prs.setType(this._rsType);
                }
                this._currentRS = new SybResultSet(this, prs);
                try {
                    this._currentRS.setManager(this._statementManager);
                    this._statementManager.register(this._currentRS);
                    this._statementManager.open(this._currentRS);
                }
                catch (IOException iOException) {
                    Debug.assert(this, false);
                }
                break;
            }
            case 5: {
                this.setRowCount(this._protocol.count(this._context));
                Debug.println(this, "nextResult: COUNT = " + this._rowcount);
                break;
            }
            case 0: {
                this.setRowCount(-1);
                this._state = 1;
                Debug.println(this, "nextResult: DONE");
                break;
            }
            case 3: {
                Debug.println(this, "nextResult: PARAM");
                if (this._rowcount == -1) {
                    this.setRowCount(0);
                }
                this.handleParam(pm);
                break;
            }
            default: {
                Debug.assert(this, false);
            }
        }
        this._validRowcount = true;
        return result;
    }

    protected String processEscapes(String escape) throws SQLException {
        if (escape.length() == 0) {
            return escape;
        }
        EscapeTokenizer et = new EscapeTokenizer(this, escape);
        StringBuffer newQuery = new StringBuffer();
        Debug.println(null, "processEscapes( " + escape + " )");
        Object o = et.next();
        while (o != null) {
            Debug.assert(null, o instanceof String || o instanceof Escape);
            if (o instanceof String) {
                newQuery.append((String)o);
            } else {
                Escape e = (Escape)o;
                switch (e.getType()) {
                    case 4: {
                        newQuery.append("'1970-1-1 ");
                        String time = e.getBody();
                        newQuery.append(time.substring(1, time.length()));
                        break;
                    }
                    case 3: {
                        String date = e.getBody();
                        newQuery.append(date.substring(0, date.length() - 1));
                        newQuery.append(" 00:00:00'");
                        break;
                    }
                    case 5: {
                        String timestamp = e.getBody();
                        int decimal = timestamp.indexOf(".");
                        if (decimal > 0 && timestamp.length() - decimal > 4) {
                            newQuery.append(String.valueOf(timestamp.substring(0, decimal + 4)) + "'");
                            break;
                        }
                        newQuery.append(timestamp);
                        break;
                    }
                    case 2: {
                        this._hasReturn = true;
                        newQuery = new StringBuffer(this.handleCallBody(e.getBody()));
                        break;
                    }
                    case 1: {
                        this._hasReturn = false;
                        newQuery = new StringBuffer(this.handleCallBody(e.getBody()));
                        break;
                    }
                    case 7: {
                        newQuery.append(" ESCAPE " + e.getBody());
                        break;
                    }
                    case 6: {
                        String mapString = this._protocol.getStringOption(this._context, 10, e.functionName());
                        if (mapString == null) {
                            ErrorMessage.raiseError("JZ0SI", e.functionName());
                        }
                        newQuery.append(e.doMap(mapString));
                        break;
                    }
                    case 8: {
                        if (((SybDatabaseMetaData)this._context._conn.getMetaData()).supportsOuterJoinEscapeSyntax()) {
                            newQuery.append(e.getBody());
                            break;
                        }
                        ErrorMessage.raiseError("JZ0SK");
                        break;
                    }
                    default: {
                        Debug.assert(null, false);
                        break;
                    }
                }
            }
            o = et.next();
        }
        Debug.println(null, "converted buffer = '" + newQuery.toString() + "'");
        return newQuery.toString();
    }

    protected ResultSet queryLoop() throws SQLException {
        this._currentQT = 2;
        boolean doCancel = true;
        try {
            block9: while (true) {
                int result = this.nextResult();
                switch (result) {
                    case 3: 
                    case 5: {
                        continue block9;
                    }
                    case 1: {
                        return this._currentRS;
                    }
                    case 0: {
                        doCancel = false;
                        ErrorMessage.raiseError("JZ0R2");
                        continue block9;
                    }
                }
                ErrorMessage.raiseError("JZ0P1");
            }
        }
        catch (SQLException sqe) {
            block11: {
                if (!doCancel || "JZ0T4".equals(sqe.getSQLState())) break block11;
                try {
                    this.doCancel(false);
                }
                catch (SQLException sqle) {
                    if (sqle.getSQLState().equals("JZ0F2")) {
                        sqle.setNextException(sqe);
                        throw sqle;
                    }
                    sqe.setNextException(sqle);
                }
            }
            throw sqe;
        }
    }

    private void resetRowCount() {
        this._validRowcount = false;
        this._rowcount = -1;
    }

    protected int[] sendBatch(String batch, ParamManager params) throws SQLException {
        String sql = this.doEscapeProcessing(batch);
        this._context._batch = true;
        this.checkStatement(true);
        this.sendQuery(sql, params);
        return this.batchLoop(params);
    }

    protected boolean sendQuery(String sql, ParamManager params) throws SQLException {
        Debug.assert(this, sql != null);
        if (this._type == 4100 || this._type == 4104) {
            sql.trim();
            int k = sql.lastIndexOf(32);
            String cursor = sql.substring(k + 1);
            Debug.println(this, "Looking for cursor, " + cursor);
            SybCursorResultSet crs = (SybCursorResultSet)this._context._conn.getCursorResultSet(cursor);
            if (crs != null && !crs._cursor.isLanguageCursor()) {
                crs._cursor.setTable(this._table);
                if (this._type == 4100) {
                    crs.deleteRow();
                } else {
                    crs._cursor.update(crs._prs, params, sql.substring(0, this._setEnd));
                }
                return true;
            }
            if (params != null) {
                params.literalizeAll();
            }
        }
        try {
            this._protocol.language(this._context, sql, params);
        }
        catch (SQLException sqe) {
            this.handleSQLE(sqe);
        }
        this._state = 2;
        return false;
    }

    public void setCursorName(String name) throws SQLException {
        this.checkDead();
        Debug.println(this, "setCursorName = " + name);
        try {
            this.checkCursor(true);
            this._cursor.setName(name);
        }
        catch (SQLException sqe) {
            this.handleSQLE(sqe);
        }
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkDead();
        this._doEscapes = enable;
    }

    public void setFetchDirection(int direction) throws SQLException {
        switch (direction) {
            case 1000: 
            case 1001: 
            case 1002: {
                this._rsFetchDir = direction;
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0I3", String.valueOf(direction), "setFetchDirection(int)");
            }
        }
    }

    public void setFetchSize(int numRows) throws SQLException {
        if (numRows == 0) {
            return;
        }
        int currentMaxRows = this.getMaxRows();
        if (numRows < 0 || currentMaxRows > 0 && numRows > currentMaxRows) {
            ErrorMessage.raiseError("JZ0BI");
        }
        this.checkCursor(false);
        this._cursor.setFetchSize(numRows);
    }

    public void setMaxFieldSize(int max) throws SQLException {
        if (max < 0) {
            ErrorMessage.raiseError("JZ0SN");
        }
        this.checkStatement(true);
        this._context._maxFieldSize = max;
    }

    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            ErrorMessage.raiseError("JZ0SR");
        }
        this.checkStatement(true);
        try {
            this._protocol.setOption(this._context, 4, max);
        }
        catch (SQLException sqe) {
            this.handleSQLE(sqe);
        }
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            ErrorMessage.raiseError("JZ0SS");
        }
        this.checkDead();
        this._context._timeout = seconds * 1000;
    }

    protected void setResultSetParams(int rsType, int rsConcur) throws SQLException {
        Debug.println(this, "setResultSetParams(). ResultSet requested: Type = " + rsType + ", Concurrency = " + rsConcur);
        boolean warning = false;
        switch (rsType) {
            case 1005: {
                warning = true;
                rsType = 1004;
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0SP", String.valueOf(rsType));
            }
            case 1003: 
            case 1004: 
        }
        switch (rsConcur) {
            case 1008: {
                if (rsType != 1004) break;
                rsConcur = 1007;
                warning = true;
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0SO", String.valueOf(rsConcur));
            }
            case 1007: 
        }
        this._rsType = rsType;
        this._rsConcur = rsConcur;
        Debug.println(this, "ResultSet assigned:  Type = " + this._rsType + ", Concurrency = " + this._rsConcur);
        if (warning) {
            this._context._conn.chainWarnings(ErrorMessage.createWarning("010RC"));
        }
    }

    protected void setRowCount(int rowcount) {
        Debug.println(this, "setRowCount(" + rowcount + ")");
        this._rowcount = rowcount;
    }

    public void setSybMessageHandler(SybMessageHandler msgHandler) {
        this._context.setMessageHandler(msgHandler);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int updateLoop() throws SQLException {
        int lastRowCount = 0;
        this._currentQT = 1;
        try {
            block7: while (true) {
                int result = this.nextResult();
                switch (result) {
                    case 5: {
                        lastRowCount = this._rowcount;
                        continue block7;
                    }
                    case 3: {
                        if (!(this instanceof CallableStatement)) continue block7;
                        return lastRowCount;
                    }
                    default: {
                        ErrorMessage.raiseError("JZ0P1");
                        continue block7;
                    }
                    case 0: {
                        return lastRowCount;
                    }
                }
                break;
            }
        }
        catch (SQLException sqe) {
            this.doCancel(false);
            throw sqe;
        }
    }
}

