/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.tds.TdsCursor;
import com.sybase.jdbc2.tds.TdsDataOutputStream;
import com.sybase.jdbc2.tds.Token;
import com.sybase.jdbc2.utils.Debug;
import java.io.IOException;

public class CurFetchToken
extends Token {
    private TdsCursor _cursor;
    private int _type;
    private int _rowNum;

    protected CurFetchToken() {
    }

    public CurFetchToken(TdsCursor cursor, int type, int rowNum) {
        this._cursor = cursor;
        this._type = type;
        this._rowNum = rowNum;
        Debug.assert(this, type >= 1 && type <= 6);
    }

    public void send(TdsDataOutputStream out) throws IOException {
        Debug.println(this, "send " + this.toString());
        int length = 5;
        byte[] cvtName = null;
        int nameLen = 0;
        if (this._cursor._id == 0) {
            cvtName = out.stringToByte(this._cursor.getName());
            nameLen = cvtName.length;
            length += 1 + nameLen;
        }
        switch (this._type) {
            case 5: 
            case 6: {
                length += 4;
                break;
            }
        }
        try {
            out.writeByte(130);
            out.writeShort(length);
            out.writeInt(this._cursor._id);
            if (this._cursor._id == 0) {
                out.writeByte(nameLen);
                out.write(cvtName);
            }
            out.writeByte(this._type);
            switch (this._type) {
                case 5: 
                case 6: {
                    out.writeInt(this._rowNum);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (IOException ioe) {
            Token.writeSQE(ioe);
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer("CurFetchToken: ");
        s.append(this._cursor._id == 0 ? "curId= " + this._cursor._id : "name= " + this._cursor.getName());
        s.append(", type = " + this._type);
        s.append(", row# = " + this._rowNum);
        return s.toString();
    }
}

