/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.utils.Debug;
import java.io.CharConversionException;
import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class TdsOutputStream
extends FilterOutputStream
implements DataOutput {
    protected byte[] _numbuf = new byte[8];
    protected static final int LOW_BYTE = 255;
    protected static final long D_LOW_BYTE = 255L;
    private boolean _byteswap = false;

    public TdsOutputStream(OutputStream os) throws IOException {
        super(os);
    }

    public boolean getBigEndian() {
        return this._byteswap ^ true;
    }

    public abstract String getCharset();

    protected int getStringByteLen(String s) throws IOException {
        return s == null ? 0 : this.toBytes(s).length;
    }

    public void setBigEndian(boolean bigEndian) {
        this._byteswap = bigEndian ^ true;
    }

    public final int size() {
        return -1;
    }

    public byte[] stringToByte(String s) throws IOException {
        try {
            return this.toBytes(s);
        }
        catch (CharConversionException cce) {
            ErrorMessage.raiseIOException("JZ0I6", cce.toString());
            Debug.assert(null, false);
            return null;
        }
    }

    protected abstract byte[] toBytes(String var1) throws CharConversionException;

    public void write(int b) throws IOException {
        this.out.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.out.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    public final void writeBoolean(boolean b) throws IOException {
        throw new IOException("Not a supported TDS type");
    }

    public final void writeByte(int i) throws IOException {
        this.write(i);
    }

    public final void writeBytes(String s) throws IOException {
        throw new IOException("Not a supported TDS type");
    }

    public final void writeChar(int v) throws IOException {
        throw new IOException("Not a supported TDS type");
    }

    public final void writeChars(String s) throws IOException {
        throw new IOException("Not a supported TDS type");
    }

    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeInt(int v) throws IOException {
        if (this._byteswap) {
            this._numbuf[3] = (byte)(v >>> 24 & 0xFF);
            this._numbuf[2] = (byte)(v >>> 16 & 0xFF);
            this._numbuf[1] = (byte)(v >>> 8 & 0xFF);
            this._numbuf[0] = (byte)(v & 0xFF);
        } else {
            this._numbuf[0] = (byte)(v >>> 24 & 0xFF);
            this._numbuf[1] = (byte)(v >>> 16 & 0xFF);
            this._numbuf[2] = (byte)(v >>> 8 & 0xFF);
            this._numbuf[3] = (byte)(v & 0xFF);
        }
        this.write(this._numbuf, 0, 4);
    }

    public final void writeLong(long l) throws IOException {
        if (this._byteswap) {
            this._numbuf[7] = (byte)((int)(l >>> 56) & 0xFF);
            this._numbuf[6] = (byte)((int)(l >>> 48) & 0xFF);
            this._numbuf[5] = (byte)((int)(l >>> 40) & 0xFF);
            this._numbuf[4] = (byte)((int)(l >>> 32) & 0xFF);
            this._numbuf[3] = (byte)((int)(l >>> 24) & 0xFF);
            this._numbuf[2] = (byte)((int)(l >>> 16) & 0xFF);
            this._numbuf[1] = (byte)((int)(l >>> 8) & 0xFF);
            this._numbuf[0] = (byte)((int)l & 0xFF);
        } else {
            this._numbuf[0] = (byte)((int)(l >>> 56) & 0xFF);
            this._numbuf[1] = (byte)((int)(l >>> 48) & 0xFF);
            this._numbuf[2] = (byte)((int)(l >>> 40) & 0xFF);
            this._numbuf[3] = (byte)((int)(l >>> 32) & 0xFF);
            this._numbuf[4] = (byte)((int)(l >>> 24) & 0xFF);
            this._numbuf[5] = (byte)((int)(l >>> 16) & 0xFF);
            this._numbuf[6] = (byte)((int)(l >>> 8) & 0xFF);
            this._numbuf[7] = (byte)((int)l & 0xFF);
        }
        this.write(this._numbuf, 0, 8);
    }

    public final void writeLongAsUnsignedInt(long v) throws IOException {
        if (this._byteswap) {
            this._numbuf[3] = (byte)(v >>> 24 & 0xFFL);
            this._numbuf[2] = (byte)(v >>> 16 & 0xFFL);
            this._numbuf[1] = (byte)(v >>> 8 & 0xFFL);
            this._numbuf[0] = (byte)(v & 0xFFL);
        } else {
            this._numbuf[0] = (byte)(v >>> 24 & 0xFFL);
            this._numbuf[1] = (byte)(v >>> 16 & 0xFFL);
            this._numbuf[2] = (byte)(v >>> 8 & 0xFFL);
            this._numbuf[3] = (byte)(v & 0xFFL);
        }
        this.write(this._numbuf, 0, 4);
    }

    public final void writeShort(int i) throws IOException {
        if (this._byteswap) {
            this._numbuf[1] = (byte)(i >>> 8 & 0xFF);
            this._numbuf[0] = (byte)(i & 0xFF);
        } else {
            this._numbuf[0] = (byte)(i >>> 8 & 0xFF);
            this._numbuf[1] = (byte)(i & 0xFF);
        }
        this.write(this._numbuf, 0, 2);
    }

    public void writeString(String s) throws IOException {
        throw new IOException("Not a supported TDS type");
    }

    public void writeStringLen(String s, int len) throws IOException {
        int sLen = 0;
        if (s != null) {
            byte[] cvtString = this.toBytes(s);
            sLen = cvtString.length;
            if (sLen > len) {
                ErrorMessage.raiseIOException("JZ0TS", s);
            }
            this.write(cvtString);
        }
        int i = sLen;
        while (i < len) {
            this.write(0);
            ++i;
        }
        this.write(sLen);
    }

    public final void writeUTF(String str) throws IOException {
        throw new IOException("Not a supported TDS type");
    }
}

