/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.timedio;

import com.sybase.jdbc2.jdbc.Capture;
import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.SybProperty;
import com.sybase.jdbc2.tds.Tds;
import com.sybase.jdbc2.timedio.Dbio;
import com.sybase.jdbc2.timedio.OutStreamMgr;
import com.sybase.jdbc2.timedio.ResponseQueue;
import com.sybase.jdbc2.timedio.StreamContext;
import com.sybase.jdbc2.utils.BufferInterval;
import com.sybase.jdbc2.utils.BufferPool;
import com.sybase.jdbc2.utils.Debug;
import com.sybase.jdbc2.utils.SyncObj;
import com.sybase.jdbc2.utils.SyncQueue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.EmptyStackException;

public class InStreamMgr {
    public static final int RESPONSE_DONE = 0;
    public static final int RESPONSE_MORE = 1;
    public static final int PARTIAL_PACKET = 2;
    public static final int EVENT = 3;
    public static final int ERROR = 4;
    public static final int RESPONSE_OPEN = 5;
    public static final int EVENT_DONE = 6;
    private Dbio _dbio = null;
    private OutStreamMgr _outMgr;
    private BufferPool _pool;
    private StreamContext _currentCtx;
    private StreamContext _eventCtx;
    private boolean _closing;
    private int _cacheSize;
    private boolean _cancelling = false;
    private boolean _serialize = false;
    BufferInterval _partialBI = null;
    private SyncQueue _readList;
    private SyncObj _readerThd;
    private boolean _readAhead = false;
    private SQLWarning _capSqw;
    public Tds _tds;
    public boolean _tracing = false;

    public InStreamMgr(String host, int port, SybProperty info) throws IOException, SQLException {
        int timeout = 1000 * DriverManager.getLoginTimeout();
        Debug.println(this, "Connecting to '" + host + ":" + port + "', timeout =  " + timeout + "ms");
        this._readList = new SyncQueue(6, 6);
        this._readerThd = new SyncObj(this._readList);
        this._cacheSize = info.getInteger(13);
        int packet = info.getInteger(12);
        this._serialize = info.getBoolean(29);
        this._pool = new BufferPool(this, this._cacheSize, packet);
        this._dbio = Dbio.connect(host, port, this, info);
        this._dbio.doConnect(timeout);
        this._closing = false;
        try {
            this._dbio.createCapture(info);
        }
        catch (SQLWarning w) {
            this._capSqw = w;
        }
    }

    protected void cacheResponses(StreamContext ctx) throws IOException {
        StreamContext curCtx;
        Debug.assert(this, this._serialize);
        Debug.println(this, "cacheResponses()");
        while ((curCtx = this.getCurrentContext()) != null) {
            Debug.println(this, "reading for context = " + curCtx);
            if (!this._readAhead) {
                ctx._responseQue.setNeed();
            }
            int owner = this.takeIfNoReadAhead(ctx);
            Debug.println(this, "owner from responseQueue = " + owner);
            if (owner != 13) continue;
            curCtx = this.getCurrentContext();
            if (curCtx != null) {
                Debug.println(this, "reading for context = " + curCtx);
                this.readIfOwner(owner, curCtx);
            }
            ctx._responseQue.giveToNext();
        }
    }

    public void cancelling(boolean cancel) {
        Debug.println(this, "cancelling(" + cancel + ") context = " + this._currentCtx);
        InStreamMgr inStreamMgr = this;
        synchronized (inStreamMgr) {
            this._cancelling = cancel;
        }
        if (this._cancelling) {
            StreamContext curCtx = this.getCurrentContext();
            if (curCtx != null) {
                curCtx.cancelled();
            }
        } else {
            this.setCurrentContextNull();
        }
    }

    public void close() {
        Debug.println(this, "close");
        this._closing = true;
        this._dbio.stopAsync();
        if (this._eventCtx != null) {
            this._eventCtx.drop();
        }
        this._dbio.close();
    }

    public void closing() {
        this._dbio.closing();
    }

    protected StreamContext currentContext() {
        return this._currentCtx;
    }

    public void doRead(StreamContext context) throws IOException {
        Debug.println(this, "doRead() wait " + context._request.whoAmI() + ", context = " + context);
        this.readIfOwner(this.takeIfNoReadAhead(context), context);
    }

    protected SyncObj dump() {
        SyncObj ret = null;
        return ret;
    }

    public BufferInterval getBI() {
        return this._pool.getBI(true);
    }

    public Capture getCapture() {
        return this._dbio.getCapture();
    }

    public SQLWarning getCaptureWarnings() {
        return this._capSqw;
    }

    private synchronized StreamContext getCurrentContext() {
        if (this._currentCtx == null) {
            this._currentCtx = this._outMgr.getNextContext();
            if (this._currentCtx == null) {
                Debug.println(this, "No context pending, event?");
            }
            Debug.println(this, "get a new context = " + this._currentCtx);
        }
        return this._currentCtx;
    }

    public InputStream getInputStream() throws IOException {
        return this._dbio.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this._dbio.getOutputStream();
    }

    protected SyncQueue getReadQueue() {
        return this._readList;
    }

    public String getSessionID() {
        return this._dbio.getSessionID();
    }

    public void markDead() throws IOException {
        StreamContext curCtx = this.getCurrentContext();
        if (curCtx != null) {
            curCtx._conn.markDeadTryHA();
        } else {
            this._eventCtx._conn.markDeadTryHA();
        }
        ErrorMessage.raiseIOException("JZ0C0");
    }

    protected void moreData(BufferInterval bi, int nBytes) {
        int remainder = bi._length - nBytes;
        Debug.println(this, "moreData() bytes received = " + nBytes + " _currentCtx = " + this._currentCtx);
        if (this._closing) {
            return;
        }
        BufferInterval databi = null;
        if (remainder > 0) {
            databi = bi.divide(nBytes);
            this._pool.put(bi);
        } else {
            databi = bi;
        }
        bi = null;
        int ctxResp = 0;
        while (true) {
            StreamContext curCtx;
            if ((curCtx = this.getCurrentContext()) != null) {
                Debug.println(this, "Data received for " + curCtx);
                databi = curCtx.queueData(databi);
                ctxResp = curCtx.responseState();
            } else {
                databi = this._eventCtx.queueData(databi);
                ctxResp = this._eventCtx.responseState();
            }
            switch (ctxResp) {
                case 0: {
                    this.setCurrentContextNull();
                    break;
                }
                case 2: {
                    this.partialPacket(databi);
                    return;
                }
                case 3: {
                    databi = this._eventCtx.queueData(databi);
                    ctxResp = this._eventCtx.responseState();
                }
            }
            if (ctxResp == 4) {
                this._pool.put(databi);
                databi = null;
                this._dbio._lastEx = null;
                this.reportError("JZ0T8");
                break;
            }
            if (databi == null) {
                Debug.println(this, "ctxResp = " + ctxResp + ", databi = null");
                break;
            }
            Debug.println(this, "ctxResp = " + ctxResp + ", databi._buf = " + databi._buf + ", offset =  " + databi._offset + ", length = " + databi._length);
        }
        Debug.println(this, "All data queued");
    }

    private void partialPacket(BufferInterval databi) {
        Debug.println(this, "partialPacket");
        this._partialBI = databi;
    }

    private void readIfOwner(int owner, StreamContext ctx) throws IOException {
        switch (owner) {
            case 13: {
                try {
                    this._dbio.doRead(ctx._timeout);
                    Object var4_4 = null;
                    ctx._responseQue.giveToNext();
                    break;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    ctx._responseQue.giveToNext();
                    throw throwable;
                }
            }
            case 12: {
                Debug.println(this, "doRead() satisfied, context = " + ctx);
                break;
            }
            case 14: {
                Debug.println(this, "doRead() timeout, context = " + ctx);
                ErrorMessage.raiseIOException("JZ0T3");
            }
            default: {
                Debug.assert(this, false);
            }
        }
    }

    public void reportError(String sqlstate) {
        StreamContext ctx = this.getCurrentContext();
        if (ctx == null) {
            try {
                ctx = this._outMgr.peekNextContext();
            }
            catch (EmptyStackException emptyStackException) {}
        }
        Debug.println(this, "reportError to context: " + ctx);
        SQLException sqle = ErrorMessage.makeIOReportableException(sqlstate, this._dbio._lastEx);
        if (ctx != null) {
            ctx.chainException(sqle);
        } else {
            this._eventCtx._conn.chainWarnings(sqle);
        }
        if (this._dbio._lastEx != null) {
            this._dbio._lastEx = null;
            this.close();
        }
        Debug.println(this, sqle.toString());
    }

    protected void setBuffer(long timeout) throws IOException {
        BufferInterval nextbi = null;
        InStreamMgr inStreamMgr = this;
        synchronized (inStreamMgr) {
            nextbi = this._pool.getBI(this._cancelling);
            if (nextbi == null) {
                Debug.println(this, "Waiting buffer space");
                Debug.startTimer(this);
                try {
                    this.wait((int)timeout);
                }
                catch (InterruptedException interruptedException) {
                    Debug.println(this, "InterruptedException!");
                }
                Debug.stopTimer(this, "Wait for buffer");
                nextbi = this._pool.getBI(this._cacheSize == -1);
            }
        }
        if (nextbi == null) {
            ErrorMessage.raiseIOException("JZ0T5");
        }
        int partial = 0;
        if (this._partialBI != null) {
            System.arraycopy(this._partialBI._buf, this._partialBI._offset, nextbi._buf, nextbi._offset, this._partialBI._length);
            partial = this._partialBI._length;
            this._pool.put(this._partialBI);
            this._partialBI = null;
        }
        this._dbio.setBufferInfo(nextbi, partial);
    }

    public synchronized void setCurrentContextNull() {
        this._currentCtx = null;
    }

    public void setEventContext(StreamContext eventCtx) {
        this._eventCtx = eventCtx;
    }

    public void setNetBufSize(int packetSize) {
        this._pool.setNetBufSize(packetSize);
    }

    protected void setOutStreamMgr(OutStreamMgr outMgr) {
        this._outMgr = outMgr;
        this._outMgr.setSerialize(this._serialize);
    }

    public void setSerialize() {
        this._serialize = true;
        this._outMgr.setSerialize(this._serialize);
    }

    public boolean startAsync() {
        if (this._readAhead) {
            return true;
        }
        if (this._readerThd.giveToMe(0L) == 13) {
            this._readAhead = this._dbio.startAsync();
            if (!this._readAhead) {
                this._readerThd.giveToNext();
            }
        }
        return this._readAhead;
    }

    private int takeIfNoReadAhead(StreamContext context) {
        if (this._readAhead) {
            ResponseQueue responseQueue = context._responseQue;
            synchronized (responseQueue) {
                if (context._responseQue.available(0) > 0) {
                    int n = 12;
                    Object var4_4 = null;
                    return n;
                }
                try {
                    context._responseQue.wait(context._timeout);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (context._responseQue.available(0) > 0) {
                return 12;
            }
            return 14;
        }
        return context._responseQue.giveToMe(context._timeout);
    }
}

