/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.timedio;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.timedio.URLDbio;
import com.sybase.jdbc2.utils.Debug;
import java.io.IOException;
import java.io.OutputStream;

public class TDSTunnellingOS
extends OutputStream {
    private URLDbio _dbio;
    private int _length = 0;
    private static final int MAX_WRITE = 4096;
    private byte[] _buf = new byte[4096];

    public TDSTunnellingOS(URLDbio dbio) {
        this._dbio = dbio;
    }

    public void close() throws IOException {
        Debug.println(this, "closing ");
        this.flush(4);
    }

    public void flush() throws IOException {
        Debug.println(this, "flush " + this._length + " bytes");
        Debug.assert(this, this._length > 0);
        this.flush(2);
        Debug.println(this, "flush complete");
    }

    protected synchronized void flush(int operation) throws IOException {
        Debug.println(this, "flushing " + this._length + " bytes to Tunnelling, with operation (" + operation + ")");
        this._dbio.write(operation, this._buf, this._length);
        this._length = 0;
        this.notify();
    }

    protected synchronized void moreData(long timeout) throws IOException {
        if (this._length == 0) {
            Debug.println(this, "asking for MORE data");
            this.flush(2);
        } else {
            try {
                this.wait(timeout);
            }
            catch (InterruptedException interruptedException) {}
            if (this._length != 0) {
                ErrorMessage.raiseIOException("JZ0T3");
            }
        }
    }

    public void write(int b) throws IOException {
        Debug.assert(this, false);
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        Debug.println(this, "write " + len + " bytes");
        while (len > 0) {
            int toWrite = 4096 - this._length;
            if (toWrite < len) {
                len -= toWrite;
                System.arraycopy(b, off, this._buf, this._length, toWrite);
                this._length += toWrite;
                this.flush(1);
                continue;
            }
            System.arraycopy(b, off, this._buf, this._length, len);
            this._length += len;
            len = 0;
        }
    }
}

