/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.ovm.mgr.ws.client;

import com.oracle.ovm.mgr.ws.WsException_Exception;
import com.oracle.ovm.mgr.ws.client.OvmWsClient;
import com.oracle.ovm.mgr.ws.client.OvmWsRestClient;
import com.oracle.ovm.mgr.ws.model.BaseObject;
import com.oracle.ovm.mgr.ws.model.Event;
import com.oracle.ovm.mgr.ws.model.Id;
import com.oracle.ovm.mgr.ws.model.Job;
import com.oracle.ovm.mgr.ws.model.WsException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.List;

public final class OvmWsClientTools {
    private static final Long JOB_WAIT_SLEEP_MS = 250L;

    private OvmWsClientTools() {
    }

    public static <T extends BaseObject> Event getLatestEvent(OvmWsClient api, T object, String eventType, Event.EventSeverity eventSeverity) throws WsException {
        OvmWsClientTools.nullCheck(object, "object");
        OvmWsClientTools.nullCheck(api, "api");
        Event event = null;
        List<Event> events = api.eventGetAll(object.getId(), eventType, eventSeverity, false, 0L, 0L, true, 1);
        if (events != null && !events.isEmpty()) {
            event = events.get(0);
        }
        return event;
    }

    public static <T extends BaseObject<T>> T refresh(OvmWsClient api, T object) throws Exception {
        OvmWsClientTools.nullCheck(object, "object");
        OvmWsClientTools.nullCheck(api, "api");
        object = OvmWsClientTools.getById(api, object.getId(), object.getClass());
        return object;
    }

    public static <T extends BaseObject<T>> T findObject(OvmWsClient api, String wsClassName, String uuid) throws Exception {
        OvmWsClientTools.nullCheck(api, "api");
        OvmWsClientTools.nullCheck(wsClassName, "wsClassName");
        OvmWsClientTools.nullCheck(uuid, "uuid");
        Class<?> clazz = null;
        if (!wsClassName.contains("com.oracle.ovm.mgr.ws.model")) {
            wsClassName = "com.oracle.ovm.mgr.ws.model." + wsClassName;
        }
        clazz = Class.forName(wsClassName);
        Id id = new Id();
        id.setType(clazz);
        id.setValue(uuid);
        if (api instanceof OvmWsRestClient) {
            String uriStr = ((OvmWsRestClient)api).getBaseURI().toString() + "/" + clazz.getSimpleName() + "/" + uuid;
            URI uri = new URI(uriStr);
            id.setUri(uri);
        }
        Object foundObject = OvmWsClientTools.getById(api, id, clazz);
        return foundObject;
    }

    public static Job jobWait(OvmWsClient api, Id<Job> jobId, int timeoutSecs, boolean abortOnTimeout) throws WsException, WsException_Exception {
        return OvmWsClientTools.jobWait(api, jobId, timeoutSecs, abortOnTimeout, false);
    }

    public static Job jobWaitForChildren(OvmWsClient api, Id<Job> jobId, int timeoutSecs, boolean abortOnTimeout) throws WsException, WsException_Exception {
        return OvmWsClientTools.jobWait(api, jobId, timeoutSecs, abortOnTimeout, true);
    }

    private static Job jobWait(OvmWsClient api, Id<Job> jobId, int timeoutSecs, boolean abortOnTimeout, boolean waitForChildren) throws WsException, WsException_Exception {
        OvmWsClientTools.nullCheck(api, "api");
        OvmWsClientTools.nullCheck(jobId, "jobId");
        Long timeoutMs = (long)timeoutSecs * 1000L;
        Job job = null;
        boolean timedOut = false;
        boolean isDone = false;
        while (!timedOut && !isDone) {
            job = api.jobGetById(jobId);
            isDone = waitForChildren ? job.isSummaryDone() : job.isDone();
            if (isDone || timeoutSecs <= 0) continue;
            if ((timeoutMs = Long.valueOf(timeoutMs - JOB_WAIT_SLEEP_MS)) <= 0L) {
                timedOut = true;
                continue;
            }
            try {
                Thread.sleep(JOB_WAIT_SLEEP_MS);
            }
            catch (InterruptedException e) {}
        }
        if (timedOut && abortOnTimeout) {
            api.jobAbort(jobId);
        }
        return job;
    }

    private static String makeInitialLowerCase(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() <= 1) {
            return s.toLowerCase();
        }
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    private static void nullCheck(Object param, String name) {
        if (param == null) {
            throw new IllegalArgumentException(name + " is null");
        }
        if (param instanceof String && ((String)param).isEmpty()) {
            throw new IllegalArgumentException(name + " is empty string");
        }
    }

    private static <T extends BaseObject<T>> T getById(OvmWsClient api, Id<T> id, Class<T> wsClass) throws Exception {
        String classUnderTestName = wsClass.getSimpleName();
        String methodName = OvmWsClientTools.makeInitialLowerCase(classUnderTestName) + "GetById";
        Method getMethod = api.getClass().getMethod(methodName, Id.class);
        return (T)((BaseObject)getMethod.invoke((Object)api, id));
    }
}

