/*
 * Decompiled with CFR 0.152.
 */
package eGTTIntegration;

import com.sforce.soap.BMCRF_EG_WebService.Connector;
import com.sforce.soap.BMCRF_EG_WebService.CreateIncidentResponse;
import com.sforce.soap.BMCRF_EG_WebService.ResolveIncidentResponse;
import com.sforce.soap.BMCRF_EG_WebService.SoapConnection;
import com.sforce.soap.BMCRF_EG_WebService.UpdateIncidentResponse;
import com.sforce.soap.partner.GetUserInfoResult;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.ws.ConnectionException;
import com.sforce.ws.ConnectorConfig;
import eGTTIntegration.TTIntegrationWrapper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;

public class SalesForceIntegrator
extends TTIntegrationWrapper {
    PartnerConnection connection;
    SoapConnection EGConnection;
    String url = "";
    String authEndPoint = "";
    String sessionID = "";
    String serviceEndPoint = "";
    String username = "";
    String password = "";
    String criticalCustomLabel = "";
    String majorCustomLabel = "";
    String minorCustomLabel = "";
    String hostName = "";
    String outputXML = "";
    String createIncidentFormat = "";
    String updateIncidentFormat = "";
    String closeIncidentFormat = "";
    String sessionTimeOutStr = "";
    String proxyHost = "";
    String proxyUser = "";
    String proxyPassword = "";
    int proxyPort = 0;
    long sessionTimeOut = 0L;
    long lastTimeSessionID = new Date().getTime();

    public SalesForceIntegrator(Hashtable hashtable) {
        this.setInitParams(hashtable);
    }

    public boolean login() {
        StringWriter stringWriter;
        boolean bl = false;
        ConnectorConfig connectorConfig = new ConnectorConfig();
        connectorConfig.setUsername("");
        connectorConfig.setPassword("");
        try {
            ConnectorConfig connectorConfig2 = new ConnectorConfig();
            connectorConfig2.setUsername(this.username);
            connectorConfig2.setPassword(this.password);
            if (this.proxyHost != null && this.proxyHost.length() > 0 && !this.proxyHost.equalsIgnoreCase("none") && this.proxyPort != 0) {
                connectorConfig2.setProxy(this.proxyHost, this.proxyPort);
                connectorConfig.setProxy(this.proxyHost, this.proxyPort);
            }
            if (this.proxyUser != null && this.proxyUser.length() > 0 && this.proxyPassword != null && this.proxyPassword.length() > 0 && !this.proxyUser.equalsIgnoreCase("none") && !this.proxyPassword.equalsIgnoreCase("none")) {
                connectorConfig2.setProxyUsername(this.proxyUser);
                connectorConfig2.setProxyPassword(this.proxyPassword);
                connectorConfig.setProxyUsername(this.proxyUser);
                connectorConfig.setProxyPassword(this.proxyPassword);
            }
            connectorConfig2.setAuthEndpoint(this.authEndPoint);
            this.connection = new PartnerConnection(connectorConfig2);
            this.printUserInfo(connectorConfig2);
            bl = true;
        }
        catch (Throwable throwable) {
            stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            this.sop("Unable to login in SalesForce Remedy account ---->" + throwable.toString());
        }
        try {
            if (this.EGConnection != null) {
                this.EGConnection.clearSessionHeader();
                this.EGConnection.clearExtraHeaders();
            }
            if (bl) {
                if (this.EGConnection == null) {
                    this.EGConnection = Connector.newConnection((ConnectorConfig)connectorConfig);
                }
                this.EGConnection.setSessionHeader(this.sessionID);
            }
        }
        catch (Throwable throwable) {
            stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            this.sop("Unable to make SoapConnection with eG web service ---->" + throwable.toString());
        }
        return bl;
    }

    public void updateInitParams(Hashtable hashtable) {
        this.setInitParams(hashtable);
    }

    public void setInitParams(Hashtable hashtable) {
        this.url = (String)hashtable.get("url");
        this.authEndPoint = (String)hashtable.get("partnerurl");
        this.username = (String)hashtable.get("user");
        this.password = (String)hashtable.get("password");
        this.criticalCustomLabel = (String)hashtable.get("criticalCustomLabel");
        this.majorCustomLabel = (String)hashtable.get("majorCustomLabel");
        this.minorCustomLabel = (String)hashtable.get("minorCustomLabel");
        this.hostName = (String)hashtable.get("hostName");
        this.outputXML = (String)hashtable.get("outputXML");
        this.createIncidentFormat = (String)hashtable.get("createIncidentFormat");
        this.updateIncidentFormat = (String)hashtable.get("updateIncidentFormat");
        this.closeIncidentFormat = (String)hashtable.get("closeIncidentFormat");
        this.sessionTimeOutStr = (String)hashtable.get("sessionTimeOut");
        this.proxyHost = (String)hashtable.get("proxyHost");
        String string = (String)hashtable.get("proxyPort");
        if (string != null && !string.equals("") && !string.equalsIgnoreCase("none")) {
            this.proxyPort = Integer.parseInt(string);
        }
        this.proxyUser = (String)hashtable.get("proxyUser");
        this.proxyPassword = (String)hashtable.get("proxyPassword");
        if (this.sessionTimeOutStr != null && !this.sessionTimeOutStr.equals("")) {
            this.sessionTimeOut = Long.parseLong(this.sessionTimeOutStr) * 60000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFormattedOutput(String string, Object[] objectArray) {
        String string2 = string;
        try {
            String string3 = (String)objectArray[0];
            String string4 = (String)objectArray[2];
            String string5 = (String)objectArray[3];
            String string6 = (String)objectArray[4];
            String string7 = (String)objectArray[5];
            String string8 = (String)objectArray[6];
            String string9 = (String)objectArray[8];
            String string10 = (String)objectArray[9];
            String string11 = "";
            if (string3 != null && string3.equalsIgnoreCase("critical")) {
                string11 = this.criticalCustomLabel;
            } else if (string3 != null && string3.equalsIgnoreCase("major")) {
                string11 = this.majorCustomLabel;
            } else if (string3 != null && string3.equalsIgnoreCase("minor")) {
                string11 = this.minorCustomLabel;
            } else if (string3 != null && string3.equalsIgnoreCase("normal")) {
                string11 = "Normal";
            }
            if (string9 == null || string9.equals("")) {
                string9 = "NONE";
            }
            string2 = this.replace(string2, "$user", string9);
            string2 = this.replace(string2, "$cname", string6);
            string2 = this.replace(string2, "$ctype", string5);
            string2 = this.replace(string2, "$prior", string11);
            string2 = this.replace(string2, "$pdesc", string8);
            string2 = this.replace(string2, "$layer", string7);
            string2 = this.replace(string2, "$alarmid", string10);
            string2 = this.replace(string2, "$Service", string4);
            return string2;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            return string2;
        }
    }

    public void validateSessionID() {
        if (new Date().getTime() - this.lastTimeSessionID > this.sessionTimeOut || this.sessionID == null || this.sessionID.equals("")) {
            this.login();
        }
    }

    public String createTicket(Object[] objectArray) throws Exception {
        String string;
        block7: {
            string = null;
            try {
                String string2;
                String string3;
                String string4;
                CreateIncidentResponse createIncidentResponse;
                String string5;
                boolean bl;
                String string6;
                block8: {
                    if (objectArray == null) break block7;
                    this.validateSessionID();
                    string6 = (String)objectArray[0];
                    String string7 = (String)objectArray[9];
                    if (string6.equalsIgnoreCase("Normal")) break block7;
                    bl = false;
                    string5 = this.getFormattedOutput(this.createIncidentFormat, objectArray);
                    createIncidentResponse = null;
                    string4 = "";
                    string3 = "";
                    try {
                        createIncidentResponse = this.EGConnection.CreateIncident(string5, string6, "EG", "");
                        string = createIncidentResponse.getIncidentId();
                        string4 = createIncidentResponse.getErrorMessage();
                        string3 = createIncidentResponse.getSuccess();
                    }
                    catch (Exception exception) {
                        string2 = exception.toString();
                        if (string2.indexOf("INVALID_SESSION_ID") <= -1) break block8;
                        bl = true;
                    }
                }
                if (bl) {
                    this.login();
                    createIncidentResponse = this.EGConnection.CreateIncident(string5, string6, "EG", "");
                    string = createIncidentResponse.getIncidentId();
                    string4 = createIncidentResponse.getErrorMessage();
                    string3 = createIncidentResponse.getSuccess();
                }
                String string8 = (String)objectArray[2];
                string2 = (String)objectArray[3];
                String string9 = (String)objectArray[4];
                String string10 = (String)objectArray[5];
                String string11 = (String)objectArray[6];
                if (string3 != null && string3.equalsIgnoreCase("true")) {
                    this.sop("INFO : Ticket has been created.Ticket Details-> Ticket Number : " + string + " Priority : " + string6 + " Component Type : " + string2 + " Component name : " + string9 + " Layer : " + string10 + " Description : " + string5);
                } else {
                    this.sop("Unable to create Ticket---->" + string4);
                    this.sop("The Failed to create Ticket.The Details are Priority : " + string6 + " Component Type : " + string2 + " Component name : " + string9 + " Layer : " + string10 + " Description : " + string5);
                }
            }
            catch (Throwable throwable) {
                StringWriter stringWriter = new StringWriter();
                throwable.printStackTrace(new PrintWriter(stringWriter));
                this.sop("Unable to connect eG Web Service when creating ticket ---->" + throwable.toString());
            }
        }
        return string;
    }

    public boolean closeTicket(String string, Object[] objectArray) throws Exception {
        boolean bl;
        block7: {
            bl = false;
            try {
                String string2;
                String string3;
                ResolveIncidentResponse resolveIncidentResponse;
                String string4;
                boolean bl2;
                String string5;
                String string6;
                String string7;
                String string8;
                block8: {
                    if (objectArray == null) break block7;
                    string8 = (String)objectArray[0];
                    String string9 = (String)objectArray[2];
                    string7 = (String)objectArray[3];
                    string6 = (String)objectArray[4];
                    string5 = (String)objectArray[5];
                    String string10 = (String)objectArray[6];
                    String string11 = (String)objectArray[9];
                    this.validateSessionID();
                    bl2 = false;
                    string4 = this.getFormattedOutput(this.closeIncidentFormat, objectArray);
                    String string12 = (String)objectArray[0];
                    resolveIncidentResponse = null;
                    string3 = "";
                    string2 = "";
                    try {
                        resolveIncidentResponse = this.EGConnection.ResolveIncident(string, string4, "", "EG");
                        System.out.println("Incident Closed with Id: " + resolveIncidentResponse.getIncidentId());
                        System.out.println("Incident Closed with errorMessage: " + resolveIncidentResponse.getErrorMessage());
                        System.out.println("Incident Closed with success: " + resolveIncidentResponse.getSuccess());
                        string3 = resolveIncidentResponse.getErrorMessage();
                        string2 = resolveIncidentResponse.getSuccess();
                    }
                    catch (Exception exception) {
                        String string13 = exception.toString();
                        if (string13.indexOf("INVALID_SESSION_ID") <= -1) break block8;
                        bl2 = true;
                    }
                }
                if (bl2) {
                    this.login();
                    resolveIncidentResponse = this.EGConnection.ResolveIncident(string, string4, "", "EG");
                    System.out.println("Incident Closed with Id: " + resolveIncidentResponse.getIncidentId());
                    System.out.println("Incident Closed with errorMessage: " + resolveIncidentResponse.getErrorMessage());
                    System.out.println("Incident Closed with success: " + resolveIncidentResponse.getSuccess());
                    string3 = resolveIncidentResponse.getErrorMessage();
                    string2 = resolveIncidentResponse.getSuccess();
                }
                if (string2 != null && string2.equalsIgnoreCase("true")) {
                    bl = true;
                    this.sop("INFO : Ticket has been Closed.Ticket Details-> Ticket Number : " + string + " Priority : " + string8 + " Component Type : " + string7 + " Component name : " + string6 + " Layer : " + string5 + " Description : " + string4);
                } else {
                    this.sop("Unable to close the Ticket---->" + string3);
                    this.sop("The Failed Closed Ticket Details are Ticket Number : " + string + " Priority : " + string8 + " Component Type : " + string7 + " Component name : " + string6 + " Layer : " + string5 + " Description : " + string4);
                }
            }
            catch (Throwable throwable) {
                StringWriter stringWriter = new StringWriter();
                throwable.printStackTrace(new PrintWriter(stringWriter));
                this.sop("Unable to connect eG Web Service when closing Ticket ---->" + throwable.toString());
            }
        }
        return bl;
    }

    public boolean updateTicket(String string, Object[] objectArray) throws Exception {
        boolean bl;
        block8: {
            bl = false;
            try {
                String string2;
                String string3;
                UpdateIncidentResponse updateIncidentResponse;
                String string4;
                String string5;
                boolean bl2;
                String string6;
                String string7;
                String string8;
                block9: {
                    if (objectArray == null) break block8;
                    String string9 = (String)objectArray[2];
                    string8 = (String)objectArray[3];
                    string7 = (String)objectArray[4];
                    string6 = (String)objectArray[5];
                    String string10 = (String)objectArray[6];
                    String string11 = (String)objectArray[9];
                    this.validateSessionID();
                    bl2 = false;
                    string5 = this.getFormattedOutput(this.updateIncidentFormat, objectArray);
                    string4 = (String)objectArray[0];
                    if (string4 != null && string4.equalsIgnoreCase("normal")) {
                        bl = this.closeTicket(string, objectArray);
                        break block8;
                    }
                    updateIncidentResponse = null;
                    string3 = "";
                    string2 = "";
                    try {
                        updateIncidentResponse = this.EGConnection.UpdateIncident(string, string4, string5);
                        System.out.println("Incident Update with Id: " + updateIncidentResponse.getIncidentId());
                        System.out.println("Incident Update with errorMessage: " + updateIncidentResponse.getErrorMessage());
                        System.out.println("Incident Update with success: " + updateIncidentResponse.getSuccess());
                        string3 = updateIncidentResponse.getErrorMessage();
                        string2 = updateIncidentResponse.getSuccess();
                    }
                    catch (Exception exception) {
                        String string12 = exception.toString();
                        if (string12.indexOf("INVALID_SESSION_ID") <= -1) break block9;
                        bl2 = true;
                    }
                }
                if (bl2) {
                    this.login();
                    updateIncidentResponse = this.EGConnection.UpdateIncident(string, string4, string5);
                    string3 = updateIncidentResponse.getErrorMessage();
                    string2 = updateIncidentResponse.getSuccess();
                }
                if (string2 != null && string2.equalsIgnoreCase("true")) {
                    bl = true;
                    this.sop("INFO : Ticket has been updated.Ticket Details-> Ticket Number : " + string + " Priority : " + string4 + " Component Type : " + string8 + " Component name : " + string7 + " Layer : " + string6 + " Description : " + string5);
                } else {
                    this.sop("Unable to update the Ticket---->" + string3);
                    this.sop("The Failed Update Ticket Details are Ticket Number : " + string + " Priority : " + string4 + " Component Type : " + string8 + " Component name : " + string7 + " Layer : " + string6 + " Description : " + string5);
                }
            }
            catch (Throwable throwable) {
                StringWriter stringWriter = new StringWriter();
                throwable.printStackTrace(new PrintWriter(stringWriter));
                this.sop("Unable to connect eG Web Service when Updating ticket ---->" + throwable.toString());
            }
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        try {
            SalesForceIntegrator salesForceIntegrator = new SalesForceIntegrator(new Hashtable());
            Object[] objectArray = new Object[]{"Major", "eGWebsite", "8", "Apache Web", "eg:9783", "Network", "Network Down", new HashSet(), "12/04/2014 17:03", "sSFDsAF"};
            System.out.println("Calling create Ticket and ID is ----> ");
            String string = salesForceIntegrator.createTicket(objectArray);
            Thread.sleep(5000L);
            Object[] objectArray2 = new Object[]{"Critical", "eGWebsite", "8", "Apache", "eg:9783", "Network", "Network Down", new HashSet(), "12/04/2014 17:13", "sSFDsAF"};
            salesForceIntegrator.updateTicket(string, objectArray2);
            Thread.sleep(5000L);
            Object[] objectArray3 = new Object[]{"minor", "eGWebsite", "8", "Apache", "eg:9783", "Network", "Network Down", new HashSet(), "12/04/2014 17:23", "sSFDsAF"};
            salesForceIntegrator.updateTicket(string, objectArray3);
            Thread.sleep(5000L);
            Object[] objectArray4 = new Object[]{"minor", "eGWebsite", "8", "Apache", "eg:9783", "Network", "Network Down", new HashSet(), "12/04/2014 17:33", "sSFDsAF"};
            salesForceIntegrator.updateTicket(string, objectArray4);
            Object[] objectArray5 = new Object[]{"normal", "eGWebsite", "8", "Apache", "eg:9783", "Network", "Network Down", new HashSet(), "12/04/2014 17:33", "sSFDsAF"};
            salesForceIntegrator.updateTicket(string, objectArray5);
            Object[] objectArray6 = new Object[]{"critical", "eGWebsite", "8", "Apache", "eg:9783", "Network", "Network Down", new HashSet(), "12/04/2014 17:33", "sSFDsAF"};
            string = salesForceIntegrator.createTicket(objectArray6);
            System.out.println("TicketID is ----> " + string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void printUserInfo(ConnectorConfig connectorConfig) {
        try {
            GetUserInfoResult getUserInfoResult = this.connection.getUserInfo();
            this.sop("\nLogging in ...\n");
            this.sop("UserID: " + getUserInfoResult.getUserId());
            this.sop("User Full Name: " + getUserInfoResult.getUserFullName());
            this.sop("User Email: " + getUserInfoResult.getUserEmail());
            this.sop("SessionID: " + connectorConfig.getSessionId());
            this.sop("Auth End Point: " + connectorConfig.getAuthEndpoint());
            this.sop("Service End Point: " + connectorConfig.getServiceEndpoint());
            this.sessionID = connectorConfig.getSessionId();
            this.serviceEndPoint = connectorConfig.getServiceEndpoint();
            this.lastTimeSessionID = new Date().getTime();
        }
        catch (ConnectionException connectionException) {
            connectionException.printStackTrace();
        }
    }

    private void logout() {
        try {
            this.connection.logout();
            this.sop("Logged out.");
        }
        catch (ConnectionException connectionException) {
            connectionException.printStackTrace();
        }
    }
}

