/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.BarChartRenderer;
import com.objectplanet.chart.Chart;
import com.objectplanet.chart.ChartSample;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;

public class BarChart
extends Chart {
    public static final int SIDE_BY_SIDE_BARS = 0;
    public static final int STACKED_BARS = 1;
    public static final int BEHIND_BARS = 2;
    public static final int BLOCK = 0;
    public static final int CYLINDER = 1;
    private Color[] ci;
    private boolean cf;
    private boolean cg;
    private Color cl;
    private boolean cj;
    private double cm;
    private int ck;
    private int ch;

    public BarChart() {
        this(1);
    }

    public BarChart(int n) {
        this(n, 100.0);
    }

    public BarChart(int n, double d) {
        this(n, d, 0.0);
    }

    public BarChart(int n, double d, double d2) {
        this(1, n, d, d2);
    }

    public BarChart(int n, int n2, double d, double d2) {
        super(n2);
        this.renderer = new BarChartRenderer(this);
        this.chartType = "bar";
        this.ci = new Color[n2];
        this.setAutomaticRepaintOn(false);
        this.setSeriesCount(n);
        this.grid.setRange(0, d);
        this.grid.setLowerRange(0, d2);
        this.grid.setCurrentRange(0, d);
        this.grid.setCurrentLowerRange(0, d2);
        this.cf = false;
        this.bz = 1;
        this.by = 1;
        this.bG = 1;
        this.cg = true;
        this.cj = false;
        this.cm = 0.4;
        this.ck = 0;
        this.u = false;
        this.cl = null;
        this.bA = false;
        this.setAutomaticRepaintOn(true);
    }

    public void reset() {
        super.reset();
        this.cf = false;
        this.bG = 1;
        this.by = 1;
        this.bz = 1;
        this.cg = true;
        this.cj = false;
        this.cm = 0.4;
        this.ck = 0;
        this.u = false;
        this.cl = null;
        this.bA = false;
    }

    protected double getHighestValue(int n) {
        if (this.ck == 1 && this.getSeriesRange(0) == n) {
            double d = super.getHighestValue(n);
            int n2 = this.getSampleCount();
            int n3 = this.getSeriesCount();
            for (int i = 0; i < n2; ++i) {
                double d2 = 0.0;
                for (int j = 0; j < n3; ++j) {
                    ChartSample chartSample = this.getSample(j, i);
                    if (chartSample == null || chartSample.value == null || chartSample.value.isNaN() || !(chartSample.value > 0.0)) continue;
                    d2 += chartSample.value.doubleValue();
                }
                d = Math.max(d, d2);
            }
            return d;
        }
        return super.getHighestValue(n);
    }

    protected double getLowestValue(int n) {
        if (this.ck == 0) {
            return super.getLowestValue(n);
        }
        double d = super.getLowestValue(n);
        int n2 = this.getSampleCount();
        int n3 = this.getSeriesCount();
        for (int i = 0; i < n2; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < n3; ++j) {
                ChartSample chartSample = this.getSample(j, i);
                if (chartSample == null || chartSample.value == null || chartSample.value.isNaN() || !(chartSample.value < 0.0)) continue;
                d2 += chartSample.value.doubleValue();
            }
            d = Math.min(d, d2);
        }
        return d;
    }

    public int getValuePosition(double d) {
        return this.grid.a(0, d, this.getGraphBounds());
    }

    public void setMultiColorOn(boolean bl) {
        if (bl != this.cf) {
            this.cf = bl;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public boolean isMultiColorOn() {
        return this.cf;
    }

    public void setBarLabels(String[] stringArray) {
        this.bE = stringArray;
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public String[] getBarLabels() {
        if (this.bE != null) {
            return this.bE;
        }
        return this.getSampleLabels();
    }

    public void setBarLabelsOn(boolean bl) {
        this.bN = bl;
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public boolean isBarLabelsOn() {
        return this.bN;
    }

    public synchronized void setBarLabelColor(int n, Color color) {
        try {
            this.ci[n] = color;
            this.autoRepaint();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid sample index: " + n);
        }
    }

    public Color getBarLabelColor(int n) {
        if (this.bE != null && n < this.ci.length) {
            return this.ci[n];
        }
        return null;
    }

    public void setBarOutlineOn(boolean bl) {
        if (this.cg != bl) {
            this.cg = bl;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public boolean isBarOutlineOn() {
        return this.cg;
    }

    public void setBarOutlineColor(Color color) {
        if (color != this.cl) {
            this.cl = color;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public Color getBarOutlineColor() {
        return this.cl;
    }

    public void setBarAlignment(int n) {
        this.grid.setGridAlignment(n);
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public int getGridAlignment() {
        return this.grid.getGridAlignment();
    }

    public void setBarType(int n) {
        if (n != this.ck) {
            if (n == 0 || n == 1 || n == 2) {
                this.ck = n;
                this.needRender = true;
                this.needChartCalculation = true;
                this.autoRepaint();
            } else {
                throw new IllegalArgumentException("Invalid bar type: " + n);
            }
        }
    }

    public int getBarType() {
        return this.ck;
    }

    public void setBarShape(int n) {
        if (n != this.ch) {
            if (n == 1 || n == 0) {
                this.ch = n;
                this.needRender = true;
                this.needChartCalculation = true;
                this.autoRepaint();
            } else {
                throw new IllegalArgumentException("Invalid bar shape: " + n);
            }
        }
    }

    public int getBarShape() {
        return this.ch;
    }

    public void setAutoLabelSpacingOn(boolean bl) {
        if (bl != this.cj) {
            this.cj = bl;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public boolean isAutoLabelSpacingOn() {
        return this.cj;
    }

    public void setBarWidth(double d) {
        if (d != this.cm) {
            d = Math.max(0.0, d);
            this.cm = d = Math.min(1.0, d);
            this.needRender = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public double getBarWidth() {
        return this.cm;
    }

    public Rectangle getBarBounds(int n, int n2) {
        return ((BarChartRenderer)this.renderer).if(n, n2);
    }

    public void setMultiSeriesOn(boolean bl) {
        if (bl != this.u) {
            this.u = bl;
            this.needRender = true;
            this.needGraphBounds = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public boolean isMultiSeriesOn() {
        return this.u;
    }

    public String[] getLegendLabels() {
        String[] stringArray = this.legend.getLegendLabels();
        if (stringArray != null) {
            return stringArray;
        }
        if (this.getSeriesCount() > 1 || this.ck == 1 || this.u) {
            return this.getSeriesLabels();
        }
        return this.getSampleLabels();
    }

    protected void checkDataIntegrity() {
        super.checkDataIntegrity();
        this.renderer.checkDataIntegrity();
        int n = this.chartData.getSampleCount();
        if (n != this.ci.length) {
            this.needRender = true;
            Color[] colorArray = new Color[n];
            int n2 = Math.min(n, this.ci.length);
            System.arraycopy(this.ci, 0, colorArray, 0, n2);
            this.ci = colorArray;
        }
    }

    public ChartSample checkSelection(Point point) {
        return this.renderer.checkSelection(point);
    }
}

