/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart.ext;

import com.objectplanet.chart.ChartRenderer;
import com.objectplanet.chart.ChartSample;
import com.objectplanet.chart.Grid;
import com.objectplanet.chart.ext.PlotterChart;
import com.objectplanet.chart.ext.PlotterGrid;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.util.Enumeration;

public class PlotterChartRenderer
extends ChartRenderer {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int TOP = 2;
    public static final int BOTTOM = 3;
    private boolean adjustingUpper;
    private boolean adjustingLower;
    private boolean slidingAdjuster;
    private int lastAdjusterClick;
    private int adjusterIndex;
    private Rectangle[] rangeAdjusterBounds;
    private Rectangle mouseBox;
    private boolean zoomOutPushed;
    private int mousePressX;
    private int mousePressY;
    private Rectangle graphBounds;
    Rectangle chartDataBounds;
    private int gridEdgeToAdjust;
    long lastClickTime;
    private final double[] STEPS = new double[]{1.0, 2.0, 2.5, 5.0};
    protected PlotterChart chart;

    public PlotterChartRenderer(PlotterChart chart) {
        super(chart);
        this.chart = chart;
        this.legend = chart.getLegend();
        this.gridRenderer = chart.getGridRenderer();
        this.legendRenderer = chart.getLegendRenderer();
        this.rangeAdjusterBounds = new Rectangle[4];
        this.rangeAdjusterBounds[1] = new Rectangle();
        this.rangeAdjusterBounds[3] = new Rectangle();
        this.adjusterIndex = -1;
        this.mousePressX = -1;
        this.mousePressY = -1;
    }

    public void reset() {
        this.rangeAdjusterBounds = new Rectangle[4];
        this.rangeAdjusterBounds[1] = new Rectangle();
        this.rangeAdjusterBounds[3] = new Rectangle();
        this.adjusterIndex = -1;
        this.mousePressX = -1;
        this.mousePressY = -1;
    }

    protected void calculateGraphBounds(Rectangle gridBounds) {
        this.legendRenderer.calculateGraphBounds(this.legend, gridBounds);
        int left = 0;
        int right = 0;
        int top = 0;
        int bottom = 0;
        FontMetrics fm = this.getFontMetrics(this.getFont("rangeLabelFont"));
        top += this.getRangeWidth(2, true);
        bottom += this.getRangeWidth(3, true);
        left += this.getRangeWidth(0, true);
        right += this.getRangeWidth(1, true);
        if (this.chart.isRangeOn(2) || this.chart.isRangeOn(3) && !this.chart.isRangeOn(1)) {
            right += 5;
        }
        if (this.chart.isRangeOn(2) || this.chart.isRangeOn(3) && !this.chart.isRangeOn(0)) {
            left += 5;
        }
        if (this.chart.isRangeOn(1) || this.chart.isRangeOn(0) && !this.chart.isRangeOn(2)) {
            top += 5;
        }
        if (this.chart.isRangeOn(1) || this.chart.isRangeOn(0) && !this.chart.isRangeOn(3)) {
            bottom += 5;
        }
        bottom += this.getBelowLabelsHeight();
        String rangeAxisLabel = this.getLabel("rangeAxisLabel_right");
        fm = this.getFontMetrics(this.getFont("rangeAxisLabelFont"));
        int angle = this.getLabelAngle("rangeAxisLabelAngle_right");
        Dimension angledSize = this.getAngledLabelSize(this.getLabelSize(rangeAxisLabel, fm), angle);
        if (rangeAxisLabel != null) {
            right += angledSize.width + 15;
        }
        if ((rangeAxisLabel = this.getLabel("rangeAxisLabel_left")) != null) {
            angle = this.getLabelAngle("rangeAxisLabelAngle_left");
            angledSize = this.getAngledLabelSize(this.getLabelSize(rangeAxisLabel, fm), angle);
            left += angledSize.width + 15;
        }
        if ((rangeAxisLabel = this.getLabel("rangeAxisLabel_top")) != null) {
            angle = this.getLabelAngle("rangeAxisLabelAngle_top");
            angledSize = this.getAngledLabelSize(this.getLabelSize(rangeAxisLabel, fm), angle);
            top += angledSize.height + 5;
        }
        if ((rangeAxisLabel = this.getLabel("rangeAxisLabel_bottom")) != null) {
            angle = this.getLabelAngle("rangeAxisLabelAngle_bottom");
            angledSize = this.getAngledLabelSize(this.getLabelSize(rangeAxisLabel, fm), angle);
            bottom += angledSize.height + 5;
        }
        if (this.chart.isTitleOn()) {
            Dimension titleSize = this.getLabelSize(this.chart.getTitle(), this.getFontMetrics(this.getFont("titleFont")));
            top += titleSize.height - 5;
        }
        if (this.chart.isRangeOn(2) || this.chart.isRangeOn(3)) {
            fm = this.getFontMetrics(this.getFont("rangeLabelFont"));
            String prefix = this.getLabel("rangeLabelPrefix");
            String postfix = this.getLabel("rangeLabelPostfix");
            int decimals = this.chart.getXRangeDecimalCount();
            String upper = this.chart.formatRangeNumber(0, this.chart.getXUpperRange());
            String lower = this.chart.formatRangeNumber(0, this.chart.getXLowerRange());
            if (this.chart.getXUpperRange() < this.chart.getXLowerRange()) {
                upper = this.chart.formatRangeNumber(0, this.chart.getXLowerRange());
                lower = this.chart.formatRangeNumber(0, this.chart.getXUpperRange());
            }
            upper = prefix != null ? prefix + upper : upper;
            lower = prefix != null ? prefix + lower : lower;
            upper = postfix != null ? upper + postfix : upper;
            lower = postfix != null ? lower + postfix : lower;
            int upper_width = fm.stringWidth(upper);
            int lower_width = fm.stringWidth(lower);
            left = Math.max(lower_width / 2 + 2, left);
            right = Math.max(upper_width / 2 + 2, right);
        }
        Insets insets = this.chart.getGraphInsets();
        gridBounds.x = gridBounds.x + (insets.left == -1 ? left : insets.left - 5);
        gridBounds.width = gridBounds.width - (insets.left == -1 ? left : insets.left);
        gridBounds.width = gridBounds.width - (insets.right == -1 ? right : insets.right - 9);
        gridBounds.y = gridBounds.y + (insets.top == -1 ? top : insets.top - 5);
        gridBounds.height = gridBounds.height - (insets.top == -1 ? top : insets.top);
        gridBounds.height = gridBounds.height - (insets.bottom == -1 ? bottom : insets.bottom - 9);
        this.graphBounds = gridBounds;
    }

    protected void checkDataIntegrity() {
    }

    protected void calculateChartData(Rectangle gridBounds, Rectangle dataBounds) {
        this.graphBounds = gridBounds;
        this.chartDataBounds = dataBounds;
    }

    protected ChartSample checkSelection(Point point) {
        int series = this.chart.checkSelection(point);
        int sample = this.chart.mouseOverSampleIndex;
        if (series == -1 && sample == -1) {
            return null;
        }
        ChartSample chartSample = new ChartSample(sample);
        chartSample.setSeries(series);
        return chartSample;
    }

    Rectangle getGraphBounds() {
        return this.graphBounds;
    }

    protected Rectangle getDataBounds(Grid grid) {
        if (this.graphBounds == null) {
            throw new IllegalArgumentException("graphBounds is NULL");
        }
        Rectangle dataBounds = new Rectangle(this.graphBounds);
        double factor_xu = (this.chart.getXUpperRange() - this.chart.getXCurrentUpperRange()) / (this.chart.getXUpperRange() - this.chart.getXLowerRange());
        double factor_xl = (this.chart.getXCurrentLowerRange() - this.chart.getXLowerRange()) / (this.chart.getXUpperRange() - this.chart.getXLowerRange());
        double factor_yu = (this.chart.getYUpperRange() - this.chart.getYCurrentUpperRange()) / (this.chart.getYUpperRange() - this.chart.getYLowerRange());
        double factor_yl = (this.chart.getYCurrentLowerRange() - this.chart.getYLowerRange()) / (this.chart.getYUpperRange() - this.chart.getYLowerRange());
        double bounds_width = Math.round((double)this.graphBounds.width / (1.0 - factor_xu - factor_xl));
        double bounds_height = Math.round((double)this.graphBounds.height / (1.0 - factor_yu - factor_yl));
        dataBounds.width = (int)bounds_width;
        dataBounds.x = (int)((long)this.graphBounds.x - Math.round(factor_xl * bounds_width));
        dataBounds.height = (int)bounds_height;
        dataBounds.y = (int)((long)this.graphBounds.y - Math.round(factor_yu * bounds_height));
        return dataBounds;
    }

    protected void renderData(Graphics g, Rectangle gridBounds, Rectangle dataBounds) {
        this.paintSeries(g, gridBounds);
    }

    public void render(Graphics g) {
        this.render(g, true);
    }

    protected void renderOffScreen(Graphics g) {
    }

    public void paintSeries(Graphics g, Rectangle gridBounds) {
        Point p;
        int i;
        double[][] plots;
        Color plot_color;
        g.setClip(gridBounds.x, gridBounds.y, gridBounds.width, gridBounds.height);
        for (int series = 0; series < this.getSeriesCount(); ++series) {
            if (!this.chart.isSeriesOn(series)) continue;
            plot_color = this.chart.getSeriesColor(series);
            if (this.chart.isConnectedLinesOn(series)) {
                this.paintLine(g, series, plot_color, gridBounds);
            }
            plots = this.chart.getPlots(series);
            for (i = 0; plots != null && i < plots.length; ++i) {
                p = this.getPoint(plots[i][0], plots[i][1], gridBounds);
                if (p.y < gridBounds.y || p.y > gridBounds.y + gridBounds.height || p.x < gridBounds.x || p.x > gridBounds.x + gridBounds.width + 1) continue;
                this.paintPlotPoint(g, series, i, p.x, p.y, plot_color);
            }
            this.paintGridLabels(g, series, gridBounds, gridBounds);
        }
        int selectedSeries = this.chart.getSelectedSeries();
        if (selectedSeries >= 0 && selectedSeries < this.getSeriesCount() && this.chart.isSeriesOn(selectedSeries)) {
            plot_color = this.chart.getSeriesColor(selectedSeries);
            if (this.chart.isConnectedLinesOn(selectedSeries)) {
                this.paintLine(g, selectedSeries, plot_color, gridBounds);
            }
            plots = this.chart.getPlots(selectedSeries);
            for (i = 0; plots != null && i < plots.length; ++i) {
                p = this.getPoint(plots[i][0], plots[i][1], gridBounds);
                if (p.y < gridBounds.y || p.y > gridBounds.y + gridBounds.height || p.x < gridBounds.x || p.x > gridBounds.x + gridBounds.width + 1) continue;
                this.paintPlotPoint(g, selectedSeries, i, p.x, p.y, plot_color);
            }
            this.paintGridLabels(g, selectedSeries, gridBounds, gridBounds);
        }
        g.setClip(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
    }

    private void paintBelowGridLabels(Graphics g, Rectangle grid) {
        Font font = this.getFont("plotLabelFont");
        FontMetrics fm = this.getFontMetrics(font);
        g.setFont(font);
        int angle = this.getLabelAngle("plotLabelAngle");
        for (int series = 0; series < this.getSeriesCount(); ++series) {
            String[] plotLabels = this.chart.getPlotLabels(series);
            if (plotLabels == null) {
                return;
            }
            int last_label_x = Integer.MIN_VALUE;
            for (int index = 0; index < Math.min(plotLabels.length, this.chart.getPlots(series).length); ++index) {
                String label = plotLabels[index];
                Dimension labelSize = this.getLabelSize(label, fm);
                Dimension angledSize = this.getAngledLabelSize(labelSize, angle);
                if (!this.chart.isPlotLabelsOn() || this.chart.getPlotLabelStyle() != 3 && this.chart.getPlotLabelStyle() != 5) continue;
                int offset = this.chart.isRangeAdjusterOn(3) ? 8 : 0;
                int ypos = grid.y + grid.height + offset;
                int left_edge = grid.x;
                int right_edge = grid.x + grid.width;
                int xpos = this.getPoint((double)this.chart.getPlots((int)series)[index][0], (double)this.chart.getPlots((int)series)[index][1], (Rectangle)grid).x;
                if (label == null || label.length() <= 0 || xpos < left_edge || xpos > right_edge + 1) continue;
                int label_ypos = ypos + this.getRangeWidth(3, false) + 4 - offset;
                if (angle % 180 == 0) {
                    label_ypos += fm.getMaxAscent();
                }
                int label_xpos = angle % 180 == 0 ? xpos - angledSize.width / 2 : (angle % 360 > 90 && angle % 360 < 180 || angle % 360 > 270 ? xpos - angledSize.width + fm.getAscent() / 2 : xpos - fm.getAscent() / 2);
                g.setColor(this.chart.getForeground());
                if (label_xpos <= last_label_x && index != 0 && this.chart.isAutoLabelSpacingOn()) continue;
                if (label.trim().length() > 0) {
                    g.drawLine(Math.round(xpos), ypos, Math.round(xpos), ypos + 3);
                    this.paintLabel(g, label, label_xpos, label_ypos, labelSize, 0, angle, false);
                }
                last_label_x = label_xpos + angledSize.width;
            }
        }
    }

    private void paintXRangeLabels(Graphics g, Rectangle grid) {
        int label_style = this.chart.getXRangeLabelStyle();
        if (label_style == 4) {
            return;
        }
        if (label_style == 6) {
            Rectangle clip_area = new Rectangle(grid.x, 0, grid.width, Integer.MAX_VALUE);
            g.setClip(clip_area);
        }
        Font font = this.getFont("xrangelabelfont");
        FontMetrics fm = this.getFontMetrics(font);
        int angle = this.getLabelAngle("xrangelabelangle");
        int last_label_x = Integer.MIN_VALUE;
        double[] x_pos = this.chart.getXRangeLabelsPos();
        for (int index = 0; index < x_pos.length; ++index) {
            int label_x;
            int label_y;
            String label = this.chart.getXRangeLabel(x_pos[index]);
            Dimension labelSize = this.getLabelSize(label, fm);
            Dimension angledSize = this.getAngledLabelSize(labelSize, angle);
            boolean line_on = this.chart.getXRangeLabelLineOn(x_pos[index]);
            int offset = this.chart.isRangeAdjusterOn(3) ? 8 : 0;
            int ypos = grid.y + grid.height + offset;
            int left_edge = grid.x;
            int right_edge = grid.x + grid.width;
            int xpos = this.getPoint((double)x_pos[index], (double)0.0, (Rectangle)grid).x;
            if (label == null || label.length() <= 0 || xpos < left_edge || xpos > right_edge + 1) continue;
            if (this.chart.getXRangeLabelStyle() == 6) {
                label_y = grid.y;
                label_x = angle % 180 == 0 ? xpos + 3 : (angle % 360 > 90 && angle % 360 < 180 || angle % 360 > 270 ? xpos + fm.getAscent() / 2 : xpos + 1);
            } else {
                label_y = ypos + this.getRangeWidth(3, false) + 4 - offset;
                if (angle % 180 == 0) {
                    label_y += fm.getMaxAscent();
                }
                label_x = angle % 180 == 0 ? xpos - angledSize.width / 2 : (angle % 360 > 90 && angle % 360 < 180 || angle % 360 > 270 ? xpos - angledSize.width + fm.getAscent() / 2 : xpos - fm.getAscent() / 2);
            }
            g.setFont(font);
            Color color = this.chart.getXRangeLabelColor(x_pos[index]);
            if (color == null) {
                color = this.chart.getXRangeLabelsColor();
            }
            g.setColor(color);
            if (label_x <= last_label_x && index != 0 && this.chart.isAutoLabelSpacingOn() || label == null || label.trim().length() <= 0) continue;
            this.paintLabel(g, label, label_x, label_y, labelSize, 0, angle, false);
            if (label_style == 3 || label_style == 5) {
                g.drawLine(Math.round(xpos), ypos, Math.round(xpos), ypos + 3);
            }
            if (line_on) {
                g.setColor(color);
                for (int j = grid.y; j < grid.y + grid.height; j += 6) {
                    g.drawLine(xpos, j, xpos, j + Math.min(3, grid.y + grid.height - j));
                }
            }
            last_label_x = label_x + angledSize.width;
        }
        g.setClip(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
    }

    protected void paintLine(Graphics g, int series, Color color, Rectangle grid) {
        double[][] plots = this.chart.getPlots(series);
        for (int i = 0; plots != null && i < plots.length - 1; ++i) {
            double slope;
            Point start = this.getPoint(plots[i][0], plots[i][1], grid);
            Point end = this.getPoint(plots[i + 1][0], plots[i + 1][1], grid);
            boolean paint_line = grid.contains(start);
            paint_line |= grid.contains(end);
            paint_line |= start.x <= grid.x && end.x >= grid.x + grid.width;
            paint_line |= start.y <= grid.y && end.y >= grid.y + grid.height;
            if (paint_line |= start.y >= grid.y + grid.height && end.y <= grid.y) {
                g.setColor(color);
                g.drawLine(start.x, start.y, end.x, end.y);
                if (this.chart.getLineWidth(series) > 1) {
                    slope = 0.0;
                    if (end.x - start.x != 0) {
                        slope = Math.abs((double)(end.y - start.y) / (double)(end.x - start.x));
                    }
                    int side = 1;
                    for (int line_width = 2; line_width <= this.chart.getLineWidth(series); ++line_width) {
                        int offset = line_width / 2 * side;
                        if (slope <= 1.0) {
                            g.drawLine(start.x, start.y + offset, end.x, end.y + offset);
                        } else {
                            g.drawLine(start.x - offset, start.y, end.x - offset, end.y);
                        }
                        side = -side;
                    }
                }
            }
            if (series != this.chart.getSelectedSeries() || this.chart.getSelectedSample() != -1) continue;
            slope = 0.0;
            if (end.x - start.x != 0) {
                slope = Math.abs((double)(end.y - start.y) / (double)(end.x - start.x));
            }
            int offset = this.chart.getLineWidth(series) / 2 + 1;
            g.setColor(PlotterChartRenderer.getDarker(PlotterChartRenderer.getDarker(color)));
            if (slope <= 1.0) {
                g.drawLine(start.x, start.y + offset, end.x, end.y + offset);
                continue;
            }
            g.drawLine(start.x - offset, start.y, end.x - offset, end.y);
        }
    }

    protected void paintPlotPoint(Graphics g, int series, int index, int x, int y, Color color) {
        Shape clip = g.getClip();
        g.setClip(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        boolean selected = series == this.chart.getSelectedSeries() && (this.chart.getSelectedSample() == index || this.chart.getSelectedSample() == -1);
        String imageName = this.chart.getPlotImage(series);
        if (imageName == null) {
            imageName = this.chart.getPlotImage(series);
        }
        if (imageName == null) {
            imageName = this.chart.getPlotImage(-1);
        }
        if (imageName == null) {
            imageName = this.chart.getLegendImage(series);
        }
        Dimension imageSize = this.getImageSize(imageName);
        if (imageName != null && imageSize.width > 0 && imageSize.height > 0) {
            Image image = this.chart.getImage(imageName);
            if (image != null) {
                g.drawImage(image, x - imageSize.width / 2, y - imageSize.height / 2, this.chart);
            }
        } else {
            int size = this.chart.getPlotSize(series, index);
            if (size == 0) {
                size = 3;
            } else if (size < 0) {
                return;
            }
            int style = this.chart.getPlotStyle(series);
            Color chartBackground = this.chart.getChartBackground();
            g.setColor(color);
            switch (style) {
                case 0: 
                case 1: 
                case 2: {
                    if (style == 0) {
                        g.drawOval(x - size / 2, y - size / 2, size, size);
                    } else if (style == 2) {
                        if (size == 2) {
                            size = 3;
                        }
                        g.fillOval(x - size / 2, y - size / 2, size, size);
                    } else if (style == 1) {
                        g.setColor(chartBackground);
                        g.fillOval(x - size / 2, y - size / 2, size + 1, size + 1);
                        g.setColor(color);
                        g.drawOval(x - size / 2, y - size / 2, size, size);
                    }
                    if (!selected) break;
                    g.setColor(PlotterChartRenderer.getDarker(PlotterChartRenderer.getDarker(color)));
                    if (style == 2) {
                        g.drawOval(x - size / 2, y - size / 2, size - 1, size - 1);
                    } else {
                        g.drawOval(x - size / 2, y - size / 2, size, size);
                    }
                    if (size != 0 && size != 1) break;
                    g.drawLine(x, y, x, y);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    if (style == 3) {
                        g.drawRect(x - size / 2, y - size / 2, size, size);
                    } else if (style == 5) {
                        g.fillRect(x - size / 2, y - size / 2, size + 1, size + 1);
                    } else if (style == 4) {
                        g.setColor(chartBackground);
                        g.fillRect(x - size / 2, y - size / 2, size + 1, size + 1);
                        g.setColor(color);
                        g.drawRect(x - size / 2, y - size / 2, size, size);
                    }
                    if (!selected) break;
                    g.setColor(PlotterChartRenderer.getDarker(PlotterChartRenderer.getDarker(color)));
                    g.drawRect(x - size / 2 - 1, y - size / 2 - 1, size + 2, size + 2);
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    int[] xpoints = new int[4];
                    xpoints[0] = xpoints[2] = x;
                    xpoints[1] = x + size / 2;
                    xpoints[3] = x - size / 2;
                    int[] ypoints = new int[4];
                    ypoints[0] = y - size / 2;
                    ypoints[2] = y + size / 2;
                    ypoints[1] = ypoints[3] = y;
                    if (style == 7) {
                        g.setColor(chartBackground);
                        g.fillPolygon(xpoints, ypoints, 4);
                    } else if (style == 8) {
                        g.setColor(color);
                        g.fillPolygon(xpoints, ypoints, 4);
                    }
                    g.setColor(color);
                    g.drawPolygon(xpoints, ypoints, 4);
                    if (!selected) break;
                    xpoints[1] = xpoints[1] + 1;
                    xpoints[3] = xpoints[3] - 1;
                    ypoints[0] = ypoints[0] - 1;
                    ypoints[2] = ypoints[2] + 1;
                    g.setColor(PlotterChartRenderer.getDarker(PlotterChartRenderer.getDarker(color)));
                    g.drawPolygon(xpoints, ypoints, 4);
                }
            }
        }
        g.setClip(clip);
    }

    protected void paintGrid(Graphics g, Grid grid, Rectangle gridBounds) {
        Image image;
        Color chartBackground = this.chart.getChartBackground();
        Color chartBackground2 = this.chart.getChartBackground2();
        g.setColor(chartBackground);
        if (chartBackground2 != null) {
            GradientPaint gp = new GradientPaint(0.0f, gridBounds.y + gridBounds.height, chartBackground2, 0.0f, gridBounds.y, chartBackground);
            ((Graphics2D)g).setPaint(gp);
        } else {
            g.setColor(this.chart.getChartBackground());
        }
        g.fillRect(gridBounds.x, gridBounds.y, gridBounds.width, gridBounds.height);
        Point zero_point = this.getPoint(0.0, 0.0, gridBounds);
        Dimension image_size = this.getImageSize(this.chart.getGridImage());
        if (this.chart.getGridImage() != null && image_size.height > 0 && image_size.width > 0 && (image = this.chart.getImage(this.chart.getGridImage())) != null) {
            g.drawImage(image, gridBounds.x, gridBounds.y, gridBounds.width, gridBounds.height, this.chart);
        }
        if (this.chart.isRangeOn(0) || this.chart.isRangeOn(1) || this.chart.isYValueLinesOn()) {
            this.paintRange(g, gridBounds, 1);
        }
        if (this.chart.isRangeOn(2) || this.chart.isRangeOn(3) || this.chart.isXValueLinesOn()) {
            this.paintRange(g, gridBounds, 0);
        }
        if (this.chart.getGridLines() != null) {
            this.paintGridLines(g, gridBounds);
        }
        Font font = this.getFont("rangeLabelFont");
        FontMetrics fm = this.getFontMetrics(font);
        g.setFont(font);
        Enumeration e = this.chart.targetsLabel.keys();
        while (e.hasMoreElements()) {
            double value;
            String id = (String)e.nextElement();
            String target = this.chart.getTargetLabel(id);
            Double double_value = (Double)this.chart.targetsValue.get(id);
            Color color = (Color)this.chart.targetsColor.get(id);
            if (double_value == null || !((value = double_value.doubleValue()) >= this.chart.getYCurrentLowerRange() && value <= this.chart.getYCurrentUpperRange()) && (!(value <= this.chart.getYCurrentLowerRange()) || !(value >= this.chart.getYCurrentUpperRange()))) continue;
            this.paintRangeLabel(g, target, value, color, gridBounds, fm, true, 1);
        }
        g.setColor(this.chart.getChartForeground());
        g.drawRect(gridBounds.x, gridBounds.y, gridBounds.width, gridBounds.height);
        Color axis_color = this.chart.getXAxisColor();
        if (this.chart.getXAxisColor() == null) {
            axis_color = this.chart.getChartForeground().darker().darker();
        }
        g.setColor(axis_color);
        if (this.chart.isXAxisOn() && zero_point.y >= gridBounds.y && zero_point.y <= gridBounds.y + gridBounds.height) {
            g.drawLine(gridBounds.x, zero_point.y, gridBounds.x + gridBounds.width, zero_point.y);
            if (zero_point.x - gridBounds.x > 20) {
                g.drawLine(gridBounds.x, zero_point.y, gridBounds.x + 7, zero_point.y + 3);
                g.drawLine(gridBounds.x, zero_point.y, gridBounds.x + 7, zero_point.y - 3);
            }
            if (gridBounds.x + gridBounds.width - zero_point.x > 20) {
                g.drawLine(gridBounds.x + gridBounds.width, zero_point.y, gridBounds.x + gridBounds.width - 7, zero_point.y + 3);
                g.drawLine(gridBounds.x + gridBounds.width, zero_point.y, gridBounds.x + gridBounds.width - 7, zero_point.y - 3);
            }
        }
        axis_color = this.chart.getYAxisColor();
        if (this.chart.getYAxisColor() == null) {
            axis_color = this.chart.getChartForeground().darker().darker();
        }
        if (this.chart.isYAxisOn() && zero_point.x >= gridBounds.x && zero_point.x <= gridBounds.x + gridBounds.width) {
            g.setColor(axis_color);
            g.drawLine(zero_point.x, gridBounds.y, zero_point.x, gridBounds.y + gridBounds.height);
            if (zero_point.y - gridBounds.y > 20) {
                g.drawLine(zero_point.x, gridBounds.y, zero_point.x + 3, gridBounds.y + 7);
                g.drawLine(zero_point.x, gridBounds.y, zero_point.x - 3, gridBounds.y + 7);
            }
            if (gridBounds.y + gridBounds.height - zero_point.y > 20) {
                g.drawLine(zero_point.x, gridBounds.y + gridBounds.height, zero_point.x + 3, gridBounds.y + gridBounds.height - 7);
                g.drawLine(zero_point.x, gridBounds.y + gridBounds.height, zero_point.x - 3, gridBounds.y + gridBounds.height - 7);
            }
        }
        this.paintBelowGridLabels(g, gridBounds);
        this.paintXRangeLabels(g, gridBounds);
    }

    private void paintRange(Graphics g, Rectangle grid, int direction) {
        double factor_l;
        double factor_u;
        String label;
        Font font = this.getFont("rangeLabelFont");
        FontMetrics fm = this.getFontMetrics(font);
        g.setFont(font);
        if (direction == 1) {
            double value;
            label = this.chart.formatRangeNumber(1, 0.0);
            if (this.chart.getYCurrentUpperRange() > 0.0 && this.chart.getYCurrentLowerRange() < 0.0 || this.chart.getYCurrentUpperRange() < 0.0 && this.chart.getYCurrentLowerRange() > 0.0) {
                this.paintRangeLabel(g, label, 0.0, null, grid, fm, false, direction);
            }
            label = this.chart.formatRangeNumber(1, this.chart.getYCurrentUpperRange());
            this.paintRangeLabel(g, label, this.chart.getYCurrentUpperRange(), null, grid, fm, false, direction);
            label = this.chart.formatRangeNumber(1, this.chart.getYCurrentLowerRange());
            this.paintRangeLabel(g, label, this.chart.getYCurrentLowerRange(), null, grid, fm, false, direction);
            double step = this.getTickStep(this.chart.getYCurrentUpperRange() - this.chart.getYCurrentLowerRange(), this.chart.getYRangeInterval(), grid.height, fm, false);
            if (this.chart.getYCurrentUpperRange() > this.chart.getYCurrentLowerRange()) {
                for (value = Math.max(0.0, this.chart.getYCurrentLowerRange() - this.chart.getYCurrentLowerRange() % step); value < this.chart.getYCurrentUpperRange(); value += step) {
                    if (!(value > 0.0) || !(value > this.chart.getYCurrentLowerRange())) continue;
                    label = this.chart.formatRangeNumber(1, value);
                    this.paintRangeLabel(g, label, value, null, grid, fm, false, direction);
                }
                for (value = Math.min(0.0, this.chart.getYCurrentUpperRange() - this.chart.getYCurrentUpperRange() % step); value > this.chart.getYCurrentLowerRange(); value -= step) {
                    if (!(value < 0.0) || !(value < this.chart.getYCurrentUpperRange())) continue;
                    label = this.chart.formatRangeNumber(1, value);
                    this.paintRangeLabel(g, label, value, null, grid, fm, false, direction);
                }
            } else {
                for (value = Math.min(0.0, this.chart.getYCurrentLowerRange() - this.chart.getYCurrentLowerRange() % step); value > this.chart.getYCurrentUpperRange(); value -= step) {
                    if (!(value < 0.0) || !(value < this.chart.getYCurrentLowerRange())) continue;
                    label = this.chart.formatRangeNumber(1, value);
                    this.paintRangeLabel(g, label, value, null, grid, fm, false, direction);
                }
                for (value = Math.max(0.0, this.chart.getYCurrentUpperRange() - this.chart.getYCurrentUpperRange() % step); value < this.chart.getYCurrentLowerRange(); value += step) {
                    if (!(value > 0.0) || !(value > this.chart.getYCurrentUpperRange())) continue;
                    label = this.chart.formatRangeNumber(1, value);
                    this.paintRangeLabel(g, label, value, null, grid, fm, false, direction);
                }
            }
        } else if (direction == 0) {
            double value;
            label = this.chart.formatRangeNumber(0, 0.0);
            double XCurrentUpperRange = this.chart.getXCurrentUpperRange();
            double XCurrentLowerRange = this.chart.getXCurrentLowerRange();
            int XRangeDecimalCount = this.chart.getXRangeDecimalCount();
            if (XCurrentUpperRange > 0.0 && XCurrentLowerRange < 0.0 || XCurrentUpperRange < 0.0 && XCurrentLowerRange > 0.0) {
                this.paintRangeLabel(g, label, 0.0, null, grid, fm, false, direction);
            }
            label = this.chart.formatRangeNumber(0, XCurrentUpperRange);
            this.paintRangeLabel(g, label, XCurrentUpperRange, null, grid, fm, false, direction);
            label = this.chart.formatRangeNumber(0, XCurrentLowerRange);
            this.paintRangeLabel(g, label, XCurrentLowerRange, null, grid, fm, false, direction);
            double step = this.getTickStep(XCurrentUpperRange - XCurrentLowerRange, this.chart.getXRangeInterval(), grid.width, fm, true);
            if (XCurrentUpperRange >= XCurrentLowerRange) {
                for (value = Math.max(0.0, this.chart.getXCurrentLowerRange() - this.chart.getXCurrentLowerRange() % step); value < XCurrentUpperRange; value += step) {
                    if (!(value > 0.0) || !(value > XCurrentLowerRange)) continue;
                    label = this.chart.formatRangeNumber(0, value);
                    this.paintRangeLabel(g, label, value, null, grid, fm, false, direction);
                }
                for (value = Math.min(0.0, this.chart.getXCurrentUpperRange() - this.chart.getXCurrentUpperRange() % step); value > XCurrentLowerRange; value -= step) {
                    if (!(value < 0.0) || !(value < XCurrentUpperRange)) continue;
                    label = this.chart.formatRangeNumber(0, value);
                    this.paintRangeLabel(g, label, value, null, grid, fm, false, direction);
                }
            } else {
                for (value = Math.min(0.0, this.chart.getXCurrentLowerRange() - this.chart.getXCurrentLowerRange() % step); value > XCurrentUpperRange; value -= step) {
                    if (!(value < 0.0) || !(value < XCurrentLowerRange)) continue;
                    label = this.chart.formatRangeNumber(0, value);
                    this.paintRangeLabel(g, label, value, null, grid, fm, false, direction);
                }
                for (value = Math.max(0.0, this.chart.getXCurrentUpperRange() - this.chart.getXCurrentUpperRange() % step); value < XCurrentLowerRange; value += step) {
                    if (!(value > 0.0) || !(value > XCurrentUpperRange)) continue;
                    label = this.chart.formatRangeNumber(0, value);
                    this.paintRangeLabel(g, label, value, null, grid, fm, false, direction);
                }
            }
        }
        if (this.chart.isRangeAdjusterOn(1)) {
            int xpos = grid.x + grid.width + 5;
            int ypos = grid.y;
            g.setColor(this.chart.getBackground().darker());
            g.drawLine(xpos, ypos, xpos, ypos + grid.height);
            g.setColor(this.chart.getBackground().brighter());
            g.drawLine(xpos + 1, ypos, xpos + 1, ypos + grid.height);
            factor_u = 0.0;
            factor_l = 0.0;
            double YUpperRange = this.chart.getYUpperRange();
            double YLowerRange = this.chart.getYLowerRange();
            if (YUpperRange - YLowerRange != 0.0) {
                factor_u = (this.chart.getYCurrentUpperRange() - YLowerRange) / (YUpperRange - YLowerRange);
                factor_l = (this.chart.getYCurrentLowerRange() - YLowerRange) / (YUpperRange - YLowerRange);
            }
            int upper_y = (int)Math.round((double)(ypos + grid.height) - factor_u * (double)grid.height);
            int lower_y = (int)Math.round((double)(ypos + grid.height) - factor_l * (double)grid.height);
            this.rangeAdjusterBounds[1].setBounds(xpos - 3, upper_y, 7, lower_y - upper_y);
            this.paintBox(g, Color.lightGray, xpos - 3, upper_y, 6, lower_y - upper_y, false);
            g.setColor(Color.gray);
            g.drawLine(xpos - 2, upper_y + 2, xpos + 2, upper_y + 2);
            g.setColor(Color.white);
            g.drawLine(xpos - 2, lower_y - 2, xpos + 2, lower_y - 2);
        }
        if (this.chart.isRangeAdjusterOn(3)) {
            int xpos = grid.x;
            int ypos = grid.y + grid.height + 4;
            g.setColor(this.chart.getBackground().darker());
            g.drawLine(xpos, ypos, xpos + grid.width, ypos);
            g.setColor(this.chart.getBackground().brighter());
            g.drawLine(xpos, ypos + 1, xpos + grid.width, ypos + 1);
            factor_u = 0.0;
            factor_l = 0.0;
            if (this.chart.getXUpperRange() - this.chart.getXLowerRange() != 0.0) {
                factor_u = (this.chart.getXCurrentUpperRange() - this.chart.getXLowerRange()) / (this.chart.getXUpperRange() - this.chart.getXLowerRange());
                factor_l = (this.chart.getXCurrentLowerRange() - this.chart.getXLowerRange()) / (this.chart.getXUpperRange() - this.chart.getXLowerRange());
            }
            int lower_x = (int)Math.round((double)xpos + factor_l * (double)grid.width);
            int upper_x = (int)Math.round((double)xpos + factor_u * (double)grid.width);
            this.rangeAdjusterBounds[3].setBounds(lower_x, ypos - 3, upper_x - lower_x, 7);
            this.paintBox(g, Color.lightGray, lower_x, ypos - 3, upper_x - lower_x, 6, false);
            g.setColor(Color.gray);
            g.drawLine(lower_x + 2, ypos - 2, lower_x + 2, ypos + 2);
            g.setColor(Color.white);
            g.drawLine(upper_x - 2, ypos - 2, upper_x - 2, ypos + 2);
        }
        String[] positions = new String[]{"right", "left", "top", "bottom"};
        Font range_axis_label_font = this.getFont("rangeAxisLabelFont");
        fm = this.getFontMetrics(range_axis_label_font);
        g.setFont(range_axis_label_font);
        g.setColor(this.chart.getForeground());
        for (int i = 0; i < positions.length; ++i) {
            String rangeAxisLabel = this.getLabel("rangeAxisLabel_" + positions[i]);
            if (rangeAxisLabel == null) continue;
            int angle = this.getLabelAngle("rangeAxisLabelAngle_" + positions[i]);
            Dimension labelSize = this.getLabelSize(rangeAxisLabel, fm);
            Dimension angledSize = this.getAngledLabelSize(labelSize, angle);
            int label_x = -100;
            int label_y = -100;
            Color color = this.chart.getForeground();
            if (positions[i].equals("right")) {
                label_x = grid.x + grid.width + this.getRangeWidth(1, true) + 10;
                label_y = grid.y + grid.height / 2 - angledSize.height / 2;
                color = this.chart.getRangeColor(1);
            } else if (positions[i].equals("left")) {
                label_x = grid.x - angledSize.width - this.getRangeWidth(0, true) - 10;
                label_y = grid.y + grid.height / 2 - angledSize.height / 2;
                color = this.chart.getRangeColor(0);
            } else if (positions[i].equals("top")) {
                label_x = grid.x + grid.width / 2 - angledSize.width / 2;
                label_y = grid.y - angledSize.height - this.getRangeWidth(2, true) - 5;
                color = this.chart.getRangeColor(2);
            } else if (positions[i].equals("bottom")) {
                label_x = grid.x + grid.width / 2 - angledSize.width / 2;
                label_y = grid.y + grid.height + this.getRangeWidth(3, true) + 5;
                label_y += this.getBelowLabelsHeight();
                color = this.chart.getRangeColor(3);
            }
            if (angle % 180 == 0) {
                label_y += fm.getAscent();
            }
            g.setColor(color);
            this.paintLabel(g, rangeAxisLabel, label_x, label_y, labelSize, 0, angle, false);
        }
    }

    private void paintRangeLabel(Graphics g, String label, double value, Color lineColor, Rectangle grid, FontMetrics fm, boolean target, int direction) {
        if (direction == 0) {
            int label_size;
            Point pos = this.getPoint(value, this.chart.getYCurrentUpperRange(), grid);
            if (this.chart.isXValueLinesOn() || target) {
                if (lineColor != null) {
                    g.setColor(lineColor);
                } else {
                    g.setColor(this.chart.getXValueLinesColor());
                }
                for (int i = grid.y; i < grid.y + grid.height; i += 6) {
                    g.drawLine(pos.x, i, pos.x, i + Math.min(3, grid.y + grid.height - i));
                }
            }
            boolean do_paint = pos.x > grid.x + (label_size = fm.stringWidth("-" + label)) && pos.x < grid.x + grid.width - label_size;
            if (do_paint |= value == this.chart.getXCurrentUpperRange() || value == this.chart.getXCurrentLowerRange()) {
                if (this.chart.isRangeOn(2)) {
                    g.setColor(this.chart.getRangeColor(2));
                    g.drawLine(pos.x, pos.y, pos.x, pos.y - 3);
                    g.drawString(label, pos.x - fm.stringWidth(label) / 2 + 1, pos.y - 5);
                }
                if (this.chart.isRangeOn(3)) {
                    g.setColor(this.chart.getRangeColor(3));
                    pos = this.getPoint(value, this.chart.getYCurrentLowerRange(), grid);
                    if (this.chart.isRangeAdjusterOn(3)) {
                        pos.y += 8;
                    }
                    g.drawLine(pos.x, pos.y, pos.x, pos.y + 3);
                    int ypos = pos.y + fm.getHeight();
                    g.drawString(label, pos.x - fm.stringWidth(label) / 2 + 1, ypos);
                }
            }
        } else if (direction == 1) {
            int label_size;
            int i;
            Point pos = this.getPoint(this.chart.getXCurrentLowerRange(), value, grid);
            Color targetColor = lineColor;
            if (targetColor == null) {
                targetColor = this.chart.getYValueLinesColor();
            }
            if (target) {
                g.setColor(targetColor);
                for (i = grid.x; i < grid.x + grid.width; i += 12) {
                    g.drawLine(i, pos.y, i + Math.min(9, grid.x + grid.width - i), pos.y);
                }
            } else if (this.chart.isYValueLinesOn()) {
                g.setColor(this.chart.getYValueLinesColor());
                for (i = grid.x; i < grid.x + grid.width; i += 6) {
                    g.drawLine(i, pos.y, i + Math.min(3, grid.x + grid.width - i), pos.y);
                }
            }
            boolean do_paint = pos.y > grid.y + (label_size = fm.getAscent()) && pos.y < grid.y + grid.height - label_size;
            if (do_paint |= value == this.chart.getYCurrentUpperRange() || value == this.chart.getYCurrentLowerRange()) {
                if (target) {
                    g.setColor(targetColor);
                    if (this.chart.getTargetLabelsPosition() == 0) {
                        g.drawLine(pos.x, pos.y, pos.x - 3, pos.y);
                        g.drawString(label, pos.x - fm.stringWidth(label) - 4, pos.y + fm.getHeight() - fm.getAscent() + 1);
                    } else {
                        pos = this.getPoint(this.chart.getXCurrentUpperRange(), value, grid);
                        g.drawLine(pos.x, pos.y, pos.x + 3, pos.y);
                        int xpos = pos.x + 6;
                        if (this.chart.isRangeAdjusterOn(1)) {
                            xpos += 6;
                        }
                        g.drawString(label, xpos, pos.y + fm.getHeight() - fm.getAscent() + 1);
                    }
                } else {
                    if (this.chart.isRangeOn(0)) {
                        g.setColor(this.chart.getRangeColor(0));
                        g.drawLine(pos.x, pos.y, pos.x - 3, pos.y);
                        g.drawString(label, pos.x - fm.stringWidth(label) - 4, pos.y + fm.getHeight() - fm.getAscent() + 1);
                    }
                    if (this.chart.isRangeOn(1)) {
                        g.setColor(this.chart.getRangeColor(1));
                        pos = this.getPoint(this.chart.getXCurrentUpperRange(), value, grid);
                        g.drawLine(pos.x, pos.y, pos.x + 3, pos.y);
                        int xpos = pos.x + 6;
                        if (this.chart.isRangeAdjusterOn(1)) {
                            xpos += 6;
                        }
                        g.drawString(label, xpos, pos.y + fm.getHeight() - fm.getAscent() + 1);
                    }
                }
            }
        }
    }

    private void paintGridLabels(Graphics g, int series, Rectangle grid, Rectangle dataBounds) {
        Shape clip = g.getClip();
        g.setClip(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        double[][] plots = this.chart.getPlots(series);
        for (int index = 0; plots != null && index < plots.length; ++index) {
            int y_pos;
            int x_pos;
            Point p = this.getPoint(plots[index][0], plots[index][1], grid);
            boolean inside_grid = p.y >= grid.y && p.y <= grid.y + grid.height;
            if (!(inside_grid &= p.x >= grid.x && p.x <= grid.x + grid.width + 1)) continue;
            Color color = this.chart.getSeriesLabelColor(series);
            if (color == null) {
                color = this.chart.getForeground();
            }
            g.setColor(color);
            Font font = this.getFont("seriesLabelFont_" + series);
            if (font == this.chart.getFont()) {
                font = this.getFont("seriesLabelFont");
            }
            g.setFont(font);
            String label = this.constructLabel(series, index, 0);
            if (label.length() > 0) {
                Dimension labelSize = this.getLabelSize(label, g.getFontMetrics());
                int x_pos2 = p.x - labelSize.width / 2 + 1;
                int y_pos2 = p.y + labelSize.height / 2;
                this.paintLabel(g, label, x_pos2, y_pos2, labelSize, 0, 0, false);
            }
            label = this.constructLabel(series, index, 1);
            int plot_size = Math.max(1, this.chart.getPlotSize(series, index));
            if (label.length() > 0) {
                Dimension labelSize = this.getLabelSize(label, g.getFontMetrics());
                x_pos = p.x - labelSize.width / 2 + 1;
                y_pos = p.y - plot_size / 2 - 3;
                this.paintLabel(g, label, x_pos, y_pos, labelSize, 0, 0, false);
            }
            if ((label = this.constructLabel(series, index, 2)).length() <= 0) continue;
            Dimension labelSize = this.getLabelSize(label, g.getFontMetrics());
            x_pos = p.x - labelSize.width / 2 + 1;
            y_pos = p.y + labelSize.height + plot_size / 2;
            this.paintLabel(g, label, x_pos, y_pos, labelSize, 0, 0, false);
        }
        g.setClip(clip);
    }

    private void paintGridLines(Graphics g, Rectangle grid) {
        Font font = this.getFont("rangeLabelFont");
        FontMetrics fm = this.getFontMetrics(font);
        g.setFont(font);
        double[] gridLines = this.chart.getGridLines();
        for (int i = 0; i < gridLines.length; ++i) {
            if (!(gridLines[i] > 0.0) || !(gridLines[i] <= 100.0)) continue;
            double value = this.chart.getXLowerRange() + (this.chart.getXUpperRange() - this.chart.getXLowerRange()) / 100.0 * gridLines[i];
            this.paintRangeLabel(g, "", value, this.chart.getGridLineColor(i), grid, fm, true, 0);
        }
    }

    protected boolean paintFloatingLabels(Graphics g, Rectangle bounds) {
        boolean floating_on = this.chart.isPlotLabelsOn();
        floating_on |= this.chart.isXValueLabelsOn(-1) && this.chart.getValueLabelStyle() == 4;
        floating_on |= this.chart.isYValueLabelsOn(-1) && this.chart.getValueLabelStyle() == 4;
        boolean bl = this.chart.isSeriesLabelsOn() && this.chart.getSeriesLabelStyle() == 4;
        int mouseOverSeriesIndex = this.chart.mouseOverSeriesIndex;
        int mouseOverSampleIndex = this.chart.mouseOverSampleIndex;
        if ((floating_on |= bl) && (mouseOverSeriesIndex > -1 || mouseOverSampleIndex > -1)) {
            Font font = this.getFont("floatingLabelFont");
            FontMetrics fm = this.getFontMetrics(font);
            g.setFont(font);
            if (mouseOverSeriesIndex >= 0 && mouseOverSampleIndex >= 0) {
                String label = this.constructLabel(mouseOverSeriesIndex, mouseOverSampleIndex, 4);
                this.paintFloatingLabel(g, label, bounds, mouseOverSampleIndex, mouseOverSeriesIndex, font, fm);
                return true;
            }
            if (this.chart.isFloatingOnLegendOn() && mouseOverSampleIndex == -1) {
                for (int i = 0; i < this.chart.getPlots(mouseOverSeriesIndex).length; ++i) {
                    String label = this.constructLabel(mouseOverSeriesIndex, i, 4);
                    this.paintFloatingLabel(g, label, bounds, i, mouseOverSeriesIndex, font, fm);
                }
                return true;
            }
        }
        return false;
    }

    protected void paintFloatingLabel(Graphics g, String label, Rectangle gridBounds, int sample, int series, Font font, FontMetrics fm) {
        if (label == null || label.equals("")) {
            return;
        }
        double[][] plots = this.chart.getPlots(series);
        Point p = this.getPoint(plots[sample][0], plots[sample][1], gridBounds);
        if (p.x < gridBounds.x || p.x > gridBounds.x + gridBounds.width || p.y < gridBounds.y || p.y > gridBounds.y + gridBounds.height) {
            return;
        }
        Dimension labelSize = this.getLabelSize(label, fm);
        int plot_size = Math.max(1, this.chart.getPlotSize(series, sample));
        p.x -= labelSize.width / 2;
        p.y -= labelSize.height / 2 + plot_size / 2;
        p.x = Math.max(p.x, 3);
        p.x = Math.min(p.x, this.chart.getSize().width - labelSize.width - 3);
        p.y = Math.max(p.y, fm.getAscent());
        p.y = Math.min(p.y, this.chart.getSize().height - labelSize.height + fm.getAscent() - 1);
        int fheight = fm.getHeight();
        int descent = fm.getDescent();
        g.setColor(new Color(255, 255, 231));
        g.fillRect(p.x - 2, p.y - fheight + descent * 2 - 2, labelSize.width + 5, labelSize.height);
        g.setColor(PlotterChartRenderer.getDarker(this.chart.getSeriesColor(series)));
        g.drawRect(p.x - 3, p.y - fheight + descent * 2 - 3, labelSize.width + 5, labelSize.height + 1);
        g.setColor(Color.black);
        this.paintLabel(g, label, p.x, p.y, labelSize, this.chart.getMultilineLabelAlignment(), 0, false);
    }

    protected String constructLabel(int series, int sample, int style) {
        String number;
        String postfix;
        String prefix;
        String plotLabel;
        String seriesLabel;
        if (series < 0 || series >= this.getSeriesCount() || sample < 0 || sample >= this.chart.getPlots(series).length) {
            return "";
        }
        boolean plotlabels_on = this.chart.isPlotLabelsOn() && (this.chart.getPlotLabelStyle() == style || this.chart.getPlotLabelStyle() == 5 && style == 4);
        boolean series_on = this.chart.isSeriesLabelsOn() && this.chart.getSeriesLabelStyle() == style;
        boolean xvalue_on = this.chart.isXValueLabelsOn(series) && this.chart.getValueLabelStyle() == style;
        boolean yvalue_on = this.chart.isYValueLabelsOn(series) && this.chart.getValueLabelStyle() == style;
        String separator = this.chart.getComplexLabelSeparator();
        if (separator == null) {
            separator = style == 3 ? " : " : ":";
        }
        String label = "";
        if (series_on && (seriesLabel = this.chart.getSeriesLabel(series)) != null) {
            label = label + seriesLabel;
            if (!seriesLabel.endsWith("\n") && (plotlabels_on && this.chart.getPlotLabel(series, sample) != null || xvalue_on || yvalue_on)) {
                label = label + separator;
            }
        }
        if (plotlabels_on && (plotLabel = this.chart.getPlotLabel(series, sample)) != null) {
            label = label + plotLabel;
            if (!plotLabel.endsWith("\n") && (xvalue_on || yvalue_on)) {
                label = label + separator;
            }
        }
        if (xvalue_on) {
            prefix = this.getLabel("XValueLabelPrefix_" + series);
            if (prefix == null) {
                prefix = this.getLabel("XValueLabelPrefix");
            }
            if ((postfix = this.getLabel("XValueLabelPostfix_" + series)) == null) {
                postfix = this.getLabel("XValueLabelPostfix");
            }
            number = this.chart.formatNumber(this.chart.getPlots(series)[sample][0], this.chart.getXValueDecimalCount(series));
            number = prefix != null ? prefix + number : number;
            number = postfix != null ? number + postfix : number;
            label = label + number;
            if (yvalue_on) {
                label = label + " , ";
            }
        }
        if (yvalue_on) {
            prefix = this.getLabel("YValueLabelPrefix_" + series);
            if (prefix == null) {
                prefix = this.getLabel("YValueLabelPrefix");
            }
            if ((postfix = this.getLabel("YValueLabelPostfix_" + series)) == null) {
                postfix = this.getLabel("YValueLabelPostfix");
            }
            number = this.chart.formatNumber(this.chart.getPlots(series)[sample][1], this.chart.getYValueDecimalCount(series));
            number = prefix != null ? prefix + number : number;
            number = postfix != null ? number + postfix : number;
            label = label + number;
        }
        return label;
    }

    private double getTickStep(double range, double rangeInterval, int size, FontMetrics fm, boolean horizontal) {
        int count;
        int label_size;
        if (range == 0.0) {
            if (horizontal) {
                return Math.abs(this.chart.getXCurrentUpperRange());
            }
            return Math.abs(this.chart.getYCurrentUpperRange());
        }
        if (horizontal) {
            String upper_label = this.chart.formatRangeNumber(0, this.chart.getXCurrentUpperRange());
            String lower_label = this.chart.formatRangeNumber(0, this.chart.getXCurrentLowerRange());
            label_size = Math.max(fm.stringWidth(upper_label), fm.stringWidth(lower_label)) + 4;
        } else {
            label_size = fm.getHeight() + 4;
        }
        int valueLineCount = (int)Math.round((double)size / (double)label_size);
        if (horizontal) {
            if (this.chart.getXMaxValueLineCount() != -1) {
                valueLineCount = Math.min(this.chart.getXMaxValueLineCount(), valueLineCount);
            }
            count = (int)Math.round(Math.abs(this.chart.getXCurrentUpperRange() - this.chart.getXCurrentLowerRange()) * Math.pow(10.0, this.chart.getXRangeDecimalCount()));
        } else {
            if (this.chart.getYMaxValueLineCount() != -1) {
                valueLineCount = Math.min(this.chart.getYMaxValueLineCount(), valueLineCount);
            }
            count = (int)Math.round(Math.abs(this.chart.getYCurrentUpperRange() - this.chart.getYCurrentLowerRange()) * Math.pow(10.0, this.chart.getYRangeDecimalCount()));
        }
        valueLineCount = Math.min(valueLineCount, count + 1);
        valueLineCount = Math.max(1, valueLineCount);
        double step = 0.0;
        double raw_step = range / (double)valueLineCount;
        raw_step = Math.abs(raw_step);
        if (rangeInterval > 0.0) {
            step = rangeInterval;
            double multiplier = 1.0;
            while (step < raw_step) {
                for (int i = 0; i < this.STEPS.length; ++i) {
                    if (!(this.STEPS[i] * multiplier * step >= raw_step)) continue;
                    step = this.STEPS[i] * multiplier * step;
                    break;
                }
                multiplier *= 10.0;
            }
        } else {
            step = raw_step;
            boolean stepFound = false;
            double multiplier = 10.0;
            while (!stepFound && multiplier * 1.0E-12 < 1.0E14) {
                for (int i = 0; i < this.STEPS.length; ++i) {
                    if (!(this.STEPS[i] * multiplier * 1.0E-12 >= raw_step)) continue;
                    step = this.STEPS[i] * multiplier * 1.0E-12;
                    stepFound = true;
                    break;
                }
                multiplier *= 10.0;
            }
        }
        return step;
    }

    void paintZoomOutButton(Graphics g, Rectangle bounds) {
        boolean paintZoomOut = this.chart.getXUpperRange() != this.chart.getXCurrentUpperRange();
        paintZoomOut |= this.chart.getXLowerRange() != this.chart.getXCurrentLowerRange();
        paintZoomOut |= this.chart.getYUpperRange() != this.chart.getYCurrentUpperRange();
        if (paintZoomOut |= this.chart.getYLowerRange() != this.chart.getYCurrentLowerRange()) {
            int xpos = bounds.x + 8;
            int ypos = bounds.y + 8;
            this.paintBox(g, Color.lightGray, xpos, ypos, 8, 8, this.zoomOutPushed);
            g.setColor(Color.black);
            g.drawLine(xpos + 3, ypos + 4, xpos + 5, ypos + 4);
        }
    }

    void paintMouseBox(Graphics g) {
        g.setColor(this.chart.getForeground());
        if (this.mouseBox != null) {
            boolean dot = true;
            for (int x = this.mouseBox.x; x < this.mouseBox.x + this.mouseBox.width; ++x) {
                if (dot) {
                    g.drawLine(x, this.mouseBox.y, x, this.mouseBox.y);
                    g.drawLine(x, this.mouseBox.y + this.mouseBox.height, x, this.mouseBox.y + this.mouseBox.height);
                }
                dot = !dot;
            }
            dot = true;
            for (int y = this.mouseBox.y; y < this.mouseBox.y + this.mouseBox.height; ++y) {
                if (dot) {
                    g.drawLine(this.mouseBox.x, y, this.mouseBox.x, y);
                    g.drawLine(this.mouseBox.x + this.mouseBox.width, y, this.mouseBox.x + this.mouseBox.width, y);
                }
                dot = !dot;
            }
        }
    }

    private int getRangeWidth(int range, boolean target) {
        range = Math.min(3, Math.max(0, range));
        FontMetrics fm = this.getFontMetrics(this.getFont("rangeLabelFont"));
        int range_width = 0;
        if (this.chart.isRangeOn(range)) {
            if (range == 1 || range == 0) {
                String range_label = this.chart.formatRangeNumber(1, this.chart.getYUpperRange());
                range_width = fm.stringWidth(range_label);
                range_label = this.chart.formatRangeNumber(1, this.chart.getYLowerRange());
                range_width = Math.max(fm.stringWidth(range_label), range_width);
            }
            if (range == 2 || range == 3) {
                range_width = fm.getHeight() - 5;
            }
        }
        if (target && (range == 1 || range == 0) && this.chart.getTargetLabelsPosition() == range) {
            int widestTarget = 0;
            Enumeration e = this.chart.targetsLabel.keys();
            while (e.hasMoreElements()) {
                String id = (String)e.nextElement();
                String label = this.chart.getTargetLabel(id);
                if (label == null || label.length() <= 0) continue;
                widestTarget = Math.max(widestTarget, fm.stringWidth(label));
            }
            range_width = Math.max(widestTarget, range_width);
        }
        if ((range == 1 || range == 3) && this.chart.isRangeAdjusterOn(range)) {
            range_width += 6;
        }
        return range_width + 4;
    }

    private int getBelowLabelsHeight() {
        int label_height = 0;
        int angle = this.getLabelAngle("plotLabelAngle");
        FontMetrics fm = this.getFontMetrics(this.getFont("plotLabelFont"));
        if (this.chart.isPlotLabelsOn() && (this.chart.getPlotLabelStyle() == 3 || this.chart.getPlotLabelStyle() == 5)) {
            for (int series = 0; series < this.getSeriesCount(); ++series) {
                String[] labels = this.chart.getPlotLabels(series);
                for (int i = 0; i < labels.length; ++i) {
                    Dimension labelSize = this.getLabelSize(labels[i], fm);
                    Dimension angledSize = this.getAngledLabelSize(labelSize, angle);
                    label_height = Math.max(angledSize.height, label_height);
                }
            }
        }
        int xrange_style = this.chart.getXRangeLabelStyle();
        if (this.chart.getXRangeLabels() != null && (xrange_style == 3 || xrange_style == 5)) {
            int xrange_angle = this.getLabelAngle("xrangelabelangle");
            FontMetrics xrange_fm = this.getFontMetrics(this.getFont("xrangelabelfont"));
            String[] labels = this.chart.getXRangeLabels();
            for (int i = 0; i < labels.length; ++i) {
                Dimension labelSize = this.getLabelSize(labels[i], xrange_fm);
                Dimension angledSize = this.getAngledLabelSize(labelSize, xrange_angle);
                if (angledSize.height <= label_height) continue;
                label_height = angledSize.height;
                angle = xrange_angle;
                fm = xrange_fm;
            }
        }
        if (angle % 180 == 0) {
            label_height -= fm.getMaxDescent();
        }
        return label_height;
    }

    Point getPoint(double x, double y, Rectangle gridBounds) {
        int y_pos;
        int x_pos;
        if (gridBounds == null) {
            return new Point(-1, -1);
        }
        Grid grid = this.chart.getGrid();
        if (grid instanceof PlotterGrid) {
            double x_factor = (x - this.chart.getXCurrentLowerRange()) / (this.chart.getXCurrentUpperRange() - this.chart.getXCurrentLowerRange());
            x_pos = (int)Math.round((double)gridBounds.x + (double)gridBounds.width * x_factor);
            double y_factor = (y - this.chart.getYCurrentLowerRange()) / (this.chart.getYCurrentUpperRange() - this.chart.getYCurrentLowerRange());
            y_pos = (int)Math.round((double)(gridBounds.y + gridBounds.height) - (double)gridBounds.height * y_factor);
        } else {
            if (this.chartDataBounds == null) {
                return new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
            }
            x_pos = (int)((double)this.chartDataBounds.width * (x - this.chart.getXLowerRange()) / (this.chart.getXUpperRange() - this.chart.getXLowerRange())) + this.chartDataBounds.x;
            double y_factor = (y - grid.getCurrentLowerRange(0)) / (grid.getCurrentRange(0) - grid.getCurrentLowerRange(0));
            y_pos = (int)Math.round((double)(gridBounds.y + gridBounds.height) - (double)gridBounds.height * y_factor);
        }
        return new Point(x_pos, y_pos);
    }

    protected Point getSampleCenter(int sample, int series) {
        double[][] plots = this.chart.getPlots(series);
        return this.getPoint(plots[sample][0], plots[sample][1], this.graphBounds);
    }

    void handleZoom(AWTEvent event) {
        if (this.gridEdgeToAdjust != -1 || this.adjustingUpper || this.adjustingLower || this.slidingAdjuster) {
            return;
        }
        int xpos = ((MouseEvent)event).getX();
        int ypos = ((MouseEvent)event).getY();
        long now = System.currentTimeMillis();
        switch (event.getID()) {
            case 501: {
                this.mousePressX = xpos;
                this.mousePressY = ypos;
                boolean paintZoomOut = false;
                paintZoomOut |= this.chart.getXUpperRange() != this.chart.getXCurrentUpperRange();
                paintZoomOut |= this.chart.getXLowerRange() != this.chart.getXCurrentLowerRange();
                paintZoomOut |= this.chart.getYUpperRange() != this.chart.getYCurrentUpperRange();
                boolean inside_zoom_out = paintZoomOut |= this.chart.getYLowerRange() != this.chart.getYCurrentLowerRange();
                inside_zoom_out &= xpos > this.graphBounds.x + 8 && xpos < this.graphBounds.x + 17;
                if (inside_zoom_out &= ypos > this.graphBounds.y + 8 && ypos < this.graphBounds.y + 17) {
                    double delta;
                    double factor;
                    double upperDiff = Math.abs(this.chart.getXUpperRange() - this.chart.getXCurrentUpperRange());
                    double lowerDiff = Math.abs(this.chart.getXLowerRange() - this.chart.getXCurrentLowerRange());
                    if (upperDiff > 0.0 || lowerDiff > 0.0) {
                        factor = 0.1 * (this.chart.getXUpperRange() - this.chart.getXLowerRange());
                        delta = factor * upperDiff / (upperDiff + lowerDiff);
                        this.chart.setXCurrentUpperRange(this.chart.getXCurrentUpperRange() + delta);
                        this.chart.setXCurrentLowerRange(this.chart.getXCurrentLowerRange() - (factor - delta));
                    }
                    upperDiff = Math.abs(this.chart.getYUpperRange() - this.chart.getYCurrentUpperRange());
                    lowerDiff = Math.abs(this.chart.getYLowerRange() - this.chart.getYCurrentLowerRange());
                    if (upperDiff > 0.0 || lowerDiff > 0.0) {
                        factor = 0.1 * (this.chart.getYUpperRange() - this.chart.getYLowerRange());
                        delta = factor * upperDiff / (upperDiff + lowerDiff);
                        this.chart.setYCurrentUpperRange(this.chart.getYCurrentUpperRange() + delta);
                        this.chart.setYCurrentLowerRange(this.chart.getYCurrentLowerRange() - (factor - delta));
                    }
                    this.zoomOutPushed = true;
                } else if (now - this.lastClickTime < 350L) {
                    this.chart.setXCurrentUpperRange(this.chart.getXUpperRange());
                    this.chart.setXCurrentLowerRange(this.chart.getXLowerRange());
                    this.chart.setYCurrentUpperRange(this.chart.getYUpperRange());
                    this.chart.setYCurrentLowerRange(this.chart.getYLowerRange());
                }
                this.chart.repaint();
                break;
            }
            case 506: {
                if (this.zoomOutPushed || this.mousePressX < 0 || this.mousePressY < 0) break;
                int box_start_x = Math.max(this.graphBounds.x + 1, this.mousePressX);
                int box_start_y = Math.max(this.graphBounds.y + 1, this.mousePressY);
                box_start_x = Math.min(this.graphBounds.x + this.graphBounds.width - 1, box_start_x);
                box_start_y = Math.min(this.graphBounds.y + this.graphBounds.height - 1, box_start_y);
                int box_end_x = Math.max(this.graphBounds.x + 1, xpos);
                int box_end_y = Math.max(this.graphBounds.y + 1, ypos);
                box_end_x = Math.min(this.graphBounds.x + this.graphBounds.width - 1, box_end_x);
                box_end_y = Math.min(this.graphBounds.y + this.graphBounds.height - 1, box_end_y);
                this.mouseBox = new Rectangle();
                this.mouseBox.x = Math.min(box_start_x, box_end_x);
                this.mouseBox.y = Math.min(box_start_y, box_end_y);
                this.mouseBox.width = Math.abs(box_start_x - box_end_x);
                this.mouseBox.height = Math.abs(box_start_y - box_end_y);
                if (this.mouseBox.width < 3 || this.mouseBox.height < 3) {
                    this.mouseBox = null;
                }
                this.chart.repaint();
                break;
            }
            case 502: {
                this.mousePressX = -1;
                this.mousePressY = -1;
                if (now - this.lastClickTime > 100L && this.mouseBox != null) {
                    Rectangle rect = new Rectangle(this.mouseBox.x - 1, this.mouseBox.y - 1, this.mouseBox.width + 2, this.mouseBox.height + 2);
                    double lowerFactor = (double)(rect.x - this.graphBounds.x) / (double)this.graphBounds.width;
                    double upperFactor = (double)(this.graphBounds.x + this.graphBounds.width - rect.x - rect.width) / (double)this.graphBounds.width;
                    double newLower = this.chart.getXCurrentLowerRange() + lowerFactor * (this.chart.getXCurrentUpperRange() - this.chart.getXCurrentLowerRange());
                    double newUpper = this.chart.getXCurrentUpperRange() - upperFactor * (this.chart.getXCurrentUpperRange() - this.chart.getXCurrentLowerRange());
                    if (Math.abs(newUpper - newLower) >= Math.abs(this.chart.getXUpperRange() - this.chart.getXLowerRange()) / 1000.0) {
                        this.chart.setXCurrentLowerRange(newLower);
                        this.chart.setXCurrentUpperRange(newUpper);
                    }
                    lowerFactor = (double)(this.graphBounds.y + this.graphBounds.height - rect.y - rect.height) / (double)this.graphBounds.height;
                    upperFactor = (double)(rect.y - this.graphBounds.y) / (double)this.graphBounds.height;
                    newLower = this.chart.getYCurrentLowerRange() + lowerFactor * (this.chart.getYCurrentUpperRange() - this.chart.getYCurrentLowerRange());
                    newUpper = this.chart.getYCurrentUpperRange() - upperFactor * (this.chart.getYCurrentUpperRange() - this.chart.getYCurrentLowerRange());
                    if (Math.abs(newUpper - newLower) >= Math.abs(this.chart.getYUpperRange() - this.chart.getYLowerRange()) / 1000.0) {
                        this.chart.setYCurrentLowerRange(newLower);
                        this.chart.setYCurrentUpperRange(newUpper);
                    }
                }
                this.mouseBox = null;
                this.zoomOutPushed = false;
                this.chart.repaint();
            }
        }
    }

    void handleAdjusters(AWTEvent event) {
        boolean inside_range = false;
        boolean inside_upper = false;
        boolean inside_lower = false;
        int adjuster = -1;
        int xpos = ((MouseEvent)event).getX();
        int ypos = ((MouseEvent)event).getY();
        Rectangle b = this.rangeAdjusterBounds[1];
        if (this.chart.isRangeAdjusterOn(1) && b != null) {
            inside_range = xpos >= b.x && xpos <= b.x + b.width;
            inside_range = inside_range && ypos >= b.y - 3 && ypos <= b.y + b.height + 1;
            inside_upper = ypos >= b.y - 1 && ypos <= b.y + 3;
            inside_upper = inside_upper && xpos >= b.x && xpos <= b.x + b.width;
            inside_lower = ypos >= b.y + b.height - 3 && ypos <= b.y + b.height + 1;
            boolean bl = inside_lower = inside_lower && xpos >= b.x && xpos <= b.x + b.width;
            if (inside_range || inside_upper || inside_lower) {
                adjuster = 3;
            }
        }
        if (adjuster == -1 && this.chart.isRangeAdjusterOn(3) && b != null) {
            b = this.rangeAdjusterBounds[3];
            inside_range = ypos >= b.y && ypos <= b.y + b.height;
            inside_range = inside_range && xpos >= b.x - 1 && xpos <= b.x + b.width + 1;
            inside_lower = xpos >= b.x - 1 && xpos <= b.x + 2;
            inside_lower = inside_lower && ypos >= b.y && ypos <= b.y + b.height;
            inside_upper = xpos >= b.x + b.width - 3 && xpos <= b.x + b.width + 1;
            boolean bl = inside_upper = inside_upper && ypos >= b.y && ypos <= b.y + b.height;
            if (inside_range || inside_upper || inside_lower) {
                adjuster = 1;
            }
        }
        if ((inside_upper || inside_lower) && inside_range) {
            if (adjuster == 3) {
                this.chart.setNewCursor(RESIZE_CURSOR);
            } else if (adjuster == 1) {
                this.chart.setNewCursor(RESIZE_HOR_CURSOR);
            }
        } else if (inside_range) {
            this.chart.setNewCursor(HAND_CURSOR);
        }
        switch (event.getID()) {
            case 503: {
                break;
            }
            case 501: {
                this.adjustingUpper = inside_upper && inside_range;
                this.adjustingLower = inside_lower && inside_range;
                this.slidingAdjuster = inside_range && !inside_upper && !inside_lower;
                this.adjusterIndex = adjuster;
                this.lastAdjusterClick = ypos;
                if (this.adjusterIndex == 1) {
                    this.lastAdjusterClick = xpos;
                }
                long now = System.currentTimeMillis();
                if (inside_range && !inside_upper && !inside_lower && now - this.lastClickTime < 350L) {
                    if (adjuster == 3) {
                        this.chart.setYCurrentUpperRange(this.chart.getYUpperRange());
                        this.chart.setYCurrentLowerRange(this.chart.getYLowerRange());
                    } else if (adjuster == 1) {
                        this.chart.setXCurrentUpperRange(this.chart.getXUpperRange());
                        this.chart.setXCurrentLowerRange(this.chart.getXLowerRange());
                    }
                }
                this.chart.repaint();
                break;
            }
            case 506: {
                int pos = ((MouseEvent)event).getY();
                if (this.adjusterIndex == 1) {
                    pos = ((MouseEvent)event).getX();
                }
                Rectangle grid = this.graphBounds;
                if (this.adjusterIndex == 3) {
                    if (this.adjustingUpper) {
                        this.chart.setNewCursor(RESIZE_CURSOR);
                        double factor = 1.0 - (double)(pos -= grid.y) / (double)grid.height;
                        this.adjustRange(3, factor, 0.0);
                    } else if (this.adjustingLower) {
                        this.chart.setNewCursor(RESIZE_CURSOR);
                        double factor = 1.0 - (double)(pos -= grid.y) / (double)grid.height;
                        this.adjustRange(3, 0.0, factor);
                    } else if (this.slidingAdjuster) {
                        this.chart.setNewCursor(HAND_CURSOR);
                        int change_pos = this.lastAdjusterClick - pos;
                        double factor = (double)change_pos / (double)grid.height;
                        this.adjustRangeSlide(3, factor);
                        this.lastAdjusterClick = pos;
                    }
                } else if (this.adjusterIndex == 1) {
                    if (this.adjustingUpper) {
                        this.chart.setNewCursor(RESIZE_HOR_CURSOR);
                        double factor = (double)(pos -= grid.x) / (double)grid.width;
                        this.adjustRange(1, factor, 0.0);
                    } else if (this.adjustingLower) {
                        this.chart.setNewCursor(RESIZE_HOR_CURSOR);
                        double factor = (double)(pos -= grid.x) / (double)grid.width;
                        this.adjustRange(1, 0.0, factor);
                    } else if (this.slidingAdjuster) {
                        this.chart.setNewCursor(HAND_CURSOR);
                        int change_pos = pos - this.lastAdjusterClick;
                        double factor = (double)change_pos / (double)grid.width;
                        this.adjustRangeSlide(1, factor);
                        this.lastAdjusterClick = pos;
                    }
                }
                this.chart.repaint();
                break;
            }
            case 502: {
                this.slidingAdjuster = false;
                this.adjustingLower = false;
                this.adjustingUpper = false;
                this.chart.repaint();
            }
        }
    }

    void handleGridAdjustment(AWTEvent event) {
        int top = 0;
        int left = 0;
        int right = 0;
        int bottom = 0;
        if (this.graphBounds != null) {
            top = this.graphBounds.y;
            left = this.graphBounds.x - (this.display3dOn ? this.depth3dPoint.x : 0);
            right = this.graphBounds.x + this.graphBounds.width;
            bottom = this.graphBounds.y + this.graphBounds.height - (this.display3dOn ? this.depth3dPoint.y : 0);
        }
        long now = System.currentTimeMillis();
        int xpos = ((MouseEvent)event).getX();
        int ypos = ((MouseEvent)event).getY();
        Insets graphInsets = this.chart.getGraphInsets();
        switch (event.getID()) {
            case 501: {
                this.mousePressX = xpos;
                this.mousePressY = ypos;
                if (this.gridEdgeToAdjust < 0 || now - this.lastClickTime >= 350L) break;
                switch (this.gridEdgeToAdjust) {
                    case 0: {
                        graphInsets.left = -1;
                        break;
                    }
                    case 1: {
                        graphInsets.right = -1;
                        break;
                    }
                    case 2: {
                        graphInsets.top = -1;
                        break;
                    }
                    case 3: {
                        graphInsets.bottom = -1;
                    }
                }
                break;
            }
            case 503: {
                if (this.chart.isGridAdjustmentOn(2) && xpos >= left && xpos <= right && ypos >= top - 1 && ypos <= top + 3) {
                    this.chart.setNewCursor(GRID_CURSOR_VERT);
                    this.gridEdgeToAdjust = 2;
                    break;
                }
                if (this.chart.isGridAdjustmentOn(0) && xpos >= left - 1 && xpos <= left + 3 && ypos >= top && ypos <= bottom) {
                    this.chart.setNewCursor(GRID_CURSOR_HORZ);
                    this.gridEdgeToAdjust = 0;
                    break;
                }
                if (this.chart.isGridAdjustmentOn(3) && xpos >= left && xpos <= right && ypos >= bottom - 3 && ypos <= bottom + 1) {
                    this.chart.setNewCursor(GRID_CURSOR_VERT);
                    this.gridEdgeToAdjust = 3;
                    break;
                }
                if (this.chart.isGridAdjustmentOn(2) && xpos >= right - 3 && xpos <= right + 1 && ypos >= top && ypos <= bottom) {
                    this.chart.setNewCursor(GRID_CURSOR_HORZ);
                    this.gridEdgeToAdjust = 1;
                    break;
                }
                this.gridEdgeToAdjust = -1;
                break;
            }
            case 506: {
                int xoff = 0;
                int yoff = 0;
                if (this.display3dOn) {
                    xoff = this.depth3dPoint.x;
                    yoff = this.depth3dPoint.y;
                }
                if (this.gridEdgeToAdjust < 0) break;
                Dimension size = this.chart.getSize();
                switch (this.gridEdgeToAdjust) {
                    case 0: {
                        graphInsets.left = Math.max(0, xpos) + xoff;
                        if (this.graphBounds != null) {
                            graphInsets.left = Math.min(graphInsets.left, this.graphBounds.x + this.graphBounds.width - 5);
                        }
                        this.chart.setNewCursor(GRID_CURSOR_HORZ);
                        break;
                    }
                    case 1: {
                        graphInsets.right = Math.max(size.width - xpos, 0);
                        if (this.graphBounds != null) {
                            graphInsets.right = Math.min(graphInsets.right, size.width - this.graphBounds.x - 5);
                        }
                        this.chart.setNewCursor(GRID_CURSOR_HORZ);
                        break;
                    }
                    case 2: {
                        graphInsets.top = Math.max(ypos, 0);
                        if (this.graphBounds != null) {
                            graphInsets.top = Math.min(graphInsets.top, this.graphBounds.y + this.graphBounds.height - 5);
                        }
                        this.chart.setNewCursor(GRID_CURSOR_VERT);
                        break;
                    }
                    case 3: {
                        graphInsets.bottom = Math.max(size.height - ypos, 0) - yoff;
                        if (this.graphBounds != null) {
                            graphInsets.bottom = Math.min(graphInsets.bottom, size.height - this.graphBounds.y - 5);
                        }
                        this.chart.setNewCursor(GRID_CURSOR_VERT);
                    }
                }
                this.chart.repaint();
            }
        }
        this.chart.setGraphInsets(graphInsets.top, graphInsets.left, graphInsets.bottom, graphInsets.right);
    }

    private void adjustRange(int rangeIndex, double upperFactor, double lowerFactor) {
        if (rangeIndex == 1) {
            if (upperFactor != 0.0) {
                double upperValue = this.chart.getXLowerRange() + upperFactor * (this.chart.getXUpperRange() - this.chart.getXLowerRange());
                if (this.chart.getXUpperRange() >= this.chart.getXLowerRange()) {
                    if (upperValue > this.chart.getXCurrentLowerRange()) {
                        this.chart.setXCurrentUpperRange(upperValue);
                    }
                    this.chart.setXCurrentUpperRange(Math.min(this.chart.getXCurrentUpperRange(), this.chart.getXUpperRange()));
                } else if (this.chart.getXUpperRange() < this.chart.getXLowerRange()) {
                    if (upperValue < this.chart.getXCurrentLowerRange()) {
                        this.chart.setXCurrentUpperRange(upperValue);
                    }
                    this.chart.setXCurrentUpperRange(Math.max(this.chart.getXCurrentUpperRange(), this.chart.getXUpperRange()));
                }
            }
            if (lowerFactor != 0.0) {
                double lowerValue = this.chart.getXLowerRange() + lowerFactor * (this.chart.getXUpperRange() - this.chart.getXLowerRange());
                if (this.chart.getXUpperRange() >= this.chart.getXLowerRange()) {
                    if (lowerValue < this.chart.getXCurrentUpperRange()) {
                        this.chart.setXCurrentLowerRange(lowerValue);
                    }
                    this.chart.setXCurrentLowerRange(Math.max(this.chart.getXCurrentLowerRange(), this.chart.getXLowerRange()));
                } else if (this.chart.getXUpperRange() < this.chart.getXLowerRange()) {
                    if (lowerValue > this.chart.getXCurrentUpperRange()) {
                        this.chart.setXCurrentLowerRange(lowerValue);
                    }
                    this.chart.setXCurrentLowerRange(Math.min(this.chart.getXCurrentLowerRange(), this.chart.getXLowerRange()));
                }
            }
        } else if (rangeIndex == 3) {
            if (upperFactor != 0.0) {
                double upperValue = this.chart.getYLowerRange() + upperFactor * (this.chart.getYUpperRange() - this.chart.getYLowerRange());
                if (this.chart.getYUpperRange() >= this.chart.getYLowerRange()) {
                    if (upperValue > this.chart.getYCurrentLowerRange()) {
                        this.chart.setYCurrentUpperRange(upperValue);
                    }
                    this.chart.setYCurrentUpperRange(Math.min(this.chart.getYCurrentUpperRange(), this.chart.getYUpperRange()));
                } else if (this.chart.getYUpperRange() < this.chart.getYLowerRange()) {
                    if (upperValue < this.chart.getYCurrentLowerRange()) {
                        this.chart.setYCurrentUpperRange(upperValue);
                    }
                    this.chart.setYCurrentUpperRange(Math.max(this.chart.getYCurrentUpperRange(), this.chart.getYUpperRange()));
                }
            }
            if (lowerFactor != 0.0) {
                double lowerValue = this.chart.getYLowerRange() + lowerFactor * (this.chart.getYUpperRange() - this.chart.getYLowerRange());
                if (this.chart.getYUpperRange() >= this.chart.getYLowerRange()) {
                    if (lowerValue < this.chart.getYCurrentUpperRange()) {
                        this.chart.setYCurrentLowerRange(lowerValue);
                    }
                    this.chart.setYCurrentLowerRange(Math.max(this.chart.getYCurrentLowerRange(), this.chart.getYLowerRange()));
                } else if (this.chart.getYUpperRange() < this.chart.getYLowerRange()) {
                    if (lowerValue > this.chart.getYCurrentUpperRange()) {
                        this.chart.setYCurrentLowerRange(lowerValue);
                    }
                    this.chart.setYCurrentLowerRange(Math.min(this.chart.getYCurrentLowerRange(), this.chart.getYLowerRange()));
                }
            }
        }
    }

    private void adjustRangeSlide(int rangeIndex, double factor) {
        if (rangeIndex == 1) {
            double change = factor * (this.chart.getXUpperRange() - this.chart.getXLowerRange());
            if (this.chart.getXUpperRange() >= this.chart.getXLowerRange()) {
                if (change >= 0.0) {
                    change = Math.min(this.chart.getXUpperRange() - this.chart.getXCurrentUpperRange(), change);
                } else if (this.chart.getXCurrentLowerRange() + change < this.chart.getXLowerRange()) {
                    change = this.chart.getXLowerRange() - this.chart.getXCurrentLowerRange();
                }
            } else if (this.chart.getXUpperRange() < this.chart.getXLowerRange()) {
                if (change <= 0.0) {
                    change = Math.max(this.chart.getXUpperRange() - this.chart.getXCurrentUpperRange(), change);
                } else if (this.chart.getXCurrentLowerRange() + change > this.chart.getXLowerRange()) {
                    change = this.chart.getXLowerRange() - this.chart.getXCurrentLowerRange();
                }
            }
            this.chart.setXCurrentUpperRange(this.chart.getXCurrentUpperRange() + change);
            this.chart.setXCurrentLowerRange(this.chart.getXCurrentLowerRange() + change);
        } else if (rangeIndex == 3) {
            double change = factor * (this.chart.getYUpperRange() - this.chart.getYLowerRange());
            if (this.chart.getYUpperRange() >= this.chart.getYLowerRange()) {
                if (change >= 0.0) {
                    change = Math.min(this.chart.getYUpperRange() - this.chart.getYCurrentUpperRange(), change);
                } else if (this.chart.getYCurrentLowerRange() + change < this.chart.getYLowerRange()) {
                    change = this.chart.getYLowerRange() - this.chart.getYCurrentLowerRange();
                }
            } else if (this.chart.getYUpperRange() < this.chart.getYLowerRange()) {
                if (change <= 0.0) {
                    change = Math.max(this.chart.getYUpperRange() - this.chart.getYCurrentUpperRange(), change);
                } else if (this.chart.getYCurrentLowerRange() + change > this.chart.getYLowerRange()) {
                    change = this.chart.getYLowerRange() - this.chart.getYCurrentLowerRange();
                }
            }
            this.chart.setYCurrentUpperRange(this.chart.getYCurrentUpperRange() + change);
            this.chart.setYCurrentLowerRange(this.chart.getYCurrentLowerRange() + change);
        }
    }

    public boolean isAnyFloatingLabelsOn(int serie) {
        int valueLabelStyle = this.chart.getValueLabelStyle();
        int plotLabelStyle = this.chart.getPlotLabelStyle();
        int seriesLabelStyle = this.chart.getSeriesLabelStyle();
        boolean valueLabelsOn = this.chart.isXValueLabelsOn(serie) || this.chart.isYValueLabelsOn(serie);
        boolean sampleLabelsOn = this.chart.isSampleLabelsOn();
        boolean seriesLabelsOn = this.chart.isSeriesLabelsOn();
        boolean labels_on = valueLabelsOn && valueLabelStyle == 4;
        labels_on |= sampleLabelsOn && (plotLabelStyle == 4 || plotLabelStyle == 5);
        return labels_on |= seriesLabelsOn && seriesLabelStyle == 4;
    }
}

