/*
 * Decompiled with CFR 0.152.
 */
package com.representqueens.spark;

import com.representqueens.spark.GraphUtils;
import com.representqueens.spark.SizeParams;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;

public class LineGraph {
    private static final int WIDTH = 100;
    private static final int HEIGHT = 25;
    private static final int SPACING = 2;
    public static final SizeParams DEFAULT_SIZE = new SizeParams(100, 25, 2);
    public static final Color DEFAULT_COLOR = Color.GRAY;

    public static BufferedImage createGraph(Number[] numberArray) {
        return LineGraph.createGraph(numberArray, DEFAULT_SIZE, DEFAULT_COLOR);
    }

    public static BufferedImage createGraph(Number[] numberArray, SizeParams sizeParams, Color color) {
        return LineGraph.createGraph(numberArray, sizeParams, color, null);
    }

    public static BufferedImage createGraph(Number[] numberArray, SizeParams sizeParams, Color color, Color color2) {
        BufferedImage bufferedImage = new BufferedImage(sizeParams.getWidth(), sizeParams.getHeight(), 2);
        if (numberArray == null || numberArray.length < 2) {
            return bufferedImage;
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (color2 != null) {
            graphics2D.setBackground(color2);
            graphics2D.clearRect(0, 0, sizeParams.getWidth(), sizeParams.getHeight());
        }
        float f = GraphUtils.getDivisor(numberArray, sizeParams.getHeight());
        int n = (sizeParams.getWidth() - sizeParams.getSpacing() * (numberArray.length - 1)) / (numberArray.length - 1);
        float f2 = Float.MAX_VALUE;
        for (Number number : numberArray) {
            f2 = Math.min(f2, number.floatValue());
        }
        int n2 = 0;
        int n3 = -1;
        if ((double)f == 0.0) {
            f = 1.0f;
            n3 = -sizeParams.getHeight() / 2;
        }
        for (int i = 0; i < numberArray.length - 1; ++i) {
            int n4 = n2;
            int n5 = n2 += n + sizeParams.getSpacing();
            graphics2D.setPaint(color);
            graphics2D.draw(new Line2D.Double(n4, (float)n3 + ((float)sizeParams.getHeight() - (numberArray[i].floatValue() - f2) / f), n5, (float)n3 + ((float)sizeParams.getHeight() - (numberArray[i + 1].floatValue() - f2) / f)));
        }
        return bufferedImage;
    }
}

