
import Foundation
import Capacitor
import eGMobileAPM

/**
 * Please read the Capacitor iOS Plugin Development Guide
 * here: https://capacitorjs.com/docs/plugins/ios
 */
@objc(eGCapacitorPlugin)
public class eGCapacitorPlugin: CAPPlugin {

    @objc func echo(_ call: CAPPluginCall) {
        let value = call.getString("value") ?? ""
        call.success([
            "value": value
        ])
    }
    
    @objc func getBaseOs(_ call: CAPPluginCall) {
        let baseOs = getBaseOs()
        print("Base Os is \(baseOs )")
        if baseOs != nil && (baseOs.count ) > 0 && baseOs != nil {
            call.success([
                "osName": baseOs
            ])
        }else {
            call.reject("failed to get os")
        }
    }
    
    @objc func getUserCountry(_ call: CAPPluginCall) {
        let userCountry = getUserCountry()
        print("User Country is \(userCountry )")
        if userCountry != nil && (userCountry.count) > 0 && userCountry != nil {
            call.success([
                "country": userCountry
            ])
        } else {
            call.reject("failed to get country")
        }
    }
    
    @objc func getOSVersion(_ call: CAPPluginCall) {
        let osVersion = getOSVersion()
        print("Os Version is \(osVersion )")
        if osVersion != nil && (osVersion.count) > 0 && osVersion != nil {
            call.success([
                "osVersion": osVersion
            ])
        } else {
            call.reject("failed to get os version")
        }
    }
    
    @objc func getDeviceName(_ call: CAPPluginCall) {
        let deviceName = getDeviceName()
        print("Device Name is \(deviceName )")
        if deviceName != nil && (deviceName.count) > 0 && deviceName != nil {
            call.success([
                "deviceName": deviceName
            ])
        } else {
            call.reject("failed to get device name")
        }
    }
    
    @objc func getAppName(_ call: CAPPluginCall) {
        let appName = getAppName()
        print("App Name  is \(appName )")
        if appName != nil && (appName.count) > 0 && appName != nil {
            call.success([
                "appName": appName
            ])
        } else {
            call.reject("failed to get app name")
        }
    }
    
    @objc  func getUserInfo(_ call: CAPPluginCall) {
        let userInfo = getUserInfo()
        print("User Info  is \(userInfo )")
        if userInfo != nil && (userInfo.count) > 0 && userInfo != nil {
            call.success([
                "userInformation": userInfo
            ])
        } else {
            call.reject("failed to get user info")
        }
    }
    
    @objc func getAppinfo(_ call: CAPPluginCall) {
        let appInfo = getAppinfo()
        print("App Info  is \(appInfo )")
        if appInfo != nil && (appInfo.count) > 0 && appInfo != nil {
            call.success([
                "applicationInformation": appInfo
            ])
        } else {
            call.reject("failed to get application info")
        }
    }
    
    @objc func getResInfo(_ call: CAPPluginCall) {
        let resInfo = getResInfo()
        print("Res Info  is \(resInfo )")
        if resInfo != nil && (resInfo.count) > 0 && resInfo != nil {
            call.success([
                "resourceInformation": resInfo
            ])
        } else {
            call.reject("failed to get resource info")
        }
    }
    
    @objc(getDevInfo:)func getDevInfo(_ call: CAPPluginCall) {
        let devInfo = getDevInfo()
        print("Dev Info  is \(devInfo )")
        if devInfo != nil && (devInfo.count) > 0 && devInfo != nil {
            call.success([
                "deviceInformation": devInfo
            ])
        } else {
            call.reject("failed to get device info")
        }
    }
    
    @objc func getCurrentActivityName(_ call: CAPPluginCall) {
        let currentViewController = getCurrentActivityName()
        print("View Controller  is \(currentViewController )")
        if currentViewController != nil && (currentViewController.count) > 0 && currentViewController != nil {
            call.success([
                "activityName": currentViewController
            ])
        } else {
            call.reject("failed to get view controller")
        }
    }
    
    @objc func setUserName(_ call: CAPPluginCall) {
        print("eGCapacitorPlugin::setUserName:PluginCall:::is \(call)")
        let name = call.getString("userName")
        print("eGCapacitorPlugin::setUserName:PluginCall::name is \(name)")
        egAPM.sharedInstance().setUserName(name ?? "")
        call.success()
    }

    @objc func setAttribute(_ call: CAPPluginCall) {
        print("eGCapacitorPlugin::setAttribute:PluginCall:::is \(call)")
        let key = call.getString("key")
        print("eGCapacitorPlugin::setAttribute:PluginCall: is \(key)")
        let value = call.getString("value")
        print("eGCapacitorPlugin::setAttribute:PluginCall::name: is \(value)")
        egAPM.sharedInstance().setAttribute(key ?? "", value)
        call.success()
    }

    func getBaseOs() -> String {
        return "ios"
    }
    
    func getUserCountry() -> String  {
          return egAPM.sharedInstance().userCountry()
       }
       
       func getOSVersion() -> String {
           return egAPM.sharedInstance().osVersion()
       }
       
       func getDeviceName() -> String {
           return egAPM.sharedInstance().deviceName()
       }
       
       func getAppName() -> String {
           return egAPM.sharedInstance().appName()
       }
       
       func getAppinfo() -> String {
           return egAPM.sharedInstance().appInfo()
       }
       
       func getResInfo() -> String {
           return egAPM.sharedInstance().resInfo()
       }
       
       func getDevInfo() -> String {
           return egAPM.sharedInstance().devInfo()
       }
    
        func getUserInfo() -> String {
            return egAPM.sharedInstance().userInfo()
        }
       
       func getCurrentActivityName() -> String {
           return egAPM.sharedInstance().getViewController()
       }
    
}
