/*     */ package com.egurkha.jsp.indexer;
/*     */ 
/*     */ import com.egurkha.jsp.indexer.parser.IndexTagExport;
/*     */ import com.egurkha.jsp.indexer.parser.ParseException;
/*     */ import com.egurkha.jsp.indexer.parser.TagExportParser;
/*     */ import jakarta.servlet.jsp.JspException;
/*     */ import jakarta.servlet.jsp.JspTagException;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ public final class IndexTag
/*     */   extends PagerTagSupport
/*     */ {
/*  29 */   private String export = null;
/*     */   
/*  31 */   private IndexTagExport indexTagExport = null;
/*  32 */   private Object oldItemCount = null;
/*  33 */   private Object oldPageCount = null;
/*     */ 
/*     */   
/*     */   public final void setExport(String value) throws JspException {
/*  37 */     if (this.export != value) {
/*     */       
/*     */       try {
/*     */         
/*  41 */         this.indexTagExport = TagExportParser.parseIndexTagExport(value);
/*     */       }
/*  43 */       catch (ParseException ex) {
/*     */         
/*  45 */         throw new JspTagException(ex.getMessage());
/*     */       } 
/*     */     }
/*  48 */     this.export = value;
/*     */   }
/*     */ 
/*     */   
/*     */   public final String getExport() {
/*  53 */     return this.export;
/*     */   }
/*     */ 
/*     */   
/*     */   public int doStartTag() throws JspException {
/*  58 */     super.doStartTag();
/*     */     
/*  60 */     if (this.indexTagExport != null) {
/*     */       String name;
/*     */       
/*  63 */       if ((name = this.indexTagExport.getItemCount()) != null) {
/*     */         
/*  65 */         this.oldItemCount = this.pageContext.getAttribute(name);
/*  66 */         this.pageContext.setAttribute(
/*  67 */             name, 
/*  68 */             new Integer(this.pagerTag.getItemCount()));
/*     */       } 
/*     */       
/*  71 */       if ((name = this.indexTagExport.getPageCount()) != null) {
/*     */         
/*  73 */         this.oldPageCount = this.pageContext.getAttribute(name);
/*  74 */         this.pageContext.setAttribute(
/*  75 */             name, 
/*  76 */             new Integer(this.pagerTag.getPageCount()));
/*     */       } 
/*     */     } 
/*     */     
/*  80 */     return this.pagerTag.isIndexNeeded() ? 1 : 0;
/*     */   }
/*     */ 
/*     */ 
/*     */   
/*     */   public int doEndTag() throws JspException {
/*  86 */     if (this.indexTagExport != null) {
/*     */       String name;
/*     */       
/*  89 */       if ((name = this.indexTagExport.getItemCount()) != null) {
/*     */         
/*  91 */         restoreAttribute(name, this.oldItemCount);
/*  92 */         this.oldItemCount = null;
/*     */       } 
/*     */       
/*  95 */       if ((name = this.indexTagExport.getPageCount()) != null) {
/*     */         
/*  97 */         restoreAttribute(name, this.oldPageCount);
/*  98 */         this.oldPageCount = null;
/*     */       } 
/*     */     } 
/*     */     
/* 102 */     super.doEndTag();
/*     */     
/* 104 */     return 6;
/*     */   }
/*     */ 
/*     */   
/*     */   public void release() {
/* 109 */     this.export = null;
/* 110 */     this.indexTagExport = null;
/* 111 */     this.oldItemCount = null;
/* 112 */     this.oldPageCount = null;
/*     */     
/* 114 */     super.release();
/*     */   }
/*     */ }


/* Location:              C:\Users\dhanabal\Desktop\Index\!\com\egurkha\jsp\indexer\IndexTag.class
 * Java compiler version: 1 (45.3)
 * JD-Core Version:       1.1.3
 */