/*     */ package com.egurkha.jsp.indexer.parser;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ public class TokenMgrError
/*     */   extends Error
/*     */ {
/*     */   public static final int LEXICAL_ERROR = 0;
/*     */   public static final int STATIC_LEXER_ERROR = 1;
/*     */   public static final int INVALID_LEXICAL_STATE = 2;
/*     */   public static final int LOOP_DETECTED = 3;
/*     */   int errorCode;
/*     */   
/*     */   public TokenMgrError() {}
/*     */   
/*     */   public TokenMgrError(String message, int reason) {
/*  46 */     super(message);
/*  47 */     this.errorCode = reason;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public TokenMgrError(boolean EOFSeen, int errorLine, int errorColumn, String errorAfter, char curChar, int reason) {
/*  66 */     this(lexicalError(EOFSeen, errorLine, errorColumn, errorAfter, 
/*  67 */           curChar), reason);
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   protected static final String addEscapes(String str) {
/*  76 */     StringBuffer retval = new StringBuffer();
/*     */     
/*  78 */     for (int i = 0; i < str.length(); i++) {
/*     */       char ch;
/*  80 */       switch (str.charAt(i)) {
/*     */         case '\000':
/*     */           break;
/*     */         
/*     */         case '\b':
/*  85 */           retval.append("\\b");
/*     */           break;
/*     */         case '\t':
/*  88 */           retval.append("\\t");
/*     */           break;
/*     */         case '\n':
/*  91 */           retval.append("\\n");
/*     */           break;
/*     */         case '\f':
/*  94 */           retval.append("\\f");
/*     */           break;
/*     */         case '\r':
/*  97 */           retval.append("\\r");
/*     */           break;
/*     */         case '"':
/* 100 */           retval.append("\\\"");
/*     */           break;
/*     */         case '\'':
/* 103 */           retval.append("\\'");
/*     */           break;
/*     */         case '\\':
/* 106 */           retval.append("\\\\");
/*     */           break;
/*     */         default:
/* 109 */           if ((ch = str.charAt(i)) < ' ' || ch > '~') {
/*     */             
/* 111 */             String s = "0000" + Integer.toString(ch, 16);
/* 112 */             retval.append(
/* 113 */                 "\\u" + s.substring(s.length() - 4, s.length()));
/*     */             
/*     */             break;
/*     */           } 
/* 117 */           retval.append(ch);
/*     */           break;
/*     */       } 
/*     */     
/*     */     } 
/* 122 */     return retval.toString();
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   private static final String lexicalError(boolean EOFSeen, int errorLine, int errorColumn, String errorAfter, char curChar) {
/* 145 */     StringBuffer sb = new StringBuffer();
/* 146 */     sb.append("Lexical error at line ");
/* 147 */     sb.append(errorLine);
/* 148 */     sb.append(", column ");
/* 149 */     sb.append(errorColumn);
/* 150 */     sb.append(".  Encountered: ");
/* 151 */     sb.append(EOFSeen ? "<EOF> " : ("\"" + addEscapes(String.valueOf(curChar)) + "\"" + 
/* 152 */         " (" + curChar + "), "));
/* 153 */     sb.append("after : \"");
/* 154 */     sb.append(addEscapes(errorAfter));
/* 155 */     sb.append("\"");
/*     */     
/* 157 */     return sb.toString();
/*     */   }
/*     */ }


/* Location:              C:\Users\dhanabal\Desktop\Index\!\com\egurkha\jsp\indexer\parser\TokenMgrError.class
 * Java compiler version: 1 (45.3)
 * JD-Core Version:       1.1.3
 */