(function() {

    /**
     * @class Ext.ux.grid.VarHeaders
     *
     * Plugin for GridPanel that enables configuration of three different headers which are shown depending on the available column width:
     * longText, text, shortText.
     *
     * Plugin alias is 'varheaders' (use "plugins: 'varheaders'" in GridPanel config).
     *
     * @author <a href="mailto:stephen.friedrich@fortis-it.de">Stephen Friedrich</a>
     * @author <a href="mailto:fabian.urban@fortis-it.de">Fabian Urban</a>
     *
     * @copyright (c) 2011 Fortis IT Services GmbH
     * @license Ext.ux.grid.VarHeaders is released under the
     * <a target="_blank" href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.
     *
     */
    Ext.define('Ext.ux.slider.FillSlider', {
                   alias: 'plugin.fillslider',

                   /**
                    * Called by plug-in system to initialize the plugin for a specific grid panel
                    */
		    init: function(slider) {
			/*f.onRender = f.onRender.createSequence(this.onRender);
			f.afterRender = f.afterRender.createSequence(this.afterRender);
				    f.onClickChange = f.onClickChange.createSequence(this.onClickChange);
			f.moveThumb = f.moveThumb.createSequence(this.moveThumb);*/
			
			slider.on('render',
			function(){
			     this.onRender(slider);
			},
			this);
			
			slider.on('afterrender',
			function(){
			     this.afterRender(slider);
			},
			this);
			
			slider.on('change',
			function(){
			     this.onClickChange(slider);
			},
			this);
			
			
			
			/*slider.on('movethumb',
			function(){
			     //this.afterRender(slider);
			     this.moveThumb();
			},
			thumb);*/
		    },

		    onRender : function(slider){
			    //console.log(slider);
			    /*for (var i in slider) {
				console.log(i);
			    }*/
			    this.fill = slider.innerEl.insertFirst({cls:'x-slider-bg'});
			    
			    // For IE
			    this.fill.insertHtml("afterBegin", "&nbsp;");
		    },
		    
		    afterRender : function(slider)
		    {
			    var thumb=slider.getNearest();
			    if(this.vertical==true)			
			    {
				var height = (this.translateValue(slider.value)+(thumb.el.thumb.getHeight()/2)).constrain(0,slider.innerEl.getHeight());
				this.fill.setHeight(height, true);
				this.fill.setWidth(slider.innerEl.getWidth());
			    }
			    else
			    {
				    this.fill.setWidth(thumb.el.getRight(true)-(thumb.el.getWidth()/2));
				    this.fill.setHeight(slider.innerEl.getHeight() + 2);
			    }
			    
		    },		
		    
		    onClickChange : function(slider)
		    {
			    //console.log(slider);
			    if(this.vertical==true)			
			    {				
				    if(local.left > this.clickRange[0] && local.left < this.clickRange[1]){
					    var height = (this.translateValue(this.value)+(this.thumb.getHeight()/2)).constrain(0,this.innerEl.getHeight());
					    this.fill.setHeight(height, true);
				    }
			    }
			    else
			    {
				    //if(local.top > this.clickRange[0] && local.top < this.clickRange[1]){
					    //var width = (this.translateValue(this.value)+(this.thumb.getWidth()/2)).constrain(0,this.innerEl.getWidth()) ;			
					    //this.fill.setWidth(width, true);
				    //}
				    var thumb=slider.getNearest();
				    this.fill.setWidth(thumb.el.getRight(true)-(thumb.el.getWidth()/2));
			    }
		    },		
		    
		    moveThumb: function(v, animate)
		    {
			var thumb=slider.getNearest();
			if(this.vertical==true)		
				this.fill.setHeight(this.translateValue(this.value)+(this.thumb.getHeight()/2), animate);
			else
				//this.fill.setWidth(this.translateValue(this.value)+(this.thumb.getWidth()/2), animate);
				this.fill.setWidth(slider.value+(thumb.el.getWidth()/2), animate);
		    }
               });
})();
