<%
/***********************************************************************************************************
*
*       Name            :       EgManageCommandsRCpJson.jsp 
*       Purpose         :       Processing page of EgManageCommandsRCJson. 
		
***********************************************************************************************************/
%>

<%@ include file = "../../EgTrackerAJSON.jsp" %>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import = "com.egurkha.ini.*" %>
<%@ page import = "java.util.*" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "net.sf.json.*"%>

<%
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	JSONObject resultMsg = new JSONObject();
	resultMsg.put("title",_mapping.getTextDescription("admin.title.REMOTE CONTROL COMMAND"));

	String process = request.getParameter("processRad");
	boolean isValidProcess = process != null && (process = process.trim()).length() >0;
	
	String cmdKeyOrName = request.getParameter("nickNameTxt");
	String commandDesc = request.getParameter("commandTxt");
	cmdKeyOrName = cmdKeyOrName != null ? StringUtils.decodeSecurityChar(cmdKeyOrName.trim()) : cmdKeyOrName;
	commandDesc = commandDesc != null ? StringUtils.decodeSecurityChar(commandDesc.trim()) : commandDesc;
	String osSubject = request.getParameter("selOS");

	String selectedOS = osSubject.toLowerCase();
	if(selectedOS.indexOf("_") != -1)
	{
		selectedOS = selectedOS.substring(0,selectedOS.indexOf("_"));
		selectedOS = selectedOS.substring(0,1).toUpperCase() + selectedOS.substring(1);
	}

	if(isValidProcess)
	{
		AuditLogThread auditLogThread = new AuditLogThread();
		auditLogThread.setValue("Category","Admin");
		auditLogThread.setValue("User_id",_user.getLoginID());
		auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
		auditLogThread.setValue("Session_id",session.getId());
		auditLogThread.setValue("Module","Settings");
		auditLogThread.setValue("Activity","Remote Control");

		String iniConfDir = EgInstallInfo.getInstallDir()+"/manager/config/";
		IniFile iniUI = EgConfigFilesSync.getInstance(iniConfDir+"eg_ui.ini", true);
		if(process.equalsIgnoreCase("add"))
		{
			Vector cmdList = iniUI.getVariables(osSubject,false);
			List cmdKeys = new ArrayList();
			int count=cmdList.size();
			for(int i=0;i<count;i++)
			{
				try
				{
					String cmdIdx = ((String)cmdList.get(i)).trim();
					if(cmdIdx.startsWith("U"))
					{
						//user-defined remote control actions will have internal names starting with UA,UL,UH,US and UW.
						cmdKeys.add(new Integer(cmdIdx.substring(2)));
					}
				}
				catch(Exception e)
				{}
			}
			if(cmdKeys.isEmpty())
			{
				cmdKeys.add(new Integer(0));
			}
			Collections.sort(cmdKeys);
			Integer idx = (Integer)cmdKeys.get(cmdKeys.size()-1);
			String cmdKey = "U"+osSubject.charAt(0) + String.valueOf(idx+1);
			commandDesc = StringUtils.replace(commandDesc,"\r\n"," ");
			iniUI.setValue(osSubject,cmdKey,cmdKeyOrName+"|"+commandDesc);
			iniUI.saveFile();

			auditLogThread.setCurrentValue("ColumnName","Command Added");
			auditLogThread.setCurrentValue("1~~Operating System",selectedOS);
			auditLogThread.setCurrentValue("2~~Command Display Name",cmdKeyOrName);
			auditLogThread.setCurrentValue("3~~Command Syntax",commandDesc);
			auditLogThread.setValue("Description","Command has been added");
			auditLogThread.sendItToDB();
			resultMsg.put("message1",_mapping.getTextDescription("admin.remote.Command added successfully"));
		}
		else if(process.equalsIgnoreCase("edit"))
		{
			HashMap cmdMap = (HashMap)session.getAttribute("cmds");
			String cmd_name = (String)cmdMap.get(cmdKeyOrName);
			cmd_name = cmd_name.substring(0,cmd_name.indexOf("|"));
			iniUI.deleteValue(osSubject,cmdKeyOrName);
			commandDesc = StringUtils.replace(commandDesc,"\r\n"," ");
			iniUI.setValue(osSubject,cmdKeyOrName,cmd_name + "|" + commandDesc);
			iniUI.saveFile();

			String temp = StringUtils.decodeSecurityChar(request.getParameter("previousCmdDesc"));
			if( temp != null && !temp.equalsIgnoreCase("null") && (temp = temp.trim()).length()>0)
			{
				auditLogThread.setPreviousValue("1~~Command Syntax",temp);
			}

			if(!temp.equals(commandDesc.trim()))
			{
				auditLogThread.setCurrentValue("1~~Command Syntax",commandDesc);
				auditLogThread.setValue("Description",selectedOS+" operating system command syntax has been updated for command display name "+cmd_name);
				auditLogThread.sendItToDB();
			}
			resultMsg.put("message1",_mapping.getTextDescription("admin.remote.Command updated successfully"));
		}
		else if(process.equalsIgnoreCase("delete"))
		{
			String allCommands = "";
			Vector delCmdKeys = new Vector();
			Vector delUserList = new Vector();
			Vector updateUserList = new Vector();
			Vector updateCmdsList = new Vector();
			String selCmdKeys = StringUtils.decodeSecurityChar(request.getParameter("selCmd"));
			if (selCmdKeys != null && (selCmdKeys = selCmdKeys.trim()).length() > 0)
			{
				StringTokenizer stKeys = new StringTokenizer(selCmdKeys,",");
				if(stKeys.countTokens() == 1)
				{
					String cmd_key = stKeys.nextToken();
					allCommands = iniUI.getValue(osSubject,cmd_key);
					delCmdKeys.add(cmd_key);
				}
				else
				{
					StringBuffer sbCmds = new StringBuffer();
					while(stKeys.hasMoreTokens())
					{
						String cmd_key = stKeys.nextToken();
						String cmd_desc = iniUI.getValue(osSubject,cmd_key);
						sbCmds.append(",");
						sbCmds.append(cmd_desc.substring(0,cmd_desc.indexOf("|")));
						sbCmds.append(" ("+cmd_desc.substring(cmd_desc.indexOf("|")+1)+")");
						delCmdKeys.add(cmd_key);
					}
					allCommands = sbCmds.toString();
				}
			}
			if(!delCmdKeys.isEmpty())
			{
				IniFile iniUserRc = EgConfigFilesSync.getInstance(iniConfDir+"eg_usercommands.ini", true);
				String[] permitCmdUsers = iniUserRc.getVariables("ALLOWED_COMMANDS");
				for(int i=0;i<permitCmdUsers.length;i++)
				{
					String user = permitCmdUsers[i];
					String cmds = iniUserRc.getValue("ALLOWED_COMMANDS",user).trim();
					String typePipeIds[] = StringUtils.getTokens(cmds,"#");
					String customStr=typePipeIds[0];
					String newValStr=null;
					boolean isValid=false;
					int pairCount=typePipeIds.length;
					for(int j=1;j<pairCount;j++)
					{
						String pair=typePipeIds[j];
						int pipeIdx=pair.indexOf("|");
						if(pipeIdx>0)
						{
							isValid=true;
							String copyType=pair.substring(0,pipeIdx);
							String tids=pair.substring(pipeIdx+1);
							ArrayList task_ids=StringUtils.myTokenizer(tids,",");
							task_ids.removeAll(delCmdKeys);
							int tsize=task_ids.size();
							if(tsize>0)
							{
								StringBuffer buffer = new StringBuffer();
								for(int k=0;k<tsize;k++)
								{
									buffer.append((String)task_ids.get(k));
									buffer.append(EgConstants.COMMA);
								}
								buffer.deleteCharAt(buffer.length()-1);
								String newIds=buffer.toString();
								if(newValStr==null)
								{
									newValStr=customStr+"#"+copyType+"|"+newIds;
								}
								else
								{
									newValStr+="#"+copyType+"|"+newIds;
								}
								buffer.setLength(0);
							}
						}
					}
					if(isValid)
					{
						if(newValStr==null)
						{
							delUserList.add(user);
						}
						else
						{
							updateUserList.add(user);
							updateCmdsList.add(newValStr);
						}
					}
				}
				iniUI.deleteValues(osSubject,delCmdKeys);
				iniUI.saveFile();
				if(!delUserList.isEmpty())
				{
					iniUserRc.deleteValues("ALLOWED_COMMANDS",delUserList);
				}
				if(!updateUserList.isEmpty() && !updateCmdsList.isEmpty())
				{
					iniUserRc.setValues("ALLOWED_COMMANDS",updateUserList,updateCmdsList,false);
				}
				iniUserRc.saveFile();
				EgConfigFilesSync.releaseInstance(iniUserRc);

				if(allCommands.startsWith(","))
				{
					allCommands = allCommands.substring(1);
				}
				if(allCommands.indexOf(",")!=-1)
				{
					auditLogThread.setCurrentValue("ColumnName","Commands Deleted");
					auditLogThread.setCurrentValue("Deleted Commands",allCommands);
					auditLogThread.setValue("Description","Commands of "+selectedOS+" operating system have been deleted");
					resultMsg.put("message1",_mapping.getTextDescription("admin.remote.Selected commands deleted successfully"));
				}
				else
				{
					int pipeIdx = allCommands.indexOf("|");
					auditLogThread.setCurrentValue("ColumnName","Command Deleted");
					auditLogThread.setCurrentValue("1~~Operating System",selectedOS);
					auditLogThread.setCurrentValue("2~~Command Display Name",allCommands.substring(0,pipeIdx));
					auditLogThread.setCurrentValue("3~~Command Syntax",allCommands.substring(pipeIdx+1));
					auditLogThread.setValue("Description","Command has been deleted");
					resultMsg.put("message1",_mapping.getTextDescription("admin.remote.Selected command deleted successfully"));
				}
				auditLogThread.sendItToDB();
			}
		}
		EgConfigFilesSync.releaseInstance(iniUI);
	}
	session.removeAttribute("cmds");

	rootJson.put("requestStatus","success");
	rootJson.put("result",resultMsg);
	out.println(rootJson.toString());
	//System.out.println("rootJson_______"+rootJson);
%>



