<%@ include file= "../../EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="application/json; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import="com.eg.EgGroupInfo"%>
<%@ page import = "com.eg.EgTopoInfo"%>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import = "com.eg.EgAggregateInfo"%>
<%@ page import="com.egurkha.util.StringUtils" %>
<%@ page import="net.sf.json.*" %>
<%@ page import="java.util.*"%>
<%@ page import = "com.eg.EgGroupInfoAdmin"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.egurkha.EgUserRole"%>
<%@ page import = "egurkha.EgDbAdapterUI"%>
<%@ page import = "com.eg.EgDbAdapterTypeUI"%>
<%@ page import = "java.sql.*"%>

<%
	response.setContentType("application/json;charset=UTF-8");
	JSONObject rootJson = new JSONObject();
	JSONObject parentObject = new JSONObject();
	JSONObject parentObjectGroups = new JSONObject();
	JSONObject parentObjectSegments = new JSONObject();
	JSONObject parentObjectServices = new JSONObject();
	JSONObject parentObjectZones = new JSONObject();

	JSONArray arrayOne = new  JSONArray();
	JSONArray subGroups = new JSONArray();
	JSONArray subSegments = new JSONArray();
	JSONArray subServices = new JSONArray();
	JSONArray subZones = new JSONArray();
	String highLightNode=request.getParameter("highLightNode");
	if(StringUtils.isNull(highLightNode))
	{
		highLightNode="Components";
	}
	
	ArrayList externalAgents = new ArrayList();
	ArrayList remoteAgents = new ArrayList();

	String user_id = _user.getLoginID();
	EgUuidInfo uuidInfo = new EgUuidInfo();
	if (uuidInfo.isUser(user_id) && uuidInfo.hasOURole(user_id))
	{
		user_id = uuidInfo.getDirectDependentOU(user_id);
	}
	EgCertUsage user = new EgCertUsage();
	ArrayList usersList = user.getAllLimitedCompAccessUsers(true);
	boolean isLimitedAdmin = (usersList.contains(_user.getLoginID()));
	boolean isShowElements = false;

	if(isLimitedAdmin)
	{
		EgUserElementsInfo userElemInfoObj = new EgUserElementsInfo();
		externalAgents = userElemInfoObj.getExternalAgentsForUser(user_id);
		remoteAgents = userElemInfoObj.getRemoteAgentsForUser(user_id);
	}
	else
	{
		EgExternalInfo extInfo = new EgExternalInfo("manager");
		String[] extAgents = extInfo.getAllExternalAgents();
		String[] remAgents = extInfo.getAllRemoteAgents();
		if(extAgents != null)
		{
			externalAgents.addAll(Arrays.asList(extAgents));
		}
		if(remAgents != null)
		{
			remoteAgents.addAll(Arrays.asList(remAgents));
		}
	}

	EgTesterInfo testerInfo = new EgTesterInfo("manager");
	boolean externalAgentRunsAllAggTests = testerInfo.externalAgentRunsAllAggTests();
	if(externalAgentRunsAllAggTests)
	{
		if(externalAgents != null && !externalAgents.isEmpty())
		{
			isShowElements = true;
		}
	}
	else if(remoteAgents != null && !remoteAgents.isEmpty())
	{
		isShowElements = true;
	}

	String searchStr = egurkha.EgUIUtils.decodeMultiChars(request.getParameter("searchValue"));
	searchStr = egurkha.EgUIUtils.decodeSecurityChar(searchStr);
	boolean isElementCreated = false;
	boolean isSearchEntities = (searchStr != null && searchStr.trim().length() >0);
	ArrayList searchList = new ArrayList();
	if(isSearchEntities)
	{
		StringTokenizer searchTokens = new StringTokenizer(searchStr);
		while (searchTokens.hasMoreTokens())
		{
			String thisToken = searchTokens.nextToken().trim();
			if (thisToken.equals(""))
				continue;
			searchList.add(thisToken);
		}
	}

	EgGroupInfo groupInfo = new EgGroupInfo();
	EgTopoInfo topoInfo = new EgTopoInfo("manager");

	EgAggregateInfo aggregateInfo = new EgAggregateInfo("manager");
	Vector noAggSupportTypes = aggregateInfo.getNoAggregateSupportTypes();
	if(noAggSupportTypes != null && noAggSupportTypes.isEmpty())
	{
		noAggSupportTypes = null;
	}

	String[] groups = null;
	String[] segments = null;
	String[] services = null;
	String[] zones = null;

	if(isShowElements)
	{
		groups = groupInfo.getGroupNames();
		segments = topoInfo.getSegmentNames();
		services = topoInfo.getVariables("SERVICE");
		zones = groupInfo.getZoneNames();

		EgUserRole userRole = _user.getUserRole();
		boolean hasAllComponentAccess = userRole.hasAllComponentAccess();
		if(!hasAllComponentAccess)
		{
			//user specific work - start
			ArrayList userSpecZoneList = new ArrayList();
			ArrayList userSpecServiceList = new ArrayList();
			ArrayList userSpecSegmentList = new ArrayList();
			ArrayList userSpecGroupList = new ArrayList();
			String sql_query = "";
			ResultSet rs = null;
			String con_status = "";
			EgDbAdapterUI egDb;
			String session_userId = (String)session.getAttribute("sess_userid");

			EgUuidInfo egUuidInfo = new EgUuidInfo();
			boolean isSuperOrg = egUuidInfo.isSuperOrg(session_userId);
			boolean isOrg = egUuidInfo.isOrg(session_userId);
			boolean isUser = egUuidInfo.isUser(session_userId);
			boolean hasOURole = egUuidInfo.hasOURole(session_userId);

			egDb = EgDbAdapterTypeUI.getObject();
			con_status = egDb.setConnection();
			try
			{
				if(con_status.equals("CONNECTED"))
				{
					sql_query = "SELECT ZONE_NAME FROM USER_ZONE WHERE USER_ID='" + session_userId + "' ";
					rs = egDb.SelectExec(sql_query);
					while(rs.next())
					{
						String zone_name = rs.getString("ZONE_NAME");
						userSpecZoneList.add(zone_name);
					}

					sql_query = "SELECT SITE_NAME FROM USER_SITE WHERE USER_ID='" + session_userId + "' ";
					rs = egDb.SelectExec(sql_query);
					while(rs.next())
					{
						String service_name = rs.getString("SITE_NAME");
						userSpecServiceList.add(service_name);
					}

					sql_query = "SELECT SEG_NAME FROM USER_SEG WHERE USER_ID='" + session_userId + "' ";
					rs = egDb.SelectExec(sql_query);
					while(rs.next())
					{
						String segment_name = rs.getString("SEG_NAME");
						userSpecSegmentList.add(segment_name);
					}

					sql_query = "SELECT GROUP_NAME FROM USER_GROUP WHERE USER_ID='" + session_userId + "' ";
					rs = egDb.SelectExec(sql_query);
					while(rs.next())
					{
						String group_name = rs.getString("GROUP_NAME");
						userSpecGroupList.add(group_name);
					}
				}
			}
			catch(Exception e1)
			{
				e1.printStackTrace();
				out.println(e1.getMessage());
			}
			finally
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
			}
			egDb.releaseConnection(false);
			EgDbAdapterTypeUI.releaseObject(egDb);

			zones = (String[])userSpecZoneList.toArray(new String[userSpecZoneList.size()]);
			services = (String[])userSpecServiceList.toArray(new String[userSpecServiceList.size()]);
			segments = (String[])userSpecSegmentList.toArray(new String[userSpecSegmentList.size()]);
			groups = (String[])userSpecGroupList.toArray(new String[userSpecGroupList.size()]);
		}
		//user specific work - end
	}
	else
	{
		if(externalAgentRunsAllAggTests)
		{
			System.out.println("Aggregate AddAll page : No external agents found.");
		}
		else
		{
			System.out.println("Aggregate AddAll page : No remote agents found.");
		}
	}

	if(groups == null) groups = new String[0];
	if(segments == null) segments = new String[0];
	if(services == null) services = new String[0];
	if(zones == null) zones = new String[0];

	ArrayList validGroups = new ArrayList();
	for(int i=0;i<groups.length;i++)
	{
		Vector typeList = groupInfo.getComponentTypes("group",groups[i]);
		if(noAggSupportTypes != null)
		{
			typeList.removeAll(noAggSupportTypes);
		}
		for(int k=0;k<typeList.size();k++)
		{
			if(!typeList.get(k).toString().startsWith("Agg_"))
			{
				if(isSearchEntities && !doesExist(searchList,groups[i]))
				{
					continue;
				}
				else
				{
					validGroups.add(groups[i]);
				}
				break;
			}
		}
		Collections.sort(validGroups,String.CASE_INSENSITIVE_ORDER);
	}
	ArrayList validSegments = new ArrayList();
	for(int i=0;i<segments.length;i++)
	{
		Vector typeList = groupInfo.getComponentTypes("segment",segments[i]);
		if(noAggSupportTypes != null)
		{
			typeList.removeAll(noAggSupportTypes);
		}
		for(int k=0;k<typeList.size();k++)
		{
			if(!typeList.get(k).toString().startsWith("Agg_"))
			{
				if(isSearchEntities && !doesExist(searchList,segments[i]))
				{
					continue;
				}
				else
				{
					validSegments.add(segments[i]);
				}
				break;
			}
		}
		Collections.sort(validSegments,String.CASE_INSENSITIVE_ORDER);
	}
	ArrayList validServices = new ArrayList();
	for(int i=0;i<services.length;i++)
	{
		Vector typeList = groupInfo.getComponentTypes("service",services[i]);
		if(noAggSupportTypes != null)
		{
			typeList.removeAll(noAggSupportTypes);
		}
		for(int k=0;k<typeList.size();k++)
		{
			if(!typeList.get(k).toString().startsWith("Agg_"))
			{
				if(isSearchEntities && !doesExist(searchList,services[i]))
				{
					continue;
				}
				else
				{
					validServices.add(services[i]);
				}
				break;
			}
		}
		Collections.sort(validServices,String.CASE_INSENSITIVE_ORDER);
	}
	ArrayList validZones = new ArrayList();
	for(int i=0;i<zones.length;i++)
	{
		Vector typeList = groupInfo.getComponentTypes("zone",zones[i]);
		if(noAggSupportTypes != null)
		{
			typeList.removeAll(noAggSupportTypes);
		}
		for(int k=0;k<typeList.size();k++)
		{
			if(!typeList.get(k).toString().startsWith("Agg_"))
			{
				if(isSearchEntities && !doesExist(searchList,zones[i]))
				{
					continue;
				}
				else
				{
					validZones.add(zones[i]);
				}
				break;
			}
		}
		Collections.sort(validZones,String.CASE_INSENSITIVE_ORDER);
	}
	groups = (String[]) validGroups.toArray(new String[validGroups.size()]);
	segments = (String[]) validSegments.toArray(new String[validSegments.size()]);
	services = (String[]) validServices.toArray(new String[validServices.size()]);
	zones = (String[]) validZones.toArray(new String[validZones.size()]);

	int treeCount = 1;
	parentObject.put("text","Components");
	parentObject.put("selectedTreeNode",new Integer(treeCount++));
	parentObject.put("leaf","true");
	parentObject.put("iconCls","iconComponent");
	if(groups != null && groups.length>0)
	{
		isElementCreated = true;
		parentObjectGroups.put("text","Groups");
		parentObjectGroups.put("selectedPage","Groups");
		parentObjectGroups.put("selectedTreeNode",new Integer(treeCount++));
		parentObjectGroups.put("expanded","true");
		parentObjectGroups.put("iconCls","iconGroup");
		for(int i=0; i<groups.length;i++)
		{
			String gname=groups[i];
			JSONObject tmpObj = new JSONObject();
			tmpObj.put("text",gname);
			String tooltip=gname;
			if(gname.length()>30)
			{
				tooltip=com.egurkha.util.StringUtils.format(tooltip, 25, "<br>");
			}
			tmpObj.put("qtip",tooltip);
			tmpObj.put("selectedPage","subGroups");
			tmpObj.put("selectedTreeNode",new Integer(treeCount++));
			tmpObj.put("leaf","true");
			tmpObj.put("iconCls","iconGroup");
			subGroups.add(tmpObj);
		}
		parentObjectGroups.put("children",subGroups);
	}
	if(segments != null && segments.length>0)
	{
		isElementCreated = true;
		parentObjectSegments.put("text","Segments");
		parentObjectSegments.put("selectedPage","Segments");
		parentObjectSegments.put("selectedTreeNode",new Integer(treeCount++));
		parentObjectSegments.put("expanded","true");
		parentObjectSegments.put("iconCls","iconSegment");
		for(int i=0; i<segments.length;i++)
		{
			JSONObject tmpObj = new JSONObject();
			tmpObj.put("text",segments[i]);
			tmpObj.put("selectedPage","subSegments");
			tmpObj.put("selectedTreeNode",new Integer(treeCount++));
			tmpObj.put("leaf","true");
			tmpObj.put("iconCls","iconSegment");
			subSegments.add(tmpObj);
		}
		parentObjectSegments.put("children",subSegments);
	}
	if(services != null && services.length>0)
	{
		isElementCreated = true;
		parentObjectServices.put("text","Services");
		parentObjectServices.put("selectedPage","Services");
		parentObjectServices.put("selectedTreeNode",new Integer(treeCount++));
		parentObjectServices.put("expanded","true");
		parentObjectServices.put("iconCls","iconService");
		for(int i=0; i<services.length;i++)
		{
			JSONObject tmpObj = new JSONObject();
			tmpObj.put("text",services[i]);
			tmpObj.put("selectedPage","subServices");
			tmpObj.put("selectedTreeNode",new Integer(treeCount++));
			tmpObj.put("leaf","true");
			tmpObj.put("iconCls","iconService");
			subServices.add(tmpObj);
		}
		parentObjectServices.put("children",subServices);
	}
	if(zones != null && zones.length>0)
	{
		isElementCreated = true;
		parentObjectZones.put("text","Zones");
		parentObjectZones.put("selectedPage","Zones");
		parentObjectZones.put("selectedTreeNode",new Integer(treeCount++));
		parentObjectZones.put("expanded","true");
		parentObjectZones.put("iconCls","iconZone");
		for(int i=0; i<zones.length;i++)
		{
			JSONObject tmpObj = new JSONObject();
			tmpObj.put("text",zones[i]);
			tmpObj.put("selectedPage","subZones");
			tmpObj.put("selectedTreeNode",new Integer(treeCount++));
			tmpObj.put("leaf","true");
			tmpObj.put("iconCls","iconZone");
			subZones.add(tmpObj);
		}
		parentObjectZones.put("children",subZones);
	}
	arrayOne.add(parentObject);
	if(!parentObjectGroups.isEmpty())
		arrayOne.add(parentObjectGroups);
	if(!parentObjectSegments.isEmpty())
		arrayOne.add(parentObjectSegments);
	if(!parentObjectServices.isEmpty())
		arrayOne.add(parentObjectServices);
	if(!parentObjectZones.isEmpty())
		arrayOne.add(parentObjectZones);

	JSONObject treeObj = new JSONObject();
	treeObj.put("text","Add/Modify Aggregates");
	treeObj.put("iconCls","iconAddModifyAggregates");
	treeObj.put("expanded","true");
	treeObj.put("children",arrayOne);
	treeObj.put("isElementCreated",isElementCreated);
	out.println(treeObj.toString());
%>

<%!
	private boolean doesExist(List searchList, String entity)
	{
		Iterator searchItr = searchList.iterator();
		while(searchItr.hasNext())
		{
			String searchStr = (String)searchItr.next();
			if(entity.indexOf(searchStr)!=-1 || (entity.toLowerCase().indexOf(searchStr.toLowerCase()))!=-1)
				return true;
		}
		return false;
	}
%>