<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import = "net.sf.json.*"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="java.util.*"%>
<%@ page language="java" contentType="application/json; charset=UTF-8" pageEncoding="UTF-8" %>
<%
	response.setContentType("application/json;charset=UTF-8");
	JSONObject rootJson = new JSONObject();
	
	MappingNameSorter sorter = new MappingNameSorter(trackerLanguage);
	EgTablesInfo tablesInfo = new EgTablesInfo("manager");

	String selectedLayer =request.getParameter("layer");
	Hashtable compTestDetails = (Hashtable)session.getAttribute("compTestDetails");
	String compType = (String)compTestDetails.get("compType");
	ArrayList associatedTests = new ArrayList();
	if(compTestDetails != null && compTestDetails.containsKey("TEST_MEASURES"))
	{
		LinkedHashMap TEST_MEASURES_ht = (LinkedHashMap)compTestDetails.get("TEST_MEASURES");
		Iterator itrtm = TEST_MEASURES_ht.keySet().iterator();
		while(itrtm.hasNext())
		{
			String atmp = (String)TEST_MEASURES_ht.get(itrtm.next());
			String array[] = StringUtils.getTokens(atmp,"|");
			for(int i=0;i<array.length;i++)
			{
				String atm = array[i];
				String t = atm.substring(0,atm.indexOf(":"));
				if(!associatedTests.contains(t))
				{
					associatedTests.add(t);
				}
			}
		}
	}

	boolean associatedComponentsFound = false;
	boolean availableComponentsFound = false;
	JSONArray associatedComponentsJsonArray = new JSONArray();
	JSONArray availableComponentsJsonArray = new JSONArray();

	ArrayList alreadyAsociatedCompTypes = new ArrayList();

	if(compTestDetails.containsKey("ass_comp_types"))
	{
		ArrayList associatedCompTypesPre = (ArrayList)compTestDetails.get("ass_comp_types");
		if(associatedCompTypesPre != null && !associatedCompTypesPre.isEmpty())
		{
			alreadyAsociatedCompTypes.addAll(associatedCompTypesPre);
		}
	}
	if(!alreadyAsociatedCompTypes.contains(compType))
	{
		alreadyAsociatedCompTypes.add(compType);
	}
	int compTypeCount = 0;
	if(!associatedTests.isEmpty())
	{
		EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
		EgDiscInfo discInfo = new EgDiscInfo("manager");
		String componentTypes[] = discInfo.getComponentTypes();
		if(componentTypes != null && componentTypes.length>0)
		{
			ArrayList tempList = new ArrayList();
			tempList.addAll(Arrays.asList(componentTypes));
			ArrayList serverList = sorter.getSortedCompTypeList(tempList);
			for(int i=0;i<componentTypes.length;i++)
			{
				EgName egNameObj = (EgName)serverList.get(i);
				String componentType = egNameObj.getActualName();
				if(componentType.startsWith("Agg_"))
				{
					continue;
				}
				String defaultTests[] = specsInfo.getDefaultTestsForServer(componentType);
				if(defaultTests == null || defaultTests.length==0)
					continue;
				ArrayList allTests=new ArrayList();
				allTests.addAll(Arrays.asList(defaultTests));
				if(!allTests.containsAll(associatedTests))
					continue;
				ArrayList allLayers = tablesInfo.getLayersForComponent(componentType);
				if(allLayers == null || !allLayers.contains(selectedLayer))
				{
					alreadyAsociatedCompTypes.remove(componentType);
					continue;
				}
				if(!alreadyAsociatedCompTypes.contains(componentType))
				{
					JSONObject compTypeObj = new JSONObject();
					compTypeObj.put("displayField",egNameObj.getLocalName());
					compTypeObj.put("valueField",componentType);
					availableComponentsJsonArray.add(compTypeObj);
					availableComponentsFound=true;
					compTypeCount++;
				}
			}
		}
	}
	for(int i=0;i<alreadyAsociatedCompTypes.size();i++)
	{
		String tmp = (String)alreadyAsociatedCompTypes.get(i);
		JSONObject compTypeObj = new JSONObject();
		compTypeObj.put("displayField",_mapping.getComponentTypeDescription(tmp));
		compTypeObj.put("valueField",tmp);
		associatedComponentsJsonArray.add(compTypeObj);
		associatedComponentsFound=true;
	}
	rootJson.put("availableComponents",availableComponentsJsonArray);
	rootJson.put("associatedComponents",associatedComponentsJsonArray);
	rootJson.put("associatedComponentsFound",associatedComponentsFound);
	rootJson.put("availableComponentsFound",availableComponentsFound);
	rootJson.put("multipleCompTypesCanBeAssociated",(compTypeCount>0)?true:false);
	rootJson.put("lastSelection",request.getParameter("lastSelection"));

	String compTest = (String)compTestDetails.get("compTest");
	rootJson.put("is_predefined_test",(compTest.indexOf("_")==compTest.lastIndexOf("_"))?true:false);


	rootJson.put("success","true");
	out.println(rootJson.toString());

%>