<%
/*******************************************************************************
*
*	Name			:	EgBuildTreeJSON.jsp
*	Purpose			:	This jsp is used for processing view of Identity Provider Information.
*	Version			:	
*	CreationDate	:	13/11/2015
*	LastModified	:	
*	Author			:	Vengatesan R
*	Design Changes	:	
*******************************************************************************/
%>

<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import="com.eg.IniFile" %>
<%@ page import="com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgCrypt"%>
<%@ page import = "com.egurkha.monitor.*"%>
<%@ page import = "java.io.*"%>
<%@ page import = "java.util.*"%>
<%@ page import = "net.sf.json.*"%>
<%@ page import = "com.egurkha.util.StringUtils"%>

<%@ page language="java" contentType="application/json; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");

	JSONObject rootObj = new JSONObject();

	IniFile egAuthenticate=new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_samlsso.ini");
	String[] allSso=egAuthenticate.getSubjects();
	UserViewModel userView = new UserViewModel();
	Hashtable ht_users = userView.getUsers();
	Vector users = new Vector();
	Vector idpUsers = new Vector();
	if (ht_users !=null)
	{
		Enumeration ee = ht_users.keys();
		while (ee.hasMoreElements())
		{
			String username = (String)ee.nextElement();
			users.add(username);
			if (!username.startsWith("samlsso/"))
				continue;
			
			String ssoDisplayName = username.substring(username.indexOf("/")+1,username.lastIndexOf("/"));
			if (!idpUsers.contains(ssoDisplayName))
				idpUsers.add(ssoDisplayName);
		}
	}

	boolean isClusterSupported  = EgInstallInfo.isClusterSupported ;
	rootObj.put("isClusterSupported",isClusterSupported);

	String strSSOLogin = egAuthenticate.getValue("SAML_SSO","SSO_ENABLED");
	String strIdpLogout = egAuthenticate.getValue("SAML_SSO","IDP_LOGOUT");
	String strDefaultLoginIdp = egAuthenticate.getValue("SAML_SSO","defaultIdPForLogin");

	boolean isSsoEnabled = false;
	if (!com.egurkha.util.StringUtils.isNull(strSSOLogin) && strSSOLogin.equalsIgnoreCase("yes"))
	{
		isSsoEnabled = true;
	}
	rootObj.put("isSsoEnabled",isSsoEnabled);

	boolean isIdpLogoutEnabled = false;
	if (!com.egurkha.util.StringUtils.isNull(strIdpLogout) && strIdpLogout.equalsIgnoreCase("yes"))
	{
		isIdpLogoutEnabled = true;
	}
	rootObj.put("isIdpLogoutEnabled",isIdpLogoutEnabled);

	session.setAttribute("idpUsers",idpUsers);

	/*
	boolean userexists=false;
	for (int i =0; i<users.size();i++)
	{
		String uName=(String)users.get(i);
		for (int j =0 ; j< allSso.length;j++)
		{
			if (com.egurkha.util.StringUtils.isNull(allSso[j]) && (allSso[j].equals("SAML_SSO") || allSso[j].startsWith("SECONDARY_")))
			{
				continue;
			}

			if (uName.startsWith(allSso[j]+"/"))
			{
				userexists=true;
				break;
			}
		}
	}*/
	String comty=request.getParameter("ctype");
	String isSsoFound = "no";
	
	if (allSso != null && allSso.length > 1)
	{
		isSsoFound = "yes";
	}

	IniFile egUI = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_samlsso.ini");

	JSONArray allsso = new JSONArray();
	rootObj.put("isSsoConfigured",new Boolean(false));
	for (int i=0;i < allSso.length; i++)
	{
		if (!com.egurkha.util.StringUtils.isNull(allSso[i]) && (allSso[i].equals("SAML_SSO") || allSso[i].startsWith("SECONDARY_")))
		{
			continue;
		}

		rootObj.put("isSsoConfigured",new Boolean(true));
		JSONObject tmpObj = new JSONObject();
		String loginURL = (String)egAuthenticate.getValue(allSso[i],"loginURL");
		String logoutURL = (String)egAuthenticate.getValue(allSso[i],"logoutURL");
		String certInfo = (String)egAuthenticate.getValue(allSso[i],"certInfo");
		String isSecondary = (String)egAuthenticate.getValue(allSso[i],"isSecondary");
		
		if (logoutURL == null||logoutURL.length()==0) logoutURL = "none";
		boolean isUserExist = false;
		if (idpUsers.contains(allSso[i]))
		{
			isUserExist = true;
		}
		tmpObj.put("SAML IdP Name",allSso[i]);
		tmpObj.put("Login URL",loginURL);
		tmpObj.put("Logout URL",logoutURL);
		tmpObj.put("isUserExist",isUserExist);
		if (!com.egurkha.util.StringUtils.isNull(strDefaultLoginIdp) && strDefaultLoginIdp.equals(allSso[i]))
		{
			tmpObj.put("Is default IdP for login?","Yes");
		}
		else
		{
			tmpObj.put("Is default IdP for login?","No");
		}

		tmpObj.put("Certificate",certInfo);
		tmpObj.put("IdP for secondary manager",isSecondary);
		allsso.add(tmpObj);	
	}

	JSONArray gridColums = new JSONArray();
	gridColums.add("SAML IdP Name");
	gridColums.add("Login URL");
	gridColums.add("Logout URL");
	gridColums.add("Is default IdP for login?");
	gridColums.add("IdP for secondary manager");
	gridColums.add("Certificate");

	rootObj.put("gridColums",gridColums);
	rootObj.put("allsso",allsso);

	String hostName = EgInstallInfo.getHostName();
	if (!com.egurkha.util.StringUtils.isNull(hostName) && hostName.indexOf(".") != -1)
	{
		hostName = hostName.substring(0,hostName.indexOf("."));
	}

	String fileSep = System.getProperty("file.separator");
	String filePath = EgInstallInfo.getInstallDir()+fileSep+"manager"+fileSep+"tomcat"+fileSep+"webapps"+fileSep+"final"+fileSep+"WEB-INF"+fileSep+"classes"+fileSep+"metadata";

	String fileName = "eGMetadata_"+hostName+".xml";

	rootObj.put("filePath",filePath);
	rootObj.put("fileName",fileName);
	if (isClusterSupported)
	{
		String secHostName = getSecondaryManagerHostName();
		secHostName = "eGMetadata_"+secHostName+".xml";
		rootObj.put("secFileName",secHostName);

		String strSecAcsURL = egAuthenticate.getValue("SAML_SSO","SECONDARY_ACS_URL");
		String strSecLogoutURL = egAuthenticate.getValue("SAML_SSO","SECONDARY_LOGOUT_URL");

		rootObj.put("strSecAcsURL",strSecAcsURL);
		rootObj.put("strSecLogoutURL",strSecLogoutURL);

	}

	String strAcsURL = egAuthenticate.getValue("SAML_SSO","ACS_URL");
	String strLogoutURL = egAuthenticate.getValue("SAML_SSO","LOGOUT_URL");
	rootObj.put("strAcsURL",strAcsURL);
	rootObj.put("strLogoutURL",strLogoutURL);


	session.setAttribute("adminLastAccessedURL","/final/admin/EgConfigureIdpHome.jsp");
	out.println(rootObj.toString());
%>

<%!

	private String getSecondaryManagerHostName()
	{
		String hostName = "";
		EgManagersIniForManager mgrIni = EgManagersIniForManager.getInstance();
		boolean isThisAPrimaryManager = mgrIni.isPrimaryManager();

		ArrayList secondMgrIps = mgrIni.getSecondaryManagers();
		if (secondMgrIps != null && secondMgrIps.size() > 0)
		{
			if (secondMgrIps.size() == 1)
			{
				hostName = com.egurkha.util.StringUtils.getString(secondMgrIps);
				hostName = EgInstallInfo.getHostName(hostName);
			}
			else
			{
				hostName = (String) secondMgrIps.get(0);
				hostName = EgInstallInfo.getHostName(hostName);
			}
		}
		return hostName;
	}

%>





