<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import = "java.io.*"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "net.sf.json.*"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import="com.egurkha.admin.AuditLogThread"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");
	
	JSONObject rootObj = new JSONObject();
	EgUserRole usrRole = _user.getUserRole();
	boolean hasAllComponentAccess = usrRole.hasAllComponentAccess();
	
	String session_userid = (String)session.getAttribute("sess_userid");
	EgUuidInfo egUuidInfo = new EgUuidInfo();
	String orgname = "";
	if (!hasAllComponentAccess)
	{
		boolean isSuperOrg = egUuidInfo.isSuperOrg(session_userid);
		boolean isOrg = egUuidInfo.isOrg(session_userid);
		if (isSuperOrg)
		{
			orgname = session_userid;
		}
		else if (isOrg)
		{
			orgname = session_userid;
		}
		else
		{
			orgname = egUuidInfo.getDirectDependentOU(session_userid);
		}
	}
	else
	{
		orgname = "egenterprise";
	}
	String fromAction = request.getParameter("fromAction");
	String mibFile = request.getParameter("mibFile");
	int extIdx = mibFile.lastIndexOf(".");
	if (extIdx != -1)
	{
		mibFile = mibFile.substring(0,extIdx);
	}
	
	IniFile trapsConfig_read = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_trappriority.ini");
		
	Hashtable trapOidNameMap = new Hashtable();
	Vector trapsOidsVec = trapsConfig_read.getVariables(orgname+"^#^OIDNameMap", false);
	Vector trapsNameVec = trapsConfig_read.getAllValues(orgname+"^#^OIDNameMap", false);
	if (trapsOidsVec != null && trapsOidsVec.size() > 0)
	{
		int traps_size = trapsOidsVec.size();
		for (int t=0; t<traps_size; t++)
		{
			String trapOid = (String) trapsOidsVec.get(t);
			String trapName = (String) trapsNameVec.get(t);
			trapOidNameMap.put(trapOid,trapName);
		}
	}
	
	Vector trapObjectsOidsVec = trapsConfig_read.getVariables(orgname+"^#^ObjectOIDNameMap", false);
	Vector trapObjectsNameVec = trapsConfig_read.getAllValues(orgname+"^#^ObjectOIDNameMap", false);
	if (trapObjectsOidsVec != null && trapObjectsOidsVec.size() > 0)
	{
		int trapObj_size = trapObjectsOidsVec.size();
		for (int t=0; t<trapObj_size; t++)
		{
			String trapObjectOid = (String) trapObjectsOidsVec.get(t);
			String trapObjectName = (String) trapObjectsNameVec.get(t);
			trapOidNameMap.put(trapObjectOid,trapObjectName);
		}
	}
	
	if (!StringUtils.isNull(fromAction) && fromAction.equals("delete") && !StringUtils.isNull(mibFile))
	{
		Hashtable prevTrapTypePriorityMap = new Hashtable();
		Vector allTrapOidVec = new Vector();
		Vector allTrapObjectOidVec = new Vector();
		IniFile trapsConfig_write = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_trappriority.ini",true);
		
		String[] alltrapsSubjects = trapsConfig_write.getSubjects();
		
		if (alltrapsSubjects != null && alltrapsSubjects.length > 0)
		{
			int len = alltrapsSubjects.length;
			for (int i=0; i<len; i++)
			{
				String subject = alltrapsSubjects[i];
				if (subject.startsWith(orgname+"^#^"+mibFile))
				{
					ArrayList tokensList = new ArrayList(StringUtils.egTokenizer(subject,"^#^"));
					int tokens_size = tokensList.size();
					if (tokens_size > 2)
					{
						String trapOid = (String) tokensList.get(2);
						allTrapOidVec.add(trapOid);
						
						Vector objectOidVars = trapsConfig_write.getVariables(subject, false);
						Vector objectOidVals = trapsConfig_write.getAllValues(subject, false);
						
						if (objectOidVars != null && objectOidVars.size() > 0)
						{
							String variableStr = "";
							int tsize = objectOidVars.size();
							for (int c=0; c<tsize; c++)
							{
								String variable = (String) objectOidVars.get(c);
								String priorityStr = (String) objectOidVals.get(c);
								variableStr += "#$#"+variable+"#@#"+priorityStr;
								
								ArrayList variableList= new ArrayList(StringUtils.egTokenizer(variable,"$#$"));
								if (variableList != null && variableList.size() > 0)
								{
									int vsize = variableList.size();
									for (int d=0; d<vsize; d++)
									{
										String subVariable = (String) variableList.get(d);
										int vIdx = subVariable.indexOf("^#^");
										String objOID = subVariable.substring(0,vIdx);
										allTrapObjectOidVec.add(objOID);
									}
								}
							}
							variableStr = variableStr.substring(3);
							prevTrapTypePriorityMap.put(trapOid,variableStr);
						}
					}
					else
					{
						Vector trapsOidVars = trapsConfig_write.getVariables(subject, false);
						Vector trapsOidVals = trapsConfig_write.getAllValues(subject, false);
						if (trapsOidVars != null && trapsOidVars.size() > 0)
						{
							int traps_size = trapsOidVars.size();
							for (int m=0; m<traps_size; m++)
							{
								String trapOid = (String) trapsOidVars.get(m);
								String trapPriority = (String) trapsOidVals.get(m);
								prevTrapTypePriorityMap.put(trapOid,trapOid+"#@#"+trapPriority);
							}
							allTrapOidVec.addAll(trapsOidVars);
						}
					}
					trapsConfig_write.deleteSubject(subject);
				}
			}
		}
		
		if (allTrapOidVec != null && allTrapOidVec.size() > 0)
		{
			trapsConfig_write.deleteValues(orgname+"^#^OIDNameMap",allTrapOidVec);
		}
		
		if (allTrapObjectOidVec != null && allTrapObjectOidVec.size() > 0)
		{
			trapsConfig_write.deleteValues(orgname+"^#^ObjectOIDNameMap",allTrapObjectOidVec);
		}
		
		trapsConfig_write.saveFile();
		EgConfigFilesSync.releaseInstance(trapsConfig_write);
		
		if (prevTrapTypePriorityMap != null && prevTrapTypePriorityMap.size() > 0)
		{
			AuditLogThread auditLogThread = new AuditLogThread();
			auditLogThread.setValue("Category","Admin");
			auditLogThread.setValue("User_id",_user.getLoginID());
			auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
			auditLogThread.setValue("Session_id",session.getId());
			auditLogThread.setValue("Module","SNMP Traps - Trap Priority");
			auditLogThread.setValue("Activity","Delete trap priority");
			
			Iterator trapItr = prevTrapTypePriorityMap.keySet().iterator();
			while(trapItr.hasNext())
			{
				String trapOidStr = (String)trapItr.next();
				String trapNameStr = (String)trapOidNameMap.get(trapOidStr);
				if (!StringUtils.isNull(trapNameStr))
				{
					String trapPriority = (String)prevTrapTypePriorityMap.get(trapOidStr);
					if (trapPriority.indexOf("^#^") != -1)
					{
						auditLogThread.setCurrentValue("Deleted Traps",trapNameStr);
					}
					else
					{
						auditLogThread.setCurrentValue("Deleted Traps",trapNameStr);
					}
				}
			}
			auditLogThread.setValue("Description","Using "+mibFile+" trap priorities have been deleted.");
			auditLogThread.sendItToDB();
		}
		
		IniFile trapsConfig = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_trappriority.ini");
		
		boolean isConfiguredFilesExist = false;
		String[] allSubjects = trapsConfig.getSubjects();
		if (allSubjects != null && allSubjects.length > 0)
		{
			int len = allSubjects.length;
			for (int x=0; x<len; x++)
			{
				String subject = allSubjects[x];
				
				if (subject.equalsIgnoreCase(orgname+"^#^OIDNameMap"))
				{
					continue;
				}
				
				if (subject.equalsIgnoreCase(orgname+"^#^ObjectOIDNameMap"))
				{
					continue;
				}
				
				if (subject.startsWith(orgname+"^#^"))
				{
					isConfiguredFilesExist = true;
					break;
				}
			}
		}
		rootObj.put("isConfiguredFilesExist",isConfiguredFilesExist);
	}
	else
	{
		String finalValue = request.getParameter("finalValue");
		finalValue = StringUtils.decodeSecurityChar(finalValue);
		
		Hashtable prevTrapTypePriorityMap = new Hashtable();
		Vector allTrapOidVec = new Vector();
		Vector allTrapObjectOidVec = new Vector();
		IniFile trapsConfig_write = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_trappriority.ini",true);
		
		String[] alltrapsSubjects = trapsConfig_write.getSubjects();
		
		if (alltrapsSubjects != null && alltrapsSubjects.length > 0)
		{
			int len = alltrapsSubjects.length;
			for (int i=0; i<len; i++)
			{
				String subject = alltrapsSubjects[i];
				if (subject.startsWith(orgname+"^#^"+mibFile))
				{
					ArrayList tokensList = new ArrayList(StringUtils.egTokenizer(subject,"^#^"));
					int tokens_size = tokensList.size();
					if (tokens_size > 2)
					{
						String trapOid = (String) tokensList.get(2);
						allTrapOidVec.add(trapOid);
						
						Vector objectOidVars = trapsConfig_write.getVariables(subject, false);
						Vector objectOidVals = trapsConfig_write.getAllValues(subject, false);
						
						if (objectOidVars != null && objectOidVars.size() > 0)
						{
							String variableStr = "";
							int tsize = objectOidVars.size();
							for (int c=0; c<tsize; c++)
							{
								String variable = (String) objectOidVars.get(c);
								String priorityStr = (String) objectOidVals.get(c);
								variableStr += "#$#"+variable+"#@#"+priorityStr;
								
								ArrayList variableList= new ArrayList(StringUtils.egTokenizer(variable,"$#$"));
								if (variableList != null && variableList.size() > 0)
								{
									int vsize = variableList.size();
									for (int d=0; d<vsize; d++)
									{
										String subVariable = (String) variableList.get(d);
										int vIdx = subVariable.indexOf("^#^");
										String objOID = subVariable.substring(0,vIdx);
										allTrapObjectOidVec.add(objOID);
									}
								}
							}
							variableStr = variableStr.substring(3);
							prevTrapTypePriorityMap.put(trapOid,variableStr);
						}
					}
					else
					{
						Vector trapsOidVars = trapsConfig_write.getVariables(subject, false);
						Vector trapsOidVals = trapsConfig_write.getAllValues(subject, false);
						if (trapsOidVars != null && trapsOidVars.size() > 0)
						{
							int traps_size = trapsOidVars.size();
							for (int m=0; m<traps_size; m++)
							{
								String trapOid = (String) trapsOidVars.get(m);
								String trapPriority = (String) trapsOidVals.get(m);
								prevTrapTypePriorityMap.put(trapOid,trapOid+"#@#"+trapPriority);
							}
							allTrapOidVec.addAll(trapsOidVars);
						}
					}
					trapsConfig_write.deleteSubject(subject);
				}
			}
		}
		
		if (allTrapOidVec != null && allTrapOidVec.size() > 0)
		{
			trapsConfig_write.deleteValues(orgname+"^#^OIDNameMap",allTrapOidVec);
		}
		
		if (allTrapObjectOidVec != null && allTrapObjectOidVec.size() > 0)
		{
			trapsConfig_write.deleteValues(orgname+"^#^ObjectOIDNameMap",allTrapObjectOidVec);
		}
		
		ArrayList newTrapPriorityList = new ArrayList();
		ArrayList modifiedTrapPriorityList = new ArrayList();
		
		Hashtable newTrapOidNameMap = new Hashtable();
		Hashtable currentTrapTypePriorityMap = new Hashtable();
		ArrayList configuredTrapsList = new ArrayList(StringUtils.egTokenizer(finalValue,"$$$"));
		
		int size = configuredTrapsList.size();
		for (int x=0; x<size; x++)
		{
			String trapsToken = (String) configuredTrapsList.get(x);
			int trap_idx = trapsToken.indexOf("###");
			String trapOidName = trapsToken.substring(0,trap_idx);
			int oidName_idx = trapOidName.indexOf("@@@");
			String trapOid = trapOidName.substring(0,oidName_idx);
			String trapName = trapOidName.substring(oidName_idx+3);
			String multiEntryStr = trapsToken.substring(trap_idx+3);
			
			String trapObjWithoutName = "";
			ArrayList multiEntryList = new ArrayList(StringUtils.egTokenizer(multiEntryStr,"#$#"));
			int obj_len = multiEntryList.size();
			for (int y=0; y<obj_len; y++)
			{
				String entryStr = (String) multiEntryList.get(y);
				int entry_idx = entryStr.indexOf("#@#");
				String variable = entryStr.substring(0,entry_idx);
				String prioirty = entryStr.substring(entry_idx+3);
				
				if (variable.indexOf("^#^") != -1)
				{
					String variableStr = "";
					ArrayList variableList= new ArrayList(StringUtils.egTokenizer(variable,"$#$"));
					
					if (variableList != null && variableList.size() > 0)
					{
						int varSize = variableList.size();
						for (int b=0; b<varSize; b++)
						{
							String varWithTrapName = (String) variableList.get(b);
							int idx = varWithTrapName.indexOf("@$@");
							String trapObjName = varWithTrapName.substring(0,idx);
							
							String variableSubStr = varWithTrapName.substring(idx+3);
							
							String trapObjOid = variableSubStr.substring(0,variableSubStr.indexOf("^#^"));
							
							variableStr += "$#$"+ variableSubStr;
							if (!newTrapOidNameMap.containsKey(trapObjOid))
							{
								newTrapOidNameMap.put(trapObjOid,trapObjName);
							}
							trapsConfig_write.setValue(orgname+"^#^ObjectOIDNameMap",trapObjOid,trapObjName);
						}
					}
					variableStr = variableStr.substring(3);
					trapObjWithoutName += "#$#"+variableStr+"#@#"+prioirty;
					
					trapsConfig_write.setValue(orgname+"^#^"+mibFile+"^#^"+trapOid,variableStr,prioirty);
				}
				else
				{
					trapObjWithoutName += "#$#"+entryStr;
					trapsConfig_write.setValue(orgname+"^#^"+mibFile,variable,prioirty);
				}
				
				if (!newTrapOidNameMap.containsKey(trapOid))
				{
					newTrapOidNameMap.put(trapOid,trapName);
				}
				
				trapsConfig_write.setValue(orgname+"^#^OIDNameMap",trapOid,trapName);
			}
			
			if (!StringUtils.isNull(trapObjWithoutName))
			{
				trapObjWithoutName = trapObjWithoutName.substring(3);
				currentTrapTypePriorityMap.put(trapOid,trapObjWithoutName);
			}
		}
		
		trapsConfig_write.saveFile();
		EgConfigFilesSync.releaseInstance(trapsConfig_write);
		
		Hashtable newTrapPriorityMap = new Hashtable();
		Hashtable modifiedTrapPriorityMap = new Hashtable();
		
		if (currentTrapTypePriorityMap != null && currentTrapTypePriorityMap.size() > 0)
		{
			Iterator curItr = currentTrapTypePriorityMap.keySet().iterator();
			while(curItr.hasNext())
			{
				String trapOidStr = (String)curItr.next();
				String currentVariable = (String)currentTrapTypePriorityMap.get(trapOidStr);
				
				String prevVariable = (String) prevTrapTypePriorityMap.get(trapOidStr);
				
				if (!StringUtils.isNull(prevVariable) && prevVariable.length() > 0)
				{
					if (!currentVariable.equals(prevVariable))
					{
						modifiedTrapPriorityMap.put(trapOidStr,prevVariable+"&&&"+currentVariable);
					}
					prevTrapTypePriorityMap.remove(trapOidStr);
				}
				else
				{
					newTrapPriorityMap.put(trapOidStr, currentVariable);
					prevTrapTypePriorityMap.remove(trapOidStr);
				}
			}
		}
		
		if (newTrapPriorityMap !=null && newTrapPriorityMap.size() > 0)
		{
			AuditLogThread auditLogThread = new AuditLogThread();
			auditLogThread.setValue("Category","Admin");
			auditLogThread.setValue("User_id",_user.getLoginID());
			auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
			auditLogThread.setValue("Session_id",session.getId());
			auditLogThread.setValue("Module","SNMP Traps - Trap Priority");
			auditLogThread.setValue("Activity","Add trap priority");
			
			Iterator trapItr = newTrapPriorityMap.keySet().iterator();
			while(trapItr.hasNext())
			{
				String trapOidStr = (String)trapItr.next();
				String trapValueStr = (String)newTrapPriorityMap.get(trapOidStr);
				
				String trapName = (String)trapOidNameMap.get(trapOidStr);	
				if (StringUtils.isNull(trapName))
				{
					trapName = (String)newTrapOidNameMap.get(trapOidStr);
				}
				
				String displayValue = getDisplayValue(trapValueStr, trapName, trapOidNameMap, newTrapOidNameMap);
				auditLogThread.setCurrentValue("Trap and Priority",displayValue);
			}
			
			auditLogThread.setValue("Description","Using "+mibFile+" trap priorities have been added.");
			auditLogThread.sendItToDB();
		}
		
		if (modifiedTrapPriorityMap !=null && modifiedTrapPriorityMap.size() > 0)
		{
			AuditLogThread auditLogThread1 = new AuditLogThread();
			auditLogThread1.setValue("Category","Admin");
			auditLogThread1.setValue("User_id",_user.getLoginID());
			auditLogThread1.setValue("Host_ip",_user.getUserIP(session.getId()));
			auditLogThread1.setValue("Session_id",session.getId());
			auditLogThread1.setValue("Module","SNMP Traps - Trap Priority");
			auditLogThread1.setValue("Activity","Modify trap priority");
			
			Iterator trapItr = modifiedTrapPriorityMap.keySet().iterator();
			while(trapItr.hasNext())
			{
				String trapOidStr = (String)trapItr.next();
				String trapValueStr = (String)modifiedTrapPriorityMap.get(trapOidStr);
				int prevIdx = trapValueStr.indexOf("&&&");
				String prevValueStr = trapValueStr.substring(0,prevIdx);
				String curValueStr = trapValueStr.substring(prevIdx+3);
				
				String trapName = (String)trapOidNameMap.get(trapOidStr);	
				if (StringUtils.isNull(trapName))
				{
					trapName = (String)newTrapOidNameMap.get(trapOidStr);
				}
				
				String prevDisplayValue =  getDisplayValue(prevValueStr, trapName, trapOidNameMap, newTrapOidNameMap);
				
				String curDisplayValue =  getDisplayValue(curValueStr, trapName, trapOidNameMap, newTrapOidNameMap);
				
				auditLogThread1.setPreviousValue("Trap and Priority",prevDisplayValue);
				auditLogThread1.setCurrentValue("Trap and Priority",curDisplayValue);
			}
			
			auditLogThread1.setValue("Description","Using "+mibFile+" trap priorities have been modified.");
			auditLogThread1.sendItToDB();
		}
		
		if (prevTrapTypePriorityMap != null && prevTrapTypePriorityMap.size() > 0)
		{
			AuditLogThread auditLogThread2 = new AuditLogThread();
			auditLogThread2.setValue("Category","Admin");
			auditLogThread2.setValue("User_id",_user.getLoginID());
			auditLogThread2.setValue("Host_ip",_user.getUserIP(session.getId()));
			auditLogThread2.setValue("Session_id",session.getId());
			auditLogThread2.setValue("Module","SNMP Traps - Trap Priority");
			auditLogThread2.setValue("Activity","Delete trap priority");
			
			Iterator trapItr = prevTrapTypePriorityMap.keySet().iterator();
			while(trapItr.hasNext())
			{
				String trapOidStr = (String)trapItr.next();
				String trapNameStr = (String)trapOidNameMap.get(trapOidStr);
				if (!StringUtils.isNull(trapNameStr))
				{
					String trapPriority = (String)prevTrapTypePriorityMap.get(trapOidStr);
					if (trapPriority.indexOf("^#^") != -1)
					{
						auditLogThread2.setCurrentValue("Deleted Traps",trapNameStr);
					}
					else
					{
						auditLogThread2.setCurrentValue("Deleted Traps",trapNameStr);
					}
				}
			}
			auditLogThread2.setValue("Description","Using "+mibFile+" trap priorities have been deleted.");
			auditLogThread2.sendItToDB();
		}
	}
	
	out.println(rootObj.toString());
%>

<%!
	private String getDisplayValue(String trapTypeAndObj, String trapType, Hashtable trapOidNameMap, Hashtable newTrapOidNameMap)
	{
		String displayValue = "";
		boolean isObject = false;
		ArrayList trapTypeAndObjList = new ArrayList(StringUtils.egTokenizer(trapTypeAndObj,"#$#"));
		int tSize = trapTypeAndObjList.size();
		for (int x=0; x<tSize; x++)
		{
			String entryStr = (String) trapTypeAndObjList.get(x);
			int entry_idx = entryStr.indexOf("#@#");
			String variable = entryStr.substring(0,entry_idx);
			String prioirty = entryStr.substring(entry_idx+3);
			
			if (variable.indexOf("^#^") != -1)
			{
				isObject = true;
				String variableStr = "";
				ArrayList variableList= new ArrayList(StringUtils.egTokenizer(variable,"$#$"));
				
				if (variableList != null && variableList.size() > 0)
				{
					int varSize = variableList.size();
					for (int b=0; b<varSize; b++)
					{
						String variableSubStr = (String) variableList.get(b);
						
						ArrayList allValueList= new ArrayList(StringUtils.egTokenizer(variableSubStr,"^#^"));
						
						String trapObjOid = (String) allValueList.get(0);
						String condition = (String) allValueList.get(1);
						String objValue = (String) allValueList.get(2);
						
						String trapObjName = (String)trapOidNameMap.get(trapObjOid);
						
						if (StringUtils.isNull(trapObjName))
						{
							trapObjName = (String)newTrapOidNameMap.get(trapObjOid);
						}
						
						if (condition.equals("eq"))
						{
							condition = "equals";
						}
						else if (condition.equals("ne"))
						{
							condition = "not equals";
						}
						else if (condition.equals("gt"))
						{
							condition = "greater than";
						}
						else if (condition.equals("lt"))
						{
							condition = "less than";
						}
						else if (condition.equals("ge"))
						{
							condition = "greater than or equals";
						}
						else if (condition.equals("le"))
						{
							condition = "less than or equals";
						}
						else if (condition.equals("mc"))
						{
							condition = "matches";
						}
						else if (condition.equals("nm"))
						{
							condition = "not matches";
						}
						
						String objValueStr = "";
						ArrayList tempValueList= new ArrayList(StringUtils.egTokenizer(objValue,"#^#"));
						if (tempValueList != null && tempValueList.size() > 0)
						{
							int tmpSize = tempValueList.size();
							
							for (int c=0; c<tmpSize; c++)
							{
								String tempValStr = (String) tempValueList.get(c);
								
								objValueStr += " OR "+tempValStr;
							}
						}
						objValueStr = objValueStr.substring(4);
						
						variableStr += " AND "+trapObjName+" "+condition+" "+objValueStr;
					}
				}
				variableStr = variableStr.substring(5);
				displayValue += " OR "+variableStr+" "+prioirty;
			}
			else
			{
				String trapName = (String)trapOidNameMap.get(variable);
						
				if (StringUtils.isNull(trapName))
				{
					trapName = (String)newTrapOidNameMap.get(variable);
				}
				displayValue += " OR "+trapName+" "+prioirty;
			}
		}
		displayValue = displayValue.substring(4);
		
		if (isObject)
		{
			displayValue = trapType+" "+displayValue;
		}
		return displayValue;
	}
%>


