
<%@ include file="../../EgTrackerAJSON.jsp" %>

<%@ page import = "com.eg.EgRoleInfo" %>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.EgName"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgUsersInfo"%>
<%@ page import = "com.eg.EgSpecsInfo" %>
<%@ page import = "net.sf.json.*"%>

<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");

	JSONObject rootJson = new JSONObject();

	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (_user != null)
	{
		userLanguage = _user.getLanguage();
	}
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);

	String componentType = request.getParameter("componentType");

	String testType = "PerformanceTest";

	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));

	EgUsersInfo usersInfo = new EgUsersInfo();
	String usrBasedTests = "";
	if (usersInfo.isUserBasedLicense())
	{
		if (componentType != null && !componentType.equals(""))
		{
			ArrayList userBasedTests = usersInfo.getUserBasedTests(componentType);
			for (int i=0; i<userBasedTests.size(); i++)
			{
				String test = userBasedTests.get(i).toString();
				if (usrBasedTests.equals(""))
				{
					usrBasedTests += test;
				}
				else
				{
					usrBasedTests += ","+test;
				}
			}
		}
	}
	rootJson.put("usrBasedTests",usrBasedTests);

	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
	String[] allExtCompTypeArr = egSpecs.getAllExternalServerTypes();
	HashSet allExtCompTypeSet = new HashSet(Arrays.asList(allExtCompTypeArr));
	IniFile servicesIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_services.ini");
	ArrayList agentlessServers = new ArrayList(Arrays.asList(servicesIni.getVariables("AGENTLESS_SERVERS")));

	ArrayList serverList = new ArrayList();
	String[] componentTypes = ri.getServerTypes();
	for (int m=0; m<componentTypes.length; m++)
	{
		String strComponentType = (String) componentTypes[m];
		if (strComponentType.startsWith("Agg_"))
		{
			continue;
		}
		if (allExtCompTypeSet.contains(strComponentType))
		{
			continue;
		}
		if (agentlessServers.contains(strComponentType))
		{
			continue;
		}
		serverList.add(strComponentType);
	}

	JSONArray CompType = new JSONArray();
	JSONObject compTypeObj = new JSONObject();

	if (serverList != null && serverList.size() > 0)
	{
		compTypeObj.put("displayField",_mapping.getTextDescription("admin.common.Choose a component type"));
		compTypeObj.put("valueField","-1");
		CompType.add(compTypeObj);

		serverList = sorter.getSortedCompTypeList(serverList);
		//get the actual and display names of component types
		for (int j=0; j<serverList.size(); j++)
		{
			EgName nameObj = (EgName)serverList.get(j);
			String tmpVal = nameObj.getActualName();
			String tmpDis = nameObj.getLocalName();

			compTypeObj.put("displayField",tmpDis);
			compTypeObj.put("valueField",tmpVal);
			CompType.add(compTypeObj);
		}
		rootJson.put("ComponentType",CompType);
	}
	else
	{
		compTypeObj.put("displayField",_mapping.getTextDescription("admin.common.Not Applicable"));
		compTypeObj.put("valueField","-1");
		CompType.add(compTypeObj);

		rootJson.put("ComponentType",CompType);
	}

	if (componentType != null && !componentType.equalsIgnoreCase("null") && !componentType.equals("-1"))
	{
		List listSpecficationVariables = Arrays.asList(egSpecs.getTestSpecVar());
		ArrayList aListEnabledTests = egSpecs.getEnabledTests(componentType, false);

		if (aListEnabledTests.isEmpty())
		{
			rootJson.put("NoTestAvailable","No tests are available for this component type");
		}
		else
		{
			ArrayList enabledCorrectiveScriptTests = new ArrayList();

			JSONArray allEnabledCorrectiveScriptTests = new JSONArray();
			JSONObject allEnabledCorrectiveScriptObj = new JSONObject();
			JSONArray associatedTests = new JSONArray();
			JSONArray availableTests = new JSONArray();

			//get allAssociated tests from allEnabled tests
			int i_size = aListEnabledTests.size();
			ArrayList allEnabledInternalTests = new ArrayList();
			for (int i=0; i<i_size; i++)
			{
				String testName =(String) aListEnabledTests.get(i);
				String port = "";
				if (componentType.equals("Oracle_server"))
				{
					port = "$portNo:$sid";
				}
				else
				{
					port = "$portNo";
				}
				boolean isExternalTest = egSpecs.isExternalTest(testName, componentType);
				if (!isExternalTest)
				{
					String patternA = testName + ":" + componentType + ":" + "$hostName" + ":" + port;
					String patternB = testName + ":" + componentType + ":" + "$hostName";
					String patternC = testName + "::" + "$hostName" + ":" + port;
					String patternD = testName + "::" + "$hostName";

					String resultantPattern = "";
					if (listSpecficationVariables.contains(patternA))
					{
						resultantPattern = patternA;
					}
					else if (listSpecficationVariables.contains(patternB))
					{
						resultantPattern = patternB;
					}
					else if (listSpecficationVariables.contains(patternC))
					{
						resultantPattern = patternC;
					}
					else if (listSpecficationVariables.contains(patternD))
					{
						resultantPattern = patternD;
					}
					allEnabledInternalTests.add(testName);
					String defaultTestParams = egSpecs.getArgsForTest(resultantPattern);
					defaultTestParams = defaultTestParams.toLowerCase();
					if (defaultTestParams.indexOf(" -correct ") != -1 &&
						defaultTestParams.indexOf(" -alarmtype ") != -1 &&
						defaultTestParams.indexOf(" -userparams ") != -1 &&
						defaultTestParams.indexOf(" -correctivescript ") != -1)
					{
						enabledCorrectiveScriptTests.add(testName);
					}
				}
			}

			if (enabledCorrectiveScriptTests != null && enabledCorrectiveScriptTests.size() > 0)
			{
				allEnabledInternalTests.removeAll(enabledCorrectiveScriptTests);
			}

			enabledCorrectiveScriptTests = sorter.getSortedTestList(enabledCorrectiveScriptTests);

			for(int i=0; i<enabledCorrectiveScriptTests.size(); i++)
			{
				EgName name = (EgName)enabledCorrectiveScriptTests.get(i);
				String enableVal = name.getActualName();
				String enableDis = name.getLocalName();

				associatedTests.add(enableVal);
				allEnabledCorrectiveScriptObj.put("displayField",enableDis);
				allEnabledCorrectiveScriptObj.put("valueField",enableVal);
				allEnabledCorrectiveScriptTests.add(allEnabledCorrectiveScriptObj);
			}

			//get allAvailable tests from allEnabled tests
			JSONObject noCorrectiveTestsObj = new JSONObject();
			JSONArray noCorrectiveTestsArr = new JSONArray();
			if (allEnabledInternalTests != null && allEnabledInternalTests.size() > 0)
			{
				allEnabledInternalTests = sorter.getSortedTestList(allEnabledInternalTests);
				for(int i=0; i<allEnabledInternalTests.size(); i++) 
				{
					EgName name = (EgName)allEnabledInternalTests.get(i);
					String enableVal = name.getActualName();
					String enableDis = name.getLocalName();
					
					availableTests.add(enableVal);
					noCorrectiveTestsObj.put("displayField",enableDis);
					noCorrectiveTestsObj.put("valueField",enableVal);
					noCorrectiveTestsArr.add(noCorrectiveTestsObj);
				}
			}

			rootJson.put("noCorrectiveTestsArr",noCorrectiveTestsArr);
			rootJson.put("associatedTests",associatedTests);
			rootJson.put("availableTests",availableTests);
			rootJson.put("allEnabledCorrectiveScriptTests",allEnabledCorrectiveScriptTests);
		}
	}

	rootJson.put("updateUrl","CorrectiveScript/data/EgEnableCorrectiveScriptsp.jsp?");
	session.setAttribute("adminLastAccessedURL","/final/admin/EgCorrectiveScripts.jsp?componentType="+componentType+"&testType="+testType+"&hideBtn=true");

	out.println(rootJson.toString());
%>



