<%@ include file = "../../EgTrackerAJSON.jsp" %>

<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ page import = "net.sf.json.JSONObject"%>
<%@ page import = "com.eg.EgCorrectiveScripts"%>
<%@ page import = "com.eg.EgServicesInfo"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>

<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>

<%
	JSONObject rootJson = new JSONObject();

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");
	
	String componentType = request.getParameter("compType");
	String testName = request.getParameter("testName");
	String reqFrom = request.getParameter("reqFrom");

	EgCorrectiveScripts correctiveScripts = new EgCorrectiveScripts();
	if (!StringUtils.isNull(reqFrom) && reqFrom.equals("enableCsLink"))
	{
		EgServicesInfo egServicesInfo = new EgServicesInfo("manager");
		boolean isAuditLogEnabled = egServicesInfo.isAuditlogEnabled();
		AuditLogThread auditLogThread = new AuditLogThread();
		if (componentType == "All" || componentType == null || componentType == "")
		{
			componentType = "";
			ArrayList enableCSList = new ArrayList();
			if (!StringUtils.isNull(testName))
			{
				enableCSList.add(testName);
			}

			if (enableCSList != null && enableCSList.size() > 0)
			{
				if (isAuditLogEnabled)
				{
					auditLogThread.setValue("Category","Admin");
					auditLogThread.setValue("User_id",_user.getLoginID());
					auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
					auditLogThread.setValue("Session_id",session.getId());
					auditLogThread.setValue("Module","Corrective Scripts");
					auditLogThread.setValue("Activity","Enable Corrective Script");
					auditLogThread.setValue("Description","Corrective Script have been Enabled");
					for (int i=0; i<enableCSList.size(); i++)
					{
						String testNameStr = (String) enableCSList.get(i);
						String displayTestName = _mapping.getTestDescription(testNameStr);
						auditLogThread.setCurrentValue("Enabled Tests",displayTestName);
					}
					auditLogThread.sendItToDB();
				}
				correctiveScripts.enableCorrectiveScript(componentType, enableCSList);
			}
		}
		else
		{
			ArrayList enableCSList = new ArrayList();
			if (!StringUtils.isNull(testName))
			{
				enableCSList.add(testName);
			}

			if (enableCSList != null && enableCSList.size() > 0)
			{
				if (isAuditLogEnabled)
				{
					auditLogThread.setValue("Category","Admin");
					auditLogThread.setValue("User_id",_user.getLoginID());
					auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
					auditLogThread.setValue("Session_id",session.getId());
					auditLogThread.setValue("Module","Corrective Scripts");
					auditLogThread.setValue("Activity","Enable Corrective Script");
					auditLogThread.setValue("Description","Corrective Script have been Disabled");
					for (int i=0; i<enableCSList.size(); i++)
					{
						String testNameStr = (String) enableCSList.get(i);
						String displayTestName = _mapping.getTestDescription(testNameStr);
						auditLogThread.setCurrentValue("Enabled Tests",displayTestName);
					}
					auditLogThread.sendItToDB();
				}
				correctiveScripts.enableCorrectiveScript(componentType, enableCSList);
			}
		}
		rootJson.put("requestStatus","success");
	}

	if (!StringUtils.isNull(reqFrom) && reqFrom.equals("disableCsLink"))
	{
		EgServicesInfo egServicesInfo = new EgServicesInfo("manager");
		boolean isAuditLogEnabled = egServicesInfo.isAuditlogEnabled();
		AuditLogThread auditLogThread = new AuditLogThread();
		if (componentType == "All" || componentType == null || componentType == "")
		{
			componentType = "";
			ArrayList disableCsList = new ArrayList();
			if (!StringUtils.isNull(testName))
			{
				disableCsList.add(testName);
			}

			if (disableCsList != null && disableCsList.size() > 0)
			{
				if (isAuditLogEnabled)
				{
					auditLogThread.setValue("Category","Admin");
					auditLogThread.setValue("User_id",_user.getLoginID());
					auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
					auditLogThread.setValue("Session_id",session.getId());
					auditLogThread.setValue("Module","Corrective Scripts");
					auditLogThread.setValue("Activity","Disable Corrective Script");
					auditLogThread.setValue("Description","Corrective Script have been Disabled");
					for (int i=0; i<disableCsList.size(); i++)
					{
						String testNameStr = (String) disableCsList.get(i);
						String displayTestName = _mapping.getTestDescription(testNameStr);
						auditLogThread.setCurrentValue("Disabled Tests",displayTestName);
					}
					auditLogThread.sendItToDB();
				}
				correctiveScripts.disableCorrectiveScript(componentType, disableCsList);
			}
		}
		else
		{
			ArrayList disableCsList = new ArrayList();
			if (!StringUtils.isNull(testName))
			{
				disableCsList.add(testName);
			}

			if (disableCsList != null && disableCsList.size() > 0)
			{
				if (isAuditLogEnabled)
				{
					auditLogThread.setValue("Category","Admin");
					auditLogThread.setValue("User_id",_user.getLoginID());
					auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
					auditLogThread.setValue("Session_id",session.getId());
					auditLogThread.setValue("Module","Corrective Scripts");
					auditLogThread.setValue("Activity","Disable Corrective Script");
					auditLogThread.setValue("Description","Corrective Script have been Disabled");
					for (int i=0; i<disableCsList.size(); i++)
					{
						String testNameStr = (String) disableCsList.get(i);
						String displayTestName = _mapping.getTestDescription(testNameStr);
						auditLogThread.setCurrentValue("Disabled Tests",displayTestName);
					}
					auditLogThread.sendItToDB();
				}
				correctiveScripts.disableCorrectiveScript(componentType, disableCsList);
			}
		}
		rootJson.put("requestStatus","success");
	}

	out.println(rootJson.toString());
%>



