<%
/*************************************************************************************************
*	Name			:	EgApplyToOtherTests.jsp
*	Purpose			:	To Change Detailed Diagnosis data purge periods to selected Tests.
*	Version			:	5.2
*	CreationDate	:	11/12/2010
*	Author			:	Rekha
**************************************************************************************************/
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import="com.eg.EgName"%>
<%@ page import="com.eg.EgInstallInfo"%>
<%@ page import="com.eg.MappingNameSorter"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import="com.eg.EgMemInfo" %>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import="com.eg.EgRoleInfo" %>
<%@ page import = "com.eg.EgDiscInfo"%> 
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	String egTitleSearchStr = request.getParameter("egTitleSearchStr");
	boolean isSearchResult = (egTitleSearchStr != null);
	ArrayList searchList = new ArrayList();
	boolean searchItemFound = false;
%>

<jsp:useBean id="dddcleanup" class="egurkha.TransactionBean" scope="page" />
<jsp:useBean id="disabledd" class="egurkha.TransactionBean" scope="page" />

<%
	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (_user != null)
	{
		userLanguage = _user.getLanguage();
	}

	String componentType = request.getParameter("componentType");
	componentType = (componentType != null)?componentType:"allTests";

	MappingNameSorter sorter = new MappingNameSorter(userLanguage);
	dddcleanup.createFile("eg_format.ini");
	disabledd.createFile("eg_testinfo.ini");

	String dddTests[] = dddcleanup.getVariables("DDD_CLEANUP");
	String disableDDTests[] = disabledd.getVariables("Disable_DD");
	ArrayList aListDDDisabledTests = new ArrayList(Arrays.asList(disableDDTests));
	ArrayList aListDDDTest = new ArrayList(Arrays.asList(dddTests));
	ArrayList aListResultantCtype = new ArrayList();
	ArrayList aListTests = new ArrayList();
	ArrayList aListTempDDDTest = new ArrayList();

	IniFile egSpecsIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_specs.ini");
	//EgDiscInfo egDisc = new EgDiscInfo("manager");	
	//List listComponentTypes = Arrays.asList(egDisc.getComponentTypes());
	
	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	List listComponentTypes = Arrays.asList(ri.getServerTypes());

	// To list those component types only which has associated tests with it in eg_format.ini
	for(int i=0;i<listComponentTypes.size();i++)
	{
		String strComponentType = (String)listComponentTypes.get(i);
		//EgSpecsInfo egspecsInfo = new EgSpecsInfo("manager");
		//String strTests []= egspecsInfo.getDefaultTestsForServer(strComponentType);
		String strTests = egSpecsIni.getValue("DEFAULT_TEST_MAPPING",strComponentType);
		
		if (strTests != null)
		{
			//ArrayList aListTempTests = new ArrayList(Arrays.asList(strTests));
			ArrayList aListTempTests = new ArrayList();
			StringTokenizer strTokens = new StringTokenizer(strTests,",");
			while (strTokens.hasMoreTokens())
			{
				String strToken = strTokens.nextToken().trim();
				aListTempTests.add(strToken);
			}

			for (int j=0;j<aListTempTests.size();j++)
			{
				String strTest = (String)aListTempTests.get(j);
				if (aListDDDTest.contains(strTest)) 
				{
					if(!aListResultantCtype.contains(strComponentType))
					{
						aListResultantCtype.add(strComponentType);
					}
					if(!aListTempDDDTest.contains(strTest))
					{
						aListTempDDDTest.add(strTest);
					}
				}
			}
		}
	}
	
	aListDDDTest = aListTempDDDTest; // Assigns Clubbed Tests of Managed Comp Types
	listComponentTypes = sorter.getSortedCompTypeList(aListResultantCtype);
	// Ends

	// To list the tests for the selected component type 
	ArrayList aListShowTests = new ArrayList();
	if (!componentType.equals("") && !componentType.equalsIgnoreCase("allTests"))
	{
		String strTests = egSpecsIni.getValue("DEFAULT_TEST_MAPPING",componentType);
		StringTokenizer strTokens = new StringTokenizer(strTests,",");
		while (strTokens.hasMoreTokens())
		{
			String strToken = strTokens.nextToken().trim();
			aListTests.add(strToken);
		}

		for (int i=0;i<aListDDDTest.size();i++)
		{
			String strTest = (String)aListDDDTest.get(i);
			if (aListTests.contains(strTest)) 
			{
				aListShowTests.add(strTest);
			}
		}

		aListDDDTest = aListShowTests;
	}
	// Ends

	//Added For Search Button
	ArrayList searchList_final=new ArrayList();
	if (isSearchResult)
	{
		StringTokenizer st = new StringTokenizer(egTitleSearchStr);
		while (st.hasMoreTokens())
		{
			String thisToken = st.nextToken().trim();
			if (thisToken.equals("")) continue;
			searchList.add(thisToken);
		}
		for(int i=0;i<aListDDDTest.size();i++)
		{
			String dddDisplay_test = (String)aListDDDTest.get(i);
			String label = _mapping.getTestDescription(dddDisplay_test);
			for (int j=0;j<searchList.size();j++)
			{
				String search_String=(String)searchList.get(j);
				if (label != null && label.toLowerCase().indexOf(search_String.toLowerCase()) != -1)
				{
					if (!searchList_final.contains(dddDisplay_test))
					{
						searchList_final.add(dddDisplay_test);
					}
				}
			}
		}
		if (searchList_final != null && searchList_final.size() >0)
		{
			aListDDDTest=searchList_final;
			searchItemFound = true;
		}
		else
		{
			searchItemFound = false;
		}
	}
	// Ends

	aListDDDTest.removeAll(aListDDDisabledTests);
	aListDDDTest = sorter.getSortedTestList(aListDDDTest);
	
	String strFromPage = request.getParameter("strFromPage");
	if (strFromPage == null)
	{
		strFromPage = "";
	}
	
	// Getting the testname and testvalue which is chosen in EgDDDPurge.jsp page
	String temp_Testname = request.getParameter("testName");
	temp_Testname = (temp_Testname != null)?temp_Testname:"";
	String temp_Testvalue = request.getParameter("testValue");
	temp_Testvalue = (temp_Testvalue != null)?temp_Testvalue:"";
	// Ends

	String label = _mapping.getTestDescription(temp_Testname);
	String ddd_Test = label;
	String ddd_Value = temp_Testvalue;
%>

<html>
<title>Apply To Other Tests</title>
<head>
<egui:skin ui="admin"/>
<script language="javascript">
function showComponents()
{
	var thisForm = document.dbconfig;
	
	var egTitleSearchStr = thisForm.egTitleSearchStr.value;
	var componentType = "";
	if (thisForm.componentType != null && thisForm.componentType != undefined)
	{
		componentType = thisForm.componentType.value;
	}
	var testName="<%=temp_Testname%>";
	var testValue="<%=temp_Testvalue%>";
	thisForm.method = "post";
	thisForm.action = "/final/admin/EgApplyToOtherTests.jsp?egTitleSearchStr="+"&testName="+testName+"&testValue="+testValue;
	thisForm.submit();
}

function goBack()
{
	var thisForm = document.dbconfig;
	var componentType = "";
	if (thisForm.componentType != null && thisForm.componentType != undefined)
	{
		componentType = thisForm.componentType.value;
	}
	var testName="<%=temp_Testname%>";
	var testValue="<%=temp_Testvalue%>";
	for (l=0;l<thisForm.elements.length;l++)
	{
		if (thisForm[l].type == "text")
		{
			var name = thisForm[l].name;
			if(name=="egTitleSearchStr")
			{
				continue;
			}
			var value = thisForm[l].value;
			var regExp = (/^([1-9])+([0-9]*)$/).test(thisForm[l].value);
			if (regExp)
			{
				continue;
			}
			else
			{
				
				alert('<egui:intnl text="admin.db.Please enter non-zero whole number "/>');
				thisForm[l].focus();
				return;
			}
		}
	}
	if (isNetscape()) targetObj = document.dbconfig.back;
	if (isIE()) targetObj = document.dbconfig.back;
	targetObj.disabled = true;
	targetObj.value = '<egui:intnl text="admin.db.Update and More"/>...';
	targetObj.style.color = "#B2B2B2";
	thisForm.action = "EgDDDPurgep.jsp?testName="+testName+"&testValue="+testValue+"&strFromPage=EgApplyToOtherTests.jsp&egTitleSearchStr="+"&componentType="+componentType;
	thisForm.submit();
}

function populate()
{
	var thisForm = document.dbconfig;
	var testName="<%=temp_Testname%>";
	var testValue="<%=temp_Testvalue%>";
	for (l=0;l<thisForm.elements.length;l++)
	{
		if (thisForm[l].type == "text")
		{
			var name = thisForm[l].name;
			if(name=="egTitleSearchStr")
			{
				continue;
			}
			var value = thisForm[l].value;
			var regExp = (/^([1-9])+([0-9]*)$/).test(thisForm[l].value);
			if (regExp)
			{
				continue;
			}
			else
			{
				
				alert('<egui:intnl text="admin.db.Please enter non-zero whole number "/>');
				thisForm[l].focus();
				return;
			}
		}
	}
	if (isNetscape()) targetObj = document.dbconfig.update;
	if (isIE()) targetObj = document.dbconfig.update;
	targetObj.disabled = true;
	targetObj.value = '<egui:intnl text="admin.common.Updating"/>...';
	targetObj.style.color = "#B2B2B2";
	thisForm.action = "EgDDDPurgep.jsp?testName="+testName+"&testValue="+testValue;
	thisForm.submit();
}

function isNetscape()
{
	// get browser info. 
	appName= navigator.appName;
	appLongVer = navigator.appVersion;
	appVer = appLongVer.substring(0,1);

	// check for Navigator ver 4+.
	if ((appName == "Netscape") && (appVer >= 4)) return true;
	return false;
}

function isIE()
{
	// get browser info. 
	appName= navigator.appName;
	appLongVer = navigator.appVersion;
	appVer = appLongVer.substring(0,1);

	// check for IE ver 4+. 
	if ((appName == "Microsoft Internet Explorer") && (appVer >= 4)) return true;
	return false;
}

function egTitleSearch()
{
	var thisForm = document.dbconfig;
	var egTitleSearchStr = document.dbconfig.egTitleSearchStr.value;
	var testName="<%=temp_Testname%>";
	var testValue="<%=temp_Testvalue%>";
	var componentType = "";
	if (thisForm.componentType != null && thisForm.componentType != undefined)
	{
		componentType = thisForm.componentType.value;
	}
	if(egTitleSearchStr==null || egTitleSearchStr=="")
	{
		window.location.href = "/final/admin/EgApplyToOtherTests.jsp?componentType="+"&testName="+testName+"&testValue="+testValue;
	}
	else
	{
		window.location.href = "/final/admin/EgApplyToOtherTests.jsp?egTitleSearchStr="+encodeURI(egTitleSearchStr)+"&testName="+testName+"&testValue="+testValue+"&componentType="+componentType;
	}
}
</script>
</head>
<body style="overflow:auto" id="space6">
<form name="dbconfig" method="post" action="javascript:egTitleSearch();" style="margin:0px">

<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
	<jsp:include page="listSearch.jsp?title=DATA MANAGEMENT - Detailed Diagnosis Data Purge Periods - Apply To Other Tests&subtitle=true&backButton=true&searchBox=true"/>

	<tr>
		<td width="100%" id="eg_whitebg" align="center" valign="top">
<%
		if (listComponentTypes != null && listComponentTypes.size() > 0)
		{
%>

			<table align="center" width="90%" cellspacing="0" cellpadding="0" border="0" class="eg_subcontentbg">
				<tr>
					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>

				<tr>
					<td width="47%" align="right" nowrap> <egui:intnl text="admin.server.Component type"/>&nbsp;:&nbsp;</td>
					<td align="left" class="paddingright">
						<select name="componentType" id ="componentType" style="width:150px" onchange="javascript:showComponents()">
<%
			if(componentType != null && componentType.equalsIgnoreCase("allTests"))
			{
%>
				<option value="<%=componentType%>" selected><egui:intnl text="admin.common.All"/></option>
<%
			}
			else
			{
%>
				<option value="allTests"><egui:intnl text="admin.common.All"/></option>
<%
			}
			for (int j=0; j<listComponentTypes.size(); j++)
			{
				EgName nameObj = (EgName)listComponentTypes.get(j);
				String actualname = nameObj.getActualName();
				String localname = nameObj.getLocalName();
				if (actualname.equals(componentType))
				{
%>
					<option value="<%=actualname%>" selected><%=localname%></option>
<%
				}
				else
				{
%>
					<option value="<%=actualname%>"><%=localname%></option>
<%
				}
			}
%>
						</select>
					</td>
					<td height="6" width="7" class="eg_subcontentbg" class="form_spacing">&nbsp;</td>
				</tr>
				<tr>
					<td width="7" colspan="5"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="10"></td>
				</tr>
				<tr>
					<td colspan="5">
						<table border="0" width="75%" align="center" cellspacing="0" cellpadding="4" id="eg_subcontentbg" >	
							<tr>
								<td align="left" width="50%">&nbsp;&nbsp;<b><egui:intnl text="admin.db.Selected test"/>&nbsp;:&nbsp;</b><egui:intnl text="<%=ddd_Test%>"/></td>
								<td align="right" width="50%"><b><egui:intnl text="admin.db.Selected purge period value "/>&nbsp;:&nbsp;</b><egui:intnl text="<%=ddd_Value%>"/>(<egui:intnl text="admin.db.Days"/>)&nbsp;&nbsp;</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg" valign="top" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
			</table>
<%
		}
%>
			<input type="hidden" class="form_border" name="<%=temp_Testname+"_DDD"%>" value="<%=temp_Testvalue%>"/>
<%
		if (!searchItemFound && egTitleSearchStr != null && !egTitleSearchStr.equals(""))
		{
%>
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
				<tr>
					<td height="300">
						<table border="0" cellspacing="0" cellpadding="4" width="100%" >
							<tr> 
								<td width="100%" align="center">
								<img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif">
								</td>
							</tr>
							<tr>
								<td width="100%" align="center">
								<b><egui:intnl text="admin.db.No result(s) found for your current search"/></b><br>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
<%
		}
		else
		{
			
		//Added to display message when component type has only one test
		int aListDDDTestSize = aListDDDTest.size();
		if (strFromPage.equalsIgnoreCase("EgDDDPurge.jsp") && componentType != null && aListDDDTestSize <=1)
		{					
%>
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
				<tr>
					<td  height="400">
						<table border="0" cellspacing="0" cellpadding="4" width="100%" >
							<tr> 
								<td width="100%" align="center">
								<img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif">
								</td>
							</tr>
							<tr>
								<td width="100%" align="center">
								<b><egui:intnl text="admin.db.No other Test(s) found for your current selection"/></b><br>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
<%
		}
		else
		{
%>		
			<table align="center" width="90%" cellspacing="0" cellpadding="0" border="0">
				<tr>
					<td width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="10"></td>
				</tr>
				<tr>
					<td align="center" valign="top">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
							<tr>
								<td colspan="5">
									<table cellspacing="0" cellpadding="0" width="100%" border="0" height="22">
										<tr>
											<td id="subhead_left" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
											<td id="eg_subheadbg" style="border-left-width: 0px; border-right-width: 0px;" align="center" width="100%"><strong><egui:intnl text="admin.db.Tests To Be Selected For Applying Purge Period Value" /></strong></td>
											<td id="subhead_right" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
										</tr>
									</table>
								</td>
							</tr>

							<tr>
								<td id="eg_subcontentbg" width="7" colspan="5"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>

							<tr>
								<td id="eg_subcontentbg" width="100%" align="center" valign="top" colspan="5">
									<select name="testsName" align="center" id= "all" multiple size="22" style="width:400px">
<%
			for (int j=0;j<aListDDDTestSize;j++)
			{
				EgName name = (EgName)aListDDDTest.get(j);
				String dddValue = name.getActualName();
				String dddDisplay = name.getLocalName();
				String strVal = dddcleanup.getStrValue("DDD_CLEANUP",dddValue);
				if(dddValue != null && dddValue.equals(temp_Testname))
				{
					continue;
				}
%>
				<option value="<%=dddValue%>"><%=dddDisplay%></option>
<%
			}
%>
									</select>
								</td>
							</tr>
							<tr>
								<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
								<td id="eg_subcontentbg" valign="top" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
								<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
							</tr>
							<tr>
								<td width="7" colspan="5"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>

							<tr>
								<td align="center" colspan="5">
									<input type="button" name="back" value='<egui:intnl text="admin.common.Update and More"/>' style="width: 125px;" class="eg_back" onClick="javascript:goBack()" >
									<input type="button" name="update" value='<egui:intnl text="admin.common.Update"/>' style="width: 85px;" class="eg_back" onClick="javascript:populate()" >
								</td>
							</tr>
							<tr>
								<td width="7" colspan="5"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
<%
		}
		}
%>
		</td>
	</tr>
</table>
</form>
<%
	if (request.getQueryString() != null)
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgApplyToOtherTests.jsp?"+request.getQueryString());
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgApplyToOtherTests.jsp");
	}
%>
</body>
</html>


