<%@ include file="EgTrackerA.jsp" %>
<%@ page import="com.eg.EgInstallInfo"%>
<%@ page import="com.eg.IniFile"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import="com.eg.EgTesterInfo"%>
<%@ page import="com.eg.EgTablesInfo"%>
<%@ page import="com.eg.EgSpecsInfo"%>
<%@ page import="com.egurkha.util.StringUtils" %>


<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%!
	public int getLeniencyFactor(String relValue)
	{
		int leniency = 0;
		if (relValue != null)
		{
			if (relValue.equals("-"))
			{
				leniency = 0;
			}
			else if (relValue.equals("sqc"))
			{
				leniency = 100;
			}
			else
			{
				int idx = relValue.indexOf("*");
				String s1 = relValue.substring(0,idx);
				double d_value = Double.valueOf(s1.trim()).doubleValue();
				d_value = d_value * 100;
				leniency = (new Double(d_value)).intValue();
			}
		}
		return leniency;
	}
%>

<%
	IniUI iniUI = IniUI.getInstance();

	//user language
	String userLanguage = iniUI.getDefaultLanguage();
	if (_user != null)
	{
		userLanguage = _user.getLanguage();
	}

	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
	EgTesterInfo testerInfo = new EgTesterInfo("manager");
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgTablesInfo tablesInfo = new EgTablesInfo("manager");
	ArrayList aListHostLevelTests = (ArrayList) session.getAttribute("sessListHostLevelTests");

	String strComponentType = request.getParameter("componentType");
	String strTestName = request.getParameter("testName");
	String measure = request.getParameter("measure");
	String absMinCritical = request.getParameter("absMinCritical");
	String absMinMajor = request.getParameter("absMinMajor");
	String absMinMinor = request.getParameter("absMinMinor");
	String relMinCritical = request.getParameter("relMinCritical");
	String relMinMajor = request.getParameter("relMinMajor");
	String relMinMinor = request.getParameter("relMinMinor");
	String absMaxCritical = request.getParameter("absMaxCritical");
	String absMaxMajor = request.getParameter("absMaxMajor");
	String absMaxMinor = request.getParameter("absMaxMinor");
	String relMaxCritical = request.getParameter("relMaxCritical");
	String relMaxMajor = request.getParameter("relMaxMajor");
	String relMaxMinor = request.getParameter("relMaxMinor");
	String alarmPolicy = request.getParameter("alarmPolicy");

	String ua = request.getHeader("User-Agent");
	boolean isFirefox = (ua != null && ua.indexOf("Firefox/") != -1);
	boolean isChrome = (ua != null && ua.indexOf("Chrome") != -1);
	boolean isNegativeValuesAllowed = testerInfo.isNegativeValuesAllowed(strTestName,measure);

	if (absMinCritical == null)
	{
		absMinCritical = "-";
	}
	if (absMinMajor == null)
	{
		absMinMajor = "-";
	}
	if (absMinMinor == null)
	{
		absMinMinor = "-";
	}

	String minStaticSelected = "";
	String minStaticBlock = "none";
	if ((absMinCritical != null && !absMinCritical.equals("-")) || 
		(absMinMajor != null && !absMinMajor.equals("-")) || 
		(absMinMinor != null && !absMinMinor.equals("-")))
	{
		minStaticSelected = "selected";
		if (isFirefox || isChrome)
		{
			minStaticBlock = "table-row";
		}
		else
		{
			minStaticBlock = "block";
		}
	}

	String minAutomaticSelected = "";
	String minAutomaticBlock = "none";
	//String minAutoCriticalSelected = "none";
	//String minAutoMajorSelected = "none";
	//String minAutoMinorSelected = "none";
	String minAutoToleranceBlock = "";
	String minAutoCriticalSliderBlock = "";
	String minAutoMajorSliderBlock = "";
	String minAutoMinorSliderBlock = "";

	if ((relMinCritical != null && !relMinCritical.equals("-")) || 
		(relMinMajor != null && !relMinMajor.equals("-")) || 
		(relMinMinor != null && !relMinMinor.equals("-")))
	{
		minAutomaticSelected = "selected";
		if (isFirefox || isChrome)
		{
			minAutomaticBlock = "table-row";
		}
		else
		{
			minAutomaticBlock = "block";
		}

		if (relMinCritical != null && !relMinCritical.equals("-"))
		{
			//minAutoCriticalSelected = "selected";
			if (isFirefox || isChrome)
			{
				minAutoToleranceBlock = "table-row";
				minAutoCriticalSliderBlock = "table-row";
			}
			else
			{
				minAutoToleranceBlock = "block";
				minAutoCriticalSliderBlock = "block";
			}
		}

		if (relMinMajor != null && !relMinMajor.equals("-"))
		{
			//minAutoMajorSelected = "selected";
			if (isFirefox || isChrome)
			{
				minAutoToleranceBlock = "table-row";
				minAutoMajorSliderBlock = "table-row";
			}
			else
			{
				minAutoToleranceBlock = "block";
				minAutoMajorSliderBlock = "block";
			}
		}

		if (relMinMinor != null && !relMinMinor.equals("-"))
		{
			//minAutoMinorSelected = "selected";
			if (isFirefox || isChrome)
			{
				minAutoToleranceBlock = "table-row";
				minAutoMinorSliderBlock = "table-row";
			}
			else
			{
				minAutoToleranceBlock = "block";
				minAutoMinorSliderBlock = "block";
			}
		}
	}

	if (absMaxCritical == null)
	{
		absMaxCritical = "-";
	}
	if (absMaxMajor == null)
	{
		absMaxMajor = "-";
	}
	if (absMaxMinor == null)
	{
		absMaxMinor = "-";
	}

	String maxStaticSelected = "";
	String maxStaticBlock = "none";
	if ((absMaxCritical != null && !absMaxCritical.equals("-")) || 
		(absMaxMajor != null && !absMaxMajor.equals("-")) || 
		(absMaxMinor != null && !absMaxMinor.equals("-")))
	{
		maxStaticSelected = "selected";
		if (isFirefox || isChrome)
		{
			maxStaticBlock = "table-row";
		}
		else
		{
			maxStaticBlock = "block";
		}
	}

	String maxAutomaticSelected = "";
	String maxAutomaticBlock = "none";
	//String maxAutoCriticalSelected = "none";
	//String maxAutoMajorSelected = "none";
	//String maxAutoMinorSelected = "none";
	String maxAutoToleranceBlock = "";
	String maxAutoCriticalSliderBlock = "";
	String maxAutoMajorSliderBlock = "";
	String maxAutoMinorSliderBlock = "";
	if ((relMaxCritical != null && !relMaxCritical.equals("-")) || 
		(relMaxMajor != null && !relMaxMajor.equals("-")) || 
		(relMaxMinor != null && !relMaxMinor.equals("-")))
	{
		maxAutomaticSelected = "selected";
		if (isFirefox || isChrome)
		{
			maxAutomaticBlock = "table-row";
		}
		else
		{
			maxAutomaticBlock = "block";
		}

		if (relMaxCritical != null && !relMaxCritical.equals("-"))
		{
			//maxAutoCriticalSelected = "selected";
			if (isFirefox || isChrome)
			{
				maxAutoToleranceBlock = "table-row";
				maxAutoCriticalSliderBlock = "table-row";
			}
			else
			{
				maxAutoToleranceBlock = "block";
				maxAutoCriticalSliderBlock = "block";
			}
		}

		if (relMaxMajor != null && !relMaxMajor.equals("-"))
		{
			//maxAutoMajorSelected = "selected";
			if (isFirefox || isChrome)
			{
				maxAutoToleranceBlock = "table-row";
				maxAutoMajorSliderBlock = "table-row";
			}
			else
			{
				maxAutoToleranceBlock = "block";
				maxAutoMajorSliderBlock = "block";
			}
		}

		if (relMaxMinor != null && !relMaxMinor.equals("-"))
		{
			//maxAutoMinorSelected = "selected";
			if (isFirefox || isChrome)
			{
				maxAutoToleranceBlock = "table-row";
				maxAutoMinorSliderBlock = "table-row";
			}
			else
			{
				maxAutoToleranceBlock = "block";
				maxAutoMinorSliderBlock = "block";
			}
		}
	}

	int relMinCriticalLeniency = getLeniencyFactor(relMinCritical);
	int relMinMajorLeniency = getLeniencyFactor(relMinMajor);
	int relMinMinorLeniency = getLeniencyFactor(relMinMinor);
	int relMaxCriticalLeniency = getLeniencyFactor(relMaxCritical);
	int relMaxMajorLeniency = getLeniencyFactor(relMaxMajor);
	int relMaxMinorLeniency = getLeniencyFactor(relMaxMinor);

	IniFile thresholdsIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_thresholds.ini");
	String alarmVariables[] = thresholdsIni.getVariables("ALARM_POLICY");


	ArrayList aListGlobalThresholds = testerInfo.getGlobalThresholds();
	boolean isGlobalThresholds = false;
	if (aListGlobalThresholds != null && aListGlobalThresholds.contains(strTestName))
	{
		isGlobalThresholds = true;
	}
%>

<html>
<head>
<title>Threshold configuration</title>
<egui:skin ui="admin"/>
<link rel="stylesheet" href="/final/jquery/themes/base/jquery.ui.all.css">
</head>

<script type="text/javascript" src ="/final/jquery/jquery.js"></script>
<script type="text/javascript" src ="/final/jquery/ui/jquery.ui.core.js"></script>
<script type="text/javascript" src ="/final/jquery/ui/jquery.ui.widget.js"></script>
<script type="text/javascript" src ="/final/jquery/ui/jquery.ui.mouse.js"></script>
<script type="text/javascript" src="/final/jquery/ui/jquery.ui.slider.js"></script>

<script language="javascript">

var $j = jQuery.noConflict();
$j(function() {
	$j("#slider_handle_A").slider(
		{
			range: "min",
			min: 0,
			max: 1000,
			value: "<%=relMinCriticalLeniency%>",
			slide: function(event,ui) {
				$j("#amount_A").val(ui.value);
			}
		}
	);
	$j("#amount_A").val($j("#slider_handle_A").slider("value"));

	$j( "#slider_handle_B" ).slider(
		{
			range: "min",
			min: 0,
			max: 1000,
			value: "<%=relMinMajorLeniency%>",
			slide: function(event,ui) {
				$j("#amount_B").val(ui.value);
			}
		}
	);
	$j("#amount_B").val($j("#slider_handle_B").slider("value"));

	$j( "#slider_handle_C" ).slider(
		{
			range: "min",
			min: 0,
			max: 1000,
			value: "<%=relMinMinorLeniency%>",
			slide: function(event,ui) {
				$j("#amount_C").val(ui.value);
			}
		}
	);
	$j("#amount_C").val($j("#slider_handle_C").slider("value"));

	$j( "#slider_handle_D" ).slider(
		{
			range: "min",
			min: 0,
			max: 1000,
			value: "<%=relMaxCriticalLeniency%>",
			slide: function(event,ui) {
				$j("#amount_D").val(ui.value);
			}
		}
	);
	$j("#amount_D").val($j("#slider_handle_D").slider("value"));

	$j( "#slider_handle_E" ).slider(
		{
			range: "min",
			min: 0,
			max: 1000,
			value: "<%=relMaxMajorLeniency%>",
			slide: function(event,ui) {
				$j("#amount_E").val(ui.value);
			}
		}
	);
	$j("#amount_E").val($j("#slider_handle_E").slider("value"));

	$j( "#slider_handle_F" ).slider(
		{
			range: "min",
			min: 0,
			max: 1000,
			value: "<%=relMaxMinorLeniency%>",
			slide: function(event,ui) {
				$j("#amount_F").val(ui.value);
			}
		}
	);
	$j("#amount_F").val($j("#slider_handle_F").slider("value"));
});

function showMaxStatic()
{
	var thisForm = document.threshForm;
	var varOpt = thisForm.maxStaticOption.options[thisForm.maxStaticOption.selectedIndex].value;
	if (varOpt == "none")
	{
		document.getElementById("maxStatic").style.display = "none";
	}
	else
	{
		if (isIE())
		{
			document.getElementById("maxStatic").style.display = "block";
		}
		else if (isNetscape())
		{
			document.getElementById("maxStatic").style.display = "table-row";
		}
	}
}

function showMaxAutomatic()
{
	var thisForm = document.threshForm;
	var varOpt = thisForm.maxAutomaticOption.options[thisForm.maxAutomaticOption.selectedIndex].value;
	if (varOpt == "none")
	{
		document.getElementById("maxAutomatic").style.display = "none";
	}
	else
	{
		if (isIE())
		{
			document.getElementById("maxAutomatic").style.display = "block";
			document.getElementById("maxAutoTolerance_A").style.display = "block";
			document.getElementById("maxAutoTolerance_B").style.display = "block";
			document.getElementById("maxAutoCriticalSlider").style.display = "block";
			document.getElementById("maxAutoMajorSlider").style.display = "block";
			document.getElementById("maxAutoMinorSlider").style.display = "block";

		}
		else if (isNetscape())
		{
			document.getElementById("maxAutomatic").style.display = "table-row";
			document.getElementById("maxAutoTolerance_A").style.display = "table-row";
			document.getElementById("maxAutoTolerance_B").style.display = "table-row";
			document.getElementById("maxAutoCriticalSlider").style.display = "table-row";
			document.getElementById("maxAutoMajorSlider").style.display = "table-row";
			document.getElementById("maxAutoMinorSlider").style.display = "table-row";
		}
	}
}

function showMaxAutoCriticalSlider()
{
	var thisForm = document.threshForm;
	var varOpt = thisForm.maxAutoCriticalOption.options[thisForm.maxAutoCriticalOption.selectedIndex].value;
	if (varOpt == "none")
	{
		document.getElementById("maxAutoCriticalSlider").style.display = "none";
		if (document.getElementById("maxAutoMajorSlider").style.display == "none" && 
			document.getElementById("maxAutoMinorSlider").style.display == "none")
		{
			document.getElementById("maxAutoTolerance_A").style.display = "none";
			document.getElementById("maxAutoTolerance_B").style.display = "none";
		}
	}
	else
	{
		if (isIE())
		{
			document.getElementById("maxAutoTolerance_A").style.display = "block";
			document.getElementById("maxAutoTolerance_B").style.display = "block";
			document.getElementById("maxAutoCriticalSlider").style.display = "block";
		}
		else if (isNetscape())
		{
			document.getElementById("maxAutoTolerance_A").style.display = "table-row";
			document.getElementById("maxAutoTolerance_B").style.display = "table-row";
			document.getElementById("maxAutoCriticalSlider").style.display = "table-row";
		}
	}
}

function showMaxAutoMajorSlider()
{
	var thisForm = document.threshForm;
	var varOpt = thisForm.maxAutoMajorOption.options[thisForm.maxAutoMajorOption.selectedIndex].value;
	if (varOpt == "none")
	{
		document.getElementById("maxAutoMajorSlider").style.display = "none";
		if (document.getElementById("maxAutoCriticalSlider").style.display == "none" && 
			document.getElementById("maxAutoMinorSlider").style.display == "none")
		{
			document.getElementById("maxAutoTolerance_A").style.display = "none";
			document.getElementById("maxAutoTolerance_B").style.display = "none";
		}
	}
	else
	{
		if (isIE())
		{
			document.getElementById("maxAutoTolerance_A").style.display = "block";
			document.getElementById("maxAutoTolerance_B").style.display = "block";
			document.getElementById("maxAutoMajorSlider").style.display = "block";
		}
		else if (isNetscape())
		{
			document.getElementById("maxAutoTolerance_A").style.display = "table-row";
			document.getElementById("maxAutoTolerance_B").style.display = "table-row";
			document.getElementById("maxAutoMajorSlider").style.display = "table-row";
		}
	}
}

function showMaxAutoMinorSlider()
{
	var thisForm = document.threshForm;
	var varOpt = thisForm.maxAutoMinorOption.options[thisForm.maxAutoMinorOption.selectedIndex].value;
	if (varOpt == "none")
	{
		document.getElementById("maxAutoMinorSlider").style.display = "none";
		if (document.getElementById("maxAutoCriticalSlider").style.display == "none" && 
			document.getElementById("maxAutoMajorSlider").style.display == "none")
		{
			document.getElementById("maxAutoTolerance_A").style.display = "none";
			document.getElementById("maxAutoTolerance_B").style.display = "none";
		}
	}
	else
	{
		if (isIE())
		{
			document.getElementById("maxAutoTolerance_A").style.display = "block";
			document.getElementById("maxAutoTolerance_B").style.display = "block";
			document.getElementById("maxAutoMinorSlider").style.display = "block";
		}
		else if (isNetscape())
		{
			document.getElementById("maxAutoTolerance_A").style.display = "table-row";
			document.getElementById("maxAutoTolerance_B").style.display = "table-row";
			document.getElementById("maxAutoMinorSlider").style.display = "table-row";
		}
	}
}

function showMinStatic()
{
	var thisForm = document.threshForm;
	var varOpt = thisForm.minStaticOption.options[thisForm.minStaticOption.selectedIndex].value;
	if (varOpt == "none")
	{
		document.getElementById("minStatic").style.display = "none";
	}
	else
	{
		if (isIE())
		{
			document.getElementById("minStatic").style.display = "block";
		}
		else if (isNetscape())
		{
			document.getElementById("minStatic").style.display = "table-row";
		}
	}
}

function showMinAutomatic()
{
	var thisForm = document.threshForm;
	var varOpt = thisForm.minAutomaticOption.options[thisForm.minAutomaticOption.selectedIndex].value;
	if (varOpt == "none")
	{
		document.getElementById("minAutomatic").style.display = "none";
	}
	else
	{
		if (isIE())
		{
			document.getElementById("minAutomatic").style.display = "block";
			document.getElementById("minAutoTolerance_A").style.display = "block";
			document.getElementById("minAutoTolerance_B").style.display = "block";
			document.getElementById("minAutoCriticalSlider").style.display = "block";
			document.getElementById("minAutoMajorSlider").style.display = "block";
			document.getElementById("minAutoMinorSlider").style.display = "block";

		}
		else if (isNetscape())
		{
			document.getElementById("minAutomatic").style.display = "table-row";
			document.getElementById("minAutoTolerance_A").style.display = "table-row";
			document.getElementById("minAutoTolerance_B").style.display = "table-row";
			document.getElementById("minAutoCriticalSlider").style.display = "table-row";
			document.getElementById("minAutoMajorSlider").style.display = "table-row";
			document.getElementById("minAutoMinorSlider").style.display = "table-row";

		}
	}
}

function showMinAutoCriticalSlider()
{
	var thisForm = document.threshForm;
	var varOpt = thisForm.minAutoCriticalOption.options[thisForm.minAutoCriticalOption.selectedIndex].value;
	if (varOpt == "none")
	{
		document.getElementById("minAutoCriticalSlider").style.display = "none";
		if (document.getElementById("minAutoMajorSlider").style.display == "none" && 
			document.getElementById("minAutoMinorSlider").style.display == "none")
		{
			document.getElementById("minAutoTolerance_A").style.display = "none";
			document.getElementById("minAutoTolerance_B").style.display = "none";
		}
	}
	else
	{
		if (isIE())
		{
			document.getElementById("minAutoTolerance_A").style.display = "block";
			document.getElementById("minAutoTolerance_B").style.display = "block";
			document.getElementById("minAutoCriticalSlider").style.display = "block";
		}
		else if (isNetscape())
		{
			document.getElementById("minAutoTolerance_A").style.display = "table-row";
			document.getElementById("minAutoTolerance_B").style.display = "table-row";
			document.getElementById("minAutoCriticalSlider").style.display = "table-row";
		}
	}
}

function showMinAutoMajorSlider()
{
	var thisForm = document.threshForm;
	var varOpt = thisForm.minAutoMajorOption.options[thisForm.minAutoMajorOption.selectedIndex].value;
	if (varOpt == "none")
	{
		document.getElementById("minAutoMajorSlider").style.display = "none";
		if (document.getElementById("minAutoCriticalSlider").style.display == "none" && 
			document.getElementById("minAutoMinorSlider").style.display == "none")
		{
			document.getElementById("minAutoTolerance_A").style.display = "none";
			document.getElementById("minAutoTolerance_B").style.display = "none";
		}
	}
	else
	{
		if (isIE())
		{
			document.getElementById("minAutoTolerance_A").style.display = "block";
			document.getElementById("minAutoTolerance_B").style.display = "block";
			document.getElementById("minAutoMajorSlider").style.display = "block";
		}
		else if (isNetscape())
		{
			document.getElementById("minAutoTolerance_A").style.display = "table-row";
			document.getElementById("minAutoTolerance_B").style.display = "table-row";
			document.getElementById("minAutoMajorSlider").style.display = "table-row";
		}
	}
}

function showMinAutoMinorSlider()
{
	var thisForm = document.threshForm;
	var varOpt = thisForm.minAutoMinorOption.options[thisForm.minAutoMinorOption.selectedIndex].value;
	if (varOpt == "none")
	{
		document.getElementById("minAutoMinorSlider").style.display = "none";
		if (document.getElementById("minAutoCriticalSlider").style.display == "none" && 
			document.getElementById("minAutoMajorSlider").style.display == "none")
		{
			document.getElementById("minAutoTolerance_A").style.display = "none";
			document.getElementById("minAutoTolerance_B").style.display = "none";
		}
	}
	else
	{
		if (isIE())
		{
			document.getElementById("minAutoTolerance_A").style.display = "block";
			document.getElementById("minAutoTolerance_B").style.display = "block";
			document.getElementById("minAutoMinorSlider").style.display = "block";
		}
		else if (isNetscape())
		{
			document.getElementById("minAutoTolerance_A").style.display = "table-row";
			document.getElementById("minAutoTolerance_B").style.display = "table-row";
			document.getElementById("minAutoMinorSlider").style.display = "table-row";
		}
	}
}

function isNetscape()
{
	// get browser info.
	appName= navigator.appName;
	appLongVer = navigator.appVersion;
	appVer = appLongVer.substring(0, 1);

	// check for Navigator ver 4+. 
	if ((appName == "Netscape") && (appVer >= 4)) return true;
	return false;
}

function isIE()
{
	// get browser info.
	appName= navigator.appName;
	//alert(appName);
	appLongVer = navigator.appVersion;
	appVer = appLongVer.substring(0, 1);

	// check for IE ver 4+. 
	if ((appName == "Microsoft Internet Explorer") && (appVer >= 4)) return true;
	return false;
}

function updateData()
{
	var flag = fetchThresholdValues();
	if (flag)
	{
		var targetObj = document.threshForm.update;
		targetObj.disabled = true;
		document.threshForm.update.value = "<egui:intnl text='admin.common.Updating'/>...";
	}
}

var xmlhttp;
function getAlarmPolicyDesc()
{
	var alarmPolicyOption = document.getElementById("alarmPolicyOption").value;
	var alarmPolicyDescDiv = document.getElementById("alarmPolicyDescDiv");

	xmlhttp = null;
	if (window.XMLHttpRequest)
	{
		xmlhttp=new XMLHttpRequest();
	}
	else if (window.ActiveXObject)
	{
		xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");
	}
	if (xmlhttp != null)
	{
		var params = "alarmPolicy="+alarmPolicyOption+"&operation=alarmPolicyDesc";
		var url = "/final/admin/EgApplyAlarmPolicy.jsp";
		xmlhttp.onreadystatechange = state_Change2;
		xmlhttp.open('POST',url,true);
		alarmPolicyDescDiv.innerHTML = "Loading, please wait.....";
		xmlhttp.setRequestHeader('Content-type','application/x-www-form-urlencoded');
		xmlhttp.setRequestHeader('Content-length',params.length);
		xmlhttp.setRequestHeader('Connection','close');
		xmlhttp.send(params);
	}
	else
	{
		alert('<egui:intnl text="admin.login.Your browser does not support XMLHTTP"/>');
	}
}

function state_Change2()
{
	var alarmPolicyDescDiv = document.getElementById("alarmPolicyDescDiv");
	if (xmlhttp.readyState == 4)
	{
		try
		{
			if (xmlhttp.status == 200)
			{
				val = xmlhttp.responseText;
				alarmPolicyDescDiv.innerHTML = val;
				alarmPolicyDescDiv.style.visibility = "visible";
				alarmPolicyDescDiv.style.display = "block";
			}
		}
		catch (error)
		{
			//error
		}
	}
}

function fetchThresholdValues()
{
	var thisForm = document.threshForm;

	var v_testname = "<%=strTestName%>";
	if (v_testname == "null")
	{
		return false;
	}

	var v_measure = "<%=measure%>";
	if (v_measure == "null")
	{
		return false;
	}

	var v_policy = "mix";
	var minThreshold = "-1";
	var maxThreshold = "-1";
	var v_alarmPolicy = document.getElementById("alarmPolicyOption").value;
	var lastItem = "HML";

	var abs_MinCritical = "-";
	var abs_MinMajor = "-";
	var abs_MinMinor = "-";
	var abs_MinOpt = thisForm.minStaticOption.options[thisForm.minStaticOption.selectedIndex].value;
	if (abs_MinOpt != "none")
	{
		abs_MinCritical = thisForm.absMinCritical.value;
		abs_MinMajor = thisForm.absMinMajor.value;
		abs_MinMinor = thisForm.absMinMinor.value;



		// Negative value check...
		if ('<%=isNegativeValuesAllowed%>' == "false")
		{
			//Invalid threshold entry check...
			if (!checkValidValue(abs_MinCritical))
			{
				alert('<egui:intnl text="admin.threshold.Invalid threshold entry : Critical - Static minimum threshold"/>');
				thisForm.absMinCritical.focus();
				return false;
			}
			else if(abs_MinCritical != "-") 
			{
				if(!checkNonNegativeFormat(abs_MinCritical))
				{
					alert('<egui:intnl text="admin.threshold.Invalid threshold entry : Critical - Static minimum threshold"/>'+".\n"+'<egui:intnl text="admin.threshold.Possible reasons could be"/>'+" : \n"+
					"1) "+'<egui:intnl text="admin.threshold.Threshold is set with a negative values"/>'+".\n"+
					"2) "+"<egui:intnl text='admin.threshold.The integer part contains more than 6 digits'/>"+".\n"+
					"3) "+'<egui:intnl text="admin.threshold.The fractional part contains more than 2 digits"/>'+".");
					thisForm.absMinCritical.focus();
					return false;
				}
			}

			if (!checkValidValue(abs_MinMajor))
			{
				alert('<egui:intnl text="admin.threshold.Invalid threshold entry : Major - Static minimum threshold"/>');
				thisForm.absMinMajor.focus();
				return false;
			}
			else if(abs_MinMajor != "-")
			{
				if(!checkNonNegativeFormat(abs_MinMajor))
				{
					alert('<egui:intnl text="admin.threshold.Invalid threshold entry : Major - Static minimum threshold"/>'+".\n"+'<egui:intnl text="admin.threshold.Possible reasons could be"/>'+" : \n"+
					"1) "+'<egui:intnl text="admin.threshold.Threshold is set with a negative values"/>'+".\n"+
					"2) "+"<egui:intnl text='admin.threshold.The integer part contains more than 6 digits'/>"+".\n"+
					"3) "+'<egui:intnl text="admin.threshold.The fractional part contains more than 2 digits"/>'+".");
					thisForm.absMinMajor.focus();
					return false;
				}
			}

			if (!checkValidValue(abs_MinMinor))
			{
				alert('<egui:intnl text="admin.threshold.Invalid threshold entry : Minor - Static minimum threshold"/>');
				thisForm.absMinMinor.focus();
				return false;
			}
			else if(abs_MinMinor != "-")
			{
				if(!checkNonNegativeFormat(abs_MinMinor))
				{
					alert('<egui:intnl text="admin.threshold.Invalid threshold entry : Minor - Static minimum threshold"/>'+".\n"+'<egui:intnl text="admin.threshold.Possible reasons could be"/>'+" : \n"+
					"1) "+'<egui:intnl text="admin.threshold.Threshold is set with a negative values"/>'+".\n"+
					"2) "+"<egui:intnl text='admin.threshold.The integer part contains more than 6 digits'/>"+".\n"+
					"3) "+'<egui:intnl text="admin.threshold.The fractional part contains more than 2 digits"/>'+".");
					thisForm.absMinMinor.focus();
					return false;
				}
			}

			var ret = checkNegativeValue(abs_MinCritical);
			if (ret)
			{
				alert("<egui:intnl text='admin.threshold.Static minimum threshold'/> <egui:intnl text='admin.threshold.for'/>"+" \'"+v_measure+"\' "+"<egui:intnl text='admin.threshold.should not contain negative values'/>.");
				thisForm.absMinCritical.focus();
				return false;
			}

			ret = checkNegativeValue(abs_MinMajor);
			if (ret)
			{
				alert("<egui:intnl text='admin.threshold.Static minimum threshold'/> <egui:intnl text='admin.threshold.for'/>"+" \'"+v_measure+"\' "+"<egui:intnl text='admin.threshold.should not contain negative values'/>.");
				thisForm.absMinMajor.focus();
				return false;
			}

			ret = checkNegativeValue(abs_MinMinor);
			if (ret)
			{
				alert("<egui:intnl text='admin.threshold.Static minimum threshold'/> <egui:intnl text='admin.threshold.for'/>"+" \'"+v_measure+"\' "+"<egui:intnl text='admin.threshold.should not contain negative values'/>.");
				thisForm.absMinMinor.focus();
				return false;
			}
		}
		else
		{
			//Invalid threshold entry check...
			if (!checkValidValue(abs_MinCritical))
			{
				alert('<egui:intnl text="admin.threshold.Invalid threshold entry : Critical - Static minimum threshold"/>');
				thisForm.absMinCritical.focus();
				return false;
			}
			else if( abs_MinCritical != "-")
			{
				if(!checkNegativeFormat(abs_MinCritical))
				{
					alert('<egui:intnl text="admin.threshold.Invalid threshold entry : Critical - Static minimum threshold"/>'+".\n"+'<egui:intnl text="admin.threshold.Possible reasons could be"/>'+" : \n"+
					"1) "+"<egui:intnl text='admin.threshold.The integer part contains more than 6 digits'/>"+".\n"+
					"2) "+'<egui:intnl text="admin.threshold.The fractional part contains more than 2 digits"/>'+".");
					thisForm.absMinCritical.focus();
					return false;
				}
			}

			if (!checkValidValue(abs_MinMajor))
			{
				alert('<egui:intnl text="admin.threshold.Invalid threshold entry : Major - Static minimum threshold"/>');
				thisForm.absMinMajor.focus();
				return false;
			}
			else if( abs_MinMajor != "-")
			{
				if(!checkNegativeFormat(abs_MinMajor))
				{
					alert('<egui:intnl text="admin.threshold.Invalid threshold entry : Major - Static minimum threshold"/>'+".\n"+'<egui:intnl text="admin.threshold.Possible reasons could be"/>'+" : \n"+
					"1) "+"<egui:intnl text='admin.threshold.The integer part contains more than 6 digits'/>"+".\n"+
					"2) "+'<egui:intnl text="admin.threshold.The fractional part contains more than 2 digits"/>'+".");
					thisForm.absMinMajor.focus();
					return false;
				}
			}
			if (!checkValidValue(abs_MinMinor))
			{
				alert('<egui:intnl text="admin.threshold.Invalid threshold entry : Minor - Static minimum threshold"/>');
				thisForm.absMinMinor.focus();
				return false;
			}
			else if(abs_MinMinor != "-")
			{
				if(!checkNegativeFormat(abs_MinMinor))
				{
					alert('<egui:intnl text="admin.threshold.Invalid threshold entry : Minor - Static minimum threshold"/>'+".\n"+'<egui:intnl text="admin.threshold.Possible reasons could be"/>'+" : \n"+
					"1) "+"<egui:intnl text='admin.threshold.The integer part contains more than 6 digits'/>"+".\n"+
					"2) "+'<egui:intnl text="admin.threshold.The fractional part contains more than 2 digits"/>'+".");
					thisForm.absMinMinor.focus();
					return false;
				}
			}
		}

		//check ascending order...
		if (abs_MinCritical != "-" && abs_MinMajor != "-")
		{
			if (parseFloat(abs_MinCritical) >= parseFloat(abs_MinMajor))
			{
				alert('<egui:intnl text="admin.threshold.Static minimum threshold values representing Critical/Major/Minor should be in ascending order"/>');
				thisForm.absMinCritical.focus();
				return false;
			}
		}
		if (abs_MinMajor != "-" && abs_MinMinor != "-")
		{
			if (parseFloat(abs_MinMajor) >= parseFloat(abs_MinMinor))
			{
				alert('<egui:intnl text="admin.threshold.Static minimum threshold values representing Critical/Major/Minor should be in ascending order"/>');
				thisForm.absMinMajor.focus();
				return false;
			}
		}
		if (abs_MinCritical != "-" && abs_MinMinor != "-")
		{
			if (parseFloat(abs_MinCritical) >= parseFloat(abs_MinMinor))
			{
				alert('<egui:intnl text="admin.threshold.Static minimum threshold values representing Critical/Major/Minor should be in ascending order"/>');
				thisForm.absMinCritical.focus();
				return false;
			}
		}
	}

	var rel_MinCritical = "-";
	var rel_MinMajor = "-";
	var rel_MinMinor = "-";
	if (thisForm.minAutomaticOption != null && thisForm.minAutomaticOption != "undefined")
	{
		var rel_MinOpt = thisForm.minAutomaticOption.options[thisForm.minAutomaticOption.selectedIndex].value;
		if (rel_MinOpt != "none")
		{
				var v_amount_A = document.getElementById("amount_A").value;
				if (v_amount_A != 0)
				{
					if (v_amount_A == 100)
					{
						rel_MinCritical = "sqc";
					}
					else
					{
						rel_MinCritical = (v_amount_A/100) + "*sqc";
					}
				}

				var v_amount_B = document.getElementById("amount_B").value;
				if (v_amount_B != 0)
				{
					if (v_amount_B == 100)
					{
						rel_MinMajor = "sqc";
					}
					else
					{
						rel_MinMajor = (v_amount_B/100) + "*sqc";
					}
				}

				var v_amount_C = document.getElementById("amount_C").value;
				if (v_amount_C != 0)
				{
					if (v_amount_C == 100)
					{
						rel_MinMinor = "sqc";
					}
					else
					{
						rel_MinMinor = (v_amount_C/100) + "*sqc";
					}
				}

			//check ascending order...
			var relCri,relMaj,relMin;
			relCri = rel_MinCritical;
			relMaj = rel_MinMajor;
			relMin = rel_MinMinor;
			relCri = relCri.replace(/(\*sqc)/gi,"");
			relCri = relCri.replace(/sqc/g,"1");
			relMaj = relMaj.replace(/(\*sqc)/gi,"");
			relMaj = relMaj.replace(/sqc/g,"1");
			relMin = relMin.replace(/(\*sqc)/gi,"");
			relMin = relMin.replace(/sqc/g,"1");

			if (relCri != "-" && relMaj != "-")
			{
				if (parseFloat(relCri) >= parseFloat(relMaj))
				{
					alert('<egui:intnl text="admin.threshold.Automatic minimum threshold values representing Critical/Major/Minor should be in ascending order"/>');
					return false;
				}
			}
			if (relMaj != "-" && relMin != "-")
			{
				if (parseFloat(relMaj) >= parseFloat(relMin))
				{
					alert('<egui:intnl text="admin.threshold.Automatic minimum threshold values representing Critical/Major/Minor should be in ascending order"/>');
					return false;
				}
			}
			if (relCri != "-" && relMin != "-")
			{
				if (parseFloat(relCri) >= parseFloat(relMin))
				{
					alert('<egui:intnl text="admin.threshold.Automatic minimum threshold values representing Critical/Major/Minor should be in ascending order"/>');
					return false;
				}
			}
		}
	}

	if(abs_MinCritical.indexOf(".") != -1 )
	{
		var abs_MinCriticalDecimal = abs_MinCritical.substring(abs_MinCritical.indexOf(".")+1);
		if(abs_MinCriticalDecimal == "00" || abs_MinCriticalDecimal == "0" )
		{
			abs_MinCritical = abs_MinCritical.substring(0,abs_MinCritical.indexOf("."));
		}
		else if(abs_MinCriticalDecimal.length > 1)
		{
			if(abs_MinCriticalDecimal.charAt(1) == "0")
			{
				abs_MinCritical = abs_MinCritical.substring(0,abs_MinCritical.lastIndexOf("0"));
				//alert("Hi second decimal place is zero bossss from bs_MinCriticalDecimal!" +abs_MinCriticalDecimal.charAt(1));
			}
		}
	}
	if(abs_MinMajor.indexOf(".") != -1 )
	{
		var abs_MinMajorDecimal = abs_MinMajor.substring(abs_MinMajor.indexOf(".")+1);
		if(abs_MinMajorDecimal == "00" || abs_MinMajorDecimal == "0")
		{
			abs_MinMajor = abs_MinMajor.substring(0,abs_MinMajor.indexOf("."));
		}
		else if(abs_MinMajorDecimal.length > 1)
		{
			if(abs_MinMajorDecimal.charAt(1) == "0")
			{
				abs_MinMajor = abs_MinMajor.substring(0,abs_MinMajor.lastIndexOf("0"));
				//alert("Hi second decimal place is zero bossss from abs_MinMajorDecimal!" +abs_MinMajorDecimal.charAt(1));
			}
		}
	}
	if(abs_MinMinor.indexOf(".") != -1 )
	{
		var abs_MinMinorDecimal = abs_MinMinor.substring(abs_MinMinor.indexOf(".")+1);
		if(abs_MinMinorDecimal == "00" || abs_MinMinorDecimal == "0")
		{
			abs_MinMinor = abs_MinMinor.substring(0,abs_MinMinor.indexOf("."));
		}
		else if(abs_MinMinorDecimal.length > 1)
		{
			if(abs_MinMinorDecimal.charAt(1) == "0")
			{
				abs_MinMinor = abs_MinMinor.substring(0,abs_MinMinor.lastIndexOf("0"));
				//alert("Hi second decimal place is zero bossss from abs_MinMinorDecimal!" +abs_MinMinorDecimal.charAt(1));
			}
		}
	}

	var minCritical = "-";
	if (abs_MinCritical != "-" && rel_MinCritical != "-")
	{
		if(abs_MinCritical > -1 || abs_MinCritical < 0)
		{
			if(abs_MinCritical.indexOf(".") == 0)
			{
				abs_MinCritical = "0"+abs_MinCritical;
			}
			abs_MinCritical = parseFloat(abs_MinCritical);
			minCritical = abs_MinCritical.toString() + "&" + rel_MinCritical;
		}
		else
		{
			minCritical = rel_MinCritical;
		}
	}
	else if (abs_MinCritical != "-" && rel_MinCritical == "-")
	{
		if(abs_MinCritical > -1 || abs_MinCritical < 0)
		{
			if(abs_MinCritical.indexOf(".") == 0)
			{
				abs_MinCritical = "0"+abs_MinCritical;
			}
			abs_MinCritical = parseFloat(abs_MinCritical);
			minCritical = abs_MinCritical.toString();
		}
		else
		{
			minCritical = "-";
		}
	}
	else if (abs_MinCritical == "-" && rel_MinCritical != "-")
	{
		minCritical = rel_MinCritical;
	}

	var minMajor = "-";
	if (abs_MinMajor != "-" && rel_MinMajor != "-")
	{
		if(abs_MinMajor > -1 || abs_MinMajor < 0)
		{
			if(abs_MinMajor.indexOf(".") == 0)
			{
				abs_MinMajor = "0"+abs_MinMajor;
			}
			abs_MinMajor = parseFloat(abs_MinMajor);
			minMajor = abs_MinMajor.toString() + "&" + rel_MinMajor;
		}
		else
		{
			minMajor = rel_MinMajor;
		}
	}
	else if (abs_MinMajor != "-" && rel_MinMajor == "-")
	{
		if(abs_MinMajor > -1 || abs_MinMajor < 0)
		{
			if(abs_MinMajor.indexOf(".") == 0)
			{
				abs_MinMajor = "0"+abs_MinMajor;
			}
			abs_MinMajor = parseFloat(abs_MinMajor);
			minMajor = abs_MinMajor.toString();
		}
		else
		{
			minMajor = "-";
		}
	}
	else if (abs_MinMajor == "-" && rel_MinMajor != "-")
	{
		minMajor = rel_MinMajor;
	}

	var minMinor = "-";
	if (abs_MinMinor != "-" && rel_MinMinor != "-")
	{
		if(abs_MinMinor > -1 || abs_MinMinor < 0)
		{
			if(abs_MinMinor.indexOf(".") == 0)
			{
				abs_MinMinor = "0"+abs_MinMinor;
			}
			abs_MinMinor = parseFloat(abs_MinMinor);
			minMinor = abs_MinMinor.toString() + "&" + rel_MinMinor;
		}
		else
		{
			minMinor = rel_MinMinor;
		}
	}
	else if (abs_MinMinor != "-" && rel_MinMinor == "-")
	{
		if(abs_MinMinor > -1 || abs_MinMinor < 0)
		{
			if(abs_MinMinor.indexOf(".") == 0)
			{
				abs_MinMinor = "0"+abs_MinMinor;
			}
			abs_MinMinor = parseFloat(abs_MinMinor);
			minMinor = abs_MinMinor.toString();
		}
		else
		{
			minMinor = "-";
		}
	}
	else if (abs_MinMinor == "-" && rel_MinMinor != "-")
	{
		minMinor = rel_MinMinor;
	}

	if (minCritical != "-" || minMajor != "-" || minMinor != "-")
	{
		minThreshold = minCritical + "/" + minMajor + "/" + minMinor
	}

	var abs_MaxCritical = "-";
	var abs_MaxMajor = "-";
	var abs_MaxMinor = "-";
	var abs_MaxOpt = thisForm.maxStaticOption.options[thisForm.maxStaticOption.selectedIndex].value;
	if (abs_MaxOpt != "none")
	{
		abs_MaxCritical = thisForm.absMaxCritical.value;
		abs_MaxMajor = thisForm.absMaxMajor.value;
		abs_MaxMinor = thisForm.absMaxMinor.value;

		// Negative value check...
		if ('<%=isNegativeValuesAllowed%>' == "false")
		{
			//Invalid threshold entry check...
			if (!checkValidValue(abs_MaxCritical))
			{
				alert('<egui:intnl text="admin.threshold.Invalid threshold entry : Critical - Static maximum threshold"/>');
				thisForm.absMaxCritical.focus();
				return false;
			}
			else if(abs_MaxCritical != "-")
			{
				if(!checkNonNegativeFormat(abs_MaxCritical))
				{
					alert('<egui:intnl text="admin.threshold.Invalid threshold entry : Critical - Static maximum threshold"/>'+".\n"+'<egui:intnl text="admin.threshold.Possible reasons could be"/>'+" : \n"+
					"1) "+'<egui:intnl text="admin.threshold.Threshold is set with a negative values"/>'+".\n"+
					"2) "+"<egui:intnl text='admin.threshold.The integer part contains more than 6 digits'/>"+".\n"+
					"3) "+'<egui:intnl text="admin.threshold.The fractional part contains more than 2 digits"/>'+".");
					thisForm.absMaxCritical.focus();
					return false;
				}
			}

			if (!checkValidValue(abs_MaxMajor))
			{
				alert('<egui:intnl text="admin.threshold.Invalid threshold entry : Major - Static maximum threshold"/>');
				thisForm.absMaxMajor.focus();
				return false;
			}
			else if(abs_MaxMajor != "-")
			{
				if(!checkNonNegativeFormat(abs_MaxMajor))
				{
					alert('<egui:intnl text="admin.threshold.Invalid threshold entry : Major - Static maximum threshold"/>'+".\n"+'<egui:intnl text="admin.threshold.Possible reasons could be"/>'+" : \n"+
					"1) "+'<egui:intnl text="admin.threshold.Threshold is set with a negative values"/>'+".\n"+
					"2) "+"<egui:intnl text='admin.threshold.The integer part contains more than 6 digits'/>"+".\n"+
					"3) "+'<egui:intnl text="admin.threshold.The fractional part contains more than 2 digits"/>'+".");
					thisForm.absMaxMajor.focus();
					return false;
				}
			}

			if (!checkValidValue(abs_MaxMinor))
			{
				alert('<egui:intnl text="admin.threshold.Invalid threshold entry : Minor - Static maximum threshold"/>');
				thisForm.absMaxMinor.focus();
				return false;
			}
			else if(abs_MaxMinor != "-")
			{
				if(!checkNonNegativeFormat(abs_MaxMinor))
				{
					alert('<egui:intnl text="admin.threshold.Invalid threshold entry : Minor - Static Maximum threshold"/>'+".\n"+'<egui:intnl text="admin.threshold.Possible reasons could be"/>'+" : \n"+
					"1) "+'<egui:intnl text="admin.threshold.Threshold is set with a negative values"/>'+".\n"+
					"2) "+"<egui:intnl text='admin.threshold.The integer part contains more than 6 digits'/>"+".\n"+
					"3) "+'<egui:intnl text="admin.threshold.The fractional part contains more than 2 digits"/>'+".");
					thisForm.absMaxMinor.focus();
					return false;
				}
			}

			var ret = checkNegativeValue(abs_MaxCritical);
			if (ret)
			{
				alert("<egui:intnl text='admin.threshold.Static maximum threshold'/> <egui:intnl text='admin.threshold.for'/>"+" \'"+v_measure+"\' "+"<egui:intnl text='admin.threshold.should not contain negative values'/>.");
				thisForm.absMaxCritical.focus();
				return false;
			}

			ret = checkNegativeValue(abs_MaxMajor);
			if (ret)
			{
				alert("<egui:intnl text='admin.threshold.Static maximum threshold'/> <egui:intnl text='admin.threshold.for'/>"+" \'"+v_measure+"\' "+"<egui:intnl text='admin.threshold.should not contain negative values'/>.");
				thisForm.absMaxMajor.focus();
				return false;
			}

			ret = checkNegativeValue(abs_MaxMinor);
			if (ret)
			{
				alert("<egui:intnl text='admin.threshold.Static maximum threshold'/> <egui:intnl text='admin.threshold.for'/>"+" \'"+v_measure+"\' "+"<egui:intnl text='admin.threshold.should not contain negative values'/>.");
				thisForm.absMaxMinor.focus();
				return false;
			}
		}
		else
		{
			if (!checkValidValue(abs_MaxCritical))
			{
				alert('<egui:intnl text="admin.threshold.Invalid threshold entry : Critical - Static maximum threshold"/>');
				thisForm.absMaxCritical.focus();
				return false;
			}
			else if(abs_MaxCritical != "-")
			{
				if(!checkNegativeFormat(abs_MaxCritical))
				{
					alert('<egui:intnl text="admin.threshold.Invalid threshold entry : Critical - Static maximum threshold"/>'+".\n"+'<egui:intnl text="admin.threshold.Possible reasons could be"/>'+" : \n"+
					"1) "+"<egui:intnl text='admin.threshold.The integer part contains more than 6 digits'/>"+".\n"+
					"2) "+'<egui:intnl text="admin.threshold.The fractional part contains more than 2 digits"/>'+".");
					thisForm.absMaxCritical.focus();
					return false;
				}
			}

			if (!checkValidValue(abs_MaxMajor))
			{
				alert('<egui:intnl text="admin.threshold.Invalid threshold entry : Major - Static maximum threshold"/>');
				thisForm.absMaxMajor.focus();
				return false;
			}
			else if(abs_MaxMajor != "-")
			{
				if(!checkNegativeFormat(abs_MaxMajor))
				{
					alert('<egui:intnl text="admin.threshold.Invalid threshold entry : Major - Static maximum threshold"/>'+".\n"+'<egui:intnl text="admin.threshold.Possible reasons could be"/>'+" : \n"+
					"1) "+"<egui:intnl text='admin.threshold.The integer part contains more than 6 digits'/>"+".\n"+
					"2) "+'<egui:intnl text="admin.threshold.The fractional part contains more than 2 digits"/>'+".");
					thisForm.absMaxMajor.focus();
					return false;
				}
			}

			if (!checkValidValue(abs_MaxMinor))
			{
				alert('<egui:intnl text="admin.threshold.Invalid threshold entry : Minor - Static maximum threshold"/>');
				thisForm.absMaxMinor.focus();
				return false;
			}
			else if(abs_MaxMinor != "-")
			{
				if(!checkNegativeFormat(abs_MaxMinor))
				{
					alert('<egui:intnl text="admin.threshold.Invalid threshold entry : Major - Static maximum threshold"/>'+".\n"+'<egui:intnl text="admin.threshold.Possible reasons could be"/>'+" : \n"+
					"1) "+"<egui:intnl text='admin.threshold.The integer part contains more than 6 digits'/>"+".\n"+
					"2) "+'<egui:intnl text="admin.threshold.The fractional part contains more than 2 digits"/>'+".");
					thisForm.absMaxMinor.focus();
					return false;
				}
			}
		}
		//check descending order...
		if (abs_MaxCritical != "-" && abs_MaxMajor != "-")
		{
			if (parseFloat(abs_MaxCritical) <= parseFloat(abs_MaxMajor))
			{
				alert('<egui:intnl text="admin.threshold.Static maximum threshold values representing Critical/Major/Minor should be in descending order"/>');
				thisForm.absMaxCritical.focus();
				return false;
			}
		}
		if (abs_MaxMajor != "-" && abs_MaxMinor != "-")
		{
			if (parseFloat(abs_MaxMajor) <= parseFloat(abs_MaxMinor))
			{
				alert('<egui:intnl text="admin.threshold.Static maximum threshold values representing Critical/Major/Minor should be in descending order"/>');
				thisForm.absMaxMajor.focus();
				return false;
			}
		}
		if (abs_MaxCritical != "-" && abs_MaxMinor != "-")
		{
			if (parseFloat(abs_MaxCritical) <= parseFloat(abs_MaxMinor))
			{
				alert('<egui:intnl text="admin.threshold.Static maximum threshold values representing Critical/Major/Minor should be in descending order"/>');
				thisForm.absMaxCritical.focus();
				return false;
			}
		}
	}

	var rel_MaxCritical = "-";
	var rel_MaxMajor = "-";
	var rel_MaxMinor = "-";
	if (thisForm.maxAutomaticOption != null && thisForm.maxAutomaticOption != "undefined")
	{
		var rel_MaxOpt = thisForm.maxAutomaticOption.options[thisForm.maxAutomaticOption.selectedIndex].value;
		if (rel_MaxOpt != "none")
		{
			//var varOptA = thisForm.maxAutoCriticalOption.options[thisForm.maxAutoCriticalOption.selectedIndex].value;
			//if (varOptA != "none")
			{
				var v_amount_D = document.getElementById("amount_D").value;
				if (v_amount_D != 0)
				{
					if (v_amount_D == 100)
					{
						rel_MaxCritical = "sqc";
					}
					else
					{
						rel_MaxCritical = (v_amount_D/100) + "*sqc";
					}
				}
			}

			//var varOptB = thisForm.maxAutoMajorOption.options[thisForm.maxAutoMajorOption.selectedIndex].value;
			//if (varOptB != "none")
			{
				var v_amount_E = document.getElementById("amount_E").value;
				if (v_amount_E != 0)
				{
					if (v_amount_E == 100)
					{
						rel_MaxMajor = "sqc";
					}
					else
					{
						rel_MaxMajor = (v_amount_E/100) + "*sqc";
					}
				}
			}

			//var varOptC = thisForm.maxAutoMinorOption.options[thisForm.maxAutoMinorOption.selectedIndex].value;
			//if (varOptC != "none")
			{
				var v_amount_F = document.getElementById("amount_F").value;
				if (v_amount_F != 0)
				{
					if (v_amount_F == 100)
					{
						rel_MaxMinor = "sqc";
					}
					else
					{
						rel_MaxMinor = (v_amount_F/100) + "*sqc";
					}
				}
			}

			//check descending order...
			var relCri,relMaj,relMin;
			relCri = rel_MaxCritical;
			relMaj = rel_MaxMajor;
			relMin = rel_MaxMinor;
			relCri = relCri.replace(/(\*sqc)/gi,"");
			relCri = relCri.replace(/sqc/g,"1");
			relMaj = relMaj.replace(/(\*sqc)/gi,"");
			relMaj = relMaj.replace(/sqc/g,"1");
			relMin = relMin.replace(/(\*sqc)/gi,"");
			relMin = relMin.replace(/sqc/g,"1");

			if (relCri != "-" && relMaj != "-")
			{
				if (parseFloat(relCri) <= parseFloat(relMaj))
				{
					alert('<egui:intnl text="admin.threshold.Automatic maximum threshold values representing Critical/Major/Minor should be in descending order"/>');
					return false;
				}
			}
			if (relMaj != "-" && relMin != "-")
			{
				if (parseFloat(relMaj) <= parseFloat(relMin))
				{
					alert('<egui:intnl text="admin.threshold.Automatic maximum threshold values representing Critical/Major/Minor should be in descending order"/>');
					return false;
				}
			}
			if (relCri != "-" && relMin != "-")
			{
				if (parseFloat(relCri) <= parseFloat(relMin))
				{
					alert('<egui:intnl text="admin.threshold.Automatic maximum threshold values representing Critical/Major/Minor should be in descending order"/>');
					return false;
				}
			}
		}
	}

	if(abs_MaxCritical.indexOf(".") != -1 )
	{
		var abs_MaxCriticalDecimal = abs_MaxCritical.substring(abs_MaxCritical.indexOf(".")+1);
		if(abs_MaxCriticalDecimal == "00" || abs_MaxCriticalDecimal == "0")
		{
			abs_MaxCritical = abs_MaxCritical.substring(0,abs_MaxCritical.indexOf("."));
		}
		else if(abs_MaxCriticalDecimal.length > 1)
		{
			if(abs_MaxCriticalDecimal.charAt(1) == "0")
			{
				abs_MaxCritical = abs_MaxCritical.substring(0,abs_MaxCritical.lastIndexOf("0"));
				//alert("Hi second decimal place is zero bossss from abs_MaxCriticalDecimal !" +abs_MaxCriticalDecimal.charAt(1));
			}
		}
	}
	if(abs_MaxMajor.indexOf(".") != -1 )
	{
		var abs_MaxMajorDecimal = abs_MaxMajor.substring(abs_MaxMajor.indexOf(".")+1);
		if(abs_MaxMajorDecimal == "00" || abs_MaxMajorDecimal == "0")
		{
			abs_MaxMajor = abs_MaxMajor.substring(0,abs_MaxMajor.indexOf("."));
		}
		else if(abs_MaxMajorDecimal.length > 1)
		{
			if(abs_MaxMajorDecimal.charAt(1) == "0")
			{
				abs_MaxMajor = abs_MaxMajor.substring(0,abs_MaxMajor.lastIndexOf("0"));
				//alert("Hi second decimal place is zero bossss from abs_MaxMajorDecimal !" +abs_MaxMajorDecimal.charAt(1));
			}
		}
	}
	if(abs_MaxMinor.indexOf(".") != -1 )
	{
		var abs_MaxMinorDecimal = abs_MaxMinor.substring(abs_MaxMinor.indexOf(".")+1);
		if(abs_MaxMinorDecimal == "00" || abs_MaxMinorDecimal == "0")
		{
			abs_MaxMinor = abs_MaxMinor.substring(0,abs_MaxMinor.indexOf("."));
		}
		else if(abs_MaxMinorDecimal.length > 1)
		{
			if(abs_MaxMinorDecimal.charAt(1) == "0")
			{
				abs_MaxMinor = abs_MaxMinor.substring(0,abs_MaxMinor.lastIndexOf("0"));
				//alert("Hi second decimal place is zero bossss from abs_MaxMinorDecimal !" +abs_MaxMinorDecimal.charAt(1));
			}
		}
	}

	var maxCritical = "-";
	if (abs_MaxCritical != "-" && rel_MaxCritical != "-")
	{
		if(abs_MaxCritical > -1 || abs_MaxCritical < 0)
		{
			if(abs_MaxCritical.indexOf(".") == 0)
			{
				abs_MaxCritical = "0"+abs_MaxCritical;
			}
			abs_MaxCritical = parseFloat(abs_MaxCritical);
			maxCritical = abs_MaxCritical.toString() + "&" + rel_MaxCritical;
		}
		else
		{
			maxCritical = rel_MaxCritical;
		}
	}
	else if (abs_MaxCritical != "-" && rel_MaxCritical == "-")
	{
		if(abs_MaxCritical > -1 || abs_MaxCritical < 0)
		{
			if(abs_MaxCritical.indexOf(".") == 0)
			{
				abs_MaxCritical = "0"+abs_MaxCritical;
			}
			abs_MaxCritical = parseFloat(abs_MaxCritical);
			maxCritical = abs_MaxCritical.toString();
		}
		else
		{
			maxCritical = "-";
		}
	}
	else if (abs_MaxCritical == "-" && rel_MaxCritical != "-")
	{
		maxCritical = rel_MaxCritical;
	}

	var maxMajor = "-";
	if (abs_MaxMajor != "-" && rel_MaxMajor != "-")
	{
		if(abs_MaxMajor > -1 || abs_MaxMajor < 0)
		{
			if(abs_MaxMajor.indexOf(".") == 0)
			{
				abs_MaxMajor = "0"+abs_MaxMajor;
			}
			abs_MaxMajor = parseFloat(abs_MaxMajor);
			maxMajor = abs_MaxMajor.toString() + "&" + rel_MaxMajor;
		}
		else
		{
			maxMajor = rel_MaxMajor;
		}
	}
	else if (abs_MaxMajor != "-" && rel_MaxMajor == "-")
	{
		if(abs_MaxMajor > -1 || + abs_MaxMajor < 0)
		{
			if(abs_MaxMajor.indexOf(".") == 0)
			{
				abs_MaxMajor = "0"+abs_MaxMajor;
			}
			abs_MaxMajor = parseFloat(abs_MaxMajor);
			maxMajor = abs_MaxMajor.toString();
		}
		else
		{
			maxMajor = "-";
		}
	}
	else if (abs_MaxMajor == "-" && rel_MaxMajor != "-")
	{
		maxMajor = rel_MaxMajor;
	}

	var maxMinor = "-";
	if (abs_MaxMinor != "-" && rel_MaxMinor != "-")
	{
		if(abs_MaxMinor > -1 || abs_MaxMinor < 0)
		{
			if(abs_MaxMinor.indexOf(".") == 0)
			{
				abs_MaxMinor = "0"+abs_MaxMinor;
			}
			abs_MaxMinor = parseFloat(abs_MaxMinor);
			maxMinor = abs_MaxMinor.toString() + "&" + rel_MaxMinor;
		}
		else
		{
			maxMinor = rel_MaxMinor;
		}
	}
	else if (abs_MaxMinor != "-" && rel_MaxMinor == "-")
	{
		if(abs_MaxMinor > -1  || abs_MaxMinor < 0)
		{
			if(abs_MaxMinor.indexOf(".") == 0)
			{
				abs_MaxMinor = "0"+abs_MaxMinor;
			}
			abs_MaxMinor = parseFloat(abs_MaxMinor);
			maxMinor = abs_MaxMinor.toString();
		}
		else
		{
			maxMinor = "-";
		}
	}
	else if (abs_MaxMinor == "-" && rel_MaxMinor != "-")
	{
		maxMinor = rel_MaxMinor;
	}

	if (maxCritical != "-" || maxMajor != "-" || maxMinor != "-")
	{
		maxThreshold = maxCritical + "/" + maxMajor + "/" + maxMinor
	}

	var v_threshold = v_measure + ":" + v_policy + ":" + minThreshold + ":" + maxThreshold + ":" + v_alarmPolicy + ":" + lastItem;
	updateThresholds(v_testname,v_threshold);

	return true;
}

function updateThresholds(v_test,v_threshValue)
{
	xmlhttp = null;
	if (window.XMLHttpRequest)
	{
		xmlhttp=new XMLHttpRequest();
	}
	else if (window.ActiveXObject)
	{
		xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");
	}
	if (xmlhttp != null)
	{
		var params = "componentType=<%=strComponentType%>&testName="+v_test+"&threshold="+escape(v_threshValue)+"&operation=updateThresholds";
		var url = "/final/admin/EgApplyThresholds.jsp";
		xmlhttp.onreadystatechange = state_Change3;
		xmlhttp.open('POST',url,true);
		xmlhttp.setRequestHeader('Content-type','application/x-www-form-urlencoded');
		xmlhttp.setRequestHeader('Content-length',params.length);
		xmlhttp.setRequestHeader('Connection','close');
		xmlhttp.send(params);
	}
	else
	{
		alert('<egui:intnl text="admin.login.Your browser does not support XMLHTTP"/>');
	}
}

function state_Change3()
{
	if (xmlhttp.readyState == 4)
	{
		try
		{
			if (xmlhttp.status == 200)
			{
				var url = "/final/admin/EgDefaultThresholds.jsp?componentType=<%=strComponentType%>&testName=<%=strTestName%>";
				window.location.href = url;
			}
		}
		catch (error)
		{
			//error
		}
	}
}

function checkValidValue(val)
{
	var regExp = /^(\-)$|^(\-|\-?(([0-9]+\.|\.)?[0-9]+))$/i;
	var ret = regExp.test(val);
	return ret;
}

function checkNegativeValue(val)
{
	if (val == "-")
	{
		val = "0";
	}
	var regExp = /^\-([0-9]+\.|\.)?[0-9]+/;
	var ret = regExp.test(val);
	return ret;
}

function checkDecimal(val) 
{
	var regExp = /^[0-9]{0,6}(\.[0-9]{1,2})?$/;
	var ret = regExp.test(val);
	return ret;
}

function checkInteger(val)
{
	var regExp=  /^[0-9]{1,6}$/;
	var ret = regExp.test(val);
	return ret;
}

// var RE = /^(\-{0,1})[0-9]{0,6}(\.[0-9]{1,2})?$/; allow negative and only 6 digits and decimal 2 points

function checkNegativeFormat(val)
{
	var regExp= /^(\-{0,1})[0-9]{1,6}(\.[0-9]{1,2})?$/;
	var ret = regExp.test(val);
	return ret;
}

// var RE = /^[0-9]{0,6}(\.[0-9]{1,2})?$/; allow non-negative and only 6 digits and decimal 2 points

function checkNonNegativeFormat(val)
{
	var regExp= /^[0-9]{0,6}(\.[0-9]{1,2})?$/;
	var ret = regExp.test(val);
	return ret;
}

</script>
<body onload="javascript:getAlarmPolicyDesc();">
<form name="threshForm">
<table border="0" width="100%" cellpadding="0" cellspacing="0" align="center" valign="top">
	<jsp:include page="listSearch.jsp?title=CONFIGURE THRESHOLDS&backButton=true&subtitle=false"/>
<%
	boolean isHostTest = specsInfo.isTestRelevantForServer("Host_system",strTestName,true);
	if (isHostTest)
	{
%>
	<tr>
		<td align="center" valign="top">*&nbsp;<egui:intnl text="admin.threshold.Changes made to default threshold will be applied to all component types to which this test is mapped"/> <br><br> </td>
	</tr>
<%
	}

	String unit = tablesInfo.getUnitForMeasure(strTestName,measure);
%>
	<tr>
		<td align="center" valign="top">
			<table border="0" width="90%" cellpadding="0" cellspacing="0">
				<tr>
					<td align="left" class="table_head"  width="100%" style="padding:4px"><b>Default thresholds for the '<%=mappingInfo.getMeasureDescription(strTestName,measure)%>&nbsp;<i>(<%=unit%>)</i>' measure of the '<%=mappingInfo.getTestDescription(strTestName)%>' test</b></td>
				</tr>
			</table>
		</td>
	</tr>

	<tr>
		<td align="center" valign="top">
			<table border="0" width="90%" cellpadding="0" cellspacing="0" class="linesquare">
				<tr>
					<td><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="15"></td>
				</tr>

				<tr>
					<td align="left" valign="bottom" class="eg_7">&nbsp;&nbsp;&nbsp;*&nbsp;<egui:intnl text="admin.threshold.Specify minimum threshold values (Critical, Major, and Minor) in ascending order"/></td>
				</tr>
				<tr>
					<td align="center">
						<table border="0" width="98%" cellpadding="0" cellspacing="0" class="linesquare">
							<tr>
								<td align="center" class="table_head" ><b>Minimum Threshold</b></td>
							</tr>
							<tr>
								<td class="linebottom">
									<table border="0" width="100%" cellpadding="0" cellspacing="0">
										<tr class="eg_cellbgmedium">
											<td>
												<table border="0" width="100%" cellpadding="4" cellspacing="0">
													<tr>
														<td width="50%" align="left"><b>Static</b></td>
														<td width="50%" align="right">
															<select name="minStaticOption" onChange="javascript:showMinStatic();">
																<option value="none">None</option>
																<option value="specify" <%=minStaticSelected%>>Specific values</option>
															</select>
														</td>
													</tr>
												</table>
											</td>
										</tr>
										<tr id="minStatic" style="display:<%=minStaticBlock%>">
											<td>
												<table border="0" width="100%" cellpadding="4" cellspacing="0">
													<tr>
														<td width="33%" class="cell_border4" align="left" style="border-bottom-width:0px"><label>Critical</label>&nbsp;:&nbsp;<input type="text" name="absMinCritical" value="<%=absMinCritical%>" size="8" maxlength="10"></td>
														<td width="33%" class="cell_border4" align="left" style="border-bottom-width:0px"><label>Major</label>&nbsp;:&nbsp;<input type="text" name="absMinMajor" value="<%=absMinMajor%>" size="8" maxlength="10"></td>
														<td width="33%" class="cell_border4" align="left" style="border-bottom-width:0px;border-right-width:0px"><label>Minor</label>&nbsp;:&nbsp;<input type="text" name="absMinMinor" value="<%=absMinMinor%>" size="8" maxlength="10"></td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
	if (!isGlobalThresholds)
	{
		if(!isNegativeValuesAllowed)
		{

%>
							<tr>
								<td>
									<table border="0" width="100%" cellpadding="0" cellspacing="0">
										<tr class="eg_cellbgmedium">
											<td>
												<table border="0" width="100%" cellpadding="4" cellspacing="0">
													<tr>
														<td width="50%" align="left"><b>Automatic</b></td>
														<td width="50%" align="right"><select name="minAutomaticOption" onChange="javascript:showMinAutomatic();">
																<option value="none">None</option>
																<option value="specify" <%=minAutomaticSelected%>>Specific values</option>
															</select>
														</td>
													</tr>
												</table>
											</td>
										</tr>
										<tr id="minAutomatic" style="display:<%=minAutomaticBlock%>">
											<td>
												<table border="0" width="100%" cellpadding="4" cellspacing="0">
													<tr>
														<td width="33%" class="cell_border4" align="left" style="border-bottom-width:0px"><label>Critical</label>&nbsp;:&nbsp;<!-- <select name="minAutoCriticalOption" onChange="javascript:showMinAutoCriticalSlider();">
																<option value="none">None</option>
																<option value="auto" <%//=minAutoCriticalSelected%>>Auto</option>
															</select> -->
														</td>
														<td width="33%" class="cell_border4" align="left" style="border-bottom-width:0px"><label>Major</label>&nbsp;:&nbsp;<!-- <select name="minAutoMajorOption" onChange="javascript:showMinAutoMajorSlider();">
																<option value="none">None</option>
																<option value="auto" <%//=minAutoMajorSelected%>>Auto</option>
															</select> -->
														</td>
														<td width="33%" align="left" class="cell_border4" style="border-bottom-width:0px;border-right-width:0px"><label>Minor</label>&nbsp;:&nbsp;<!-- <select name="minAutoMinorOption" onChange="javascript:showMinAutoMinorSlider();">
																<option value="none">None</option>
																<option value="auto" <%//=minAutoMinorSelected%>>Auto</option>
															</select> -->
														</td>
													</tr>
													<tr id="minAutoTolerance_A" style="display:<%=minAutoToleranceBlock%>">
														<td width="33%" class="cell_border4" align="left" style="border-bottom-width:0px" ><b><i>% Tolerance</i></b></td>
														<td width="33%"  align="left" class="cell_border4" style="border-bottom-width:0px">&nbsp;</td>
														<td width="33%" align="left" class="cell_border4" style="border-bottom-width:0px;border-right-width:0px">&nbsp;</td>
													</tr>
													<tr id="minAutoTolerance_B" style="display:<%=minAutoToleranceBlock%>">
														<td width="33%" class="cell_border4" align="left" style="border-bottom-width:0px">
															<table border="0" width="100%" cellpadding="0" cellspacing="0">
																<tr id="minAutoCriticalSlider" style="display:<%=minAutoCriticalSliderBlock%>">
																	<td align="left" height="20">
																		<div style="float:left;">
																			<input type="text" id="amount_A" style="width:45;border:0; color:#ffffff; font-weight:bold; background-color:#6E6A6B; text-align:center" readonly />
																		</div>
																		<div class="sensitivity_slider_A" style="height:15px;width:170px;border:0px solid red;padding-left:10px;float:right;margin-top:3px;margin-right:5px">
																			<div id="slider_handle_A" style="height:11px"></div>
																		</div>
																	</td>
																</tr>
															</table>
														</td>
														<td width="33%" class="cell_border4" align="left" style="border-bottom-width:0px">
															<table border="0" width="100%" cellpadding="0" cellspacing="0">
																<tr id="minAutoMajorSlider" style="display:<%=minAutoMajorSliderBlock%>">
																	<td align="left" height="20">
																		<div style="float:left;">
																			<input type="text" id="amount_B" style="width:45;border:0; color:#ffffff; font-weight:bold; background-color:#6E6A6B; text-align:center" readonly />
																		</div>
																		<div class="sensitivity_slider_B" style="height:15px;width:170px;border:0px solid red;padding-left:10px;float:right;margin-top:3px;margin-right:5px">
																			<div id="slider_handle_B" style="height:11px"></div>
																		</div>
																	</td>
																</tr>
															</table>
														</td>
														<td width="33%" align="left" class="cell_border4" style="border-bottom-width:0px;border-right-width:0px">
															<table border="0" width="100%" cellpadding="0" cellspacing="0">
																<tr id="minAutoMinorSlider" style="display:<%=minAutoMinorSliderBlock%>">
																	<td align="left" height="20">
																		<div style="float:left;">
																			<input type="text" id="amount_C" style="width:45;border:0; color:#ffffff; font-weight:bold; background-color:#6E6A6B; text-align:center" readonly />
																		</div>
																		<div class="sensitivity_slider_C" style="height:15px;width:170px;border:0px solid red;padding-left:10px;float:right;margin-top:3px;margin-right:5px">
																			<div id="slider_handle_C" style="height:11px"></div>
																		</div>
																	</td>
																</tr>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
		}
	}
%>
						</table>
					</td>
				</tr>
				<tr>
					<td><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="15"></td>
				</tr>

				<tr>
					<td align="left" valign="bottom" class="eg_7">&nbsp;&nbsp;&nbsp;*&nbsp;<egui:intnl text="admin.threshold.Specify maximum threshold values (Critical, Major, and Minor) in descending order"/></td>

				</tr>

				<tr>
					<td align="center">
						<table border="0" width="98%" cellpadding="0" cellspacing="0" class="linesquare">
							<tr>
								<td align="center" class="table_head"><b>Maximum Threshold</b></td>
							</tr>
							<tr>
								<td class="linebottom">
									<table border="0" width="100%" cellpadding="0" cellspacing="0">
										<tr class="eg_cellbgmedium">
											<td>
												<table border="0" width="100%" cellpadding="4" cellspacing="0">
													<tr>
														<td width="50%" align="left"><b>Static</b></td>
														<td width="50%" align="right">
															<select name="maxStaticOption" onChange="javascript:showMaxStatic();">
																<option value="none">None</option>
																<option value="specify" <%=maxStaticSelected%>>Specific values</option>
															</select>
														</td>
													</tr>
												</table>
											</td>
										</tr>
										<tr id="maxStatic" style="display:<%=maxStaticBlock%>">
											<td>
												<table border="0" width="100%" cellpadding="4" cellspacing="0">
													<tr>
														<td width="33%" class="cell_border4" align="left" style="border-bottom-width:0px"><label>Critical</label>&nbsp;:&nbsp;<input type="text" name="absMaxCritical" value="<%=absMaxCritical%>" size="8" maxlength="10"></td>
														<td width="33%" class="cell_border4" align="left" style="border-bottom-width:0px"><label>Major</label>&nbsp;:&nbsp;<input type="text" name="absMaxMajor" value="<%=absMaxMajor%>" size="8" maxlength="10"></td>
														<td width="33%" class="cell_border4" align="left" style="border-bottom-width:0px;border-right-width:0px"><label>Minor</label>&nbsp;:&nbsp;<input type="text" name="absMaxMinor" value="<%=absMaxMinor%>" size="8" maxlength="10"></td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
	if (!isGlobalThresholds )
	{
		if(!isNegativeValuesAllowed)
		{
%>
							<tr>
								<td>
									<table border="0" width="100%" cellpadding="0" cellspacing="0">
										<tr class="eg_cellbgmedium">
											<td>
												<table border="0" width="100%" cellpadding="4" cellspacing="0">
													<tr>
														<td width="50%" align="left"><b>Automatic</b></td>
														<td width="50%" align="right">
															<select name="maxAutomaticOption" onChange="javascript:showMaxAutomatic();">
																<option value="none">None</option>
																<option value="specify" <%=maxAutomaticSelected%>>Specific values</option>
															</select>
														</td>
													</tr>
												</table>
											</td>
										</tr>
										<tr id="maxAutomatic" style="display:<%=maxAutomaticBlock%>">
											<td>
												<table border="0" width="100%" cellpadding="4" cellspacing="0">
													<tr>
														<td width="33%" class="cell_border4" align="left" style="border-bottom-width:0px"><label>Critical</label>&nbsp;:&nbsp;<!-- <select name="maxAutoCriticalOption" onChange="javascript:showMaxAutoCriticalSlider();">
																<option value="none">None</option>
																<option value="auto" <%//=maxAutoCriticalSelected%>>Auto</option>
															</select> -->
														</td>
														<td width="33%" class="cell_border4" align="left" style="border-bottom-width:0px"><label>Major</label>&nbsp;:&nbsp;<!-- <select name="maxAutoMajorOption" onChange="javascript:showMaxAutoMajorSlider();">
																<option value="none">None</option>
																<option value="auto" <%//=maxAutoMajorSelected%>>Auto</option>
															</select> -->
														</td>
														<td width="33%" align="left" class="cell_border4" style="border-bottom-width:0px;border-right-width:0px"><label>Minor</label>&nbsp;:&nbsp;<!-- <select name="maxAutoMinorOption" onChange="javascript:showMaxAutoMinorSlider();">
																<option value="none">None</option>
																<option value="auto" <%//=maxAutoMinorSelected%>>Auto</option>
															</select> -->
														</td>
													</tr>
													<tr id="maxAutoTolerance_A" style="display:<%=maxAutoToleranceBlock%>">
														<td width="33%" class="cell_border4" align="left" style="border-bottom-width:0px"><b><i>% Tolerance</i></td>
														<td width="33%"  align="center" class="cell_border4" style="border-bottom-width:0px">&nbsp;</td>
														<td width="33%" align="center" class="cell_border4" style="border-bottom-width:0px;border-right-width:0px">&nbsp;</td>
													</tr>
													<tr id="maxAutoTolerance_B" style="display:<%=maxAutoToleranceBlock%>">
														<td width="33%" class="cell_border4" align="left" style="border-bottom-width:0px">
															<table border="0" width="100%" cellpadding="0" cellspacing="0">
																<tr id="maxAutoCriticalSlider" style="display:<%=maxAutoCriticalSliderBlock%>">
																	<td align="left" height="20">
																		<div style="float:left;">
																			<input type="text" id="amount_D" style="width:45;border:0; color:#ffffff; font-weight:bold; background-color:#6E6A6B; text-align:center" readonly />
																		</div>
																		<div class="sensitivity_slider_D" style="height:15px;width:170px;border:0px solid red;padding-left:10px;float:right;margin-top:3px;margin-right:5px">
																			<div id="slider_handle_D" style="height:11px"></div>
																		</div>
																	</td>
																</tr>
															</table>
														</td>
														<td width="33%" class="cell_border4" align="left" style="border-bottom-width:0px">
															<table border="0" width="100%" cellpadding="0" cellspacing="0">
																<tr id="maxAutoMajorSlider" style="display:<%=maxAutoMajorSliderBlock%>">
																	<td align="left" height="20">
																		<div style="float:left;">
																			<input type="text" id="amount_E" style="width:45;border:0; color:#ffffff; font-weight:bold; background-color:#6E6A6B; text-align:center" readonly />
																		</div>
																		<div class="sensitivity_slider_E" style="height:15px;width:170px;border:0px solid red;padding-left:10px;float:right;margin-top:3px;margin-right:5px">
																			<div id="slider_handle_E" style="height:11px"></div>
																		</div>
																	</td>
																</tr>
															</table>
														</td>
														<td width="33%" align="left" class="cell_border4" style="border-bottom-width:0px;border-right-width:0px">
															<table border="0" width="100%" cellpadding="0" cellspacing="0">
																<tr id="maxAutoMinorSlider" style="display:<%=maxAutoMinorSliderBlock%>">
																	<td align="left" height="20">
																		<div style="float:left;">
																			<input type="text" id="amount_F" style="width:45;border:0; color:#ffffff; font-weight:bold; background-color:#6E6A6B; text-align:center" readonly />
																		</div>
																		<div class="sensitivity_slider_F" style="height:15px;width:170px;border:0px solid red;padding-left:10px;float:right;margin-top:3px;margin-right:5px">
																			<div id="slider_handle_F" style="height:11px"></div>
																		</div>
																	</td>
																</tr>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
		}
	}
%>
						</table>
					</td>
				</tr>

				<tr>
					<td><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="15"></td>
				</tr>

				<tr>
					<td align="center">
						<table border="0" width="98%" cellpadding="0" cellspacing="0" class="linesquare">
							<tr>
								<td align="center" class="table_head"><b>Alarm Policy</b></td>
							</tr>
							<tr>
								<td>
									<table border="0" width="100%" cellpadding="4" cellspacing="0">
										<tr class="eg_cellbgmedium">
											<td width="25%" align="center"><b>Policy</b></td>
											<td width="75%" align="center"><b>Description</b></td>
										</tr>

										<tr>
											<td width="25%" align="center" class="cell_border4" style="border-bottom-width:0px;">
												<select id="alarmPolicyOption" name="alarmPolicyOption" onChange="javascript:getAlarmPolicyDesc();">
<%
	for (int i=0;i<alarmVariables.length;i++)
	{
		String strAlarmPolicy = alarmVariables[i];
		String selected = "";
		if (strAlarmPolicy.equals(alarmPolicy))
		{
			selected = "selected";
		}
%>
		<option value="<%=strAlarmPolicy%>" <%=selected%>><%=strAlarmPolicy%></option>
<%
	}
%>
												</select>&nbsp;
											</td>
											<td width="100%"  align="center" class="cell_border4" style="border-bottom-width:0px;border-right-width:0px">
												<div id="alarmPolicyDescDiv"></div>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>

				<tr>
					<td><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="10"></td>
				</tr>

				<tr>
					<td align="center">
						<input type="button" name="update" value='<egui:intnl text="admin.common.Update"/>' class="eg_back" onClick="javascript:updateData()">
					</td>
				</tr>

				<tr>
					<td><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="10"></td>
				</tr>
			</table></br>
		</td>
	</tr>
</table>
</form>
</html>