<%
/***********************************************************************************************************
 *       Name            :       EgDbUserCreation.jsp
 *       Purpose         :       This jsp is used for adding new users into the egurkha system.
 *       Version         :       0.1
 *       CreationDate    :       15/11/2000
 *       LastModified    :      	
 *			22/06/2004	Arun		Weblogic tests have use a "server" parameter which is also used by 
 *									the JSP to send the server type. Change the query parameter to 
 *									typeOfServer to remove ambiguity.

				14/01/2003 //sandhya - Nickname change	
				27/11/2001 //sandhya - validations for deft tablespace & temp tablespace.	
				17/10/2001 //sandhya.K - to display alert message "This operation might take ..." when ADD button is clicked.	
				28/09/2001 //sandhya.K - made changes to support Oracle7.x	
				16/02/2001 //Sandhya.K - Validations 
				08/12/2000
 *       Author          :       KrishnaKumar.C
 *		Design Changes		:		Jaiwin
 */
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import = "java.util.*" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib prefix = "egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page import = "com.eg.PortDiscovery" %>
<%@ page import = "com.eg.EgAggregateInfo"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "com.eg.EgURLEncoder"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<html>
<head>
<title>Creation Of New Database User</title>
<meta name="created" content="28/6/2k">
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<!-- <link rel="stylesheet" href="eg_styles/eg_adminstyle.css">  -->
<egui:skin ui="adminindex"/>
<script language="JavaScript1.2" src="eg_scripts/validate.js"></script>
<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
<script language="JavaScript1.2">

function call()
{
	window.location.href ="EgConfigTest.jsp?comptype=" + "<%=request.getParameter("comptype")%>" + "&compname=" + "<%=request.getParameter("c_name")%>" + "&qctr=1&rctr=0&t_name=" + "<%=request.getParameter("t_name")%>" + "&typeOfServer=" + "<%=request.getParameter("server")%>" + "&hostname=" + "<%=request.getParameter("c_name")%>";
}

function valform()
{
	var thisForm = document.adduser;
	var version = thisForm.version.options[thisForm.version.selectedIndex].value;
	var deftval = thisForm.deftablespace.value;
	var tempval = thisForm.temptablespace.value;
	var start_chars = "0123456789$#_";
	var sub = true;
	var dbUser = thisForm.dbuser.value;
	var regExp = /^[A-Za-z]+/;
	if(version == "-1")
	{
		alert('<egui:intnl text= "admin.db.Please select a DB version"/>');
		sub = false;
	}
	else if(!checkblank(thisForm.dbauser))
	{
		alert('<egui:intnl text= "admin.db.Please enter the DB admin"/>');
		thisForm.dbauser.focus();
		sub = false;
	}
	else if(!checkspace(thisForm.dbauser))
	{
		thisForm.dbauser.focus();
		sub = false;
	}
	else if(!checkspecial(thisForm.dbauser,"`~!@#$%^&*()+={}[]|\\:;\"\'<>,.?\/"))
	{
		thisForm.dbauser.focus();
		sub = false;
	}
	else if(thisForm.dbapwd.value == "")
	{
		alert('<egui:intnl text="admin.user.Please enter the password"/>');
		thisForm.dbapwd.focus();
		sub = false;
	}
	else if(!checkspecialnomess(thisForm.dbapwd,"\"|"))
	{
		alert(_notAllowCharInPwd);
		thisForm.dbapwd.focus();
		sub = false;
	}
	else if(!checkblank(thisForm.dbuser))
	{
		alert('<egui:intnl text= "admin.db.Please enter the DB user"/>');
		thisForm.dbuser.focus();
		sub = false;
	}
	else if(!checkspace(thisForm.dbuser))
	{
		thisForm.dbuser.focus();
		sub = false;
	}
	else if(!checkspecial(thisForm.dbuser,"`~!@#$%^&*()+={}[]|\\:;\"\'<>,.?\/"))
	{
		thisForm.dbuser.focus();
		sub = false;
	}
	else if(!regExp.test(dbUser))
	{
		thisForm.dbuser.focus();
		alert('<egui:intnl text= "admin.db.DB user name should start with an alphabet"/>');
		sub = false;
	}
	else if(thisForm.dbuserpwd.value == "")
	{
		alert('<egui:intnl text="admin.user.Please enter the password"/>');
		thisForm.dbuserpwd.focus();
		sub = false;
	}
	else if(!checkspecialnomess(thisForm.dbuserpwd,"\"|"))
	{
		alert(_notAllowCharInPwd);
		thisForm.dbuserpwd.focus();
		sub = false;
	}
	else if(!checkblank(thisForm.deftablespace))
	{
		alert('<egui:intnl text= "admin.db.Please enter the default tablespace"/>');
		thisForm.deftablespace.focus();
		sub = false;
	}
	else if(!checkspace(thisForm.deftablespace))
	{
		thisForm.deftablespace.focus();
		sub = false;
	}
	else if(start_chars.indexOf(deftval.charAt(0)) > -1)
	{
		alert('<egui:intnl text= "admin.db.Default tablespace should begin with an alphabet"/>');
		thisForm.deftablespace.focus();
		sub = false;
	}
	else if(!checkspecial(thisForm.deftablespace,"`~!@%^&*()-+={}[]|\\:;\"\'<>,.?\/"))
	{
		thisForm.deftablespace.focus();
		sub = false;
	}
	else if(!checkblank(thisForm.temptablespace))
	{
		alert('<egui:intnl text= "admin.db.Please enter the temp tablespace"/>');
		thisForm.temptablespace.focus();
		sub = false;
	}
	else if(!checkspace(thisForm.temptablespace))
	{
		thisForm.temptablespace.focus();
		sub = false;
	}
	else if(start_chars.indexOf(tempval.charAt(0)) > -1)
	{
		alert('<egui:intnl text= "admin.db.Temp tablespace should begin with an alphabet"/>');
		thisForm.temptablespace.focus();
		sub = false;
	}
	else if(!checkspecial(thisForm.temptablespace,"`~!@%^&*()-+={}[]|\\:;\"\'<>,.?\/"))
	{
		thisForm.temptablespace.focus();
		sub = false;
	}
	else if(version == "Oracle7.x")
	{
		if(thisForm.syspwd.value == "")
		{
			alert('<egui:intnl text="admin.user.Please enter the password"/>');
			thisForm.syspwd.focus();
			sub = false;
		}
		else if(!checkspecialnomess(thisForm.syspwd,"\"|"))
		{
			alert(_notAllowCharInPwd);
			thisForm.syspwd.focus();
			sub = false;
		}
		else
		{
			sub = true;
		}
	}
	else
	{
		sub = true;
	}

	if(sub)
	{
		if (isNetscape()) targetObj = thisForm.update;
		if (isIE()) targetObj = thisForm.update;
			targetObj.diasbled = true;

		alert('<egui:intnl text= "admin.db.This operation might take sometime"/>'+", "+'<egui:intnl text= "admin.db.please wait"/>'+"...");
		thisForm.submit();
	}
}

function isNetscape()
{
	// get browser info.
	appName= navigator.appName;
	appLongVer = navigator.appVersion;
	appVer = appLongVer.substring(0, 1);

	// check for Navigator ver 4+.
	if ((appName == "Netscape") && (appVer >= 4)) return true;
	return false;
}

function isIE()
{
	// get browser info.
	appName= navigator.appName;
	appLongVer = navigator.appVersion;
	appVer = appLongVer.substring(0, 1);

	// check for IE ver 4+.
	if ((appName == "Microsoft Internet Explorer") && (appVer >= 4)) return true;
	return false;
}

function clearform()
{
	var thisForm = document.adduser;

	thisForm.dbauser.value = "";
	thisForm.dbapwd.value = "";
	thisForm.dbuser.value = "";
	thisForm.dbuserpwd.value = "";
	thisForm.deftablespace.value = "";
	thisForm.temptablespace.value = "";

	var flag = thisForm.pwd_flag.value;
	if(flag == "true")
	{
		thisForm.syspwd.value = "";
		thisForm.syspwd.focus();
	}
	else
	{
		thisForm.dbauser.focus();
	}
}

function listselect()
{
	var thisForm = document.adduser;
	var version = thisForm.version.options[thisForm.version.selectedIndex].value;
	if(version == "-1")
	{
		version = "null";
	}

	var query = thisForm.querystring.value;
	query = query.substring(0,query.indexOf("&version="))
	var str = "EgDbUserCreation.jsp?" + query + "&version=" + version;
	window.location.href = str;
}

</script>
</head>

<%
	String requestFrom = request.getParameter("requestFrom");
	String componentType = request.getParameter("comptype");
	String componentName = request.getParameter("c_name");
	String testName = request.getParameter("t_name");
	String testType = request.getParameter("testType");
	String compname = "";
	compname = request.getParameter("compname");
	if(compname != null && compname.length() > 0)
	{
		StringTokenizer strToekn = new StringTokenizer(compname,":");
		Vector sess_vec = new Vector();
		String hostIP = strToekn.nextToken();
		int portNo = Integer.parseInt(strToekn.nextToken());
		PortDiscovery pd = new PortDiscovery();
		pd.setSocketTimeout(2000);
		if(!pd.doesSocketExist(hostIP,portNo))
		{
			boolean isAggregateLink = false;
			boolean siteTick = false;
			boolean allExternalTests = true;
			if(EgInstallInfo.isAggregationSupported())
			{
				EgAggregateInfo egAggInfo = new EgAggregateInfo("manager");
				if(egAggInfo.getAggregateTypes().contains(componentType))
				{
					isAggregateLink = true;
				}
			}

			IniFile aggIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_aggregate.ini");
			String siteValue = aggIni.getValue("SITE_SUPPORT",componentType + ":" + componentName);
			if(siteValue.equals("yes"))
			{
				siteTick = true;
			}

			EgSpecsInfo egSpecsInfo = new EgSpecsInfo("manager");
			String[] testsForServer = egSpecsInfo.getTestsForServer(componentType);
			if (testsForServer != null)
			{
				for (int a=0; a<testsForServer.length; a++)
				{
					if (!egSpecsInfo.isTestExternal(testsForServer[a]))
					{
						allExternalTests = false;
						break;
					}
				}
			}

			String tempComp = null;
			if (componentType.equalsIgnoreCase("Oracle_server"))
			{
				tempComp = componentName.substring(0,componentName.lastIndexOf(":"));
			}
			else
			{
				tempComp = componentName;
			}

			sess_vec.removeAllElements();
			sess_vec.addElement(_mapping.getTextDescription("admin.error.Configure Oracle Database"));
			sess_vec.addElement("EgNewServer.jsp?for=testConfiguration&serverType="+EgURLEncoder.encode(componentType,"UTF-8")+"&componentName="+componentName+"&testType="+testType+"&testName="+testName+"&server="+EgURLEncoder.encode(tempComp,"UTF-8")+"&isAggregateLink="+isAggregateLink+"&modifyserver=true&siteSupport="+siteTick+"&allExternalTests="+allExternalTests);
			sess_vec.addElement(_mapping.getTextDescription("admin.error.Connection Error"));
			sess_vec.addElement(_mapping.getTextDescription("admin.error.Connection could not be established to the specific database server")+". ");
			sess_vec.addElement(_mapping.getTextDescription("admin.error.Please ensure that the database server is accessible from the eG manager")+".");
			session.putValue("vec_Errors",sess_vec);
%>
	<jsp:forward page="EgErrors.jsp" />
<%
		}
	}
%>

<%!
	String host = "";
	String port = "";
	String sid = "";
	String version = "";
	String strSelect1 = "";
	String strSelect2 = "";
	//String strSelect3 = "";
	//String strSelect4 = "";
	//String strSelect5 = "";
	String pwd_flag = "false";
%>

<%
	String str_querystring=request.getQueryString();
	StringTokenizer st = new StringTokenizer(compname, ":");
	while(st.hasMoreTokens())
	{
		host = st.nextToken();
		port = st.nextToken();
		sid = st.nextToken();
	}
%>

<body style="overflow:auto" id="space6">
<table border="0" align="center" cellspacing="0" cellpadding="0" width="100%">
	<jsp:include page="listSearch.jsp?title=ADD - NEW USER&leftString=Add User&backButton=true&subtitle=false"/>

	<tr>
		<td width="100%" id="eg_whitebg" align="center" height="100%" valign="top">
			<br>
			<form name="adduser" method="get" action="Egdbusercreationp.jsp" style="margin:0px">
			<table align="center" cellspacing="0" cellpadding="0" width="80%" border="0" id="eg_subcontentbg">
				<tr>
					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" width="100%" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
					<td id="form_border">&nbsp;</td>
					<td width="250" id="form_border" class="eg_subcontent" height="21">&nbsp;&nbsp;<egui:intnl text="admin.db.HOST NAME"/></td>
					<td id="form_border" class="eg_subcontent" width="20" align="center" nowrap>:</td>
					<td height="21" id="form_border" class="eg_subcontent"> 
						<input type="text" style="width: 350px; font-size: 12px; " name="hostname" maxlength="32" class="list" readonly onFocus=blur(); value=<%=host%> >
					</td>
					<td id="form_border">&nbsp;</td>
				</tr>
				<tr>
					<td id="form_border">&nbsp;</td>
					<td width="250"id="form_border" class="eg_subcontent" height="22"> &nbsp; <egui:intnl text="admin.db.PORT"/></td>
					<td id="form_border" class="eg_subcontent" width="20" align="center" nowrap>:</td>
					<td height="22"id="form_border" class="eg_subcontent"> 
					<input type="text" style="width: 350px; font-size: 12px; " name="port" maxlength="32" class="list" readonly onFocus=blur(); value=<%=port%>>
					</td>
					<td id="form_border">&nbsp;</td>
				</tr>
				<tr>
					<td id="form_border">&nbsp;</td>
					<td width="250" id="form_border" class="eg_subcontent" height="24">&nbsp;&nbsp;<egui:intnl text="admin.db.SID"/></td>
					<td id="form_border" class="eg_subcontent" width="20" align="center" nowrap>:</td>
					<td height="24" id="form_border" class="eg_subcontent">
					<input type="text" style="width: 350px; font-size: 12px; " name="sid" maxlength="32" class="list" readonly onFocus=blur(); value=<%=sid%>>
					</td>
					<td id="form_border">&nbsp;</td>
				</tr>
				<tr>
					<td id="form_border">&nbsp;</td>
					<td width="250" id="form_border" class="eg_subcontent" height="22">&nbsp;&nbsp;<egui:intnl text="admin.db.DB VERSION"/></td>
					<td id="form_border" class="eg_subcontent" width="20" align="center" nowrap>:</td>
					<td height="22" id="form_border" class="eg_subcontent">
					<select name="version" style="width: 150px; font-size: 12px; " onChange="listselect()">
<%
	version = request.getParameter("version");
	if(version != null)
	{
		if(version.equals("Oracle7.x"))
		{
			strSelect1 = "selected";
			pwd_flag = "true";
		}
		else if(version.equals("Above"))
		{
			strSelect2 = "selected";
		}
		/*else if(version.equals("Oracle9.x"))
		{
			strSelect3 = "selected";
		}
		else if(version.equals("Oracle10.x"))
		{
			strSelect4 = "selected";
		}
		else if(version.equals("Oracle11.x"))
		{
			strSelect5 = "selected";
		}*/
	}
%>
					<option value="-1">...<egui:intnl text="admin.db.Choose One"/>...</option>
					<option value="Oracle7.x" <%=strSelect1%>>Oracle 7.x</option>
					<option value="Above" <%=strSelect2%>>Oracle 8.x & above</option>
					<!-- <option value="Oracle9.x" <//%=strSelect3%>>Oracle 9.x</option>
					<option value="Oracle10.x" <//%=strSelect4%>>Oracle 10.x</option>
					<option value="Oracle11.x" <//%=strSelect5%>>Oracle 11.x</option> -->
					</select>
<%
	strSelect1 = "";
	strSelect2 = "";
	//strSelect3 = "";
	//strSelect4 = "";
	//strSelect5 = "";
%>
					</td>
					<td id="form_border">&nbsp;</td>
				</tr>
<%
	if(version != null && version.equals("Oracle7.x"))
	{
%>
				<tr>
					<td id="form_border">&nbsp;</td>
					<td width="250" id="form_border" class="eg_subcontent" height="22">&nbsp;&nbsp;<egui:intnl text="admin.db.SYS PASSWORD"/></td>
					<td id="form_border" class="eg_subcontent" width="20" align="center" nowrap>:</td>
					<td height="22"id="form_border" class="eg_subcontent">
					<input type="password" style="width: 350px; font-size: 12px; " name="syspwd" maxlength="32" class="list"><font color='#000000'>&nbsp;*</font>
					</td>
					<td id="form_border">&nbsp;</td>
				</tr>
<%
	}
%>
				<tr>
					<td id="form_border">&nbsp;</td>
					<td width="250" id="form_border" class="eg_subcontent" height="22">&nbsp;&nbsp;<egui:intnl text="admin.db.DB ADMIN"/></td>
					<td id="form_border" class="eg_subcontent" width="20" align="center" nowrap>:</td>
					<td height="22"  id="form_border" class="eg_subcontent">
					<input type="text" style="width: 350px; font-size: 12px; " name="dbauser" maxlength="32" class="list">
					</td>
					<td id="form_border">&nbsp;</td>
				</tr>
				<tr>
					<td id="form_border">&nbsp;</td>
					<td width="250" id="form_border" class="eg_subcontent" height="24">&nbsp;&nbsp;<egui:intnl text="admin.db.DB ADMIN PASSWORD"/></td>
					<td id="form_border" class="eg_subcontent" width="20" align="center" nowrap>:</td>
					<td height="24" id="form_border" class="eg_subcontent">
					<input type="password" style="width: 350px; font-size: 12px; " name="dbapwd" maxlength="32" class="list">
					</td>
					<td id="form_border">&nbsp;</td>
				</tr>
				<tr>
					<td id="form_border">&nbsp;</td>
					<td width="250" id="form_border" class="eg_subcontent" height="22">&nbsp;&nbsp;<egui:intnl text="admin.db.DB USER"/></td>
					<td id="form_border" class="eg_subcontent" width="20" align="center" nowrap>:</td>
					<td height="22" id="form_border" class="eg_subcontent">
					<input type="text" style="width: 350px; font-size: 12px; " name="dbuser" maxlength="32" class="list">
					</td>
					<td id="form_border">&nbsp;</td>
				</tr>
				<tr>
					<td id="form_border">&nbsp;</td>
					<td width="250" id="form_border" class="eg_subcontent" height="24">&nbsp;&nbsp;<egui:intnl text="admin.db.DB USER PASSWORD"/></td>
					<td id="form_border" class="eg_subcontent" width="20" align="center" nowrap>:</td>
					<td height="24"id="form_border" class="eg_subcontent">
					<input type="password" style="width: 350px; font-size: 12px; " name="dbuserpwd" maxlength="32" class="list">
					</td>
					<td id="form_border">&nbsp;</td>
				</tr>
				<tr>
					<td id="form_border">&nbsp;</td>
					<td width="250" id="form_border" class="eg_subcontent" height="22">&nbsp;&nbsp;<egui:intnl text="admin.db.DEFAULT TABLESPACE"/></td>
					<td id="form_border" class="eg_subcontent" width="20" align="center" nowrap>:</td>
					<td height="22" id="form_border" class="eg_subcontent">
					<input type="text" style="width: 350px; font-size: 12px; " name="deftablespace" maxlength="32" class="list">
					</td>
					<td id="form_border">&nbsp;</td>
				</tr>
				<tr>
					<td id="form_spacing">&nbsp;</td>
					<td width="250" id="form_spacing" class="eg_subcontent" height="22">&nbsp;&nbsp;<egui:intnl text="admin.db.TEMP TABLESPACE"/></td>
					<td id="form_spacing" class="eg_subcontent" width="20" align="center" nowrap>:</td>
					<td height="22" id="form_spacing" class="eg_subcontent">
					<input type="text" style="width: 350px; font-size: 12px; " name="temptablespace" maxlength="32" class="list">
					</td>
					<td id="form_spacing">&nbsp;</td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg"  width="100%"  valign="top"  colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
				<tr>
					<td colspan="5" id="eg_blankspace" height="10" nowrap class="eg_whitebg">&nbsp;</td>
				</tr>
				<tr> 
					<td width="100%" colspan="5" align="center" class="eg_whitebg"> 
					<input type="button" name="update" value='<egui:intnl text="admin.db.Add"/>' style="width: 80px;" class="eg_back" onClick="javascript:valform()" >
					&nbsp;&nbsp;&nbsp;&nbsp;
					<input type="button" name="update"  value='<egui:intnl text="admin.db.Clear"/>' style="width: 80px;" class="eg_back" onClick="JavaScript:clearform()" >
					</td>
				</tr>
			</table>
			<input type="hidden" name="querystring" value="<%=str_querystring%>">
			<input type="hidden" name="pwd_flag" value="<%=pwd_flag%>">
<%
	pwd_flag = "false";
%>
			</form>
		</td>
	</tr>
</table>
</body>
</html>



