<%
/*
 *   File		:	EgEnableAndDisableDD.jsp
 *   Purpose	:	To enable and disable detailed diagnosis (DD) for a test
 *   Author		:	Vaathsalya (2008)
 *   UI Design	:	Jaiwin & Krishnamurthi
*/
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import="com.eg.EgRoleInfo" %>
<%@ page import="com.eg.MappingNameSorter"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import="com.eg.EgName"%>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import="com.eg.EgMemInfo" %>
<%@ taglib prefix ="egui" uri="../WEB-INF/eg-taglib.tld"%>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<jsp:useBean id="prgBean" scope="page" class="egurkha.EgTestParamBean"/>

<%!
	String licenseCheck = new String("license");
%>

<%
	boolean ddEnabled = false;
	synchronized(licenseCheck)
	{
		ddEnabled = EgMemInfo.ddEnabled;
	}

	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (_user != null)
	{
		userLanguage = _user.getLanguage();
	}
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);

	String componentType = request.getParameter("componentType");
	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	String[] componentTypes = ri.getServerTypes();
	ArrayList serverList = null;
	if (componentTypes != null && componentTypes.length > 0)
	{
		serverList = new ArrayList(Arrays.asList(componentTypes));
		serverList.remove("Site_servers");
	}

	ArrayList aListEnabledTestForCompType = null;
	ArrayList aListDDEnabledTests = new ArrayList();
	ArrayList aListDDDisabledTests = new ArrayList();

	if (componentType != null && !componentType.equals("-1") && ddEnabled)
	{
		EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
		aListEnabledTestForCompType = egSpecs.getEnabledTests(componentType,false);

		IniFile egSpecsIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_specs.ini");
		String defaultTestMappingSection = "DEFAULT_TEST_MAPPING";
		ArrayList aListTests = new ArrayList();
		String strTests = egSpecsIni.getValue(defaultTestMappingSection,componentType);
		StringTokenizer strTokens = new StringTokenizer(strTests,",");
		while (strTokens.hasMoreTokens())
		{
			String strToken = strTokens.nextToken().trim();
			if (EgInstallInfo.isConfigTest(strToken)) continue;
			aListTests.add(strToken);
		}

		prgBean.createFile("eg_format.ini");
		String[] tests = prgBean.getVariables("FORMAT");
		for (int i=0;i<tests.length;i++)
		{
			String temp = tests[i];
			int idx = temp.indexOf(":");
			String enabledTest = temp.substring(0,idx);

			if (aListTests != null && !aListTests.contains(enabledTest))
			{
				continue;
			}

			if (aListEnabledTestForCompType != null && 
				!aListEnabledTestForCompType.contains(enabledTest))
			{
				continue;
			}

			if (!aListDDEnabledTests.contains(enabledTest))
			{
				aListDDEnabledTests.add(enabledTest);
			}
		}
		//to display the list in DD disabled list
		prgBean.createFile("eg_testinfo.ini");
		tests = prgBean.getVariables("Disable_DD");
		for (int k=0;k<tests.length;k++)
		{
			String temp = tests[k];

			if (aListTests != null && !aListTests.contains(temp))
			{
				continue;
			}

			if (!aListDDDisabledTests.contains(temp))
			{
				aListDDDisabledTests.add(temp);
			}
		}

		if (!aListDDDisabledTests.isEmpty())
		{
			aListDDEnabledTests.removeAll(aListDDDisabledTests);
		}
	}
%>


<html>
<head>
<egui:skin ui="admin"/>
<SCRIPT LANGUAGE="JavaScript">
//move to processing page
function updateData()
{
	var thisForm = document.DisableDD;
	var prevEnabledDDTests = "<%=aListDDEnabledTests%>";
	var prevDisabledDDTests = "<%=aListDDDisabledTests%>";
	var componentType = thisForm.componentType.value;
	var enableLen = thisForm.ddEnabled.options.length;
	var disableLen = thisForm.ddDisabled.options.length;
	var enableList = thisForm.ddEnabled;
	var disableList = thisForm.ddDisabled;
	var enableTest_arr = new Array();
	var disableTest_arr = new Array();

	if (componentType == "-1")
	{
		alert('<egui:intnl text="admin.test.Please choose a component type"/>');
		return;
	}
	
	for (var i=0;i<enableLen;i++)
	{
		enableTest_arr[i] = enableList.options[i].value;
	}

	for (var k=0;k<disableLen;k++)
	{
		disableTest_arr[k] = disableList.options[k].value;
	}

	thisForm.DDenabledTestList.value = enableTest_arr;
	thisForm.DDdisabledTestList.value = disableTest_arr;
	thisForm.prevEnabledDDTests.value = prevEnabledDDTests;
	thisForm.prevDisabledDDTests.value = prevDisabledDDTests;
	thisForm.submit();

}

//add to disable and delete from enabledlist
function addToDisabled()
{
	var thisForm = document.DisableDD;
	var enableLen = thisForm.ddEnabled.options.length;
	var disableLen = thisForm.ddDisabled.options.length;
	var enableList = thisForm.ddEnabled;
	var disableList = thisForm.ddDisabled;
	for (var i=0; i<enableLen; i++)
	{
		if (enableList.options[i].selected == true)
		{
			var testTxt =  enableList.options[i].text;
			var testVal =  enableList.options[i].value;
			disableList.options[disableLen++] = new Option(testTxt,testVal);
		}
	}

	for (var i = enableLen; i>0; i--)
	{
		if(enableList.options[i-1].selected == true)
		{
			enableList.options[i-1] = null;
		}
	}
}

//add to enable and delete from disabledlist
function addToEnabled()
{
	var thisForm = document.DisableDD;
	var enableLen = thisForm.ddEnabled.options.length;
	var disableLen = thisForm.ddDisabled.options.length;
	var enableList = thisForm.ddEnabled;
	var disableList = thisForm.ddDisabled;
	
	for (var i=0; i<disableLen; i++)
	{
		if (disableList.options[i].selected == true)
		{
			var testTxt =  disableList.options[i].text;
			var testVal =  disableList.options[i].value;
			enableList.options[enableLen++] = new Option(testTxt,testVal);
		}
	}

	for (var i = disableLen; i>0; i--)
	{
		if (disableList.options[i-1].selected == true)
		{
			disableList.options[i-1] = null;
		}
	}
}

function showTests()
{
	var thisForm = document.DisableDD;
	thisForm.method = "post";
	thisForm.action = "EgEnableAndDisableDD.jsp";
	thisForm.submit();
}
</SCRIPT>
</head>
<body style="overflow:auto" id="space6">
<%
	if (ddEnabled)
	{
%>
<form name="DisableDD" method="post" action="EgEnableAndDisableDDp.jsp" style="margin:0px">
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
	<jsp:include page="listSearch.jsp?title=ENABLE / DISABLE DETAILED DIAGNOSIS (DD)&subtitle=false"/>
	<tr>
		<td width="100%" id="eg_whitebg" align="center" valign="middle">
			<table align="center" cellspacing="0" cellpadding="0" border="0" width="85%" class="eg_subcontentbg">
				<tr>
					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" width="100%" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
					<td width="7" align="left" class="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td align="center" class="form_border" nowrap colspan="3">
						<table align="center" cellspacing="0" cellpadding="0" border="0">
							<tr>
								<td width="35%" align="right" nowrap><egui:intnl text="admin.server.Component type"/></td>
								<td>&nbsp;&nbsp;:&nbsp;&nbsp;</td>
								<td id="eg_subcontentbg" align="left" class="paddingright"><select name="componentType" onchange="javascript:showTests()">
<%
		if (componentTypes != null && componentTypes.length > 0)
		{
%>
			<option value="-1"><egui:intnl text="admin.common.Choose one" /></option>
<%
			serverList = sorter.getSortedCompTypeList(serverList);
			//get the actual and display names of component types
			for (int j=0;j<serverList.size();j++)
			{
				EgName nameObj = (EgName)serverList.get(j);
				String tmpVal = nameObj.getActualName();
				if (tmpVal.startsWith("Agg_"))
				{
					continue;
				}
				String tmpDis = nameObj.getLocalName();
				if(tmpVal.equals(componentType))
				{
%>
					<option value="<%=tmpVal%>" selected><%=tmpDis%></option>
<%
				}
				else
				{
%>
					<option value="<%=tmpVal%>"><%=tmpDis%></option>
<%
				}
			}
		}
		else
		{
%>
			<option value="-1"><egui:intnl text="admin.common.Not Applicable"/></option>
<%
		}
%>
								</select>
								</td>
							</tr>
						</table>
					</td>
					<td width="7" class="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
					<td colspan="5" id="eg_subcontentbg" class="padding4"><br>
						<table align="center" cellspacing="0" cellpadding="0" border="0">
							<tr>
								<td width="45%">
									<table align="center" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subheadbg" align='center' valign='middle' class="head_padding4"><strong><egui:intnl text="admin.test.DD ENABLED TESTS"/></strong></td>
										</tr>
										<tr>
											<td align="center" valign="middle">
												<select name="ddEnabled" size="22" multiple width="320" style="width:320px;margin:0px;">
<%
		aListDDEnabledTests = sorter.getSortedTestList(aListDDEnabledTests);
		for (int i=0;i<aListDDEnabledTests.size();i++)
		{
			EgName name = (EgName)aListDDEnabledTests.get(i);
			String enableValue = name.getActualName();
			String enableDisplay = name.getLocalName();
%>
			<option value="<%=enableValue%>"><%=enableDisplay%></option>
<%
		}
%>
												</select>
											</td>
										</tr>
										<tr>
											<td>&nbsp;</td>
										</tr>
									</table>
								</td>
								<td id="tablebg2"  nowrap>&nbsp;&nbsp;&nbsp;</td>
								<td width="10%" align="center" valign="middle" id="head_padding2">
									<input type="button" value='&rsaquo;&rsaquo;' class="eg_lightbutton" name="unman" style="width: 85px; letter-spacing: 0px; font-size:13px; height:20px" onclick="javascript:addToDisabled()">
									<br><br><br>
									<input type="button" value='&lsaquo;&lsaquo;' class="eg_lightbutton" name="man" style="width: 85px; letter-spacing: 0px; font-size:13px; height:20px" onclick="javascript:addToEnabled()">
								</td>
								<td id="tablebg2"  nowrap>&nbsp;&nbsp;&nbsp;</td>
								<td width="45%">
									<table align="center" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subheadbg" align='center' valign='middle' class="head_padding4" style="border-left-width:1px"><strong><egui:intnl text="admin.test.DD DISABLED TESTS"/></strong></td>
										</tr>
										<tr>
											<td align="center" valign="middle">
												<select name="ddDisabled" size="22" multiple width="320" style="width:320px;margin:0px;">
<%
		aListDDDisabledTests = sorter.getSortedTestList(aListDDDisabledTests);
		for (int j=0;j<aListDDDisabledTests.size();j++)
		{
			EgName name = (EgName)aListDDDisabledTests.get(j);
			String disableValue = name.getActualName();
			String disableDisplay = name.getLocalName();
%>
			<option value="<%=disableValue%>"><%=disableDisplay%></option>
<%
		}
%>
												</select>
											</td>
										</tr>
										<tr>
											<td>&nbsp;</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg" width="100%" colspan="3" valign="top"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
			</table>
		</td>
	</tr>
	<tr>
		<td align="center" height="40" valign="middle"><input type="button" name="update" value='<egui:intnl text="admin.common.Update"/>' class="eg_back" style="width: 90px;" onClick="javascript:updateData()"></td>
	</tr>
</table>
<input type="hidden" name="DDenabledTestList" value="">
<input type="hidden" name="DDdisabledTestList" value="">
<input type="hidden" name="prevEnabledDDTests" value="">
<input type="hidden" name="prevDisabledDDTests" value="">
</form>
<%
		session.setAttribute("adminLastAccessedURL","/final/admin/EgEnableAndDisableDD.jsp?componentType="+componentType);
	}
	else
	{
		Vector errors = new Vector();
		errors.addElement(_mapping.getTextDescription("admin.error.Admin Home"));
		errors.addElement("EgAdminOperations.jsp");
		errors.addElement(_mapping.getTextDescription("admin.error.Possible Reason"));
		errors.addElement(_mapping.getTextDescription("admin.error.Your license does not allow you to use this feature")+".");
		errors.addElement(_mapping.getTextDescription("admin.error.Please contact") + " <a href='mailTo:license@eginnovations.com' target='_parent' class='dash_link'><b>license@eginnovations.com</b></a> " + _mapping.getTextDescription("admin.error.for more details")+".");
		session.putValue("vec_Errors", errors);
%>
		<jsp:forward page="EgErrors.jsp" />
<%
	}
%>
</body>
</html>



