<%
/*
 *   File		:	EgExcludeComponents.jsp
 *   Purpose	:	Provides a mechanism to exclude components for a test
 *   Author		:	S.Anand (2009)
 *   UI Design	:	Jaiwin & Krishnamurthi
*/
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp" %>
<%@ page import="java.util.*" %>
<%@ page import="com.eg.EgRoleInfo" %>
<%@ page import="com.eg.EgExternalInfo" %>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import="com.eg.IniFile" %>
<%@ page import="com.eg.EgURLEncoder"%>

<%@ taglib prefix ="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%!
	EgExternalInfo egExternalInfo = new EgExternalInfo("manager");
	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");

	//provide a set of agents(internal or remote agent,external agent(s)) for a component
	private List getAgents(String componentName)
	{
		List agentsList = new ArrayList();

		Hashtable internalAgentMap = egExternalInfo.getInternalAgentMap();
		String componentNickName = componentName.substring(0,componentName.indexOf(":"));
		String agentNickName = "";
		boolean isRemote = false;

		//To fetch the exact agent for the selected component - start
		isRemote = egExternalInfo.isRemoteBased(componentNickName);
		if (isRemote)
		{
			//Agentless
			agentNickName = egExternalInfo.getRemoteAgentForHost(componentNickName);
		}
		else
		{
			//Auto or Manual
			String agentName = egExternalInfo.getAgentFor(componentNickName);
			if (agentName != null) //Manual
			{
				if (internalAgentMap != null && internalAgentMap.containsKey(agentName))
				{
					agentNickName = (String)internalAgentMap.get(agentName);
				}
				else
				{
					agentNickName = agentName;
				}
			}
			else //Auto
			{
				agentNickName = componentNickName;
			}
		}

		//adding an internal agent (or) a remote agent
		agentsList.add(agentNickName);
		//To fetch the exact agent for the selected component - end

		//To fetch the external agent for the selected component type - starts
		boolean hasExternalAgent = egExternalInfo.hasExternalAgent(componentNickName);
		if (hasExternalAgent)
		{
			String extAgents[] = egExternalInfo.getExternalAgentsForHost(componentNickName);
			//adding one or more external agent(s)
			agentsList.addAll(Arrays.asList(extAgents));
		}
		//To fetch the external agent for the selected component type - ends

		return agentsList;
	}

	//Will provide the right agent (subject) for a component and its test
	private String getAgentNickName(String componentType,String componentName,String testName)
	{
		boolean isExternalTest = egSpecs.isExternalTest(testName,componentType);
		List aListTempAgentsForComponent = getAgents(componentName);
		String agentName = null;
		if (isExternalTest)
		{
			//external agent for external test
			agentName = (String)aListTempAgentsForComponent.get(1);
		}
		else
		{
			//internal agent or remote agent for host level test and application level test.
			agentName = (String)aListTempAgentsForComponent.get(0);
		}

		return agentName;
	}

	//Will provide the right pattern (variable) for a component
	private String getResultantPattern(String componentType,String componentName,String testName,String[] testVariables)
	{
		String tempResultantPattern = null;
		String componentNickName = componentName.substring(0,componentName.indexOf(":"));

		String specificPattern_A = testName + ":" + componentType + ":" + componentName;
		String specificPattern_B = testName + ":" + componentType + ":" + componentNickName;
		String defaultPattern_A = testName + "::" + componentName;
		String defaultPattern_B = testName + "::" + componentNickName;

		List listTestVariables = Arrays.asList(testVariables);
		if(listTestVariables.contains(specificPattern_A))
		{
			tempResultantPattern = specificPattern_A;
		}
		else if(listTestVariables.contains(specificPattern_B))
		{
			tempResultantPattern = specificPattern_B;
		}
		else if(listTestVariables.contains(defaultPattern_A))
		{
			tempResultantPattern = defaultPattern_A;
		}
		else if(listTestVariables.contains(defaultPattern_B))
		{
			tempResultantPattern = defaultPattern_B;
		}

		return tempResultantPattern;
	}

	public boolean hasUnConfiguredParam(String paramValue)
	{
		boolean hasUnconfiguredParam = false;
		StringTokenizer st = new StringTokenizer(paramValue,",");
		st.nextToken();
		StringTokenizer st1 = new StringTokenizer(st.nextToken());
		ArrayList aListParamNameValue = new ArrayList();

		StringBuffer eachStr = null;
		while(st1.hasMoreTokens())
		{
			String token = st1.nextToken();
			token = token.trim();
			if (token.startsWith("-"))
			{
				if (eachStr!=null && eachStr.toString().length()>0)
				{
					aListParamNameValue.add((eachStr.toString()).substring(0,(eachStr.toString()).length()-1));
				}
				aListParamNameValue.add(token.toLowerCase());
				eachStr = new StringBuffer();
			}
			else
			{
				eachStr.append(token + " ");
			}
		}
		aListParamNameValue.add((eachStr.toString()).trim());

		String snmpVersion = null;
		boolean isSnmp = aListParamNameValue.contains("-snmpversion");

		if (isSnmp)
		{
			//put snmp version before snmp community.
			int snmpCommunityIdx = aListParamNameValue.indexOf("-snmpcommunity");
			String snmpCommunityVal = (String)aListParamNameValue.get(snmpCommunityIdx+1);
			aListParamNameValue.remove(snmpCommunityIdx);
			aListParamNameValue.remove(snmpCommunityIdx);

			int snmpVerIdx = aListParamNameValue.indexOf("-snmpversion");
			snmpVersion = (String)aListParamNameValue.get(snmpVerIdx+1);

			aListParamNameValue.add(snmpVerIdx+2,"-snmpcommunity");
			aListParamNameValue.add(snmpVerIdx+3,snmpCommunityVal);
		}

		for (int i=0;i<aListParamNameValue.size();i=i+2)
		{
			String strParamName = (String)aListParamNameValue.get(i);
			String strParamValue = (String)aListParamNameValue.get(i+1);

			if (strParamName.equalsIgnoreCase("-password") || 
				strParamName.equalsIgnoreCase("-proxypassword") || 
				strParamName.equalsIgnoreCase("-authpass") || 
				strParamName.equalsIgnoreCase("-encryptpassword") || 
				strParamName.equalsIgnoreCase("-admin_password") || 
				strParamName.equalsIgnoreCase("-vc_password") || 
				strParamName.equalsIgnoreCase("-esx_password") || 
				strParamName.equalsIgnoreCase("-sendpassword") || 
				strParamName.equalsIgnoreCase("-receivepassword") || 
				strParamName.equalsIgnoreCase("-xen_password") || 
				strParamName.equalsIgnoreCase("-From_User_Password"))
			{
				continue;
			}

			if (isSnmp && snmpVersion != null)
			{
				if (snmpVersion.equalsIgnoreCase("v3"))
				{
					if (strParamName.equalsIgnoreCase("-snmpcommunity"))
					{
						continue;
					}
				}
			}

			strParamValue = strParamValue.trim();
			if (strParamValue.startsWith("$"))
			{
				hasUnconfiguredParam = true;
				break;
			}
		}

		return hasUnconfiguredParam;
	}
%>

<%
	String enableConfTestSize = request.getParameter("enableConfTestSize");
	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));

	String componentType = request.getParameter("componentType");
	String componentName = request.getParameter("componentName");
	String testForExclusion = request.getParameter("TestsForExclusion");

	String testType = request.getParameter("testType");
	testType = testType != null?testType:"PerformanceTest";

	String[] strComponents = ri.getAllServersOfType(componentType);
	List listComponents = Arrays.asList(strComponents);
	String currentComponentPattern = componentType + ":" + componentName;
	String query = "";
	//Scenario : Only one component is managed.
	if (listComponents.size() == 1 && listComponents.contains(currentComponentPattern))
	{
		query = "EgExcludeComponentTests.jsp?componentType="+EgURLEncoder.encode(componentType,"UTF-8")+"&componentName="+EgURLEncoder.encode(componentName,"UTF-8")+"&TestsForExclusion="+EgURLEncoder.encode(testForExclusion,"UTF-8")+"&testType="+EgURLEncoder.encode(testType,"UTF-8");
%>
		<jsp:forward page="<%=query%>" />
<%
	}
	String excludingState = request.getParameter("excludingState");
	if (excludingState == null)
	{
		excludingState = "";
	}

	String pageRefreshed = request.getParameter("pageRefreshed");
	boolean isPageRefreshed = false;
	if (pageRefreshed == null)
	{
		pageRefreshed = "false";
	}
	else
	{
		pageRefreshed = "true";
		isPageRefreshed = true;
	}

	ArrayList aListTests = new ArrayList();
	StringTokenizer st = new StringTokenizer(testForExclusion,",");
	while (st.hasMoreTokens())
	{
		String temp = st.nextToken();
		aListTests.add(temp);
	}

	ArrayList aListChoosenManagedComps = new ArrayList();
	boolean hasManagedComp = false;
	String managed = null;
	String unmanaged = null;
	if (pageRefreshed != null && pageRefreshed.equals("true"))
	{
		componentName = request.getParameter("mainComponentName");

		managed = request.getParameter("strManage");
		unmanaged = request.getParameter("strunManage");

		if (managed != null && managed.length() > 0)
		{
			hasManagedComp = true;
			StringTokenizer stComponents = new StringTokenizer(managed,",");
			while (stComponents.hasMoreTokens())
			{
				String eachComponent = stComponents.nextToken();
				if (!aListChoosenManagedComps.contains(eachComponent))
				{
					aListChoosenManagedComps.add(eachComponent);
				}
			}
		}
	}
	else
	{
		hasManagedComp = true;
		for (int i=0;i<aListTests.size();i++)
		{
			String strTest = (String)aListTests.get(i);
			aListChoosenManagedComps.add(componentName);
		}
	}

	IniFile agentIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_agents.ini");
	ArrayList aListTempComponents = new ArrayList(listComponents);

	TreeMap tmapIncludedComps = null;
	TreeMap tmapCompsToBeExcluded = null;
	if (isPageRefreshed)
	{
		if (managed != null && managed.length() > 0)
		{
			tmapCompsToBeExcluded = new TreeMap();
			StringTokenizer st1 = new StringTokenizer(managed,",");
			while (st1.hasMoreTokens())
			{
				String str = st1.nextToken();
				int hashIdx = str.indexOf("#");
				String strComponent = str.substring(0,hashIdx);
				String strTest = str.substring(hashIdx+1);
				boolean isCompUnconfigured=false;
				if (strTest.indexOf("$") > -1)
				{
					strTest = strTest.substring(0,strTest.indexOf("$"));
					isCompUnconfigured = true;
				}
				ArrayList aListResultant = (ArrayList)tmapCompsToBeExcluded.get(strTest);
				if (aListResultant == null)
				{
					ArrayList aListUnConfiguredComps = null;
					ArrayList aListConfiguredComps = null;

					if (isCompUnconfigured)
					{
						aListUnConfiguredComps = new ArrayList();
						aListUnConfiguredComps.add(strComponent);
					}
					else
					{
						aListConfiguredComps = new ArrayList();
						aListConfiguredComps.add(strComponent);
					}

					aListResultant = new ArrayList();
					aListResultant.add(aListUnConfiguredComps);
					aListResultant.add(aListConfiguredComps);

					tmapCompsToBeExcluded.put(strTest,aListResultant);
				}
				else
				{
					if (isCompUnconfigured)
					{
						ArrayList aListUnConfiguredComps = (ArrayList)aListResultant.get(0);
						if (aListUnConfiguredComps == null)
						{
							aListResultant.remove(0);//remove the null reference
							aListUnConfiguredComps = new ArrayList();
							aListResultant.add(0,aListUnConfiguredComps);
						}
						aListUnConfiguredComps.add(strComponent);
					}
					else
					{
						ArrayList aListConfiguredComps = (ArrayList)aListResultant.get(1);
						if (aListConfiguredComps == null)
						{
							aListResultant.remove(1);//remove the null reference
							aListConfiguredComps = new ArrayList();
							aListResultant.add(1,aListConfiguredComps);
						}
						aListConfiguredComps.add(strComponent);
					}
				}
			}
		}

		if (unmanaged != null && unmanaged.length() > 0)
		{
			tmapIncludedComps = new TreeMap();
			StringTokenizer st2 = new StringTokenizer(unmanaged,",");
			while (st2.hasMoreTokens())
			{
				String str = st2.nextToken();
				int hashIdx = str.indexOf("#");
				String strComponent = str.substring(0,hashIdx);
				String strTest = str.substring(hashIdx+1);
				boolean isCompUnconfigured=false;
				if (strTest.indexOf("$") > -1)
				{
					strTest = strTest.substring(0,strTest.indexOf("$"));
					isCompUnconfigured = true;
				}
				ArrayList aListResultant = (ArrayList)tmapIncludedComps.get(strTest);
				if (aListResultant == null)
				{
					ArrayList aListUnConfiguredComps = null;
					ArrayList aListConfiguredComps = null;

					if (isCompUnconfigured)
					{
						aListUnConfiguredComps = new ArrayList();
						aListUnConfiguredComps.add(strComponent);
					}
					else
					{
						aListConfiguredComps = new ArrayList();
						aListConfiguredComps.add(strComponent);
					}

					aListResultant = new ArrayList();
					aListResultant.add(aListUnConfiguredComps);
					aListResultant.add(aListConfiguredComps);

					tmapIncludedComps.put(strTest,aListResultant);
				}
				else
				{
					if (isCompUnconfigured)
					{
						ArrayList aListUnConfiguredComps = (ArrayList)aListResultant.get(0);
						if (aListUnConfiguredComps == null)
						{
							aListResultant.remove(0);//remove the null reference
							aListUnConfiguredComps = new ArrayList();
							aListResultant.add(0,aListUnConfiguredComps);
						}
						aListUnConfiguredComps.add(strComponent);
					}
					else
					{
						ArrayList aListConfiguredComps = (ArrayList)aListResultant.get(1);
						if (aListConfiguredComps == null)
						{
							aListResultant.remove(1);//remove the null reference
							aListConfiguredComps = new ArrayList();
							aListResultant.add(1,aListConfiguredComps);
						}
						aListConfiguredComps.add(strComponent);
					}
				}
			}
		}
	}
	else
	{
		//ensure whether there are more than one components to be excluded.if not donot show this page
		boolean hasMoreThanOneCompToExcl = false;
		int compCount=0;
		int prevCompIdx=-1;
		for (int i=0;i<aListTests.size();i++)
		{
			String strTest = (String)aListTests.get(i);

			ArrayList aListStrUnconfiguredComponents = null;
			ArrayList aListStrConfiguredComponents = null;

			for (int j=0;j<aListTempComponents.size();j++)
			{
				String strTempPattern = (String)aListTempComponents.get(j);
				String tempComponent = strTempPattern.substring(strTempPattern.indexOf(":")+1);
				String tempAgentNickName = getAgentNickName(componentType,tempComponent,strTest);
				String[] tempTestVariables = agentIni.getVariables(tempAgentNickName);
				String tempResultantPattern = getResultantPattern(componentType,tempComponent,strTest,tempTestVariables);
				if (tempResultantPattern == null) continue;
				String tempTestValue = agentIni.getValue(tempAgentNickName,tempResultantPattern);

				if (tempTestValue.indexOf("-auto") > -1 && 
					tempTestValue.indexOf(" $") > -1 && 
					hasUnConfiguredParam(tempTestValue))
				{
					if (!hasMoreThanOneCompToExcl)
					{
						if (prevCompIdx == -1)
						{
							compCount++;
						}
						else
						{
							if (j != prevCompIdx)
							{
								compCount++;
							}
						}
						prevCompIdx=j;

						if (compCount > 1)
						{
							hasMoreThanOneCompToExcl = true;
						}
					}

					if (!tempComponent.equals(componentName))
					{
						if (aListStrUnconfiguredComponents == null)
						{
							aListStrUnconfiguredComponents = new ArrayList();
						}

						aListStrUnconfiguredComponents.add(tempComponent);
					}
				}
				else if (tempTestValue.indexOf("-auto") > -1 || tempTestValue.indexOf("-manual") > -1)
				{
					if (!hasMoreThanOneCompToExcl)
					{
						if (prevCompIdx == -1)
						{
							compCount++;
						}
						else
						{
							if (j != prevCompIdx)
							{
								compCount++;
							}
						}
						prevCompIdx=j;

						if (compCount > 1)
						{
							hasMoreThanOneCompToExcl = true;
						}
					}

					if (!tempComponent.equals(componentName))
					{
						if (aListStrConfiguredComponents == null)
						{
							aListStrConfiguredComponents = new ArrayList();
						}
						aListStrConfiguredComponents.add(tempComponent);
					}
				}
			}

			if (aListStrUnconfiguredComponents != null || 
				aListStrConfiguredComponents != null)
			{
				ArrayList aListResultant = new ArrayList();
				aListResultant.add(aListStrUnconfiguredComponents);
				aListResultant.add(aListStrConfiguredComponents);
				if (tmapIncludedComps == null)
				{
					tmapIncludedComps = new TreeMap();
				}
				tmapIncludedComps.put(strTest,aListResultant);
			}
		}

		//has only one to component to exclude
		if (!hasMoreThanOneCompToExcl)
		{
			query = "EgExcludeComponentTests.jsp?componentType="+EgURLEncoder.encode(componentType,"UTF-8")+"&componentName="+EgURLEncoder.encode(componentName,"UTF-8")+"&TestsForExclusion="+EgURLEncoder.encode(testForExclusion,"UTF-8")+"&testType="+EgURLEncoder.encode(testType,"UTF-8");
%>
			<jsp:forward page="<%=query%>" />
<%
		}
	}

	if (!isPageRefreshed)
	{
		tmapCompsToBeExcluded = new TreeMap();
		for (int i=0;i<aListTests.size();i++)
		{
			String strTest = (String)aListTests.get(i);
			ArrayList aListTempUnconfiguredComponents = null;
			ArrayList aListTempconfiguredComponents = null;
			if (excludingState.equals("unconfiguredstate"))
			{
				aListTempUnconfiguredComponents = new ArrayList();
				aListTempUnconfiguredComponents.add(componentName);
			}
			else if (excludingState.equals("configuredstate"))
			{
				aListTempconfiguredComponents = new ArrayList();
				aListTempconfiguredComponents.add(componentName);
			}

			ArrayList aListTempResultant = new ArrayList();
			aListTempResultant.add(aListTempUnconfiguredComponents);
			aListTempResultant.add(aListTempconfiguredComponents);

			tmapCompsToBeExcluded.put(strTest,aListTempResultant);
		}
	}

%>

<html>
<head>
<egui:skin ui="adminindex"/>
<META HTTP-EQUIV="expires" CONTENT="0">
<META HTTP-EQUIV="expires" CONTENT="0">
<script language="JavaScript">

function unManagedComponentToManagedComponent(enableConfTestSize)
{
	//journey from unmanagedcomponent to managedcomponent
	var thisForm = document.list;
	var managedComponentLength = thisForm.managed.options.length;
	var unmanagedComponentLength = thisForm.unmanaged.options.length;
	var managedComponentList = thisForm.managed;
	var unmanagedComponentList = thisForm.unmanaged;
	if (unmanagedComponentList.selectedIndex == -1)
	{
		alert('<egui:intnl text="admin.test.Please choose a component"/>');
		return false;
	}
	else
	{
		for (var i=0; i<unmanagedComponentLength; i++)
		{
			if (unmanagedComponentList.options[i].selected == true)
			{
				var testTxt = unmanagedComponentList.options[i].text;
				var testVal = unmanagedComponentList.options[i].value;
				managedComponentList.options[managedComponentLength++] = new Option(testTxt,testVal);
			}
		}

		for (var i = unmanagedComponentLength; i>0; i--)
		{
			if(unmanagedComponentList.options[i-1].selected == true)
			{
				unmanagedComponentList.options[i-1] = null;
			}
		}
	}

	var managedComponentLen = thisForm.managed.options.length;
	var managedComponentList = thisForm.managed;

	var temp = "";
	for (var i=0; i<managedComponentLen; i++)
	{
		var testVal = managedComponentList.options[i].value;
		temp = temp + testVal + ",";
	}
	temp = temp.substring(0,temp.length-1);
	thisForm.strManage.value = temp;

	var unmanagedComponentLen = thisForm.unmanaged.options.length;
	var unmanagedComponentList = thisForm.unmanaged;

	var temp1 = "";
	for (var i=0; i<unmanagedComponentLen; i++)
	{
		var testVal = unmanagedComponentList.options[i].value;
		temp1 = temp1 + testVal + ",";
	}
	temp1 = temp1.substring(0,temp1.length-1);
	thisForm.strunManage.value = temp1;

	thisForm.method = "post";
	thisForm.action = "EgExcludeComponents.jsp?enableConfTestSize=<%=enableConfTestSize%>";
	thisForm.submit();
}

function managedComponentTounManagedComponent(enableConfTestSize)
{
	//journey from managedcomponent to unmanagedcomponent
	var thisForm = document.list;
	var managedComponentLength = thisForm.managed.options.length;
	var unmanagedComponentLength = thisForm.unmanaged.options.length;
	var managedComponentList = thisForm.managed;
	var unmanagedComponentList = thisForm.unmanaged;
	if (managedComponentList.selectedIndex == -1)
	{
		alert('<egui:intnl text="admin.test.Please choose a component"/>');
		return false;
	}
	else
	{
		for (var i=0; i<managedComponentLength; i++)
		{
			if (managedComponentList.options[i].selected == true)
			{
				var testTxt = managedComponentList.options[i].text;
				var testVal = managedComponentList.options[i].value;
				unmanagedComponentList.options[unmanagedComponentLength++] = new Option(testTxt,testVal);
			}
		}

		for (var i = managedComponentLength; i>0; i--)
		{
			if(managedComponentList.options[i-1].selected == true)
			{
				managedComponentList.options[i-1] = null;
			}
		}
	}

	var managedComponentLen = thisForm.managed.options.length;
	var managedComponentList = thisForm.managed;

	var temp = "";
	for (var i=0; i<managedComponentLen; i++)
	{
		var testVal = managedComponentList.options[i].value;
		temp = temp + testVal + ",";
	}
	temp = temp.substring(0,temp.length-1);
	thisForm.strManage.value = temp;

	var unmanagedComponentLen = thisForm.unmanaged.options.length;
	var unmanagedComponentList = thisForm.unmanaged;

	var temp1 = "";
	for (var i=0; i<unmanagedComponentLen; i++)
	{
		var testVal = unmanagedComponentList.options[i].value;
		temp1 = temp1 + testVal + ",";
	}
	temp1 = temp1.substring(0,temp1.length-1);
	thisForm.strunManage.value = temp1;

	thisForm.method = "post";
	thisForm.action = "EgExcludeComponents.jsp?enableConfTestSize=<%=enableConfTestSize%>";
	thisForm.submit();
}

function apply(enableConfTestSize)
{
	var thisForm = document.list;
	var managedComponentLen = thisForm.managed.options.length;
	var managedComponentList = thisForm.managed;
	var allowToSubmit = true;

	if (managedComponentLen==0)
	{
		alert('<egui:intnl text="admin.test.Please choose a component"/>');
		return false;
	}

	var temp = "";
	for (var i=0; i<managedComponentLen; i++)
	{
		var testVal = managedComponentList.options[i].value;
		temp = temp + testVal + ",";
	}
	temp = temp.substring(0,temp.length-1);
	thisForm.componentName.value = temp;
	thisForm.applybutton.disabled = true;
	thisForm.method = "post";
	thisForm.action = "EgExcludeComponentTests.jsp?enableConfTestSize=<%=enableConfTestSize%>";
	thisForm.submit();
}

function isNetscape()
{
	// get browser info.
	appName= navigator.appName;
	appLongVer = navigator.appVersion;
	appVer = appLongVer.substring(0,1);
	// check for Navigator ver 4+.
	if ((appName == "Netscape") && (appVer >= 4)) return true;
	return false;
}

function isIE()
{
	// get browser info.
	appName= navigator.appName;
	appLongVer = navigator.appVersion;
	appVer = appLongVer.substring(0,1);
	// check for IE ver 4+.
	if ((appName == "Microsoft Internet Explorer") && (appVer >= 4)) return true;
	return false;
}

function showAgentSummary()
{
	document.getElementById('AgentSummaryHeading_2').style.display = 'none';
	if (isNetscape())
	{
		document.getElementById('AgentSummaryHeading_1').style.display = 'table-row';
		document.getElementById('AgentSummary').style.display = 'table-row';
	}
	else if (isIE())
	{
		document.getElementById('AgentSummaryHeading_1').style.display = 'block';
		document.getElementById('AgentSummary').style.display = 'block';
	}
}

function hideAgentSummary()
{
	document.getElementById('AgentSummaryHeading_1').style.display = 'none';
	if (isNetscape())
	{
		document.getElementById('AgentSummaryHeading_2').style.display = 'table-row';
		document.getElementById('AgentSummary').style.display = 'table-row';
	}
	else if (isIE())
	{
		document.getElementById('AgentSummaryHeading_2').style.display = 'block';
		document.getElementById('AgentSummary').style.display = 'block';
	}
	document.getElementById('AgentSummary').style.display = 'none';
}

</script>
</head>
<body style="overflow:auto" id="space6">
<form name="list" method="post" action="EgConfigureComponentTestsp.jsp" style="margin:0px">
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
	<jsp:include page="listSearch.jsp?title=AGENT - TESTS - SPECIFIC CONFIGURATION&subtitle=false&backButton=true"/>
	<tr>
		<td width="100%" id="eg_whitebg" align="center">
			<table align="center" width="85%" cellspacing="0" cellpadding="0" border="0" class="eg_subcontentbg">
				<tr>
					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>

				<tr id="AgentSummaryHeading_1">
					<td width="7" align="left"class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td align="center" id="eg_subcontentbg" nowrap colspan="3" width="100%">
						<table border="0" cellspacing="0" cellpadding="2" width="100%">
							<tr>
								<td width="100%"><b><egui:intnl text="admin.test.admin.test.TEST(S) TO BE EXCLUDED"/></b></td>
								<td style="width:30px" align="center"><img id="img0" class="mouse" src="/final/admin/eg_images/arrowup.gif" border="0" onClick="javascript:hideAgentSummary();"></td>
							</tr>
						</table>
					</td>
					<td width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>

				<tr id="AgentSummaryHeading_2" style="display:none">
					<td width="7" align="left"class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td align="center" id="eg_subcontentbg" nowrap colspan="3" width="100%">
						<table border="0" cellspacing="0" cellpadding="2" width="100%">
							<tr>
								<td width="100%"><b><egui:intnl text="admin.test.TEST(S) TO BE EXCLUDED"/></b></td>
								<td style="width:30px" align="center"><img id="img0" class="mouse" src="/final/admin/eg_images/arrowdn.gif" border="0" onClick="javascript:showAgentSummary();"></td>
							</tr>
						</table>
					</td>
					<td width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>

				<tr id="AgentSummary">
					<td width="7" align="left"class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td colspan="3" align="center" width="100%" >
						<div class="div_scroll" style="width:100%;height:60px; border:0px solid #ff0000;">
						<table align="center" border="0" width="100%"  cellpadding="4" cellspacing="0" class="tableborder_ad">
<%
	for (int i=0;i<aListTests.size();i=i+3)
	{
		boolean border = true;
		if (i+1 == aListTests.size()) border = false;
%>
							<tr>
<%
		for (int j=i;j<i+3;j++)
		{
			if (j < aListTests.size())
			{
				String strTest = (String)aListTests.get(j);
				String strDisplay = _mapping.getTestDescription(strTest);
%>
								<td width="33%" class="tdborder_ad" valign="top"><%=strDisplay%> </td>
<%
			}
			else
			{
%>
								<td width="33%" class="tdborder_ad" valign="top">&nbsp;</td>
<%
			}
		}
%>
							</tr>
<%
	}
%>
						</table>
						</div>
					</td>
					<td width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>

				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg"  valign="top" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
			</table>
		</td>
	</tr>

	<tr><td class="eg_blankspace" height="20px">&nbsp;</td></tr>

	<tr>
		<td style="padding:0px">
			<table align="center" cellspacing="0" cellpadding="4" border="0" width="85%" class="linesquare2">
				<tr>
					<td class="linebg" colspan="3">
						<table border="0" cellspacing="0" cellpadding="0" width="100%">
							<tr>
								<td width="50%" align="left"><strong><%=_mapping.getComponentTypeDescription(componentType)%>&nbsp;<egui:intnl text="admin.test.components"/></strong></td>
								<td width="50%" align="right">&nbsp;</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr><td class="eg_blankspace" height="4px" colspan="3">&nbsp;</td></tr>
				<tr>
					<td width="45%" style="padding:0px">
						<table align="center" cellspacing="0" cellpadding="0" border="0">
							<tr>
								<td id="eg_subheadbg" align='center' valign='middle' class="head_padding4" style="border-left-width:1px"><strong><egui:intnl text="admin.server.Components to be Excluded"/></strong></td>
							</tr>
							<tr>
								<td align="center" valign="middle">
									<select name="managed" size="20" multiple width="320" style="width:320px;">
<%
	if (tmapCompsToBeExcluded != null)
	{
		for (int i=0;i<aListTests.size();i++)
		{
			String strTest = (String)aListTests.get(i);
			ArrayList aListResultant = (ArrayList)tmapCompsToBeExcluded.get(strTest);
			if (aListResultant != null)
			{
				ArrayList aListUnConfiguredComps = (ArrayList)aListResultant.get(0);
				ArrayList aListConfiguredComps = (ArrayList)aListResultant.get(1);

				if (aListUnConfiguredComps != null)
				{
					Collections.sort(aListUnConfiguredComps,String.CASE_INSENSITIVE_ORDER);
					String strLabel =_mapping.getTestDescription(strTest) + " - " +  "Unconfigured component(s)";
%>
					<optgroup label="<%=strLabel%>">
<%
					for (int j=0;j<aListUnConfiguredComps.size();j++)
					{
						String strComp = (String)aListUnConfiguredComps.get(j);
						String strDispComp = null;
						if (strComp.indexOf(":NULL") > -1)
						{
							strDispComp = strComp.substring(0,strComp.indexOf(":"));
						}
						else
						{
							strDispComp = strComp;
						}
%>
						<option value="<%=strComp+"#"+strTest+"$"%>"><%=strDispComp%></option>
<%
					}
				}

				if (aListConfiguredComps != null)
				{
					Collections.sort(aListConfiguredComps,String.CASE_INSENSITIVE_ORDER);
					String strLabel =_mapping.getTestDescription(strTest) + " - " +  "Configured component(s)";
%>
					<optgroup label="<%=strLabel%>">
<%
					for (int j=0;j<aListConfiguredComps.size();j++)
					{
						String strComp = (String)aListConfiguredComps.get(j);
						String strDispComp = null;
						if (strComp.indexOf(":NULL") > -1)
						{
							strDispComp = strComp.substring(0,strComp.indexOf(":"));
						}
						else
						{
							strDispComp = strComp;
						}
%>
						<option value="<%=strComp+"#"+strTest%>"><%=strDispComp%></option>
<%
					}
				}
%>
				<optgroup label="&nbsp;&nbsp;&nbsp;">
<%
			}
		}
	}
%>
									</select>
								</td>
							</tr>
						</table>
					</td>
					<td width="10%" align="center" valign="middle"  style="padding:0px">
						<input type="button" value='&lsaquo;&lsaquo;' class="eg_lightbutton" onClick="javascript:unManagedComponentToManagedComponent('<%=enableConfTestSize%>');" name="man" style="width: 85px; letter-spacing: 0px; font-size:13px; height:20px"><br><br><br>
						<input type="button" value='&rsaquo;&rsaquo;' class="eg_lightbutton" onClick="javascript:managedComponentTounManagedComponent('<%=enableConfTestSize%>');" name="unman" style="width: 85px; letter-spacing: 0px;font-size:13px; height:20px">
					</td>
					<td width="45%" style="padding:0px">
						<table align="center" cellspacing="0" cellpadding="0" border="0">
							<tr>
								<td id="eg_subheadbg" align='center' valign='middle' class="head_padding4"><strong><egui:intnl text="admin.server.Included Components"/></strong></td>
							</tr>
							<tr>
								<td align="center" valign="middle">
									<select name="unmanaged" size="20" multiple width="320" style="width:320px;">
<%
	if (tmapIncludedComps != null)
	{
		for (int i=0;i<aListTests.size();i++)
		{
			String strTest = (String)aListTests.get(i);
			ArrayList aListResultant = (ArrayList)tmapIncludedComps.get(strTest);
			if (aListResultant != null)
			{
				ArrayList aListUnConfiguredComps = (ArrayList)aListResultant.get(0);
				ArrayList aListConfiguredComps = (ArrayList)aListResultant.get(1);

				if (aListUnConfiguredComps != null)
				{
					Collections.sort(aListUnConfiguredComps,String.CASE_INSENSITIVE_ORDER);
					String strLabel =_mapping.getTestDescription(strTest) + " - " +  "Unconfigured component(s)";
%>
					<optgroup label="<%=strLabel%>">
<%
					for (int j=0;j<aListUnConfiguredComps.size();j++)
					{
						String strComp = (String)aListUnConfiguredComps.get(j);
						String strDispComp = null;
						if (strComp.indexOf(":NULL") > -1)
						{
							strDispComp = strComp.substring(0,strComp.indexOf(":"));
						}
						else
						{
							strDispComp = strComp;
						}
%>
						<option value="<%=strComp+"#"+strTest+"$"%>"><%=strDispComp%></option>
<%
					}
				}

				if (aListConfiguredComps != null)
				{
					Collections.sort(aListConfiguredComps,String.CASE_INSENSITIVE_ORDER);
					String strLabel =_mapping.getTestDescription(strTest) + " - " +  "Configured component(s)";
%>
					<optgroup label="<%=strLabel%>">
<%
					for (int j=0;j<aListConfiguredComps.size();j++)
					{
						String strComp = (String)aListConfiguredComps.get(j);
						String strDispComp = null;
						if (strComp.indexOf(":NULL") > -1)
						{
							strDispComp = strComp.substring(0,strComp.indexOf(":"));
						}
						else
						{
							strDispComp = strComp;
						}
%>
						<option value="<%=strComp+"#"+strTest%>"><%=strDispComp%></option>
<%
					}
				}
%>
				<optgroup label="&nbsp;&nbsp;&nbsp;">
<%
			}
		}
	}
%>
									</select>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr><td class="eg_blankspace" height="4px" colspan="3">&nbsp;</td></tr>
			</table>
		</td>
	</tr>
	<tr><td class="eg_blankspace" height="6px">&nbsp;</td></tr>
	<tr>
		<td width="100%" align="center">
			<input type="button" name="applybutton" value='<egui:intnl text="admin.test.Apply"/>' onClick="javascript:apply('<%=enableConfTestSize%>');" class="eg_back">
			<input type="hidden" name="componentType" value="<%=componentType%>">
			<input type="hidden" name="componentName" value="">
			<input type="hidden" name="mainComponentName" value="<%=componentName%>">
			<input type="hidden" name="testType" value="<%=testType%>">
			<input type="hidden" name="TestsForExclusion" value="<%=testForExclusion%>">
			<input type="hidden" name="showPopup" value='<%=request.getParameter("showPopup")%>'>
			<input type="hidden" name="pageRefreshed" value="true">
			<input type="hidden" name="strManage" value="">
			<input type="hidden" name="strunManage" value="">
		</td>
	</tr>
</table>
</form>
</body>
</html>



