<%@ include file = "../../EgTrackerAJSON.jsp" %>
<%@ page import = "net.sf.json.*"%>
<%@ page import = "com.eg.EgDateInfo"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
/*
*	This page helps to load the eG REST API list data for REST CLient node in Manager Settings tree.
*	ini File : eg_api.ini;
*/
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");

	/*{"Any","1 hour","3 hours","6 hours","9 hours","12 hours","15 hours","18 hours","21 hours","24 hours","2 days","3 days","4 days","5 days","6 days","1 week","2 weeks","3 weeks","4 weeks","1 month","2 months"};*/
	JSONObject rootJson = new JSONObject();
	JSONArray apiTypeArr=new JSONArray();
	JSONArray apiNamesArr=new JSONArray();
	rootJson.put("success","true");

	String selectedParamName=request.getParameter("selectedParamName");
	String selectedApiName=request.getParameter("selectedApiName");	

	if(selectedParamName.equalsIgnoreCase("timeline"))
	{
		rootJson.put("timelineArr",getTimelineComboJsonObj(selectedApiName));
	}
	rootJson.put("hoursArr",getHourComboJsonObj());
	rootJson.put("minutesArr",getMinsComboJsonObj());

	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
	String comFormat = "";
	String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	
	
	UserRegistry registry1 = UserRegistry.getInstance();
	User user = registry1.getUser(session.getId());

	String userDateFormat = user.getUserDateFormat();
	if (userDateFormat != null && userDateFormat.equalsIgnoreCase("default"))
	{
		userDateFormat = currentDateFormat;
	}

	// If user date format is set, assign it to current date format.
	if (userDateFormat != null)
	{
		currentDateFormat = userDateFormat;
	}

	String StrDate="";
	String SDate ="";
	String enDate ="";
	String s_st_time = "";
	String s_en_time = "";
	String s_st_hr="",s_en_hr="",s_st_min="",s_end_min="";
	EgDateInfo edi = new EgDateInfo();
	try
	{
		java.text.SimpleDateFormat df=new java.text.SimpleDateFormat("MM/dd/yyyy k 'at' h:m");
			//----modified on 22/11/07stalin-----------------------
		Calendar cal = Calendar.getInstance();
		cal.setTime(edi.egetRealDate());
		//end date
		StrDate =df.format(cal.getTime());
		enDate=StrDate.substring(0,StrDate.indexOf(" "));	
		//start date
		cal.add(Calendar.DATE, -1);
		StrDate =df.format(cal.getTime());
		SDate =StrDate.substring(0,StrDate.indexOf(" "));

	}
	catch(Exception ee)
	{
		System.out.println("Exception is"+ee);
	}
	
	String shour =StrDate.substring(StrDate.indexOf(" "),StrDate.lastIndexOf(""));
	shour = shour.substring(0,3);
	String smin =StrDate.substring(StrDate.indexOf(":")+1);
	if (s_st_time== null || s_st_time.equalsIgnoreCase("null") || s_st_time.equals(""))
	{
		s_st_time= SDate;
	}
	if(s_en_time == null || s_en_time.equalsIgnoreCase("null") || s_en_time.equals(""))
	{
		s_en_time=enDate;
	}
	if(s_st_hr==null || s_st_hr.equals(""))
	{
		shour =shour.trim();
		int starthr = Integer.parseInt(shour);
		starthr = starthr-1;
		s_st_hr=String.valueOf(starthr);
	}
	if(s_st_min==null || s_st_min.equals(""))
	{
		s_st_min = smin;
	}
	if(s_en_hr==null || s_en_hr.equals(""))
	{
		shour =shour.trim();
		int enhour=Integer.parseInt(shour);		
		if(enhour==24)
		{
			enhour=0;
		}
		s_en_hr =String.valueOf(enhour);;
	}
	if(s_end_min==null || s_end_min.equals(""))
	{
		s_end_min = smin;
	}
	//sess_st_time = s_st_time;
	//sess_end_time = s_en_time;
	if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
	{
		comFormat = "MM/dd/yyyy";
	}
	else
	{
		comFormat = currentDateFormat;
	}
	s_st_time = DateUtil.changeDateFormat(s_st_time,comFormat,"MM/dd/yyyy");
	if(DateUtil.isDate(s_en_time,"MM/dd/yyyy"))
	{
		comFormat = "MM/dd/yyyy";
	}
	else
	{
		comFormat = currentDateFormat;
	}
	s_en_time = DateUtil.changeDateFormat(s_en_time,comFormat,"MM/dd/yyyy");
		
	rootJson.put("startDate",s_st_time);
	rootJson.put("startHour",s_st_hr);
	rootJson.put("startMin",s_st_min);
	rootJson.put("endDate",s_en_time);
	rootJson.put("endHour",s_en_hr);
	rootJson.put("endMin",s_end_min);
	
	out.println(rootJson);
%>
<%!
	private JSONArray getTimelineComboJsonObj(String selectedApiName)
	{
		String[] timelineOptions;
		if(selectedApiName.equalsIgnoreCase("getConfigurationChanges"))
		{
			timelineOptions = new String[] {"1 hour","3 hours","6 hours","9 hours","12 hours","15 hours","18 hours","21 hours","24 hours","2 days","3 days","4 days","5 days","6 days","1 week","2 weeks","3 weeks","4 weeks","1 month","2 month","3 month","4 month"};
		}
		else if(selectedApiName.equalsIgnoreCase("getConfigurationChangesOverTime"))
		{
			timelineOptions = new String[] {"1 day", "2 days", "3 days", "4 days", "5 days", "6 days","1 week"};
		}
		else if(selectedApiName.equalsIgnoreCase("getAlarmsHistory"))
		{
			timelineOptions = new String[] {"Any","10 minutes","20 minutes","30 minutes","40 minutes","50 minutes","59 minutes","1 hour","3 hours","6 hours","9 hours","12 hours","15 hours","18 hours","21 hours","24 hours","2 days","3 days","4 days","5 days","6 days","1 week","2 weeks","3 weeks","4 weeks","1 month","2 months"};
		}
		else if(selectedApiName.equalsIgnoreCase("getMeasureGraph"))
		{
			timelineOptions = new String[] {"Any","1 hour","3 hours","6 hours","9 hours","12 hours","15 hours","18 hours","21 hours","24 hours","2 days","3 days","4 days","5 days","6 days","1 week","2 weeks","3 weeks","4 weeks","1 month","2 months"};
		}
		else if(selectedApiName.equalsIgnoreCase("getHourlyTrend"))
		{
			timelineOptions = new String[] {"1 hour","3 hours","6 hours","9 hours","12 hours","15 hours","18 hours","21 hours","24 hours"};
		}
		else if(selectedApiName.equalsIgnoreCase("getDailyTrend"))
		{
			timelineOptions = new String[] {"1 day","2 days","3 days","4 days","5 days","6 days","1 week","2 weeks","3 weeks","4 weeks"};		
		}
		else if(selectedApiName.equalsIgnoreCase("getMonthlyTrend"))
		{
			timelineOptions = new String[] {"Any","1 month","3 months","6 months","9 months","12 months"};
		}
		else if(selectedApiName.equalsIgnoreCase("getUptimeForServers") || selectedApiName.equalsIgnoreCase("getUptimeForVMs"))
		{
			timelineOptions = new String[] {"Any","1 hour","3 hours","6 hours","9 hours","12 hours","15 hours","18 hours","21 hours","24 hours","1 day","3 days","6 days","9 days","12 days","15 days","18 days","18 days","21 days","24 days","24 days","27 days","31 days","1 week","2 weeks","3 weeks","4 weeks","1 month","2 months"};
		}
		else
		{
			timelineOptions = new String[] {"1 hour","3 hours","6 hours","9 hours","12 hours","15 hours","18 hours","21 hours","24 hours","2 days","3 days","4 days","5 days","6 days","1 week","2 weeks","3 weeks","4 weeks"};
		}
		JSONArray timelineArr = new JSONArray();
		for (int incr = 0; incr < timelineOptions.length; incr++)
		{
			JSONObject tmpObj = new JSONObject();
			String strOption = timelineOptions[incr];
			tmpObj.put("valueField",strOption);
			tmpObj.put("displayField",strOption);
			timelineArr.add(tmpObj);
		}
		return timelineArr;
	}
	
	private JSONArray getHourComboJsonObj()
	{
		String[] hours = {"0","1", "2", "3", "4", "5", "6", "7","8", "9", "10", "11", "12","13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"};
		JSONArray hoursArr = new JSONArray();
		for (int incr = 0; incr < hours.length; incr++)
		{
			JSONObject tmpObj = new JSONObject();
			String currentVal = hours[incr];
			tmpObj.put("valueField",currentVal);
			tmpObj.put("displayField",currentVal);
			hoursArr.add(tmpObj);
		}
		return hoursArr;
	}
	
	private JSONArray getMinsComboJsonObj()
	{
		String[] minutes = {"0","1", "2", "3", "4", "5", "6", "7","8", "9", "10", "11", "12","13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23","24","25", "26", "27", "28", "29", "30", "31","32", "33", "34", "35", "36","37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47","48", "49","50", "51", "52", "53", "54","55", "56", "57", "58", "59"};

		JSONArray minsArr = new JSONArray();
		for (int incr = 0; incr < minutes.length; incr++)
		{
			JSONObject tmpObj = new JSONObject();
			String currentVal = minutes[incr];
			tmpObj.put("valueField",currentVal);
			tmpObj.put("displayField",currentVal);
			minsArr.add(tmpObj);
		}
		return minsArr;
	}
%>